//
// KeyConfig Class
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "KeyConfig.h"

CKeyConfig::CKeyConfig(){

	lstrcpy(m_cfgFile, "KeyCfg.dat"); // łӂ
	lstrcpy(m_verStr,  "Keycfg_dat");

	m_DIkey  = NULL;
	m_midiIn = NULL;
	m_joy1   = NULL;
	m_joy2   = NULL;
	m_Vkey	 = NULL;

	for(int i=0;i<MAX_VKEY;i++)
	{
		for(int j=0;j<MAX_KEY;j++)
			m_VKeyList[i][j] = -1;
	}

}

CKeyConfig::~CKeyConfig(){

}

void CKeyConfig::SetCfgFile(const char* szFile){

	lstrcpy(m_cfgFile, szFile);

}

void CKeyConfig::SaveCfg(void){

	DWORD oldAttr = GetFileAttributes(m_cfgFile);

	SetFileAttributes(m_cfgFile, FILE_ATTRIBUTE_NORMAL);
	FILE* fp = fopen(m_cfgFile, "w");

	if(fp==NULL)
	{
		if(oldAttr!=0xFFFFFFFF)
			SetFileAttributes(m_cfgFile, oldAttr);
		return;
	}

	fputs(m_verStr, fp);
	fputc('\n', fp);

	for(int i=0;i<MAX_VKEY;i++)
	{
		for(int j=0;j<MAX_KEY;j++)
			fprintf(fp, "%d ", m_VKeyList[i][j]);

		fprintf(fp, "\n");
	}

	fclose(fp);

	if(oldAttr!=0xFFFFFFFF)
		SetFileAttributes(m_cfgFile, oldAttr);

}

BOOL CKeyConfig::LoadCfg(void){

	FILE* fp = fopen(m_cfgFile, "r");

	if(fp==NULL)
		return FALSE;

	char dummy[256];
	fgets(dummy, 256, fp);

	for(int i=0;i<MAX_VKEY;i++)
	{
		for(int j=0;j<MAX_KEY;j++)
			fscanf(fp, "%d ", &(m_VKeyList[i][j]));
	}

	fclose(fp);

	return TRUE;

}

void CKeyConfig::Clear(void){

	for(int i=0;i<MAX_VKEY;i++)
	{
		for(int j=0;j<MAX_KEY;j++)
			m_VKeyList[i][j] = -1;
	}

}

void CKeyConfig::Dispatch(void){

	m_Vkey->ClearKeyList();

	for(int i=0;i<MAX_VKEY;i++)
	{
		for(int j=0;j<MAX_KEY;j++)
		{
			if(m_VKeyList[i][j] == -1)
				continue;

			int dev = m_VKeyList[i][j]/256;

			switch(dev)
			{
			case 0: m_Vkey->AddKey(i, m_DIkey,  m_VKeyList[i][j]%256);	break;
			case 1: m_Vkey->AddKey(i, m_midiIn, m_VKeyList[i][j]%256);	break;
			case 2: m_Vkey->AddKey(i, m_joy1,   m_VKeyList[i][j]%256);	break;
			case 3: m_Vkey->AddKey(i, m_joy2,   m_VKeyList[i][j]%256);	break;
			}
		}
	}

}

void CKeyConfig::SetVKey(int vkey, int num, int key){

	m_VKeyList[vkey][num] = key;

}

void CKeyConfig::SetVKey(int vkey, int num, CKeyBase* dev, int key){

	if(dev==(CKeyBase*)m_DIkey)
		m_VKeyList[vkey][num] = key;

	if(dev==(CKeyBase*)m_midiIn)
		m_VKeyList[vkey][num] = key+256;

	if(dev==(CKeyBase*)m_joy1)
		m_VKeyList[vkey][num] = key+512;

	if(dev==(CKeyBase*)m_joy2)
		m_VKeyList[vkey][num] = key+768;

}

// L[R[hԂ
int CKeyConfig::GetVKey(int vkey, int num){

	return m_VKeyList[vkey][num];

}

// foCX0-255̃L[R[hԂ
int CKeyConfig::GetVKey(int vkey, int num, CKeyBase* dev){

	if(dev==(CKeyBase*)m_DIkey)
		return m_VKeyList[vkey][num];

	if(dev==(CKeyBase*)m_midiIn)
		return m_VKeyList[vkey][num]-256;

	if(dev==(CKeyBase*)m_joy1)
		return m_VKeyList[vkey][num]-512;

	if(dev==(CKeyBase*)m_joy2)
		return m_VKeyList[vkey][num]-768;

	return -1;

}

// ĂL[̂ŏ̂̂擾BKeyConfigpB
// -1:ĂȂ  0-255:Keyboard  256-511:Midi-IN  512-767:JoyStick1  768-1023:JoyStick2
int CKeyConfig::GetKeyPressNum(void){

	for(int i=0;i<256;i++)
	{
		if(m_DIkey->IsKeyPushDown(i))
		{
			if(i!=DIK_KANJI && i!=DIK_CAPITAL && i!=DIK_KANA) // ƃbNL[
				return i;
		}
	}

	for(i=0;i<256;i++)
	{
		if(i==251 || i==252) // sb`xhƃW[V̒l͏
			continue;

		if(m_midiIn->IsKeyPushDown(i))
			return i+256;
	}

	// Ƀ`FbNDDR}bg̓FłȂȂB
	// ̂Ń{^Ƀ`FbN
	for(i=255;i>=0;i--)
	{
		if(m_joy1->IsKeyPushDown(i))
			return i+512;
	}

	for(i=255;i>=0;i--)
	{
		if(m_joy2->IsKeyPushDown(i))
			return i+768;
	}

	return -1;

}

// GetKeyPressNumŎ擾L[̖OԂ
char* CKeyConfig::GetKeyName(int key){

	if(key<0)
		return "";

	int dev = key/256;

	switch(dev)
	{
	case 0: return m_DIkey->GetKeyName(key%256);	break;
	case 1: return m_midiIn->GetKeyName(key%256);	break;
	case 2: return m_joy1->GetKeyName(key%256);		break;
	case 3: return m_joy2->GetKeyName(key%256);		break;
	}

	return "";

}

// vkeykeyԖڂ̃L[̖OԂ
char* CKeyConfig::GetKeyName(int vkey, int key){

	if(key<0 || MAX_KEY<=key)
		return "";

	if(m_VKeyList[vkey][key]==-1)
		return "";

	int dev = m_VKeyList[vkey][key]/256;

	switch(dev)
	{
	case 0: return m_DIkey->GetKeyName (m_VKeyList[vkey][key]%256);	break;
	case 1: return m_midiIn->GetKeyName(m_VKeyList[vkey][key]%256);	break;
	case 2: return m_joy1->GetKeyName  (m_VKeyList[vkey][key]%256);	break;
	case 3: return m_joy2->GetKeyName  (m_VKeyList[vkey][key]%256);	break;
	}

	return "";

}

// vkeykeyԖڂ̃L[BMPԍԂ
int CKeyConfig::GetKeyBMPNum(int vkey, int key){

	if(key<0 || MAX_KEY<=key)
		return -1;

	if(m_VKeyList[vkey][key]==-1)
		return -1;

	int dev = m_VKeyList[vkey][key]/256;

	switch(dev)
	{
	case 0: return GetKeyboardBMPNum(m_VKeyList[vkey][key]%256);	break;
	case 1: return GetMIDIBMPNum(m_VKeyList[vkey][key]%256);	break;
	case 2: return GetJoypadBMPNum(m_VKeyList[vkey][key]%256);	break;
	case 3: return GetJoypadBMPNum(m_VKeyList[vkey][key]%256);	break;
	}

	return -1;

}

void CKeyConfig::SetDevice(CVirtualKey*	Vkey, CDirectInput* DIkey, CMIDIInput* midiIn, CJoyStick* joy1, CJoyStick* joy2){

	m_Vkey	 = Vkey;
	m_DIkey  = DIkey;
	m_midiIn = midiIn;
	m_joy1   = joy1;
	m_joy2   = joy2;

}

char* CKeyConfig::GetFileVersion(void){

	FILE* fp = fopen(m_cfgFile, "r");

	if(fp==NULL)
		return NULL;

	fgets(m_szFileVer, 256, fp);
	fclose(fp);

	return m_szFileVer;
}

// keyԂ̃L[BMPԍ擾 by Nickle
int CKeyConfig::GetKeyboardBMPNum(int key){

	// staticɂăRXgN^Ńe[uH
	int tbl[256];

	for(int i=0;i<256;i++)
		tbl[i] = -i;

	tbl[DIK_A] = 0;
	tbl[DIK_B] = 1;
	tbl[DIK_C] = 2;
	tbl[DIK_D] = 3;
	tbl[DIK_E] = 4;
	tbl[DIK_F] = 5;
	tbl[DIK_G] = 6;
	tbl[DIK_H] = 7;
	tbl[DIK_I] = 8;
	tbl[DIK_J] = 9;
	tbl[DIK_K] = 10;
	tbl[DIK_L] = 11;
	tbl[DIK_M] = 12;
	tbl[DIK_N] = 13;
	tbl[DIK_O] = 14;
	tbl[DIK_P] = 15;
	tbl[DIK_Q] = 16;
	tbl[DIK_R] = 17;
	tbl[DIK_S] = 18;
	tbl[DIK_T] = 19;
	tbl[DIK_U] = 20;
	tbl[DIK_V] = 21;
	tbl[DIK_W] = 22;
	tbl[DIK_X] = 23;
	tbl[DIK_Y] = 24;
	tbl[DIK_Z] = 25;
	tbl[DIK_1] = 26;
	tbl[DIK_2] = 27;
	tbl[DIK_3] = 28;
	tbl[DIK_4] = 29;
	tbl[DIK_5] = 30;
	tbl[DIK_6] = 31;
	tbl[DIK_7] = 32;
	tbl[DIK_8] = 33;
	tbl[DIK_9] = 34;
	tbl[DIK_0] = 35;
	tbl[DIK_MINUS] = 36;               /* - on main keyboard */
	tbl[DIK_CIRCUMFLEX] = 37;          /* (Japanese keyboard)            */
	tbl[DIK_YEN] = 38;                 /* (Japanese keyboard)            */
	tbl[DIK_AT] = 39;                  /*                     (NEC PC98) */
	tbl[DIK_LBRACKET] = 40;
	tbl[DIK_RBRACKET] = 41;
	tbl[DIK_SEMICOLON] = 42;
	tbl[DIK_COLON] = 43;               /*                     (NEC PC98) */
	tbl[DIK_COMMA] = 44;
	tbl[DIK_PERIOD] = 45;              /* . on main keyboard */
	tbl[DIK_SLASH] = 46;               /* / on main keyboard */
	tbl[DIK_BACKSLASH] = 47;
	tbl[DIK_F1] = 48;
	tbl[DIK_F2] = 49;
	tbl[DIK_F3] = 50;
	tbl[DIK_F4] = 51;
	tbl[DIK_F5] = 52;
	tbl[DIK_F6] = 53;
	tbl[DIK_F7] = 54;
	tbl[DIK_F8] = 55;
	tbl[DIK_F9] = 56;
	tbl[DIK_F10] = 57;
	tbl[DIK_F11] = 58;
	tbl[DIK_F12] = 59;
//	tbl[ vf1 ] = 60;
//	tbl[ vf2 ] = 61;
	tbl[DIK_F13] = 62;                 /* vf3                    (NEC PC98) */
	tbl[DIK_F14] = 63;                 /* vf4                    (NEC PC98) */
	tbl[DIK_F15] = 64;                 /* vf5                    (NEC PC98) */
	tbl[DIK_ESCAPE] = 65;          
	tbl[DIK_KANJI] = 66;               /* (Japanese keyboard)            */
	tbl[DIK_TAB] = 67;
	tbl[DIK_CAPITAL] = 68;
	tbl[DIK_LSHIFT] = 69;
	tbl[DIK_RSHIFT] = 70;
	tbl[DIK_LCONTROL] = 71;
	tbl[DIK_RCONTROL] = 72;
	tbl[DIK_LMENU] = 73;               /* left Alt */
	tbl[DIK_RMENU] = 74;               /* right Alt */
	tbl[DIK_LWIN] = 75;                /* Left Windows key */
	tbl[DIK_RWIN] = 76;                /* Right Windows key */
	tbl[DIK_NOCONVERT] = 77;           /* (Japanese keyboard)            */
	tbl[DIK_SPACE] = 78;
	tbl[DIK_CONVERT] = 79;             /* (Japanese keyboard)            */
	tbl[DIK_KANA] = 80;                /* (Japanese keyboard)            */
	tbl[DIK_APPS] = 81;                /* AppMenu key */
	tbl[DIK_RETURN] = 82;              /* Enter on main keyboard */
	tbl[DIK_BACK] = 83;                /* backspace */
	tbl[DIK_SYSRQ] = 84;               /* Print Screen */
	tbl[DIK_SCROLL] = 85;              /* Scroll Lock */
	tbl[DIK_PAUSE] = 86;               /* Pause */
	tbl[DIK_INSERT] = 87;              /* Insert on arrow keypad */
	tbl[DIK_DELETE] = 88;              /* Delete on arrow keypad */
	tbl[DIK_HOME] = 89;                /* Home on arrow keypad */
	tbl[DIK_END] = 90;                 /* End on arrow keypad */
	tbl[DIK_PRIOR] = 91;               /* PgUp on arrow keypad */
	tbl[DIK_NEXT] = 92;                /* PgDn on arrow keypad */
//	tbl[ Roll Down ] = 93;
//	tbl[ Roll Up ] = 94;
	tbl[DIK_RIGHT] = 95;               /* RightArrow on arrow keypad */
	tbl[DIK_LEFT] = 96;                /* LeftArrow on arrow keypad */
	tbl[DIK_UP] = 97;                  /* UpArrow on arrow keypad */
	tbl[DIK_DOWN] = 98;                /* DownArrow on arrow keypad */
//	tbl[ XFER ] = 99;
//	tbl[ NFER ] = 100;
//	tbl[ kana lock ] = 101;
	tbl[DIK_STOP] = 102;                /*                     (NEC PC98) */
//	tbl[ COPY ] = 103
	tbl[DIK_UNDERLINE] = 104;           /*                     (NEC PC98) */
	tbl[DIK_POWER] = 105;
	tbl[DIK_SLEEP] = 106;

	tbl[DIK_NUMPAD0] = 107;
	tbl[DIK_NUMPAD1] = 108;
	tbl[DIK_NUMPAD2] = 109;
	tbl[DIK_NUMPAD3] = 110;
	tbl[DIK_NUMPAD4] = 111;
	tbl[DIK_NUMPAD5] = 112;
	tbl[DIK_NUMPAD6] = 113;
	tbl[DIK_NUMPAD7] = 114;
	tbl[DIK_NUMPAD8] = 115;
	tbl[DIK_NUMPAD9] = 116;
	tbl[DIK_ADD] = 117;                 /* + on numeric keypad */
	tbl[DIK_SUBTRACT] = 118;            /* - on numeric keypad */
	tbl[DIK_MULTIPLY] = 119;            /* * on numeric keypad */
	tbl[DIK_DIVIDE] = 120;              /* / on numeric keypad */
	tbl[DIK_NUMPADENTER] = 121;         /* Enter on numeric keypad */
	tbl[DIK_NUMLOCK] = 122;
	tbl[DIK_NUMPADEQUALS] = 123;        /* = on numeric keypad (NEC PC98) */
	tbl[DIK_NUMPADCOMMA] = 124;         /* , on numeric keypad (NEC PC98) */
	tbl[DIK_DECIMAL] = 125;             /* . on numeric keypad */
//	tbl[ Home (PC98) ] = 126;

	return tbl[key];

	/*

	܂(prs)

	DIK_EQUALS          
	DIK_APOSTROPHE      
	DIK_GRAVE               // accent grave

	DIK_AX                  //                     (Japan AX)
	DIK_UNLABELED           //                        (J3100)

	*/

}

// keyԂ̃L[BMPԍ擾 by Nickle
int CKeyConfig::GetMIDIBMPNum(int key){

	int tbl[256];

	for(int i=0;i<256;i++)
		tbl[i] = 145;

	tbl[241] = 140; // "Mod.";
	tbl[242] = 139; // "P.B-";
	tbl[243] = 138; // "P.B+";

	tbl[253] = 142; // "L-Ped.";
	tbl[254] = 144; // "C-Ped.";
	tbl[255] = 143; // "R-Ped.";

	return tbl[key];

}

int CKeyConfig::GetJoypadBMPNum(int key){

	switch(key)
	{
	case  0: return	135;	break; // "Y-";
	case  1: return	136;	break; // "Y+";
	case  2: return	134;	break; // "X-";
	case  3: return	133;	break; // "X+";
	default: return 137;	break; // button
	}

}
