//
// KeyConfig Class
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __KeyConfig_h__
#define __KeyConfig_h__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

#include "yaneVirtualKey.h"
#include "yaneDirectInput.h"
#include "yaneJoyStick.h"
#include "yaneMIDIInput.h"

#define MAX_VKEY	150
#define MAX_KEY		8

class CKeyConfig{

public:

	CKeyConfig();
	~CKeyConfig();

	void SetCfgFile(const char* szFile);
	char* GetCfgFile(void){ return m_cfgFile; };


	void SaveCfg(void);
	BOOL LoadCfg(void);

	void Clear(void);
	void Dispatch(void);

	void SetVKey(int vkey, int num, int key); // L[R[hŎw
	void SetVKey(int vkey, int num, CKeyBase* dev, int key); // 0-255̃L[R[hƃfoCXŎw

	int GetVKey(int vkey, int num); // L[R[hԂ
	int GetVKey(int vkey, int num, CKeyBase* dev); // foCX0-255̃L[R[hԂ

	void SetDevice(CVirtualKey*	Vkey, CDirectInput* DIkey, CMIDIInput* midiIn, CJoyStick* joy1, CJoyStick* joy2);

	int GetKeyPressNum(void);
	char* GetKeyName(int key);
	char* GetKeyName(int vkey, int key);

	// vkeykeyԖڂ̃L[BMPԍԂ
	int GetKeyBMPNum(int vkey, int key);

	char* GetFileVersion(void);
	void  SetFileVersion(const char* ver){ strcpy(m_verStr, ver); };

private:

	int m_VKeyList[MAX_VKEY][MAX_KEY];
	char m_cfgFile[MAX_PATH];
	char m_verStr[256];
	char m_szFileVer[256];

	int	GetKeyboardBMPNum(int key);	// L[{[hkeyԂ̃L[BMPԍ擾 by Nickle
	int GetMIDIBMPNum(int key);
	int GetJoypadBMPNum(int key);

	CDirectInput*	m_DIkey;
	CMIDIInput*		m_midiIn;
	CJoyStick*		m_joy1;
	CJoyStick*		m_joy2;

	CVirtualKey*	m_Vkey;

};

#endif
