//
// ȃZ`
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "SelectMusic.h"
#include "CMusicList.h"
#include "Config.h"

extern nsDraw		dd;
extern CWaveControl	ds;
extern CVirtualKey	VKey;
extern nsPlay		dp;
extern CCDDA		cd;
extern CDirectInput	DIkey;
extern CScore		score;
extern CGlobalScene* lpGlobScene;
extern CMusicList	Juke;
extern Config		Cfg;

extern HWND hmainwnd;

extern struct tagJuke JukeBox[MAX_JUKE];
extern struct tagOpt  opt;
extern struct tagscInfo	ScoreInfo;

extern int iFolder; // JukeBox̐
extern int folPos; // ݑIĂJukeBox

extern int  g_iOptCaller; // IvV𔲂Ƃ̖߂
extern BOOL g_bClub; // ClubModeȂTRUE

extern BOOL IsBM(void);
extern BOOL IsDDR(void);
extern BOOL IsBasic(int mode);
extern BOOL IsAnother(int mode);
extern BOOL IsManiac(int mode);

extern int  CheckType(const char* szFileName);
extern void WriteLog(const char* Format,...);

extern void ClearKeyInfo(void);

extern BOOL LoadBMS(const char* szFileName, const char* path, char* szErrTxt, BMS* pBMS, BOOL bReadFiles, int dif);
extern void GoBMS(BMS& bms);
extern BOOL GoMSD(const char* szFile, const char* szPath, char* szErrTxt, MSD& msd, int mode);

extern void GetFileName(char* szFile, const char* szFullPath);
extern void GetPath(char* szPath, const char* szFullPath);
extern string AddYen(string path);
extern void Notice(const char* Format,...);

extern BOOL LoadSoundSet(int ssNum);
extern BOOL UnLoadSoundSet(int ssNum);
extern BOOL PlaySoundSet(int ssNum);

int CSelectMusic::m_curPos;
vector<int> CSelectMusic::m_curPosRec;
int CSelectMusic::m_diffPos;
int CSelectMusic::m_menuPos;

int CSelectMusic::m_dif = SINGLE+BASIC;

int CSelectMusic::m_sortDataSetMode = FALSE;
int CSelectMusic::m_sortMode = CMusicList::SORT_NONE;
DWORD CSelectMusic::m_menuMode = MM_SELMUSIC;

extern CRand rnd;
extern CGlobalScene* lpGlobScene;

CSelectMusic::CSelectMusic(){

	m_OldFont	 = NULL;
	m_yPos		 = 0;
	m_xPos		 = 0;
//	m_menuMode	 = MM_SELMUSIC;
	m_bRndDecide = FALSE;
	m_bStartMusic = FALSE;
	m_bScoreDisp = FALSE;

}

CSelectMusic::~CSelectMusic(){

	// tFCZ[t
	Term();

}

BOOL CSelectMusic::Init(CGlobalData* lpgd){

	if(Juke.size()==0) // ی
	{
		// ȂɂȂł`Ȃ`
		SetNextScene(SC1_TITLE);
		return FALSE;
	}

	g_iOptCaller = SC1_SELMUSIC;
	LoadBMP();

	LoadSoundSet(SS_SELECTMUSIC);
	LoadSoundSet(SS_MS_LEFT);
	LoadSoundSet(SS_MS_RIGHT);
	LoadSoundSet(SS_MS_DECIDE);
	LoadSoundSet(SS_JUKE_UP);
	LoadSoundSet(SS_JUKE_DOWN);

	// ȃZčŏ̂PȂShort-WAVE
	// PlayShortBGM(folPos, m_curPos);

	// BGMĐ
	ds.StopAll();
	PlaySoundSet(SS_SELECTMUSIC);

	DrawMusicList(-1000, -1000, DML_RESET); // AjZbg
	DrawDiffList(-1000, -1000, DML_RESET);
	DrawSelectedMusic(-1000, -1000, DML_RESET);
	DrawCfgMenu(-1000, -1000, DML_RESET);

	// BGScanLŁASȓǂݏIĂȂ΃XLĊJ
	if(Cfg["AutoRescan"]==AR_AUTO_BGSCAN || Cfg["AutoRescan"]==AR_MANUAL_BGSCAN)
	{
		if(Juke.IsBGScanStopping())
		{
			BOOL bRead = TRUE;
			for(int i=0;i<(int)Juke.size();i++)
			{
				Juke[i].Lock();
				{
					bRead &= Juke[i].IsRead();
				}
				Juke[i].UnLock();
			}

			if(!bRead)
				Juke.StartBGScan();
		}
	}

	// JukeXg\Ȃ
	m_JukeWndDisp.Set(JUKELIST_INTIME + JUKELIST_DISPTIME + JUKELIST_OUTTIME + 100);

	// \[g[h\Ȃ
	m_sortDispTime.Set(SORT_DISPTIME + 100);

	// ȃXg̃XChC͌u_ł}~
	m_NotBlink.Set(0);

	if(m_menuMode==MM_SELMUSIC)
		lpGlobScene->SetPartNo(PART_SELMUSIC_SELMUSIC);
	else if(m_menuMode==MM_SELDIFF)
		lpGlobScene->SetPartNo(PART_SELMUSIC_SELDIFF);

	return CScene::Init(lpgd);

}

BOOL CSelectMusic::Term(void){

	UnLoadBMP();

	ds.StopAll();

	UnLoadSoundSet(SS_SELECTMUSIC);
	UnLoadSoundSet(SS_MS_LEFT);
	UnLoadSoundSet(SS_MS_RIGHT);
	UnLoadSoundSet(SS_MS_DECIDE);
	UnLoadSoundSet(SS_JUKE_UP);
	UnLoadSoundSet(SS_JUKE_DOWN);

	return TRUE;
}

void CSelectMusic::ProcessFrame(void){

	static CTimer t;
	double dt = t.Get()/16.6;
	t.Reset();

	// ȃXgXN[
	if(m_yPos<0.0)
	{
		m_yPos += (1.0*dt + 1.0*dt*ABS(double(m_yPos)/(LIST_HEIGHT+1)));
		if(m_yPos>0.0) m_yPos = 0.0;
	}
	else if(m_yPos>0.0)
	{
		m_yPos -= (1.0*dt + 1.0*dt*ABS(double(m_yPos)/(LIST_HEIGHT+1)));
		if(m_yPos<0.0) m_yPos = 0.0;
	}

	// JukeXgXN[
	if(m_xPos<0)
	{
		m_xPos += int(6*dt + 6*dt*ABS(m_xPos/(127+1)));
		if(m_xPos>0) m_xPos = 0;
	}
	else if(m_xPos>0)
	{
		m_xPos -= int(6*dt + 6*dt*ABS(m_xPos/(127+1)));
		if(m_xPos<0) m_xPos = 0;
	}

	dd.DrawSprite(sp_bg, 0, HEAD_MARGIN); // wi

	int mode = m_bStartMusic ? DML_SLIDEOUT : DML_SLIDEIN;
	DrawSelectedMusic(0, HEAD_MARGIN+73, mode);
	DrawMusicList(640-dd.GetSpriteX(sp_wnd_selfile), HEAD_MARGIN, mode); // ȃXg
	DrawDiffList(0, HEAD_MARGIN+279, mode);
	// DrawStageFileׂ͂ĂɗD悷̂ŁÂقɒuĂ


	// \[gݒ\
	// JukeXgoB
	if(m_sortDispTime.Get() < SORT_DISPTIME)
	{
		int x = 1, y = 53;
		if(m_menuMode==MM_SELMUSIC)
		{
			switch(m_sortDataSetMode)
			{
				case CMusicList::SORT_TITLE:	lpGlobScene->DrawFont(x, y, "Sort : Alphabetic", FONT_WHITE);	break;
				case CMusicList::SORT_SCANTIME:	lpGlobScene->DrawFont(x, y, "Sort : Date", FONT_WHITE);		break;
			}
		}

		if(m_menuMode==MM_SELDIFF)
		{
			switch(m_sortMode)
			{
				case CMusicList::SORT_TITLE:	lpGlobScene->DrawFont(x, y, "Sort : Alphabetic", FONT_WHITE);	break;
				case CMusicList::SORT_ARTIST:	lpGlobScene->DrawFont(x, y, "Sort : Artist", FONT_WHITE);		break;
				case CMusicList::SORT_GENRE:	lpGlobScene->DrawFont(x, y, "Sort : Genre", FONT_WHITE);		break;
				case CMusicList::SORT_LEVEL:	lpGlobScene->DrawFont(x, y, "Sort : Difficulty", FONT_WHITE);	break;
				case CMusicList::SORT_SCANTIME:	lpGlobScene->DrawFont(x, y, "Sort : Date", FONT_WHITE);		break;
			}
		}
	}

	// JukeXg
	if(m_JukeWndDisp.Get() < JUKELIST_INTIME+JUKELIST_DISPTIME)
		DrawCfgMenu(-120, HEAD_MARGIN, DML_SLIDEIN);
	else if(m_JukeWndDisp.Get() < JUKELIST_INTIME+JUKELIST_DISPTIME+JUKELIST_OUTTIME)
		DrawCfgMenu(-120, HEAD_MARGIN, DML_SLIDEOUT);

	// ㉺t[
	dd.DrawSprite(sp_frame_top, 0, HEAD_MARGIN);
	dd.DrawSprite(sp_frame_bottom, 0, HEAD_MARGIN+420-dd.GetSpriteY(sp_frame_bottom));

	// Ȑ
	{
		char buf[256];
		Juke[folPos].Lock();
		{
			if(m_menuMode==MM_SELMUSIC)
			{
				sprintf(buf, "%03d/%03d", m_curPos+1, Juke[folPos].size());
			}
			else if(m_menuMode==MM_SELDIFF)
			{
				sprintf(buf, "%03d/%03d", m_diffPos+1, Juke[folPos][m_curPos].size());
			}
		}
		Juke[folPos].UnLock();

		lpGlobScene->DrawFont(10, HEAD_MARGIN+6, buf, FONT_WHITE);
	}

	// Juke
	Juke[folPos].Lock();
	{
		int x = 637 - lpGlobScene->DrawFont(0, 0, Juke[folPos].jukeName.c_str(), FONT_WHITE, FALSE);
		lpGlobScene->DrawFont(x, 20, Juke[folPos].jukeName.c_str(), FONT_WHITE);
	}
	Juke[folPos].UnLock();

	if(m_bScoreDisp)
		DrawScoreWindow();

	if(m_bStartMusic)
	{
		// ׂĂɗD悵ď㏑邽߂ɂ
		DrawStageFile(!m_showStageFile);
	}

	// JE^ZbgƂɕ`悷ƌꂵ̂ōŌ
	KeyCheck();

/*
	// \y݂GtFNgĂCvł
	if(m_bStartMusic && opt.iEffect<=GE_MID && m_showStageFile)
	{
		// GtFNgxGE_MIDȉ̏ꍇ͍܂łǂStageFile
		// StageFileȂƂGE_MIDȉłh胏Cv
		DrawStageFileClassic();
		dd.UnLoadBMP(STAGEFILE_BMPNUM);

		// AjÎŋȃ[h
		if(LoadMusic())
		{
			m_menuMode = MM_SELMUSIC;
			SetNextScene(SC1_GAMEMAIN);
		}
		else
		{
			// [hsBȃZɖ߂
			LoadBMP();
			ds.Play(11); // BGMĐ
			m_bStartMusic = FALSE;
			// PlayShortBGM(folPos, m_curPos);
		}
	}
*/
	if(m_bStartMusic && m_StartMusicTime.Get() > STARTMUSIC_TIME)
	{
		// ̎_łStageFilẻ̂ق\IĂȂ̂ŁA
		// Ō1t[ƕ`
		DrawStageFile(!m_showStageFile);
		dd.Flip();
		dd.UnLoadBMP(STAGEFILE_BMPNUM); // StageFile

		// AjÎŋȃ[h
		if(LoadMusic())
		{
			m_menuMode = MM_SELMUSIC;
			SetNextScene(SC1_GAMEMAIN);
		}
		else
		{
			// [hsBȃZɖ߂
			LoadBMP();
			PlaySoundSet(SS_SELECTMUSIC); // BGMĐ
			m_bStartMusic = FALSE;
			// PlayShortBGM(folPos, m_curPos);
		}
	}
}

BOOL CSelectMusic::LoadBMP(void){

	if(dd.GetScreenColor()==8)
	{
		// pbgύX̐Fh~
		dd.ClearScreen();
		dd.Flip();
		dd.ClearScreen();
		dd.Flip();

		dd.LoadPalette("Image\\SelectMusic\\palette-256.bmp");
		lpGlobScene->RemapPalette();
	}

	// VRAM̎gplāA[hɋC
	dd.LoadBMP(window_current_select,	"Image\\SelectMusic\\window-current-select.bmp"); // őgp
	dd.LoadBMP(window_selectfile,		"Image\\SelectMusic\\window-music.bmp");
	dd.LoadBMP(window_selectdifficulty,	"Image\\SelectMusic\\window-info.bmp");
	dd.LoadBMP(window_configulation,	"Image\\SelectMusic\\window-menu.bmp");

	if(dd.GetScreenColor()!=8)
	{
		// F[h
		dd.LoadBMP(background_title				, "Image\\SelectMusic\\background-title.bmp");
		dd.LoadBMP(background					, "Image\\SelectMusic\\background.bmp");
		dd.LoadBMP(background_playoption		, "Image\\SelectMusic\\background-playmode.bmp");
	}
	else
	{
		// 256F[h
		dd.LoadBMP(background_title				, "Image\\SelectMusic\\background-title-256.bmp");
		dd.LoadBMP(background					, "Image\\SelectMusic\\background-256.bmp");
		dd.LoadBMP(background_playoption		, "Image\\SelectMusic\\background-playmode-256.bmp");
	}

	dd.LoadBMP(frame_top_bottom				, "Image\\SelectMusic\\window-frame.bmp");

	dd.LoadBMP(font_number					, "Image\\SelectMusic\\font-number.bmp");
	dd.LoadBMP(difficulty					, "Image\\SelectMusic\\difficulty.bmp");
	dd.LoadBMP(information					, "Image\\SelectMusic\\information.bmp");
	dd.LoadBMP(lines						, "Image\\SelectMusic\\mode.bmp");
	dd.LoadBMP(playable						, "Image\\SelectMusic\\playable.bmp");
	dd.LoadBMP(player						, "Image\\SelectMusic\\player.bmp");

/*

	ƁAYĂB
	select-background-titleǁAԏ̂͂V`XA
	^񒆂̂͂Q`RH炢̊mŕsKɕ\A
	ԉ̍1̓_͏ɏ\{炢EɃXN[A
	i_͖̒OÂقǑXN[jA
	ƌŁBBB
	͂ŃeXgłȂǂȂ邩킩Ȃ

	-------------------------------------

	F̌ʂ͊mFĂȁc܂ȂĂ
	PɃv|[Viɂ11rfÏꎞ~݂Ɍł

*/

	dd.DefSprite(sp_bg,	background, 0, 0, 0, 0);

	for(int i=0;i<2;i++)
	{
		int w = dd.GetBMPX(background_title);
		int h = dd.GetBMPY(background_title)-1;
		dd.DefSprite(sp_background_title_base+i, background_title, 0, h*i/2, w, h*(i+1)/2);
	}
	dd.DefSprite(sp_background_title_dots, background_title, 0, 200, 0, 201);

	for(int i=0;i<7;i++)
	{
		int w = dd.GetBMPX(background_playoption);
		int h = dd.GetBMPY(background_playoption);

		if(i<3)
		{
			// ̒i
			dd.DefSprite(sp_playopt_green_base + i, background_playoption, w*i/3,   0, w*(i+1)/3,     h/4);
			dd.DefSprite(sp_playopt_blue_base + i,  background_playoption, w*i/3, h/2, w*(i+1)/3, h/2+h/4);
		}
		else
		{
			// ̒i
			int j = i-3;
			dd.DefSprite(sp_playopt_green_base + i, background_playoption, w*j/3,     h/4, w*(j+1)/3, h/2);
			dd.DefSprite(sp_playopt_blue_base + i,  background_playoption, w*j/3, h/2+h/4, w*(j+1)/3,   h);
		}
	}

	dd.DefSprite(sp_wnd_conf,		window_configulation, 0, 0, 0, 0);
	dd.DefSprite(sp_wnd_selfile,	window_selectfile, 0, 0, 0, 0);
	dd.DefSprite(sp_wnd_seldiff,	window_selectdifficulty, 0, 0, 0, 0);

	{
		int h = dd.GetBMPY(window_current_select);
		dd.DefSprite(sp_listbox_music_nonsel,	window_current_select, 0,     0, 153,   h/4);
		dd.DefSprite(sp_listbox_music_sel,		window_current_select, 0, h*2/4, 153, h*3/4);

		dd.DefSprite(sp_listbox_diff_nonsel,	window_current_select, 0,     0, 293,   h/4);
		dd.DefSprite(sp_listbox_diff_sel,		window_current_select, 0, h*3/4, 293, h*4/4);

		dd.DefSprite(sp_listbox_conf_nonsel_s,	window_current_select, 0,     0, 119,   h/4);
		dd.DefSprite(sp_listbox_conf_sel_s,		window_current_select, 0, h*1/4, 119, h*2/4);
		dd.DefSprite(sp_listbox_conf_nonsel_l,	window_current_select, 0,     0, 214,   h/4);
		dd.DefSprite(sp_listbox_conf_sel_l,		window_current_select, 0, h*1/4, 214, h*2/4);
	}

	dd.DefSprite(sp_frame_top,		frame_top_bottom, 0,  0, 0, 22);
	dd.DefSprite(sp_frame_bottom,	frame_top_bottom, 0, 23, 0, 0);

	for(int i=0;i<10;i++)
	{
		int w = dd.GetBMPX(font_number);
		int h = dd.GetBMPY(font_number);
		dd.DefSprite(sp_bpm_font_base+i, font_number, w*i/10, 0, w*(i+1)/10, h/6);
	}

	dd.DefSprite(sp_bpm, font_number, 0, 36, 59, 48);


	for(int i=0;i<5;i++)
	{
		int w = dd.GetBMPX(difficulty);
		dd.DefSprite(sp_difficulty_base+i, difficulty, w*i/5, 0, w*(i+1)/5, 0);
	}

	for(int i=0;i<10;i++)
	{
		int w1 = 160;
		int w2 = 120;
		int h = dd.GetBMPY(font_number);
		dd.DefSprite(sp_diff_num_base+i, font_number, w1*i/10, h*4/6, w1*(i+1)/10, h*5/6); // ՓxP̃tHg

		// Q͂Pv|[Vi
		if(i==1)
			dd.DefSprite(sp_diff_num_mini_base+i, font_number, 15, h*5/6, 21, h*6/6); // ՓxQ̃tHg
		else
			dd.DefSprite(sp_diff_num_mini_base+i, font_number, w2*i/10, h*5/6, w2*(i+1)/10, h*6/6); // ՓxQ̃tHg
	}

	for(int i=0;i<5;i++)
	{
		int y = i*10;
		int dy = y+9;

		if(i<4)
			dd.DefSprite(sp_info_player_base+i,	information,  0, y, 25, dy);

		if(i<4)
			dd.DefSprite(sp_info_lines_base+i,	information, 26, y, 49, dy);

		if(i<2)
			dd.DefSprite(sp_info_bga_base+i,	information, 50, y, 79, dy);

		if(i<5)
			dd.DefSprite(sp_info_level_base+i,	information, 80, y, 91, dy);
	}

	for(int i=0;i<4;i++)
	{
		int w = dd.GetBMPX(lines);
		int h = dd.GetBMPY(lines);

		if(i<2)
			dd.DefSprite(sp_lines_base+i, lines, w*i/2, 0, w*(i+1)/2, h/2);
		else
			dd.DefSprite(sp_lines_base+i, lines, w*(i-2)/2, h/2, w*(i-2+1)/2, h);
	}

	dd.DefSprite(sp_playable, playable, 0, 0, 0, 0);

	for(int i=0;i<2;i++)
	{
		int w = dd.GetBMPX(player);
		int h = dd.GetBMPY(player);
		dd.DefSprite(sp_player_base+i, player, w*i/2, 0, w*(i+1)/2, h);
	}


	return TRUE;
}

void CSelectMusic::UnLoadBMP(void){

	dd.UnLoadBMP(background);
	dd.UnLoadBMP(background_title);
	dd.UnLoadBMP(background_playoption);
	dd.UnLoadBMP(window_configulation);
	dd.UnLoadBMP(window_selectfile);
	dd.UnLoadBMP(window_selectdifficulty);
	dd.UnLoadBMP(window_current_select);
	dd.UnLoadBMP(frame_top_bottom);
	dd.UnLoadBMP(font_number);
	dd.UnLoadBMP(difficulty);
	dd.UnLoadBMP(information);
	dd.UnLoadBMP(lines);
	dd.UnLoadBMP(playable);
	dd.UnLoadBMP(player);

}

void CSelectMusic::DrawTitle(int x, int y){

	static CTimer t;
	static int count = 0;

	if(t.Get() >= 15)
	{
		count++;
//		count+=t.Get()/15;
		t.Set(t.Get()%15);
	}

}

// mode==DML_SLIDEIN  : ʂɃXChC
// mode==DML_SLIDEOUT : ʂXChAEg
// mode==DML_RESET    : JE^[̃Zbg
void CSelectMusic::DrawMusicList(int x, int y, int mode){

	static CTimer t;
	static int count = 0;
	static int oldmode = mode;

	if(mode==DML_RESET)
	{
		t.Reset();
		count=0;
		int x,y;
		CalcPos(x,y,0,DML_RESET,0);
		oldmode = mode;
		return;
	}

	while(t.Get() >= 17)
	{
		count+=1;
		t.Adjust(-17);
	}

	// [hςJE^[Zbg
	if(mode!=oldmode)
	{
		count=0;
		oldmode = mode;
	}

	// ܂wiEBhE`
	int tx = x, ty = y;
	CalcPos(tx,ty,0,mode,count);
	dd.DrawSprite(sp_wnd_selfile, tx, y, 1.0, FALSE);

	// Xg͑S LIST_MUSICNUM Ȃ LIST_SELECTEDNUM ȖڂIĂ
	int start = m_curPos-LIST_SELECTEDNUM;
	int end   = m_curPos+LIST_MUSICNUM-LIST_SELECTEDNUM;

	// XN[ƂɈԏォԉ̋ȂȂ߂̏u
	if(m_yPos>0) start -= int( m_yPos/LIST_HEIGHT) + 1;
	if(m_yPos<0) end   += int(-m_yPos/LIST_HEIGHT) + 1;

	// ǂݍݏIO͂PȂ\
	Juke[folPos].Lock();
	{
		if(!Juke[folPos].IsRead())
			start = 0, end = 1;
	}
	Juke[folPos].UnLock();

	// ɔwi̘g`
	for(int i=start;i<end;i++)
	{
		int dx = x+7, dy = y; // +7̓EBhE̘g
		CalcPos(dx,dy,i-(m_curPos-LIST_SELECTEDNUM),mode,count);
		dd.DrawSprite(sp_listbox_music_nonsel, dx, dy);
	}

	// IĂȂ̔wiFς
	{
		int dx = x+7, dy = y; // +7̓EBhE̘g
		CalcPos(dx, dy, LIST_SELECTEDNUM, mode, count);

		float alpha = float(1.0 - fabs(m_yPos)/LIST_HEIGHT);
		RANGE(alpha, 0.5f, 1.0f);
		// if(opt.iEffect<=GE_MID) alpha = 1.0f; // {ׂ͂Aalpha=1̂܂܂ƌ\Â炢

		if(m_menuMode==MM_SELDIFF)
			dd.BlendBlt(sp_listbox_music_sel, dx, y+LIST_HEIGHT*LIST_SELECTEDNUM, 1.0f);
		else if(alpha==1.0f)
			dd.BlendBlt(sp_listbox_music_sel, dx, y+LIST_HEIGHT*LIST_SELECTEDNUM, m_alpha, FALSE);
		else
			dd.BlendBlt(sp_listbox_music_sel, dx, y+LIST_HEIGHT*LIST_SELECTEDNUM, alpha, FALSE);
	}

	// XN[o[`
	{
		int dx = x, dy = y;
		CalcPos(dx, dy, LIST_SELECTEDNUM, mode, count);
		DrawScrollBarMusic(dx+163, y+27, dx+168, y+398);
	}

	// Ȗ`
	HDC hDC = dd.GetDC();
	if(hDC!=NULL)
	{
		// ۂ˂Ȃ
		SetFont(hDC, "lr oSVbN", 13, TRUE, FALSE);
		for(int i=start;i<end;i++)
		{
			SetTextColor(hDC, RGB(255,255,255));
			int musnum = i;

			Juke[folPos].Lock();
			{
				LOOP(musnum, 0, (int)Juke[folPos].size()-1);

				const char* name;
				if(Juke[folPos].IsRead())
					name = Juke[folPos][musnum].musicName.c_str();
				else
					name = "Loading...";

				if(IsDBCS(name))
				{
					// VȂ̐Fς
					if(Juke[folPos].IsRead())
					{
						if(Juke[folPos][musnum].includesNewData)
							SetTextColor(hDC, NEW_COLOR);

						/*
						for(int j=0;j<(int)Juke[folPos][musnum].size();j++)
						{
							if(Juke[folPos][musnum][j].firstRead + NEW_TIME > time(NULL))
							{
								SetTextColor(hDC, NEW_COLOR);
								break;
							}
						}*/
					}

					int dx = x+20, dy = y; // +20͓̗]T
					CalcPos(dx,dy,i-(m_curPos-LIST_SELECTEDNUM),mode,count);
	//				TextOut(hDC, dx+4, dy+2, name, lstrlen(name));
					RECT rect;
					rect.left   = dx+1;
					rect.top    = dy;
					rect.right  = dx+LIST_WIDTH;
					rect.bottom = dy+LIST_HEIGHT;

					DrawText(hDC, name, -1, &rect, DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);
				}
			}
			Juke[folPos].UnLock();
		}
		ReleaseFont(hDC);

		// łȂ
		SetFont(hDC, "Tahoma", 13, FALSE, FALSE);
		for(i=start;i<end;i++)
		{
			SetTextColor(hDC, RGB(255,255,255));
			int musnum = i;
//			LOOP(musnum, 0, JukeBox[folPos].iFileNum-1);
//			const char* name = JukeBox[folPos].Musdat[musnum]->title.c_str();
			Juke[folPos].Lock();
			{
				LOOP(musnum, 0, (int)Juke[folPos].size()-1);

				const char* name;
				if(Juke[folPos].IsRead())
					name = Juke[folPos][musnum].musicName.c_str();
				else
					name = "Loading...";

				if(!IsDBCS(name))
				{
					// VȂ̐Fς
					if(Juke[folPos].IsRead())
					{
						if(Juke[folPos][musnum].includesNewData)
							SetTextColor(hDC, NEW_COLOR);

						/*
						for(int j=0;j<(int)Juke[folPos][musnum].size();j++)
						{
							if(Juke[folPos][musnum][j].firstRead + NEW_TIME > time(NULL))
							{
								SetTextColor(hDC, NEW_COLOR);
								break;
							}
						}
						*/
					}

					int dx = x + 20, dy = y; // +20̓EBhE̘g
					CalcPos(dx,dy,i-(m_curPos-LIST_SELECTEDNUM),mode,count);
	//				TextOut(hDC, dx+4, dy+1, name, lstrlen(name));
					RECT rect;
					rect.left   = dx+2;
					rect.top    = dy-1;
					rect.right  = dx+LIST_WIDTH;
					rect.bottom = dy+LIST_HEIGHT;

					DrawText(hDC, name, -1, &rect, DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);
				}
			}
			Juke[folPos].UnLock();
		}
		ReleaseFont(hDC);

		dd.ReleaseDC(hDC);
	}

	// ㉺ɂ͂ݏoœhԂ
	int w = dd.GetSpriteX(sp_wnd_selfile);
	int h = dd.GetSpriteY(sp_wnd_selfile);
	dd.FillRect(x,   0, x+w, HEAD_MARGIN);
	dd.FillRect(x, y+h, x+w,       SCR_H);

	int size;
	Juke[folPos].Lock();
	{
		if(Juke[folPos].IsRead())
		{
			size = (Juke[folPos].size()+1)/2;

			if(Juke[folPos].size()%2==0)
				size++;
		}
		else
			size = 1;
	}
	Juke[folPos].UnLock();

	// ȂJԂƂ̂ōhԂ
/*	{
		int dx = x+7, dy = y;
		w -= 17;
		CalcPos(dx, dy, LIST_SELECTEDNUM, mode, count);

		int center = HEAD_MARGIN + LIST_HEIGHT*LIST_SELECTEDNUM;
		dd.FillRect(dx, HEAD_MARGIN, dx+w, center+LIST_HEIGHT-LIST_HEIGHT*size-1);
		dd.FillRect(dx, center+LIST_HEIGHT*size, dx+w, y+h);
	}
*/
	// ȂJԂƂ̂window-music.bmpœhԂ
	{
		int dx = x+7, dy = y;
		w -= 17;
		CalcPos(dx, dy, LIST_SELECTEDNUM, mode, count);

		int center = HEAD_MARGIN + LIST_HEIGHT*LIST_SELECTEDNUM;

		// 㑤
		{
			int y = HEAD_MARGIN;
			int dy = center+LIST_HEIGHT-LIST_HEIGHT*size-1;
			int h = dy-y;

			if(h>0)
			{
				dd.DefSprite(sp_wnd_selfile, window_selectfile, 7, 0, 7+w, h); // `挳͈͂𒲐`
				dd.DrawSprite(sp_wnd_selfile, dx, y, 1.0, FALSE);
			}
		}

		// 
		{
			int sy = center+LIST_HEIGHT*size;
			int sdy = y+h;
			int sh = sdy-sy;

			int top = sy - y;

			if(sh>0)
			{
				dd.DefSprite(sp_wnd_selfile, window_selectfile, 7, top, 7+w, top+sh); // `挳͈͂𒲐`
				dd.DrawSprite(sp_wnd_selfile, dx, sy, 1.0, FALSE);
			}
		}

		// `挳͈͂ɖ߂
		dd.DefSprite(sp_wnd_selfile, window_selectfile, 0, 0, 0, 0);
	}
}

void CSelectMusic::DrawDiffList(int x, int y, int mode)
{
	static CTimer t;
	static int count = 0;
	static int oldmode = mode;

	if(mode==DML_RESET)
	{
		t.Reset();
		count=0;
		oldmode = mode;
		return;
	}

	while(t.Get() >= 17)
	{
		count+=1;
		t.Adjust(-17);
	}

	// [hςJE^[Zbg
	if(mode!=oldmode)
	{
		count=0;
		oldmode = mode;
	}

	// cAj[V
	if(mode==DML_SLIDEIN)
	{
		double pos = (30-count) / 30.0; if(pos<0.2) pos = 0;
		double factor = pos==0 ? 0 : log(5.0*pos) / log(5.0);
		RANGE(factor, 0.0, 1.0);
		y = y + DWORD(factor*dd.GetSpriteY(sp_wnd_seldiff)); // LIST_WIDTH/2 + count*25 - (i*25); //pow(count,2.2)
	}
	else if(mode==DML_SLIDEOUT)
	{
		double pos = count/30.0; if(pos<0.2) pos = 0;
		double factor = pos==0 ? 0 : log(5.0*pos) / log(5.0);
		RANGE(factor, 0.0, 1.0);
		y = y + DWORD(factor*dd.GetSpriteY(sp_wnd_seldiff)); // LIST_WIDTH/2 + count*25 - (i*25); //pow(count,2.2)
	}

	// EBhE`
	dd.DrawSprite(sp_wnd_seldiff, x, y, 1.0, FALSE);

	int rightX = x+167;
	int rightY = y+6;

	// j[BRsy₷悤ɂĂ
	int items;
	BOOL bRead;
	Juke[folPos].Lock();
	{
		if(Juke[folPos].IsRead())
		{
			items = Juke[folPos][m_curPos].size();
			bRead = TRUE;
		}
		else
		{
			items = 1;
			bRead = FALSE;
		}
	}
	Juke[folPos].UnLock();

	int rows = DIFF_LIST_ROWS;
	int curPos = m_diffPos%rows;
	int listHead = (m_diffPos/rows) * rows; // (items/rows) * 
	int rowHeight = 17;

	for(int i=0;i<rows;i++)
	{
		BOOL bDrawCursor = (m_menuMode==MM_SELDIFF) && i==curPos;

		if(listHead+i < items)
			DrawDiffItem(rightX, rightY+i*rowHeight, listHead+i, bDrawCursor);
	}

	int leftX = x+0;
	int leftY = y+6;

	if(bRead)
		DrawMusicInfo(leftX, leftY);

	// XN[o[
	int max = listHead+rows<items ? listHead+rows : items;
	DrawScrollBarSimple(listHead, max, items, x+463, y+12, x+468, y+121);

	// Xe[^Xo[ɂ͂ݏohԂ
	dd.FillRect(x, 450, x+dd.GetSpriteX(sp_wnd_seldiff), 480);
}

void CSelectMusic::DrawCfgMenu(int x, int y, int mode)
{
	static CTimer t;
	static int count = 0;
	static int oldmode = mode;

	if(mode==DML_RESET)
	{
		t.Reset();
		count=0;
		oldmode = mode;
		return;
	}

	while(t.Get() >= 17)
	{
		count+=2;
		t.Adjust(-17);
	}

	// [hςJE^[Zbg
	if(mode!=oldmode)
	{
		count=0;
		oldmode = mode;
	}

	// Aj[V
	double pos;
	if(mode==DML_SLIDEIN)
		pos = (30-count) / 30.0;
	else if(mode==DML_SLIDEOUT)
		pos = count / 30.0;

	if(pos<0.2) pos = 0;
	double factor = pos==0 ? 0 : log(5*pos) / log(5.0);
	RANGE(factor, 0.0, 1.0);
	y = y - DWORD(factor*dd.GetSpriteY(sp_wnd_conf)); // LIST_WIDTH/2 + count*25 - (i*25); //pow(count,2.2)

	// EBhE`
	dd.DrawSprite(sp_wnd_conf, x, y, 1.0, FALSE);

	// j[BRsy₷悤ɂĂ
	int leftX = x+0;
	int leftY = y+6;

	// ݂߂ɂ
	// (+124, +20)
	if(m_menuPos==MP_JUKE)
	{
		int rightX = x+124;
		int rightY = y+20;

		int items = Juke.size();
		int rows = JUKE_LIST_ROWS;
		int curPos = folPos%rows;
		int listHead = (folPos/rows) * rows; // (items/rows) * 
		int rowHeight = 17;

		for(int i=0;i<rows;i++)
		{
			if(listHead+i < items)
			{
				// wig
				dd.DrawSprite(sp_listbox_conf_nonsel_l, rightX, rightY+rowHeight*i);

				// J[\
				if(i==curPos)
					dd.DrawSprite(sp_listbox_conf_sel_l, rightX, rightY+rowHeight*i);
			}
		}

		// XN[o[
		int max = listHead+rows<items ? listHead+rows : items;
		DrawScrollBarSimple(listHead, max, items, rightX+217, rightY, rightX+222, rightY+248);

		// Juke
		HDC hDC = dd.GetDC();
		if(hDC!=NULL)
		{
			SetTextColor(hDC, RGB(255,255,255));
			for(int i=0;i<rows;i++)
			{
				if(listHead+i < items)
				{
					const char* name = Juke[listHead+i].jukeName.c_str();
					RECT rect;
					if(IsDBCS(name))
					{
						// ۂ˂Ȃ
						SetFont(hDC, "lr oSVbN", 13, TRUE, FALSE);
						rect.top    = rightY+rowHeight*i;
					}
					else
					{
						// łȂ
						SetFont(hDC, "Tahoma", 13, FALSE, FALSE);
						rect.top    = rightY+rowHeight*i;
					}

					rect.left   = rightX+5;
					rect.right  = rightX+214;
					rect.bottom = rect.top + 16;

					DrawText(hDC, name, -1, &rect, DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);

					ReleaseFont(hDC);
				}
			}
			dd.ReleaseDC(hDC);
		}
	}

	dd.FillRect(x, 0, x+dd.GetSpriteX(sp_wnd_conf), HEAD_MARGIN); // t[ɂ͂ݏohԂ

}

void CSelectMusic::DrawMusicInfo(int x, int y)
{
	int player;
	int bmlines, ddrlines;
	BOOL playable;
	int level;

	Juke[folPos].Lock();
	{
		if(Juke[folPos].IsRead())
		{
			player		= Juke[folPos][m_curPos][m_diffPos].player;
			bmlines		= Juke[folPos][m_curPos][m_diffPos].iBMLines;
			ddrlines	= Juke[folPos][m_curPos][m_diffPos].iDDRLines;
			playable	= Juke[folPos][m_curPos][m_diffPos].bPlayable;
			level		= Juke[folPos][m_curPos][m_diffPos].level;
		}
		else
		{
			Juke[folPos].UnLock();
			return;
		}
	}
	Juke[folPos].UnLock();

	// player
	if(1<=player && player<=4)
	{
		// PFv[[̈ʒu@OFv[[̈ʒu
		int tbl[4][3] = { {0, 1, 1},
						  {0, 1, 0},
						  {1, 0, 1}, 
						  {0, 0, 0}, };

		dd.DrawSprite(sp_player_base + tbl[player-1][0],	  x+6, y+4);
		dd.DrawSprite(sp_player_base + tbl[player-1][1],	 x+74, y+4);
		dd.DrawSprite(sp_player_base + tbl[player-1][2],	x+142, y+4);
	}

	// lines
	dd.DrawSprite(sp_lines_base   + bmlines,    x+2, y+35);
	dd.DrawSprite(sp_lines_base+2 + ddrlines, x+138, y+35);

	// playable
	if(playable)
		dd.DrawSprite(sp_playable, x+40, y+35);

	// level
	int rnd = 0;
	if(level>10)
		rnd = 1 + random(4); // Level 11ȏ͓_
	else
		rnd = 4; // Level 11ȏ͓_

	for(int i=0;i<10;i++)
	{
		int w = dd.GetSpriteX(sp_difficulty_base);
		int h = dd.GetSpriteY(sp_difficulty_base);
		int sx = x+6  +  w*(i%5);
		int sy = y+60 + 27*(i/5);

		if(i<level)
			dd.DrawSprite(sp_difficulty_base + rnd, sx, sy);
		else
			dd.DrawSprite(sp_difficulty_base, sx, sy);
	}

	// Score
	lpGlobScene->DrawFont(x+96, y+57, "HI-SCORE", FONT_GRAY);

	DWORD crc, filesize;
	CalcSelectedMusicCRC();
	Juke[folPos].Lock();
	{
		crc			= Juke[folPos][m_curPos][m_diffPos].crc32;
		filesize	= Juke[folPos][m_curPos][m_diffPos].scoreFileSize;
	}
	Juke[folPos].UnLock();

	MUSIC_STAT* lpMS = score.Get(crc, filesize);
	if(lpMS==NULL)
	{
		// o^
		lpGlobScene->DrawFont(x+96, y+67, "No Score", FONT_GRAY);
	}
	else
	{
		// XRA
		SCORE* sc = IsBM() ? lpMS->bmScore : lpMS->ddrScore;
//		unsigned __int64 totsc = IsBM() ? lpMS->bmTotalScore : lpMS->ddrTotalScore;
//		DWORD pc = IsBM() ? lpMS->bmPlaycount : lpMS->ddrPlaycount;
//		DWORD scnt = IsBM() ? lpMS->bmScorecount : lpMS->ddrScorecount;

		char buf[128];
		// unionȂ̂bmddr͈ӎȂłc
		for(int i=0;i<5;i++)
		{
			sprintf(buf, "%d.%6d", i+1, sc[i].bmScore);
			lpGlobScene->DrawFont(x+96, y+67+i*10, buf, FONT_GRAY);
		}

/*		sprintf(buf, "Best 5 : %d / %d / %d / %d / %d", sc[0].bmScore, sc[1].bmScore, sc[2].bmScore, sc[3].bmScore, sc[4].bmScore);
		DrawFont(243, y, buf, FONT_WHITE); y+=10;

		double avg = scnt!=0 ? double(totsc)/scnt : 0.0;
		sprintf(buf, "Average : %.2lf", avg);
		DrawFont(243, y, buf, FONT_WHITE); y+=10;

		sprintf(buf, "Play Count : %lu", pc);
		DrawFont(243, y, buf, FONT_WHITE); y+=10;
		sprintf(buf, "CRC : %08X / Size : %lu", crc, filesize);
		DrawFont(243, y, buf, FONT_WHITE); y+=10;
*/
	}
}

DWORD CSelectMusic::DrawDigit(int spNumBase, int x, int y, DWORD num, BOOL bDraw/* = TRUE*/)
{
	// v|[VitHgɂΉB
	// v镝ɂȂ悤ɎODefSpriteƂĂ
	int oldX = x;

	char buf[16];
	int length = sprintf(buf, "%u", num);

	for(int i=0;i<length;i++)
	{
		if('0' <= buf[i] && buf[i]<='9')
		{
			if(bDraw)
				dd.DrawSprite(spNumBase+(buf[i]-'0'), x, y);

			x += dd.GetSpriteX(spNumBase+(buf[i]-'0'));
		}
		else
			x += dd.GetSpriteX(spNumBase);
	}

	return x - oldX;
}

void CSelectMusic::DrawDiffItem(int x, int y, int diffPos, BOOL bDrawCursor)
{
	// wi̐
	dd.DrawSprite(sp_listbox_diff_nonsel, x, y);

	if(bDrawCursor)
		dd.BlendBlt(sp_listbox_diff_sel, x, y, m_alpha, FALSE);

	// Ȗ
	// wb_ǂݏIĂȂLoading...Ƃoċ
	const char* name;
	BOOL bReturn;
	time_t firstread = 0;
	Juke[folPos].Lock();
	{
		if(Juke[folPos].IsRead())
		{
			name = Juke[folPos][m_curPos][diffPos].title.c_str();
			firstread = Juke[folPos][m_curPos][diffPos].firstRead;
			bReturn = FALSE;
		}
		else
		{
			name = "Loading...";
			bReturn = TRUE;
		}
	}
	Juke[folPos].UnLock();

	HDC hDC = dd.GetDC();
	if(hDC!=NULL)
	{
		if(firstread + NEW_TIME > time(NULL))
			SetTextColor(hDC, NEW_COLOR);
		else
			SetTextColor(hDC, RGB(255,255,255));

		RECT rect;
		if(IsDBCS(name))
		{
			// ۂ˂Ȃ
			SetFont(hDC, "lr oSVbN", 13, TRUE, FALSE);
			rect.top    = y;
		}
		else
		{
			// łȂ
			SetFont(hDC, "Tahoma", 13, FALSE, FALSE);
			rect.top    = y;
		}

		rect.left   = x+26;
		rect.right  = x+26 + 174;
		rect.bottom = rect.top + 16;

		DrawText(hDC, name, -1, &rect, DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);

		ReleaseFont(hDC);
		dd.ReleaseDC(hDC);
	}

	// wb_ǂݏIĂȂt@Coċ
	if(bReturn)
		return;

	// Փx̐
	Juke[folPos].Lock();
		int diff = Juke[folPos][m_curPos][diffPos].level;
	Juke[folPos].UnLock();
	if(diff<10)
	{
		// PptHg
		DrawDigit(sp_diff_num_base, x+4, y+2, diff);
	}
	else
	{
		// QptHg(Ev|[Vi)
		if(diff==11)
		{
			// 11͂̂܂܃v|[ViƋl܂肷̂ŗO
			dd.DrawSprite(sp_diff_num_mini_base+1, x+3,  y+2);
			dd.DrawSprite(sp_diff_num_mini_base+1, x+11, y+2);
		}
		else
		{
			// {IɉEA22Ƃz[I[o[Ȃ悤ɏ
			DWORD max_w = dd.GetSpriteX(sp_diff_num_base);
			DWORD w = DrawDigit(sp_diff_num_mini_base, x+4, y+2, diff, FALSE);
			int dx = x+4+max_w-w;
			if(dx < x+1)
				DrawDigit(sp_diff_num_mini_base, x+1, y+2, diff);
			else
				DrawDigit(sp_diff_num_mini_base, dx, y+2, diff);
		}
	}

	// ȏ
	Juke[folPos].Lock();
		int player = Juke[folPos][m_curPos][diffPos].player;
		int lines = IsBM() ? Juke[folPos][m_curPos][diffPos].iBMLines : Juke[folPos][m_curPos][diffPos].iDDRLines;
		BOOL bga = Juke[folPos][m_curPos][diffPos].bBMP;
		int judgeLevel = Juke[folPos][m_curPos][diffPos].rank;
	Juke[folPos].UnLock();

	int info_base_x = 199;

	// Player
	dd.DrawSprite(sp_info_player_base+player-1, x+info_base_x, y+3);

	// Lines
	if(IsBM())
		dd.DrawSprite(sp_info_lines_base + lines, x+info_base_x+23, y+3); // 5or7Line
	else
		dd.DrawSprite(sp_info_lines_base+2 + lines, x+info_base_x+23, y+3); // 4or6Arrow

	// BGA
	if(bga)
		dd.DrawSprite(sp_info_bga_base, x+info_base_x+48, y+3);

	// Judge Level
	switch(judgeLevel)
	{
		case 0:  dd.DrawSprite(sp_info_level_base+3, x+info_base_x+80, y+3); break; // very hard
		case 1:  dd.DrawSprite(sp_info_level_base+2, x+info_base_x+80, y+3); break; // hard
		case 2:  dd.DrawSprite(sp_info_level_base+1, x+info_base_x+80, y+3); break; // normal
		case 3:  dd.DrawSprite(sp_info_level_base+0, x+info_base_x+80, y+3); break; // easy
		default: dd.DrawSprite(sp_info_level_base+4, x+info_base_x+80, y+3); break; // easy
	}
}

void CSelectMusic::DrawSelectedMusic(int x, int y, int mode){

	if(mode==DML_RESET)
		return; // ȂɂȂǁÅ֐Ɠ낦邽߂

/*	static CTimer t;
	static count = 0;

	if(mode==DML_RESET)
	{
		t.Reset();
		count=0;
		oldmode = mode;
		return;
	}

	if(t.Get() >= 2)
	{
		count+=t.Get()*2;
		t.Set(t.Get()%2);
	}
	int dx = SCR_W-count;
	dx = dx<x ? x : dx;

	int dy = y;
*/

	int dx = x, dy = y;

	// ̔
	/*	select-background-titleǁAԏ̂͂V`XA
		^񒆂̂͂Q`RH炢̊mŕsKɕ\A
		ԉ̍1̓_͏ɏ\{炢EɃXN[A
		i_͖̒OÂقǑXN[jA
		ƌŁBBB
	*/

/*	if(t2.Get() >= dur)
	{
		t2.Reset();

		if(bgNum==0)
		{
			// ͂P
			dur = 150 + random(250);
			bgNum = 1;
		}
		else
		{
			// ͂O
			dur = 900 + random(700);
			bgNum = 0;
		}
	}

			static CTimer t;
			static DWORD dur = 900 + random(700);
			static DWORD blinkDur = 100 + random(200);

			if(t.Get() >= dur+blinkDur)
			{
				disp1 = FALSE;
				dur = 900 + random(700);
				blinkDur = 100 + random(200);
				t.Reset();
			}
			else if(t.Get() >= dur)
			{
				disp1 = t.Get()%60 < 30;
			}
			else
				disp1 = FALSE;
	
*/

	// wǐuH_
	if(m_NotBlink.Get() > NOT_BLINK_TIME)
	{
		BOOL disp1, disp2;

		// 邳P̏
		{
			static CTimer t;
			static DWORD dur = 2000 + random(1200);
			static DWORD blinkDur = 50 + random(150);

			if(t.Get() >= dur+blinkDur)
			{
				disp1 = FALSE;
				dur = 2400 + random(1200);
				blinkDur = 50 + random(150);
				t.Reset();
			}
			else if(t.Get() >= dur)
			{
				disp1 = (t.Get() - blinkDur)/50 % 2 == 1;
			}
			else
				disp1 = TRUE;
		}

		// 邳Q̏
		{
			static CTimer t;
			static DWORD dur = 900 + random(1200);
			static DWORD blinkDur = 100 + random(200);

			if(t.Get() >= dur+blinkDur)
			{
				disp2 = FALSE;
				dur = 900 + random(1200);
				blinkDur = 100 + random(200);
				t.Reset();
			}
			else if(t.Get() >= dur ||
					NOT_BLINK_TIME < m_NotBlink.Get() && m_NotBlink.Get() < NOT_BLINK_TIME+200)
			{
				disp2 = t.Get()%60 < 30;
			}
			else
				disp2 = FALSE;
		}

		if(disp1)
			dd.DrawSprite(sp_background_title_base, dx, dy);
		if(disp2 && disp1)
			dd.DrawSprite(sp_background_title_base+1, dx, dy);
	}

	// _
	const int background_title = 66;
	int tbl[] = { 174, 288, 406 }; // KɂR
	static int xPos[10] = { random(85), random(85), random(85), random(85), random(85),
							random(85), random(85), random(85), random(85), random(85), };
	static int dxPos[10] = { random(4), random(4), random(4), random(4), random(4),
							 random(4), random(4), random(4), random(4), random(4), };
	static int yPos[10] = { 10, 23, 30, 40, 47, 53, 60, 70, 79, 84 };

	static CTimer c3;
	for(int i=0;i<10;i++)
	{
		int j = i%3;
		dd.DefSprite(sp_background_title_dots, background_title, 0, 200, tbl[j], 201);
		dd.DrawSprite(sp_background_title_dots, dx+xPos[i], dy+yPos[i]);

		xPos[i] += int((2 + j*2 + dxPos[i]) * (c3.Get() / 16.666));
		if(xPos[i] > dd.GetSpriteX(sp_background_title_base))
		{
			xPos[i] = -tbl[2];
		}
	}
	c3.Reset();

	// BPM
	int maxWidth = dd.GetSpriteX(sp_background_title_base);

	HDC hDC = dd.GetDC();
	if(hDC==NULL)
		return;

	double bpm;

	Juke[folPos].Lock();
	{
		if(!Juke[folPos].IsRead())
		{
			Juke[folPos].UnLock();
			dd.ReleaseDC(hDC);
			return;
		}

		bpm = Juke[folPos][m_curPos][m_diffPos].dBPM;

		for(int i=0;i<2;i++)
		{
			dy = y + 15;

			if(i==0)
				SetTextColor(hDC, RGB(255,255,255));
			else
				SetTextColor(hDC, RGB(80,80,80));

			int offset = i==0 ? 1 : 0;

			// W
			const char* name = Juke[folPos][m_curPos][m_diffPos].genre.c_str();
			if(IsDBCS(name))
				SetFont(hDC, "lr oSVbN", 13, TRUE, TRUE); // ۂ˂Ȃ
			else
				SetFont(hDC, "Tahoma", 21, FALSE, TRUE); // łȂ

			RECT rect;
			rect.left   = offset + dx;
			rect.top    = offset + dy;
			rect.right  = offset + dx+maxWidth;
			rect.bottom = rect.top + 17;

			DrawText(hDC, name, -1, &rect, DT_CENTER|DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);
			ReleaseFont(hDC);

			dy += 19;

			// ^Cg
			name = Juke[folPos][m_curPos][m_diffPos].title.c_str();
			if(IsDBCS(name))
			{
				SetFont(hDC, "lr oSVbN", 25, TRUE, TRUE); // ۂ˂Ȃ
				rect.top    = offset + dy+2;
			}
			else
			{
				SetFont(hDC, "Tahoma", 30, FALSE, TRUE); // łȂ
				rect.top    = offset + dy;
			}

			rect.left   = offset + dx;
			rect.right  = offset + dx+maxWidth;
			rect.bottom = rect.top + 30;
						  
			DrawText(hDC, name, -1, &rect, DT_CENTER|DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);
			ReleaseFont(hDC);

			dy += 32;

			// A[eBXg
			name = Juke[folPos][m_curPos][m_diffPos].artist.c_str();
			if(IsDBCS(name))
				SetFont(hDC, "lr oSVbN", 13, TRUE, TRUE); // ۂ˂Ȃ
			else
				SetFont(hDC, "Tahoma", 21, FALSE, TRUE); // łȂ

			rect.left   = offset + dx;
			rect.top    = offset + dy;
			rect.right  = offset + dx+maxWidth;
			rect.bottom = rect.top + 17;

			DrawText(hDC, name, -1, &rect, DT_CENTER|DT_VCENTER|DT_SINGLELINE|DT_NOPREFIX);
			ReleaseFont(hDC);
		}
	}
	Juke[folPos].UnLock();

	dd.ReleaseDC(hDC);

	// BPM
	dd.DrawSprite(sp_bpm, (x+maxWidth)/2+3, y+155);

	DWORD w = DrawDigit(sp_bpm_font_base, 0, 0, (int)(bpm+0.5), FALSE);
	DrawDigit(sp_bpm_font_base, (x+maxWidth)/2-3-w, y+155, (int)(bpm+0.5));

}

void CSelectMusic::DrawScrollBarSimple(int start, int end, int rowNum, int x, int y, int dx, int dy)
{
	if(end-start>=rowNum)
	{
		// Ŝ\Ă
		dd.FillRect(x,y,dx,dy);
		return;
	}

	double height = double(dy-y)/rowNum;

	int sy = y + int(start * height);
	int ey = y + int(end * height);

	dd.FillRect(x, sy, dx, ey);

}

void CSelectMusic::DrawScrollBarMusic(int x, int y, int dx, int dy)
{
	int jukesize;
	Juke[folPos].Lock();
	{
		jukesize = Juke[folPos].size();
	}
	Juke[folPos].UnLock();

	if(jukesize<=LIST_MUSICNUM)
	{
		// SȉʂɏoĂ
		dd.FillRect(x,y,dx,dy);
		return;
	}

	int start = m_curPos;//-LIST_SELECTEDNUM;
	int end   = m_curPos+LIST_MUSICNUM;//-LIST_SELECTEDNUM;
//	if(m_yPos>0) start-= m_yPos/20;//+1;
//	if(m_yPos<0) end  += -m_yPos/20;//+1;

	for(int i=start;i<end;i++)
	{
		int musnum = i;//-(m_curPos-LIST_SELECTEDNUM);
		LOOP(musnum, 0, jukesize-1);

		double height = double(dy-y)/jukesize;

		int py  = y + (int)floor(musnum*height);
		int pdy = y + (int)ceil((musnum+1)*height);
		int offset = int(height * double(m_yPos)/(LIST_HEIGHT+1));

		if(py==pdy) pdy=py+1;

		int top    = py-offset;		LOOP(top, y, dy-1);
		int bottom = pdy-offset;	LOOP(bottom, y, dy-1);

		if(top<bottom)
		{
			if(top!=bottom) dd.FillRect(x,top,dx,bottom);
		}
		else
		{
			if(y!=bottom) dd.FillRect(x,y,dx,bottom); //  && bottom-y<=height
			if(top!=dy) dd.FillRect(x,top,dx,dy); //    && dy-top<=height
		}
	}

/*
	// SȉʂɏoĂ
	if(JukeBox[folPos].iFileNum<=LIST_MUSICNUM)
	{
		dd.FillRect(x,y,dx,dy);
		return;
	}

	int start = m_curPos;//-LIST_SELECTEDNUM;
	int end   = m_curPos+LIST_MUSICNUM;//-LIST_SELECTEDNUM;

	LOOP(start, 0, JukeBox[folPos].iFileNum-1);
	LOOP(end,   0, JukeBox[folPos].iFileNum-1);

	if(start<end)
	{
		// ܂ԂĂȂ
		double height = double(dy-y)/JukeBox[folPos].iFileNum;
		int offset = height * (double)m_yPos/LIST_HEIGHT;

		int py  = y + start*height - offset;
		int pdy = y + end*height   - offset;

		if(py<y) py = y;
		if(pdy>dy+1) pdy = dy+1;

		dd.FillRect(x,py,dx,pdy);
	}
	else
	{
		// ܂ԂĂ
		double height = double(dy-y)/JukeBox[folPos].iFileNum;

		// 㑤
//		if(m_yPos<0) end -= m_yPos/(LIST_HEIGHT+1);

		int py  = y;
		int pdy = y + end*height;
		int offset = height * (double)m_yPos/(LIST_HEIGHT+1);

		int top    = py;//-offset;  if(top<y) top = y;
		int bottom = pdy-offset;// if(bottom>dy+1) bottom = dy+1;
		LOOP(top, y, dy-1);
		LOOP(bottom, y, dy-1);

		dd.FillRect(x,top,dx,bottom);

		// 
//		if(m_yPos>0) start += -m_yPos/(LIST_HEIGHT+1);

		py  = y + start*height;
		pdy = dy;
		offset = height * (double)m_yPos/(LIST_HEIGHT+1);

		top    = py-offset;  if(top<y) top = y;
		bottom = pdy;//-offset; if(bottom>dy+1) bottom = dy+1;
		LOOP(top, y, dy-1);
		LOOP(bottom, y, dy-1);

		dd.FillRect(x,top,dx,bottom);
	}
*/
}

// I[o[wbĥŉxgȂ
void CSelectMusic::SetFont(HDC hDC, const char* fontname, int height, BOOL bJapanese, BOOL bBold){

//	SetBkMode(hDC, TRANSPARENT);
//	return;

	LOGFONT lf;
	ZeroMemory(&lf, sizeof(lf));

	lstrcpy(lf.lfFaceName, fontname);
	lf.lfWeight			 = bBold ? FW_BOLD : FW_NORMAL; //FW_BOLD FW_HEAVY
	lf.lfEscapement		 = 0;
	lf.lfItalic			 = FALSE;
	lf.lfUnderline		 = FALSE;
	lf.lfStrikeOut		 = FALSE;
	lf.lfCharSet		 = bJapanese ? SHIFTJIS_CHARSET : ANSI_CHARSET;
//	lf.lfPitchAndFamily	 = VARIABLE_PITCH|FF_DONTCARE;
	lf.lfWidth			 = 0; // lfHeightɍ傫
	lf.lfQuality		 = ANTIALIASED_QUALITY;

	// |CgsNZϊ(by MFĈǂ)
/*	POINT pt;
	pt.y = ::GetDeviceCaps(hDC, LOGPIXELSY) * point*10;
	pt.y /= 720;    // 72 points/inch, 10 decipoints/point
	::DPtoLP(hDC, &pt, 1);
	POINT ptOrg = { 0, 0 };
	::DPtoLP(hDC, &ptOrg, 1);
	lf.lfHeight = -abs(pt.y - ptOrg.y);
*/
	lf.lfHeight = height;

	HFONT hFont = CreateFontIndirect(&lf); // 쐬

	SetBkMode(hDC, TRANSPARENT);
//	SetTextAlign(hDC, TA_LEFT|VTA_CENTER); // w肵_獶EɍL悤ɂȂ

	if(hFont!=NULL)
		m_OldFont = (HFONT)SelectObject(hDC, hFont); //I

}

void CSelectMusic::ReleaseFont(HDC hDC){

	HFONT hFont = NULL;

	if(m_OldFont!=NULL)
		hFont = (HFONT)SelectObject(hDC, m_OldFont); // 

	if(hFont!=NULL)
		DeleteObject(hFont);

}

// ɂQoCg܂܂邩肷
// TRUEԂ{tHgŕ`悷ׂ
BOOL CSelectMusic::IsDBCS(const char* str){

	if(str==NULL) return FALSE;

	int length = lstrlen(str);

	for(int i=0;i<length;i++)
	{
		if(IsDBCSLeadByte(str[i]))
			return TRUE;

		unsigned char ch = str[i];
		if(0xa1<=ch && ch<=0xe0)
			return TRUE; // pJi(
	}

	return FALSE;

}

void CSelectMusic::KeyCheck(void){

	if(m_bStartMusic)
		return; // ς݂Ȃ̂ŃL[󂯕tȂ

	// ŏIi(
	// ȌL[OɂāAȌƓɍďĐl̂Ő^ɏ
	if(DIkey.IsKeyPushDown(DIK_0))
	{
		WriteLog("SelectMusic() : DirectSoundď܂");

		// fXgN^Ăԁoϐ̃fXgN^Ă΂遨
		// ̂ŃRXgN^͌Ă΂Ȃ̂Ŗʓ|ȂƂɂȂ
//		ds.~CWaveControl();
		ds.Term();

//		ds.CWaveControl();
		if(opt.iSoundQlty == SQ_LOW)
		{
			if(!ds.Init(hmainwnd,22,8,2))
			{
				Notice("DirectSound̍ďɎs");
				WriteLog("SelectMusic() : DirectSound̍ďɎs");
			}
		}
		else
		{
			if(!ds.Init(hmainwnd,44,16,2))
			{
				Notice("DirectSound̍ďɎs");
				WriteLog("SelectMusic() : DirectSound̍ďɎs");
			}
		}
	}

	BOOL keyU = KEYPUSH(VK_MUSICUP);
	BOOL keyD = KEYPUSH(VK_MUSICDOWN);
	// L[s[g
	static CTimer keyUrep, keyDrep;
	if(!KEYPRESS(VK_MUSICUP))
		keyUrep.Reset();

	if(!KEYPRESS(VK_MUSICDOWN))
		keyDrep.Reset();

	if(keyUrep.Get()>500)
	{
		keyU = TRUE;
		keyUrep.Set(400);
	}

	if(keyDrep.Get()>500)
	{
		keyD = TRUE;
		keyDrep.Set(400);
	}

	BOOL keyPgUP = KEYPUSH(VK_PGUP);
	BOOL keyPgDN = KEYPUSH(VK_PGDN);
	BOOL keyRet  = KEYPUSH(VK_OK);
	BOOL keyESC  = KEYPUSH(VK_ESC);
	BOOL keyJkUP = KEYPUSH(VK_JUKEUP);
	BOOL keyJkDN = KEYPUSH(VK_JUKEDOWN);

	if(DIkey.IsKeyPushDown(DIK_O))
	{
		if(g_bClub)
			dp.Send(0.0,MES_MUSSEL_EXIT,TRUE);

		SetNextScene(SC1_OPTION);
		return; // ƓEnterƋȓǂݍłIvVɍsႤ̂ŉ
	}

	if(DIkey.IsKeyPushDown(DIK_B))
	{
		if(g_bClub)
			dp.Send(0.0,MES_MUSSEL_EXIT,TRUE);

		SetNextScene(SC1_OPTION_BM);
		return; // ƓEnterƋȓǂݍłIvVɍsႤ̂ŉ
	}

	if(DIkey.IsKeyPushDown(DIK_M))
	{
		if(g_bClub)
			dp.Send(0.0,MES_MUSSEL_EXIT,TRUE);

		SetNextScene(SC1_OPTION_2);
		return; // ƓEnterƋȓǂݍłIvVɍsႤ̂ŉ
	}

	// XRAڍו\EBhEJ
	if(DIkey.IsKeyPushDown(DIK_S))
	{
		m_bScoreDisp = !m_bScoreDisp;
	}

	if(keyU || keyD || keyPgUP || keyPgDN || keyRet || keyJkUP || keyJkDN ||
	   DIkey.IsKeyPushDown(DIK_F1) || DIkey.IsKeyPushDown(DIK_F2) ||
	   DIkey.IsKeyPushDown(DIK_F3) || DIkey.IsKeyPushDown(DIK_F4))
	{
		// L[
		m_holdTime.Reset();
	}

	// ESCL[Ƃ̏ǉȂA
	//	if(m_bScoreDisp)
	//		m_bScoreDisp = FALSE; // XRAڍ׃EBhEoĂ
	//	else
	//		
	// Ƃ̂x^[

	// e[hƂ̏
	switch(m_menuMode)
	{
		case MM_SELMUSIC:	KeyCheckMusicSelect();	break;
		case MM_SELDIFF:	KeyCheckDiffSelect();	break;
	}
}

void CSelectMusic::KeyCheckMusicSelect(void)
{
	BOOL keyU = KEYPUSH(VK_MUSICUP);
	BOOL keyD = KEYPUSH(VK_MUSICDOWN);
	BOOL keyJkUP = KEYPUSH(VK_JUKEUP);
	BOOL keyJkDN = KEYPUSH(VK_JUKEDOWN);
	// L[s[g
	static CTimer keyUrep, keyDrep, keyJkUPrep, keyJkDNrep;
	if(!KEYPRESS(VK_MUSICUP))
		keyUrep.Reset();
	if(!KEYPRESS(VK_MUSICDOWN))
		keyDrep.Reset();
	if(!KEYPRESS(VK_JUKEUP))
		keyJkUPrep.Reset();
	if(!KEYPRESS(VK_JUKEDOWN))
		keyJkDNrep.Reset();

	if(keyUrep.Get()>500)
	{
		keyU = TRUE;
		keyUrep.Set(400);
	}
	if(keyDrep.Get()>500)
	{
		keyD = TRUE;
		keyDrep.Set(400);
	}
	if(keyJkUPrep.Get()>500)
	{
		keyJkUP = TRUE;
		keyJkUPrep.Set(400);
	}
	if(keyJkDNrep.Get()>500)
	{
		keyJkDN = TRUE;
		keyJkDNrep.Set(400);
	}

	BOOL keyPgUP = KEYPUSH(VK_PGUP);
	BOOL keyPgDN = KEYPUSH(VK_PGDN);
	BOOL keyRet  = KEYPUSH(VK_OK);
	BOOL keyESC  = KEYPUSH(VK_ESC);

	// _ŗpl̎Zo
	static CTimer t2;
	static double count = 0;
	while(t2.Get() >= 15)
	{
		count+=0.7;
//		count+=t.Get()/15;
		t2.Adjust(-15);
	}

#define PI 3.141592653589793238

	if(count<0)
		m_alpha = 1.0f;
	else
		m_alpha = (float)ABS(cos(fmod(count/35.0, PI/2.0)+PI/14.0));

	if(opt.iEffect<=GE_MID) m_alpha = 1.0f;

	// J[\ړ
	const int PAGE = 10; // 1y[W̃t@C (PgUP/DNŔԃt@C)
	if(keyU || keyD || keyPgUP || keyPgDN)
	{
		Juke[folPos].Lock();
		{
			if(Juke[folPos].IsRead())
			{
				if(keyU)
					m_curPos--,		m_yPos-=(LIST_HEIGHT+1),		PlaySoundSet(SS_MS_RIGHT);
				if(keyD)
					m_curPos++,		m_yPos+=(LIST_HEIGHT+1),		PlaySoundSet(SS_MS_LEFT);
				if(keyPgUP)
					m_curPos-=PAGE, m_yPos-=(LIST_HEIGHT+1)*PAGE,	PlaySoundSet(SS_MS_RIGHT);
				if(keyPgDN)
					m_curPos+=PAGE, m_yPos+=(LIST_HEIGHT+1)*PAGE,	PlaySoundSet(SS_MS_LEFT);

				LOOP(m_curPos, 0, (int)Juke[folPos].size()-1);
			}
		}
		Juke[folPos].UnLock();

		m_diffPos = 0;

		// J[\ړƂ͂΂炭邭\
		count = -50;
		m_alpha = 1.0f;

		// JukeXgXChAEg
		if(m_JukeWndDisp.Get() < JUKELIST_INTIME+JUKELIST_DISPTIME)
			m_JukeWndDisp.Set(JUKELIST_INTIME+JUKELIST_DISPTIME);
	}

	// JukeBox Down or Up
	if(keyJkDN || keyJkUP)
	{
		m_yPos = 0; // ȃXg̃XN[~߂
		m_diffPos = 0;

		if((int)m_curPosRec.size() <= folPos) m_curPosRec.resize(folPos+1, 0); // on demandŊg
		m_curPosRec[folPos] = m_curPos; //J[\ʒuL

		if(keyJkDN)
			m_xPos-=(127+1), folPos--, PlaySoundSet(SS_JUKE_DOWN);
		else
			m_xPos+=(127+1), folPos++, PlaySoundSet(SS_JUKE_UP);

		Juke[0].Lock();
		{
			LOOP(folPos, 0, (int)Juke.size()-1);
		}
		Juke[0].UnLock();

		if((int)m_curPosRec.size() <= folPos) m_curPosRec.resize(folPos+1, 0); // on demandŊg
		m_curPos = m_curPosRec[folPos]; //J[\ʒu

		assert(0<=folPos && folPos<65535); // ςȒl͓ĂȂˁH

		Juke[folPos].Lock();
		{
			// vectorɕςȒl͓ĂȂˁH
			if(m_curPos<0 || m_curPos>=(int)Juke[folPos].size())
				m_curPos = 0;

			// IJukeDIɓǂ܂
			if(!Juke[folPos].IsRead())
				Juke.SetNextScanTarget(folPos, 0);
		}
		Juke[folPos].UnLock();

		m_diffPos = 0;

		// J[\ړƂ͂΂炭邭\
		count = -50;
		m_alpha = 1.0f;

		// JukeXgXChC
		m_JukeWndDisp.Reset();
	}

	if(keyESC)
	{
		if(m_bScoreDisp)
			m_bScoreDisp = FALSE; // XRAڍ׃EBhEoĂ
		else
			SetNextScene(SC1_TITLE);
	}

	// _ZNg
	if(DIkey.IsKeyPushDown(DIK_R))
	{
		if(DIkey.IsKeyPress(DIK_LSHIFT) || DIkey.IsKeyPress(DIK_RSHIFT))
		{
			// SJuke烉_
			if((int)m_curPosRec.size() <= folPos) m_curPosRec.resize(folPos+1, 0); // on demandŊg
			m_curPosRec[folPos] = m_curPos; //J[\ʒuL

			// SȐZo
repeat:		int musTotal = 0;
			for(int i=0;i<(int)Juke.size();i++)
			{
				Juke[i].Lock();
				{
					for(int j=0;j<(int)Juke[i].size();j++)
					{
						musTotal += (int)Juke[i][j].size();
					}
				}
				Juke[i].UnLock();
			}

			// ̒烉_
			int musPlay = rnd.Get(musTotal);

			// ΉJuke,DataSetT
			i=0;
			int j=0;

			Juke[i].Lock();
			{
				while(musPlay-(int)Juke[i][j].size()>=0)
				{
					musPlay -= (int)Juke[i][j].size();
					j++;

					if(j >= (int)Juke[i].size())
					{
						Juke[i].UnLock();
						j=0, i++;
						Juke[i].Lock();
					}
				}
			}
			Juke[i].UnLock();

			folPos = i;
			m_curPos = j;
			m_diffPos = musPlay;

			// ASYɎMȂ̂(
			assert(folPos < (int)Juke.size());
			assert(m_curPos < (int)Juke[folPos].size());
			assert(m_diffPos < (int)Juke[folPos][m_curPos].size());

			// ܂ǂłȂJukeɓƂ͂
			Juke[folPos].Lock();
			{
				if(!Juke[folPos].IsRead())
				{
					Juke[folPos].UnLock();
					goto repeat;
				}
			}
			Juke[folPos].UnLock();
		}
		else
		{
			// ݂JukeŃ_
			Juke[folPos].Lock();
			{
				if(Juke[folPos].IsRead())
				{
					// SȐZo
					int musTotal = 0;
					for(int i=0;i<(int)Juke[folPos].size();i++)
					{
						musTotal += (int)Juke[folPos][i].size();
					}

					// ̒烉_
					int musPlay = rnd.Get(musTotal);

					// ΉDataSetT
					i=0;
					while(musPlay-(int)Juke[folPos][i].size()>=0)
					{
						musPlay -= (int)Juke[folPos][i].size();
						i++;
					}

					m_curPos = i;
					m_diffPos = musPlay;

					// ASYɎMȂ̂(
					assert(m_curPos < (int)Juke[folPos].size());
					assert(m_diffPos < (int)Juke[folPos][m_curPos].size());
				}
			}
			Juke[folPos].UnLock();
		}

		// ̃t[ŃJ[\ړĉʕ\B
		// ̃t[ŎIɋȃX^[g
		// ƂAL[̕`葬̂ŕ\ꂸB(L֥`)د
		keyRet = TRUE;
		m_bRndDecide = TRUE;
	}

	// L[B_ZNgkeyRet = TRUÊŃ_ZNǧɒu
	if(keyRet)
	{
		if(m_bScoreDisp && !m_bRndDecide)
			m_bScoreDisp = FALSE; // XRAڍ׃EBhEoĂ
		else
		{
			Juke[folPos].Lock();
			{
				if(Juke[folPos].IsRead())
				{
					// ړ̋Ȃɑ݂ȂDiffPosƗ̂őΏ
					if(m_diffPos >= (int)Juke[folPos][m_curPos].size())
						m_diffPos = 0;

					m_menuMode = MM_SELDIFF;
					lpGlobScene->SetPartNo(PART_SELMUSIC_SELDIFF);

					// JukeXgXChAEg
					if(m_JukeWndDisp.Get() < JUKELIST_INTIME+JUKELIST_DISPTIME)
						m_JukeWndDisp.Set(JUKELIST_INTIME+JUKELIST_DISPTIME);
				}
			}
			Juke[folPos].UnLock();
		}
	}

	// \[gZNg
	if(DIkey.IsKeyPushDown(DIK_F1))
	{
		m_sortDataSetMode = CMusicList::SORT_TITLE;
		SortDataSet();
		m_sortDispTime.Set(0);
	}
	if(DIkey.IsKeyPushDown(DIK_F2))
	{
		m_sortDataSetMode = CMusicList::SORT_SCANTIME;
		SortDataSet();
		m_sortDispTime.Set(0);
	}
}

void CSelectMusic::KeyCheckDiffSelect(void)
{
	BOOL keyU = KEYPUSH(VK_MUSICUP);
	BOOL keyD = KEYPUSH(VK_MUSICDOWN);
	// L[s[g
	static CTimer keyUrep, keyDrep;
	if(!KEYPRESS(VK_MUSICUP))
		keyUrep.Reset();

	if(!KEYPRESS(VK_MUSICDOWN))
		keyDrep.Reset();

	if(keyUrep.Get()>500)
	{
		keyU = TRUE;
		keyUrep.Set(400);
	}

	if(keyDrep.Get()>500)
	{
		keyD = TRUE;
		keyDrep.Set(400);
	}

	BOOL keyPgUP = KEYPUSH(VK_PGUP);
	BOOL keyPgDN = KEYPUSH(VK_PGDN);
	BOOL keyRet  = KEYPUSH(VK_OK);
	BOOL keyESC  = KEYPUSH(VK_ESC);

	// _ŗpl̎Zo
	static CTimer t2;
	static double count = 0;
	while(t2.Get() >= 15)
	{
		count+=0.7;
//		count+=t.Get()/15;
		t2.Adjust(-15);
	}

#define PI 3.141592653589793238

	if(count<0)
		m_alpha = 1.0f;
	else
		m_alpha = (float)ABS(cos(fmod(count/35.0, PI/2.0)+PI/14.0));

	if(opt.iEffect<=GE_MID) m_alpha = 1.0f;

	// J[\ړ
	const int PAGE = DIFF_LIST_ROWS; //1y[W̃t@C (PgUP/DNŔԃt@C)
	if(keyU || keyD || keyPgUP || keyPgDN) // && m_yPos==0)
	{
		if(keyU)
			m_diffPos--, PlaySoundSet(SS_MS_RIGHT);
		if(keyD)
			m_diffPos++, PlaySoundSet(SS_MS_LEFT);
		if(keyPgUP)
			m_diffPos-=PAGE, PlaySoundSet(SS_MS_RIGHT);
		if(keyPgDN)
			m_diffPos+=PAGE, PlaySoundSet(SS_MS_LEFT);

		Juke[folPos].Lock();
		{
			if(Juke[folPos].IsRead())
			{
				int max = (int)Juke[folPos][m_curPos].size()-1;

				if(keyU || keyD)
					LOOP(m_diffPos, 0, max);
				else
				{
					// Iɂ킩₷ɂȂ悤ɋCĂ݂
					if(max<m_diffPos)
						m_diffPos %= PAGE;

					if(m_diffPos<0)
					{
						m_diffPos = (max+1)/PAGE*PAGE + (m_diffPos+PAGE);
						if(m_diffPos>max)
							m_diffPos -= PAGE;
					}
				}
			}
			else
				m_diffPos = 0;
		}
		Juke[folPos].UnLock();

		PlayShortBGM(folPos, m_curPos);

		// J[\ړƂ͂΂炭邭\
		count = -50;
		m_alpha = 1.0f;
	}

	// _ZNg
	if(DIkey.IsKeyPushDown(DIK_R))
	{
		// ݂DataSetŃ_
		Juke[folPos].Lock();
		{
			if(Juke[folPos].IsRead())
			{
				m_diffPos = rnd.Get(Juke[folPos][m_curPos].size());
			}
		}
		Juke[folPos].UnLock();

		// ̃t[ŃJ[\ړĉʕ\B
		// ̃t[ŎIɋȃX^[g
		// ƂAL[̕`葬̂ŕ\ꂸB(L֥`)د
		keyRet = TRUE;
		m_bRndDecide = TRUE;
	}

	if(keyRet || m_bRndDecide)
	{
//		if(m_bScoreDisp && !m_bRndDecide)
//			m_bScoreDisp = FALSE; // XRAڍ׃EBhEoĂ
//		else

		// EBhEƂ̃AjX^[g
		m_bStartMusic = TRUE;

		m_bRndDecide = FALSE; // ꂪȂƃRpCG[ɖ[vɂ͂܂

		ds.Stop(SS_SELECTMUSIC); // BGM~߂
		PlaySoundSet(SS_MS_DECIDE); // 艹炷

		// StageFileǂݍ
		m_showStageFile = LoadStageFile();

		if(m_showStageFile)
			lpGlobScene->Hide(); // StageFileDx̂ŏĂ

		m_StartMusicTime.Set(0); // ^C}[Zbg
	}

	if(keyESC)
	{
		if(m_bScoreDisp)
			m_bScoreDisp = FALSE; // XRAڍ׃EBhEoĂ
		else
		{
			m_menuMode = MM_SELMUSIC;
			lpGlobScene->SetPartNo(PART_SELMUSIC_SELMUSIC);
		}
	}

	if(m_holdTime.Get() > HOLD_TIMEOUT)
	{
		// 莞ԃJ[\~߂̂CRC擾
		CalcSelectedMusicCRC();

		m_holdTime.Reset();
	}

	// \[gZNg
	if(DIkey.IsKeyPushDown(DIK_F1))
	{
		m_sortMode = CMusicList::SORT_TITLE;
		SortData();
		m_sortDispTime.Set(0);
	}

	if(DIkey.IsKeyPushDown(DIK_F2))
	{
		m_sortMode = CMusicList::SORT_ARTIST;
		SortData();
		m_sortDispTime.Set(0);
	}

	if(DIkey.IsKeyPushDown(DIK_F3))
	{
		m_sortMode = CMusicList::SORT_GENRE;
		SortData();
		m_sortDispTime.Set(0);
	}

	if(DIkey.IsKeyPushDown(DIK_F4))
	{
		m_sortMode = CMusicList::SORT_LEVEL;
		SortData();
		m_sortDispTime.Set(0);
	}

	if(DIkey.IsKeyPushDown(DIK_F5))
	{
		m_sortMode = CMusicList::SORT_SCANTIME;
		SortData();
		m_sortDispTime.Set(0);
	}
}

// ȃZShort-WAVE & DA𗬂
void CSelectMusic::PlayShortBGM(int folPos, int curPos){

	return;

/*	if(folPos<0 || MAX_JUKE<=folPos || curPos<0 || MAX_FILES<=curPos)
		return;

	if(JukeBox[folPos].Musdat[curPos]==NULL)
		return;

	if(opt.bShortWAV && JukeBox[folPos].Musdat[curPos]->WavCh!=-1 && ds.IsReady(JukeBox[folPos].Musdat[curPos]->WavCh))
	{
		// Short-WAVE
		ds.StopAll();
		ds.Play(JukeBox[folPos].Musdat[curPos]->WavCh);
		cd.Stop();
	}
	else
	{
		// SoundSet
		if(!ds.IsPlaying(11))
		{
			ds.StopAll();
			ds.Play(11,TRUE);
		}
	}

	// ׂCc
	if(opt.bShortDA && (JukeBox[folPos].Musdat[curPos]->WavCh==-1 || !opt.bShortWAV) )
		cd.Play(JukeBox[folPos].Musdat[curPos]->CDTr-38);
*/
}

// ȃXg̍㌴_x,yɗ^iȖڂ̍WԂ
// modeŃXChCEAEgEʒũZbgw
// count̓Aj[VJn̎(PPʂ͂Ƃ肠16ms)
void CSelectMusic::CalcPos(int& x, int& y, int i, int mode, int count)
{
	if(mode==DML_RESET)
		return;

	int dx = x;
	int dy = y + i*LIST_HEIGHT + int(m_yPos);

	if(mode==DML_SLIDEIN)
	{
		// XChC
		double pos = (30-count) / 30.0; if(pos<0.2) pos = 0;
		double factor = pos==0 ? 0 : log(5*pos) / log(5.0);
		RANGE(factor, 0.0, 1.0);
		dx = dx + DWORD(factor*dd.GetSpriteX(sp_wnd_selfile)); // LIST_WIDTH/2 + count*25 - (i*25); //pow(count,2.2)

//		if(count > 40)
//			dx = dx + 2 * (50-count);
//		else
//			dx = dx + 20 + 8 * (40-count);

		RANGE(dx, x, 10000);
	}
	else
	{
		// XChAEg
//		dx = dx - LIST_WIDTH/2 - count*25 + (i*25); //pow(count,2.2)
//		RANGE(dx, -10000, x);

		double pos = count/30.0; if(pos<0.2) pos = 0;
		double factor = pos==0 ? 0 : log(5*pos) / log(5.0);
		RANGE(factor, 0.0, 1.0);
		dx = dx + DWORD(factor*dd.GetSpriteX(sp_wnd_selfile)); // LIST_WIDTH/2 + count*25 - (i*25); //pow(count,2.2)

		RANGE(dx, x, 10000);
	}

	// I΂ĂȂo点
/*	int center = LIST_HEIGHT*LIST_SELECTEDNUM + LIST_HEIGHT/2;
	int offset = 5 - ABS(dy+LIST_HEIGHT/2-center)/2;
	if(offset>0) dx+=offset;
*/
	x = dx;
	y = dy;

}

BOOL CSelectMusic::LoadMusic(void)
{
	Juke.StopBGScan();

	// ܂܂ɂȂ悤
	lpGlobScene->Show();

	Juke[folPos].Lock();
	{
		ScoreInfo.lpHeader = &Juke[folPos][m_curPos][m_diffPos];
		ScoreInfo.fullpath = Juke.GetFullPath(folPos, m_curPos, m_diffPos);
	}
	Juke[folPos].UnLock();

	// tH_ƃpXɕ
	const char* path = ScoreInfo.fullpath.c_str();
	char folder[MAX_PATH];
	char file[MAX_PATH];
	GetPath(folder, path);
	GetFileName(file, path);

	switch(CheckType(file))
	{
		case TYPE_MSD:
		{
			MSD msd;
			char szErrTxt[1024];

			if(GoMSD(file, folder, szErrTxt, msd, m_dif))
			{
				dd.ClearScreen(); // Xbv̂߂̕`悪̉
				return TRUE;
			}
			else
			{
				WriteLog("RpCG[ : %s",szErrTxt);
				dd.GetLpDD()->FlipToGDISurface();
				MessageBox(hmainwnd, szErrTxt, "RpCG[I", MB_OK);
				ClearKeyInfo();
				return FALSE;
			}

			break; //endof case TYPE_MSD:
		}

		case TYPE_BMS:
		{
			BMS bms;
			BOOL res;
			char szErrTxt[1024];

			// LbV@\ς :-)
			res = LoadBMS(file, folder, szErrTxt, &bms, TRUE, m_dif);

			if(res)
			{
				GoBMS(bms);
				dd.ClearScreen(); // Xbv̂߂̕`悪̉

				dd.UnLoadBMP(32); // MSD̃
				ds.ReleaseWave(0);

				return TRUE;
			}
			else
			{
				WriteLog("RpCG[ : %s",szErrTxt);
				dd.GetLpDD()->FlipToGDISurface();
				MessageBox(hmainwnd, szErrTxt, "RpCG[I", MB_OK);
				ClearKeyInfo();
				return FALSE;
			}

			break; //endof case TYPE_BMS:
		}

		default:
//			WriteLog("mȂt@C`");
//			WriteLog(szFile[curPos]);
			return FALSE;
			break;

	} // endof switch

}

// qsortpr֐
int CSelectMusic::CompareTitle( const void *arg1, const void *arg2 ){

	HEADER** dat1 = (HEADER**)arg1;
	HEADER** dat2 = (HEADER**)arg2;

	return _stricmp((*dat1)->title.c_str(), (*dat2)->title.c_str());

}

int CSelectMusic::CompareArtist( const void *arg1, const void *arg2 ){

	HEADER** dat1 = (HEADER**)arg1;
	HEADER** dat2 = (HEADER**)arg2;

	int res = _stricmp((*dat1)->artist.c_str(), (*dat2)->artist.c_str());

	if(res==0)
		return CompareTitle(arg1, arg2); // A[eBXgȂ^Cg
	else
		return res;

}

int CSelectMusic::CompareGenre( const void *arg1, const void *arg2 ){

	HEADER** dat1 = (HEADER**)arg1;
	HEADER** dat2 = (HEADER**)arg2;

	int res = _stricmp((*dat1)->genre.c_str(), (*dat2)->genre.c_str());

	if(res==0)
		return CompareTitle(arg1, arg2); // WȂ^Cg
	else
		return res;

}

int CSelectMusic::CompareLevel( const void *arg1, const void *arg2 ){

	HEADER* dat1 = *((HEADER**)arg1);
	HEADER* dat2 = *((HEADER**)arg2);

	int level1, level2;

	if(CheckType(dat1->szFile.c_str())==TYPE_BMS)
		level1 = dat1->level[0];
	else
		level1 = dat1->level[m_dif+1];

	if(CheckType(dat2->szFile.c_str())==TYPE_BMS)
		level2 = dat2->level[0];
	else
		level2 = dat2->level[m_dif+1];

	if(level1==level2)
		return CompareTitle(arg1, arg2); // xȂ^Cg
	else
		return level1 - level2;

}

// SJukeBoxDatasetm_bSortDataSetɏ]ă\[g
void CSelectMusic::SortDataSet(void)
{
	if(m_sortDataSetMode==CMusicList::SORT_NONE)
		return;

	for(DWORD i=0;i<Juke.size();i++)
	{
		Juke.Sort(i, m_sortDataSetMode);
	}
}

// SJukeBox̑SDatasetdatã݂L[Ń\[g
void CSelectMusic::SortData(void)
{
	if(m_sortMode==CMusicList::SORT_NONE)
		return;

	for(DWORD i=0;i<Juke.size();i++)
	{
		for(DWORD j=0;j<Juke[i].size();j++)
		{
			Juke.Sort(i, j, m_sortMode);
		}
	}
}

void CSelectMusic::PlayOptionToText(PLAY_OPTION* opt, char* buf)
{
	char* ocstr[] = {"--", "OC"}; // OUCH
	char* vdstr[] = {"VV", "FL"}; // Flat/Vivid
	char* blstr[] = {"--", "HD", "SD", "ST"}; // HID / SUD / STEALTH
	char* arstr[] = {"--", "MR", "SF", "LS"}; // Mirror / Shuffle / Line Shuffle
	char* ltstr[] = {"--", "LT", "MN"}; // Little / Minimum
	char* hststr[]= {"--", "AC", "DC", "PR"}; // Accel. / Decel. / Para.
	char* revstr[]= {"--", "RV"}; // Reverse

	sprintf(buf, "Options : x%d.%02d ", opt->highSpeed/100, opt->highSpeed%100);

	if(IsDDR())
	{
		// DDR Only
		strcat(buf, ocstr[opt->ouch]);
		strcat(buf, " ");

		strcat(buf, vdstr[opt->flat]);
		strcat(buf, " ");

		strcat(buf, revstr[opt->reverse]);
		strcat(buf, " ");
	}

	strcat(buf, blstr[opt->blind]);
	strcat(buf, " ");

	strcat(buf, arstr[opt->noteArr]);
	strcat(buf, " ");

	strcat(buf, hststr[opt->hsStyle]);
}

// XRAEBMS̃vpeBڍו\
void CSelectMusic::DrawScoreWindow(void)
{
	// hBɂd߂c
	int x = 50, y = 45;
	dd.FillRect(x, y, SCR_W-x, SCR_H-y);

	x+=10, y+=10;

	// XRA
	DWORD crc, filesize;
	CalcSelectedMusicCRC();
	Juke[folPos].Lock();
	{
		crc			= Juke[folPos][m_curPos][m_diffPos].crc32;
		filesize	= Juke[folPos][m_curPos][m_diffPos].scoreFileSize;
	}
	Juke[folPos].UnLock();

	// `
	MUSIC_STAT* lpMS = score.Get(crc, filesize);
	if(lpMS==NULL)
	{
		// o^
		lpGlobScene->DrawFont(x, y, "<No Score>", FONT_WHITE);
	}
	else
	{
		// XRA
		char buf[128];
		sprintf(buf, "(%s) %s / %s", lpMS->genre.c_str(), lpMS->title.c_str(), lpMS->artist.c_str());
		lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
		y+=10;
		y+=10;

		string filename;
		Juke[folPos].Lock();
		{
			filename = Juke.GetFullPath(folPos, m_curPos, m_diffPos);
		}
		Juke[folPos].UnLock();

		lpGlobScene->DrawFont(x, y, filename.c_str(), FONT_WHITE);
		y+=10;

		sprintf(buf, "CRC : %08X / Size : %lu", crc, filesize);
		lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
		y+=10;
		y+=10;

		unsigned __int64 totsc = IsBM() ? lpMS->bmTotalScore : lpMS->ddrTotalScore;
		DWORD pc = IsBM() ? lpMS->bmPlaycount : lpMS->ddrPlaycount;
		DWORD scnt = IsBM() ? lpMS->bmScorecount : lpMS->ddrScorecount;

		double avg = scnt!=0 ? double(totsc)/scnt : 0.0;
		sprintf(buf, "Total Score : %I64u / Average : %.2lf", totsc, avg);
		lpGlobScene->DrawFont(x, y, buf, FONT_WHITE); y+=10;

		sprintf(buf, "Play Count : %lu", pc);
		lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
		y+=10;
		y+=10;

		for(int i=0;i<5;i++)
		{
			SCORE* sc = IsBM() ? lpMS->bmScore : lpMS->ddrScore;

			if(sc[i].bmScore==0)
				break;

			struct tm* lct = localtime(&sc[i].timestamp);
			sprintf(buf, "Rank %d (%d/%d/%d %d:%02d:%02d)", i+1, lct->tm_year+1900, lct->tm_mon+1, lct->tm_mday, lct->tm_hour, lct->tm_min, lct->tm_sec);
			lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
			
			x+=10; y+=10;

				// unionȂ̂bmddr͈ӎȂłc
				sprintf(buf, "Score : %d", sc[i].bmScore);
				lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
				y+=10;

				if(IsBM())
					sprintf(buf, "JG %d / GR %d / GD %d / BD %d / PR %d / OC %d", sc[i].perfect, sc[i].great, sc[i].good, sc[i].boo, sc[i].miss, sc[i].ouch);
				else
					sprintf(buf, "PF %d / GR %d / GD %d / BO %d / MS %d / OC %d / OK %d / NG %d", sc[i].perfect, sc[i].great, sc[i].good, sc[i].boo, sc[i].miss, sc[i].ouch, sc[i].ok, sc[i].ng);
				lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
				y+=10;

				if(IsBM())
				{
					switch(sc[i].play_opt.comboMode)
					{
					case 0:
						sprintf(buf, "Max Combo : Disabled");
						lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
						y+=10;
						break;
					case 1:
						sprintf(buf, "Max Combo : %d (Great&Good)", sc[i].maxCombo);
						lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
						y+=10;
						break;
					case 2:
						sprintf(buf, "Max Combo : %d (Great only)", sc[i].maxCombo);
						lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
						y+=10;
						break;
					}
				}
				else
				{
					sprintf(buf, "Max Combo : %d", sc[i].maxCombo);
					lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
					y+=10;
				}

				PlayOptionToText(&sc[i].play_opt, buf);
				lpGlobScene->DrawFont(x, y, buf, FONT_WHITE);
				y+=10;

			x-=10;
			y+=10;
		} // best5`
	}

}

void CSelectMusic::WriteScoreFromDB(void)
{
	FILE* fp = fopen("score_certified.txt", "a+");
	if(fp==NULL)
	{
		WriteLog("CSelectMusic::WriteScoreFromDB() : score_certified.txtJ܂");
		return;
	}

	// XRA
	DWORD crc = 0xFFFFFFFF, filesize=0;
/*	
	// XV
	if(CheckType(JukeBox[folPos].Musdat[m_curPos]->szFile.c_str())==TYPE_BMS)
	{
		// CRC擾
		string filename = AddYen(JukeBox[folPos].Musdat[m_curPos]->szPath) + JukeBox[folPos].Musdat[m_curPos]->szFile;
		crc = score.CalcCRC32(filename.c_str());
		filesize = score.GetFileSize(filename.c_str());
	}
	else
	{
		// CRC擾
		string filename = AddYen(JukeBox[folPos].Musdat[m_curPos]->szPath) + JukeBox[folPos].Musdat[m_curPos]->szFile;
		crc = score.CalcCRC32(filename.c_str(), m_dif);
		filesize = score.GetFileSize(filename.c_str());
	}
*/
	MUSIC_STAT* lpMS = score.Get(crc, filesize);
	if(lpMS==NULL)
	{
		// o^
		return;
	}
	else
	{
		// XRA
		time_t scoreTime = IsBM() ? lpMS->bmScore[0].timestamp : lpMS->ddrScore[0].timestamp;
		struct tm* lct = localtime(&scoreTime);
		fprintf(fp, "%d/%d/%d %d:%02d:%02d", lct->tm_year+1900, lct->tm_mon+1, lct->tm_mday, lct->tm_hour, lct->tm_min, lct->tm_sec);
		fprintf(fp, szVerStr);

		if(IsBM())
		{
			// BM Score
			
		}
		else
		{
			// DDR Score
		}
	}

/*
	---------------------------------------
	2002/11/14 18:33:20
	Delight Ver.0.50 beta3.2

	Title : negative dance 21st mix
	Genre : afgan beat
	Artist : crasoky
	CRC : 3EDF001A
	FileSize : 12345

	Score : 123456
	MaxCombo : 256
	Just Great : 123
	Great : 456
	Good : 789
	Bad : 123
	Poor : 456
	Ouch : 789
	HighSpeed : x1.2
	Combo : OFF / Great&Good / Great
	Option : Hidden / Sudden / Stealth / Mirror / Shuffle / Line Shuffle / Accel. / Decel. / Para.

	Password : AUNGIBDA
	---------------------------------------
*/

}

void CSelectMusic::CalcSelectedMusicCRC(void)
{
	Juke[folPos].Lock();
	{
		string filename = Juke.GetFullPath(folPos, m_curPos, m_diffPos);

		int msdDiff;
//		if(CheckType(filename.c_str())==TYPE_BMS)
			msdDiff = -1;
//		else
//			msdDiff = Juke[folPos][m_curPos][m_diffPos].msdDiff;

		if(Juke[folPos][m_curPos][m_diffPos].crc32==0xFFFFFFFF)
		{
			Juke[folPos][m_curPos][m_diffPos].crc32 = score.CalcCRC32(filename.c_str(), msdDiff);
			Juke[folPos][m_curPos][m_diffPos].scoreFileSize = score.GetFileSize(filename.c_str());
		}
	}
	Juke[folPos].UnLock();
}

void CSelectMusic::DrawStageFileClassic(void)
{
	dd.DefSprite(STAGEFILE_SPNUM, STAGEFILE_BMPNUM, 0,0,0,0);

	// \̉ʂ
	dd.ClearScreen();
	dd.Flip();
	dd.ClearScreen();
	dd.Flip();

	CTimer stage;
	for(int i=0;i<dd.GetSpriteY(STAGEFILE_SPNUM);i+=2)
	{
		dd.DrawSpriteWipePrimary(STAGEFILE_SPNUM,0,0,i,FALSE);
		
		KEY_INPUT;
		if(KEYPUSH(VK_OK)||KEYPUSH(VK_ESC))
		{
			dd.DrawSprite(STAGEFILE_SPNUM,0,0,1.0, FALSE);
			dd.Flip();
			dd.DrawSprite(STAGEFILE_SPNUM,0,0,1.0, FALSE);
			break;
		}

		// Ȃ悤ԑ҂
		while(stage.Get()<8) ;
		stage.Reset();
	}

	dd.SyncScreen();
}

void CSelectMusic::StartMusic(void)
{
	// ȃX^[g
	UnLoadBMP(); // BMSpVRAM󂯂

	if(dd.GetScreenColor()==8)
	{
		// pbgύX̐Fh~
		dd.ClearScreen();
		dd.Flip();

		// pbgݒBBMSÂ߂ɂƂ
		if(IsBM())
		{
			dd.LoadPalette("Image\\pal_bm.bmp");
		}
		else
		{
			dd.LoadPalette("Image\\pal_ddr.bmp");
		}

		lpGlobScene->RemapPalette();
	}

	if(LoadMusic())
	{
		m_menuMode = MM_SELMUSIC;
		SetNextScene(SC1_GAMEMAIN);
	}
	else
	{
		// [hsBȃZɖ߂
		LoadBMP();
		PlaySoundSet(SS_SELECTMUSIC); // BGMĐ
		// PlayShortBGM(folPos, m_curPos);
	}
}

BOOL CSelectMusic::LoadStageFile(void)
{
	// J[\ʒűȂɑΉStageFileǂݍ
	string stageFileName, path;
	Juke[folPos].Lock();
	{
		if(Juke[folPos].IsRead())
		{
			if(Juke[folPos][m_curPos][m_diffPos].bStageFile)
			{
				path = Juke[folPos].folder + "\\" + Juke[folPos][m_curPos].folder;
				stageFileName = Juke[folPos][m_curPos][m_diffPos].stageFile;
			}
		}
	}
	Juke[folPos].UnLock();

	if(stageFileName=="")
		return FALSE;

	char oldDir[MAX_PATH];
	if(!GetCurrentDirectory(MAX_PATH, oldDir))
		return FALSE;

	if(!SetCurrentDirectory(path.c_str()))
		return FALSE;

	BOOL res = FALSE;

	if(dd.LoadBMP(STAGEFILE_BMPNUM, const_cast<char*>(stageFileName.c_str())))
	{
		dd.DefSprite(STAGEFILE_SPNUM, STAGEFILE_BMPNUM, 0,0,0,0);
		res = TRUE;
	}

	if(!SetCurrentDirectory(oldDir))
		return FALSE;

	return res;
}

void CSelectMusic::DrawStageFile(BOOL bBlack)
{
	// ɎԍuĂStageFileo
	const int MARGINTIME = 300;
	if(m_StartMusicTime.Get() < MARGINTIME)
		return;

	// 1ԉ̃C[ɁA2Ԗڂ̃CE[ɂ܂1b
	double pos = (double)(m_StartMusicTime.Get()-MARGINTIME) / (STARTMUSIC_TIME-MARGINTIME);
	RANGE(pos, 0.0, 1.0);
	// double pos = (30-count) / 30.0; if(pos<0.2) pos = 0;

	// xWFȐȂ񂩎gĂ݂
	// [_(0,0),(1,1)

	// ڂڂH
/*	double x2 = 0.4;
	double y2 = 1.2;
	double x3 = 0.75;
	double y3 = 0.7;
*/

	double x2 = 0.4;
	double y2 = 1.2;
	double x3 = 0.75;
	double y3 = 0.7;

	// x͎gȂ
	// fx(t) = 3*(1-t)**2*t*x2 + 3*(1-t)*t**2*x3 + t**3

//	double factor = pos==0 ? 0 : 1.5 * log(5.0*pos) / log(5.0);
//	double factor = pos==0 ? 0 : log(5.0*pos) / log(3.0);
//	RANGE(factor, 0.0, 1.0);

	for(int i=0;i<480;i++)
	{
		// ̂ق̃C̐i܂
		double rateFactor = 1.0 - double(i)/480; //pow((double(i)/480), 2);
		rateFactor = rateFactor*0.3;
		// RANGE(rateFactor, 1.0, 2.0);

		double t = pos + rateFactor;
		RANGE(t, 0.0, 1.0);
		double factor = 3*pow(1-t,2.0)*t*y2 + 3*(1-t)*pow(t,2.0)*y3 + pow(t,3.0);

		int x = int(640*factor);
		RANGE(x, 0, 640);

		dd.DefSprite(STAGEFILE_SPNUM, STAGEFILE_BMPNUM, 0, i, 640, i+1);

		if(i%2==0)
		{
			// C͍E
			if(bBlack)
				dd.FillRect(-640+x, i, -640+x+640, i+1);
			else
				dd.DrawSprite(STAGEFILE_SPNUM, -640+x, i, 1.0, FALSE);
		}
		else
		{
			// C͉E獶
			if(bBlack)
				dd.FillRect(640-x, i, 640-x+640, i+1);
			else
				dd.DrawSprite(STAGEFILE_SPNUM, 640-x, i, 1.0, FALSE);
		}
	}
}
