// DirectInput Wrapper

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneDirectInput.h"
#include "yaneCOM.h"
#include "yaneError.h"
#include "yaneMacro.h"

// COMIďoł́ADirectInput̃C^[tF[XȂ
// iWindowsNT4.0+ServicePack3) IDirectInputGUIDႤB
//	 ́AMicrosoft̃`{ƎvB
// dȂ̂ŁAňLoadLibraryB

	HINSTANCE __hDirectInputDLL = NULL;

//////////////////////////////////////////////////////////////////////////////
CDirectInput::CDirectInput(void){
	m_lpDirectInput=NULL;
	m_lpDIKeyDev=NULL;

	if (CYCOM::AddRef()) { // COMgŁ[
		m_bSuccessInit = false;
	} else {
		m_bSuccessInit = true;
	}
}

CDirectInput::~CDirectInput(){
	Terminate(); // sȎ҂̂߂ɈꉞAI:p

	CYCOM::Release(); // COMgIŁ[

	// 邢́ALoadLibraryĂH
	if (__hDirectInputDLL!=NULL) FreeLibrary(__hDirectInputDLL);

}

//////////////////////////////////////////////////////////////////////////////

LRESULT CDirectInput::Initialize(HWND hWnd,HINSTANCE hInst){  // 
	Terminate(); // IɂďiÔ߁j

	m_nKeyBufNo=0;	// ƕ\flipāAƂ̂ɗp
	ZERO(m_byKeyBuffer);

	if(!m_bSuccessInit) {
		InnerLog("DirectInput::CoInitializeɎsBOLEsǁH");
		return 1;
	}

	if (CoCreateInstance(CLSID_DirectInput,NULL,CLSCTX_INPROC_SERVER,
		IID_IDirectInput, (VOID**)&m_lpDirectInput)!=DI_OK){

//		InnerLog("DirectInput::InitializeCoCreateInstanceɎs");
//		NTł́AǂsDDDB

		goto UseLoadLibrary;
	}

	if(m_lpDirectInput==NULL) {
		InnerLog("DirectInputInterfaceȂ"); // DirectX3͓Ƃ̂H
		return 2;
	}

	if(m_lpDirectInput->Initialize(hInst,DIRECTINPUT_VERSION)!=DI_OK){
		InnerLog("DirectInputłȂ");
		return 3;
	}

	goto skip;

UseLoadLibrary:

	// bnlIďoɂ
	__hDirectInputDLL = LoadLibrary("dinput.dll");
	if (__hDirectInputDLL==NULL) {
		InnerLog("DirectInputLoadLibraryɎs");
		return 4;
	}

	{ // dica̓[JIuWFNg
		typedef LRESULT (WINAPI *dica_proc)(HINSTANCE hinst,DWORD dwVersion,LPDIRECTINPUTA *ppDI,
									LPUNKNOWN punkOuter);
		dica_proc dica = (dica_proc)GetProcAddress(__hDirectInputDLL,"DirectInputCreateA");
		if (dica == NULL) {
			InnerLog("DirectInputGetProcAddressɎs");
			return 5;
		}
		if (dica(hInst, DIRECTINPUT_VERSION, &m_lpDirectInput, NULL)!=DI_OK){
			InnerLog("DirectInput::DirectInputCreateɎs");
			return 6;
		}
	}

skip:

	//L[{[hfoCX̍쐬
	if (m_lpDirectInput->CreateDevice(GUID_SysKeyboard
			,&m_lpDIKeyDev,NULL)!=DI_OK){
		InnerLog("DirectInput̏CreateDeviceɎs");
		return 7; // [...
	}

	//	L[{[htH[}bg̐ݒ
	if(m_lpDIKeyDev->SetDataFormat(&c_dfDIKeyboard)!=DI_OK){
		RELEASE_SAFE(m_lpDIKeyDev);
		InnerLog("DirectInput̏SetDataFormatɎs");
		return 8;
	}

	// WindowNTœ삳ɂ́ÁA
	// DISCL_FOREGROUND | DISCL_NONEXCLUSIVEłȂĂ͂ȂB
	if (m_lpDIKeyDev->SetCooperativeLevel(hWnd,
			DISCL_FOREGROUND | DISCL_NONEXCLUSIVE)!=DI_OK){
		RELEASE_SAFE(m_lpDIKeyDev);
		InnerLog("DirectInput̏SetCooperativeLevelɎs");
		return 9;
	}

//	MsgHook(hWnd); // WindowMessageHook

	m_bDIKeyAcquire=false;

	// L[L
	if (m_lpDIKeyDev->Acquire()!=DI_OK){
		m_bDIKeyAcquire = false;
		// InnerLog("DirectInput̏KeyAcquireɎs");
		return 0;
		// ́AAcquireɂ́A
		// EBhDtH[JXKvȂ̂ŁA͗L肤B
		// ܂bZ[WƂ񂩂
		// ACTIVATEAPP߂܂ւ񂵂ȁ[i΁j
	}
	m_bDIKeyAcquire = true;

	return 0;
}
// ---------------------------------------------------------------------------
LRESULT CDirectInput::Terminate(void){ // I

//	MsgUnhook(); // WindowMessageUnhook

	// lĂfoCX̉
	if(m_lpDIKeyDev!=NULL){
		m_lpDIKeyDev->Unacquire();
		RELEASE_SAFE(m_lpDIKeyDev);
	}

	RELEASE_SAFE(m_lpDirectInput);	// COMIɌĂяoĂ̂ŁAŉI

	return 0; // I
}

// ---------------------------------------------------------------------------

LRESULT CDirectInput::GetKeyState(void){

	if (m_lpDIKeyDev==NULL) {
		return 1;	// foCXȂ̂ɌĂԂȁ[I
	}

	//	obt@flip!
	FlipKeyBuffer(m_nKeyBufNo);

	/*
	// ANeBûƂ́AGetDeviceStatesˁ[
	if (bUnActive) {
		return 2;
	}
	*/

	LRESULT hr;
again:
	// AcquireĂȂ̂GetDeviceState炨Ȃ
	if (m_bDIKeyAcquire) {
		hr = m_lpDIKeyDev->GetDeviceState(256,
				(LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]));
		if (hr==DIERR_INPUTLOST){
		// Av؂ւuԂ͂[Ȃ̂	
			hr=m_lpDIKeyDev->Acquire();
			if (hr==DI_OK) goto again;	// 񂾂Ȃ狖:p
			// ȂƂɂ
			m_bDIKeyAcquire = false;	//	ɂ܂lĂˁI:p
			//	obt@NAĖ߂BiʊOɃtH[JXڂƂɉςȂ
			//	ɂȂ̂h߁j
			ZeroMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),256);
			return 1; // s̊
			// InnerLog("GetKeyStateŃfoCXLOSTĂ");
		}
		if (hr==DI_OK) {
			return 0;
		} else {
			//	obt@NAĖ߂BiʊOɃtH[JXڂƂɉςȂ
			//	ɂȂ̂h߁j
			ZeroMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),256);
			return 1;
		}
	}
	// AcquireƂ̂
	hr=m_lpDIKeyDev->Acquire();
	if (hr==DI_OK) {
		m_bDIKeyAcquire=true;
		goto again;
	} else {
		m_bDIKeyAcquire=false;
		// ȂƂɂ:p
		//	obt@NAĖ߂BiʊOɃtH[JXڂƂɉςȂ
		//	ɂȂ̂h߁j
		ZeroMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),256);
		return 1;
	}
}

//////////////////////////////////////////////////////////////////////////////
//	0x80&ƂKvŁAoverrideقǂH
inline bool CDirectInput::IsKeyPress(int key) {
	return	(m_byKeyBuffer[m_nKeyBufNo][key] & 0x80) !=0;
};

inline bool CDirectInput::IsKeyPushDown(int key){
	// ꂽuԂtrueɂꍇ
	if (!(m_byKeyBuffer[  m_nKeyBufNo][key] & 0x80)) return false;
	if (  m_byKeyBuffer[1-m_nKeyBufNo][key] & 0x80) return false;
	return true;
}

// keyԂ̃L[̖O擾 by Nickle
char* CDirectInput::GetKeyName(int key){

	// staticɂăRXgN^Ńe[uH
	char* tbl[256];

	for(int i=0;i<256;i++)
		tbl[i] = "Unknown";

	tbl[0x01] = "ESC";
	tbl[0x02] = "1";
	tbl[0x03] = "2";
	tbl[0x04] = "3";
	tbl[0x05] = "4";
	tbl[0x06] = "5";
	tbl[0x07] = "6";
	tbl[0x08] = "7";
	tbl[0x09] = "8";
	tbl[0x0A] = "9";
	tbl[0x0B] = "0";
	tbl[0x0C] = "-";		/* - on main keyboard */
	tbl[0x0D] = "=";
	tbl[0x0E] = "BackSpace";			/* backspace */
	tbl[0x0F] = "TAB";
	tbl[0x10] = "Q";
	tbl[0x11] = "W";
	tbl[0x12] = "E";
	tbl[0x13] = "R";
	tbl[0x14] = "T";
	tbl[0x15] = "Y";
	tbl[0x16] = "U";
	tbl[0x17] = "I";
	tbl[0x18] = "O";
	tbl[0x19] = "P";
	tbl[0x1A] = "[";
	tbl[0x1B] = "]";
	tbl[0x1C] = "ENTER";		/* Enter on main keyboard */
	tbl[0x1D] = "L-Ctrl";
	tbl[0x1E] = "A";
	tbl[0x1F] = "S";
	tbl[0x20] = "D";
	tbl[0x21] = "F";
	tbl[0x22] = "G";
	tbl[0x23] = "H";
	tbl[0x24] = "J";
	tbl[0x25] = "K";
	tbl[0x26] = "L";
	tbl[0x27] = ";";
	tbl[0x28] = "'";
	tbl[0x29] = "`";		/* accent grave */
	tbl[0x2A] = "L-SHIFT";
	tbl[0x2B] = "_";
	tbl[0x2C] = "Z";
	tbl[0x2D] = "X";
	tbl[0x2E] = "C";
	tbl[0x2F] = "V";
	tbl[0x30] = "B";
	tbl[0x31] = "N";
	tbl[0x32] = "M";
	tbl[0x33] = ",";
	tbl[0x34] = ".";		/* . on main keyboard */
	tbl[0x35] = "/";		/* / on main keyboard */
	tbl[0x36] = "R-SHIFT";
	tbl[0x37] = "*";		/* * on numeric keypad */
	tbl[0x38] = "L-Alt";		/* left Alt */
	tbl[0x39] = "SPACE";
	tbl[0x3A] = "CAPS";
	tbl[0x3B] = "F1";
	tbl[0x3C] = "F2";
	tbl[0x3D] = "F3";
	tbl[0x3E] = "F4";
	tbl[0x3F] = "F5";
	tbl[0x40] = "F6";
	tbl[0x41] = "F7";
	tbl[0x42] = "F8";
	tbl[0x43] = "F9";
	tbl[0x44] = "F10";
	tbl[0x45] = "NUM LOCK";
	tbl[0x46] = "SCROLL LOCK";		/* Scroll Lock */
	tbl[0x47] = "7";
	tbl[0x48] = "8";
	tbl[0x49] = "9";
	tbl[0x4A] = "-";		/* - on numeric keypad */
	tbl[0x4B] = "4";
	tbl[0x4C] = "5";
	tbl[0x4D] = "6";
	tbl[0x4E] = "+";			/* + on numeric keypad */
	tbl[0x4F] = "1";
	tbl[0x50] = "2";
	tbl[0x51] = "3";
	tbl[0x52] = "0";
	tbl[0x53] = ".";		/* . on numeric keypad */
	tbl[0x57] = "F11";
	tbl[0x58] = "F12";

	tbl[0x64] = "F13";			/*                     (NEC PC98) */
	tbl[0x65] = "F14";			/*                     (NEC PC98) */
	tbl[0x66] = "F15";			/*                     (NEC PC98) */

	tbl[0x70] = "KANA";			/* (Japanese keyboard)            */
	tbl[0x79] = "XFER";			/* (Japanese keyboard)            */
	tbl[0x7B] = "NFER";		/* (Japanese keyboard)            */
	tbl[0x7D] = "\\";			/* (Japanese keyboard)            */
	tbl[0x8D] = "=";			/* = on numeric keypad (NEC PC98) */
	tbl[0x90] = "^";			/* (Japanese keyboard)            */
	tbl[0x91] = "@";			/*                     (NEC PC98) */
	tbl[0x92] = ":";			/*                     (NEC PC98) */
	tbl[0x93] = "_";			/*                     (NEC PC98) */
	tbl[0x94] = "KANJI";			/* (Japanese keyboard)            */
	tbl[0x95] = "STOP";			/*                     (NEC PC98) */
	tbl[0x96] = "AX";			/*                     (Japan AX) */
	tbl[0x97] = "UNLBL";		/*                        (J3100) */
	tbl[0x9C] = "ENTER";		/* Enter on numeric keypad */
	tbl[0x9D] = "R-Ctrl";
	tbl[0xB3] = ",";			/* , on numeric keypad (NEC PC98) */
	tbl[0xB5] = "/";			/* / on numeric keypad */
	tbl[0xB7] = "PrintScreen";
	tbl[0xB8] = "R-Alt";		/* right Alt */
	tbl[0xC5] = "PAUSE";		/* Pause */
	tbl[0xC7] = "HOME";			/* Home on arrow keypad */
	tbl[0xC8] = "UP";			/* UpArrow on arrow keypad */
	tbl[0xC9] = "PageUp";			/* PgUp on arrow keypad */
	tbl[0xCB] = "LEFT";			/* LeftArrow on arrow keypad */
	tbl[0xCD] = "RIGHT";		/* RightArrow on arrow keypad */
	tbl[0xCF] = "END";			/* End on arrow keypad */
	tbl[0xD0] = "DOWN";			/* DownArrow on arrow keypad */
	tbl[0xD1] = "PageDown";			/* PgDn on arrow keypad */
	tbl[0xD2] = "INS";			/* Insert on arrow keypad */
	tbl[0xD3] = "DEL";			/* Delete on arrow keypad */
	tbl[0xDB] = "L-WIN";			/* Left Windows key */
	tbl[0xDC] = "R-WIN";			/* Right Windows key */
	tbl[0xDD] = "APP";			/* AppMenu key */
	tbl[0xDE] = "POWER";
	tbl[0xDF] = "SLEEP";

	return tbl[key];

}


//////////////////////////////////////////////////////////////////////////////
