// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneFile.h"
#include "yaneMacro.h"
// #include "yaneError.h"

//////////////////////////////////////////////////////////////////////////////
//	<yanepackp\̂ɂ>
//		t@Cwb_[ "yanepack" 8oCg + i[t@C DWORD
//		̌AȉCFileInfoi[t@CāAƂ̓f[^
class CFileInfo {
public:
	char	filename[32];
	DWORD	startpos;	//	seek pos
	size_t	filesize;	//	file size
};

//////////////////////////////////////////////////////////////////////////////
// static member
string	CYFile::m_CurrentDirectory;		// ݑΏۂƂĂfBNg
//////////////////////////////////////////////////////////////////////////////

CYFile::CYFile(void){
	m_lpFile		= NULL;
	m_lpFileAdr		= NULL;
	m_dwFileSize	= 0;
	m_lpFileMemPos	= NULL;
	m_bEncord		= false;
}

CYFile::CYFile(string FileName){
	m_lpFile		= NULL;
	m_lpFileAdr		= NULL;
	m_dwFileSize	= 0;
	m_lpFileMemPos	= NULL;
	ReadFile(FileName);
}

CYFile::~CYFile(){
	ReleaseFileBuffer();
}

//////////////////////////////////////////////////////////////////////////////
void  CYFile::ToLower(string &str){
	//	(do_tolower)
	string::iterator it = str.begin();
	bool bSkip = false;
	while (it!=str.end()){
		if (bSkip) {
			bSkip = false;
			goto Repeat;
		}

//		if (((BYTE)*it>=0x80 && (BYTE)*it<=0xa0) || ((BYTE)*it>=0xe0 && (BYTE)*it<=0xff)) {
		if (_ismbblead(*it)){
			//	QoCgR[ĥPoCgڂł
			bSkip = true;
			goto Repeat;
		} else {
			//	QoCgR[ĥPoCgڂł͂Ȃ
			bSkip = false;
		}
		*it = tolower(*it);
Repeat:;
		it ++;
	}
}

//////////////////////////////////////////////////////////////////////////////

void  CYFile::SetCurrentDirectory(LPSTR Dir){ // JgfBNgݒ
	// ƂȂƁAt@C_CAONƂ낪JgpXɂȂ邩
	// Аݒ肵āI
	
	bool bDir = false;
	m_CurrentDirectory = Dir;
	if (m_CurrentDirectory[0]=='"') {
		bDir = true;
		m_CurrentDirectory.erase(0,1);	// R}hCnȂ...
	}
	// ErrorlogOutputEnable(true);

	// c:\test\test.exe@̂悤ɃR}hCăJgfBNg
	// ݒł悤ɍHvB(bDir==truêƂ)
	// c:\test\@܂ŁBŌ\܂߂ĕۑB

	string::size_type pos;
	if (bDir) {
		pos = m_CurrentDirectory.find('.');
	} else {
		pos = string::npos;
	}
	string::iterator it;
	if (pos==string::npos) {		// . Ȃ
		it = m_CurrentDirectory.end() - 1;
		if (*it!='\\' && *it!='/') {	
			// \/ŏIĂȂȂ\ǉ
			m_CurrentDirectory += '\\';
		}
	} else { // c:\test\test or c:\test\test.exe
		GetParentDir(m_CurrentDirectory);
	}
}

string CYFile::GetCurrentDirectory(void){		// JgfBNg擾
	return m_CurrentDirectory;
}

//////////////////////////////////////////////////////////////////////////////

void CYFile::ReleaseFileBuffer(void){
	if (m_lpFileAdr!=NULL) {
		GlobalFree(m_lpFileAdr);
		m_lpFileAdr = NULL;
		m_dwFileSize = 0;
		m_lpFileMemPos = NULL;
	}
	if (m_lpFile!=NULL) {
		fclose(m_lpFile);
		m_lpFile=NULL;
	}
}

//////////////////////////////////////////////////////////////////////////////
string	CYFile::MakeFullName(const string& filename){	// NfBNgĊSpX
	string file;
	if (filename.substr(0,2)=="\\\\") {
			//	lbg[NpXȂ̂ŉȂ
			file = filename;
	} else {
		string::size_type pos = filename.find(':');
		if (pos==string::npos) {
			//	tpXłȂ΃JgfBNg₤

			// ..\\ł̋삯オ葊΃pXT|[g
			string dir;
			dir = m_CurrentDirectory;
			file = filename;
			while (file.substr(0,3)=="..\\" || file.substr(0,3)=="../"){
				GetParentDir(dir);
				file.erase(0,2);
			}
			file = dir + file;
		} else {
			file = filename;
		}
	}
	return file;
}
//////////////////////////////////////////////////////////////////////////////

LRESULT CYFile::ReadFile(string filename){
	DWORD NumberOfBytesRead;

	m_fileName = filename;
	ReleaseFileBuffer(); // OɓǂݍłAȂI

	string fullname;
	fullname = MakeFullName(filename).c_str();
	HANDLE hFile = CreateFile(fullname.c_str(),
		GENERIC_READ,		// Read
		FILE_SHARE_READ,	// ReadOpenȂ狤L̂̓}i[ 
		NULL,				// security
		OPEN_EXISTING,		// ݂ĂȂ΃G[
		FILE_ATTRIBUTE_NORMAL,	//	t@C
		NULL				// ev[gt@C
	);

	if (hFile == INVALID_HANDLE_VALUE) { // I
		// closeKv͂Ȃ(INVALIDnhȂ񂾂)

		//	ЂƂĈkt@CH
		//	test/script/game.c -> test/script.datT
			
		string::size_type pos1,pos2;
		pos1 = fullname.rfind('/');
		pos2 = fullname.rfind('\\');
		//	̋LȂƂƂ͍lȂB
		//	ɑ݂قȍ~؂藎Ƃ
		if (pos1 == string::npos) pos1=0;
		if (pos2 == string::npos) pos2=0;
		if (pos2 > pos1) pos1 = pos2;
		string inner_filename;
		inner_filename = fullname.substr(pos1+1,string::npos);
		fullname.erase(pos1);
		fullname += ".dat";

		hFile = CreateFile(fullname.c_str(),
			GENERIC_READ,		// Read
			FILE_SHARE_READ,	// ReadOpenȂ狤L̂̓}i[ 
			NULL,				// security
			OPEN_EXISTING,		// ݂ĂȂ΃G[
			FILE_ATTRIBUTE_NORMAL,	//	t@C
			NULL				// ev[gt@C
		);

		if (hFile == INVALID_HANDLE_VALUE) return 1;

		//	kt@CI
		char ident[9];
		ident[8] = '\0';
		if (!::ReadFile(hFile,ident,8,&NumberOfBytesRead,NULL) || strcmp(ident,"yanepack")){
			CloseHandle(hFile);
			return 1;
		}

		DWORD filenum;
		if (!::ReadFile(hFile,&filenum,sizeof(filenum),&NumberOfBytesRead,NULL)){
			CloseHandle(hFile);
			return 1;
		}
		
		bool bFound = false;
		
		ToLower(inner_filename);	
		CFileInfo info;
		for(DWORD i=0;i<filenum;i++){
			if (!::ReadFile(hFile,&info,sizeof(info),&NumberOfBytesRead,NULL)){
				CloseHandle(hFile);
				return 1;
			}
			string s;
			s = info.filename;	//	ĂeXg
			ToLower(s);
			if (s == inner_filename) {
				//	vI
				// info.startposSeek̂ACreateFiléASeekΉ
				m_dwFileSize = (DWORD)info.filesize;
				bFound = true;
				break;
			}
		}
		if (!bFound) {
			CloseHandle(hFile);
			return 1; // Opens		
		}
		if (SetFilePointer(hFile,info.startpos,NULL,FILE_BEGIN)==0xFFFFFFFF) {
			CloseHandle(hFile);
			return 1; // Opens		
		}
		m_dwFileSize = (DWORD)info.filesize;
		goto StartOfRead;
	}
	
	// 4GBȏ̃t@CɓǂݍނƂȂčlȂ
	m_dwFileSize = ::GetFileSize(hFile,NULL);
	
	if (m_dwFileSize == 0xFFFFFFFF) {
		m_dwFileSize = 0;
		CloseHandle(hFile);
		// InnerLog("CYFile::ReadFileFileSize擾s");
		return 2; // filesize̎擾ɎsBiőɂȂƎvǁj
	}

StartOfRead:;
	// ܂ǂݍނ߂̃mہI
	m_lpFileAdr = (LPVOID)GlobalAlloc(GMEM_FIXED | GMEM_NOCOMPACT,m_dwFileSize);
	// ܂炷ĝɁÃGAk[B
	if (m_lpFileAdr==NULL) {
		CloseHandle(hFile);
		// InnerLog("CYFile::ReadFileŃmێs");
		return 3; // mۂł񂩂B
				  // σt@CłƂȁ[i΁j
	}

	if (!::ReadFile(hFile,m_lpFileAdr,m_dwFileSize,&NumberOfBytesRead,NULL)){
		ReleaseFileBuffer();	
		CloseHandle(hFile); // ...
		// InnerLog("CYFileŃt@Cǂݍ݂Ɏs");
		return 4; // t@C̓ǂݍ݂ɎsB
	}

	if (CloseHandle(hFile)==false) {
		ReleaseFileBuffer();	
		// InnerLog("CYFileŃt@CcloseɎs");
		return 5; // Close̎sBȂ񂠂񂩂...
	}

	if (*(DWORD*)m_lpFileAdr == 0x314B5059) {	//	HEADER:YPK1(yanepack1) == Data is Encording...
		m_bEncord = true;
		for (DWORD i=4;i<m_dwFileSize;i++){
			//	juœւ邾:p
			*((BYTE*)m_lpFileAdr+i) =	(((*((BYTE*)m_lpFileAdr+i) & 0xf) << 4) +
										 ((*((BYTE*)m_lpFileAdr+i) &0xf0) >> 4)) ^ 0xcc;
		}
		m_lpFileMemPos = (LPSTR)m_lpFileAdr + 4; // for ReadLine
	} else {
		m_bEncord = false;
		m_lpFileMemPos = (LPSTR)m_lpFileAdr; // for ReadLine
	}

	return 0; // ƂI:)
}

LRESULT CYFile::WriteFile(string fileName,LPVOID lpMem,DWORD dwSize){

	HANDLE hFile = CreateFile(MakeFullName(fileName).c_str(),
		GENERIC_WRITE,		// Write
		0,					// 
		NULL,				// security
		TRUNCATE_EXISTING,
		FILE_ATTRIBUTE_NORMAL,	//	t@C
		NULL				// ev[gt@C
	);
	//	OPEN_ALWAYSł́AÕt@CTCYcĂ܂...

	if (hFile == INVALID_HANDLE_VALUE) { // I
		hFile = CreateFile(MakeFullName(fileName).c_str(),
			GENERIC_WRITE,		// Write
			0,					// 
			NULL,				// security
			CREATE_NEW,
			FILE_ATTRIBUTE_NORMAL,	//	t@C
			NULL				// ev[gt@C
		);
		if (hFile == INVALID_HANDLE_VALUE) return 1; // Opens		
	}


	DWORD NumberOfBytesRead = 0;
	if (!::WriteFile(hFile,lpMem,dwSize,&NumberOfBytesRead,NULL)){
		CloseHandle(hFile); // ...
		// InnerLog("CYFile::WriteFileŃt@C݂Ɏs");
		return 2;
	}

	if (!CloseHandle(hFile)) {
		return 3; // Close̎sBȂ񂠂񂩂...
	}

	return 0; // ƂI:)
}

const string	CYFile::GetFileName(void){	// ǂݍłt@CԂ
	return m_fileName;
}

//////////////////////////////////////////////////////////////////////////////
//	UNICODEΉBWindows̃eLXgt@Cp:p
LRESULT CYFile::ReadLine(LPSTR buf){	 // obt@256oCgpӂƂĂ˂
	if (m_lpFileMemPos == NULL) return 3; // ǂȂƂ́[II
	if (m_lpFileMemPos >= (LPSTR)m_lpFileAdr + m_dwFileSize) return 1;

	LPSTR lp = m_lpFileMemPos;
	for(int i=0;i<255;i++){
		if (*m_lpFileMemPos == 0x0D && *(m_lpFileMemPos+1) == 0x0A ||
			(m_lpFileMemPos >= (LPSTR)m_lpFileAdr + m_dwFileSize)) { // CR+LF
			*buf = '\0'; // sII
			m_lpFileMemPos+=2;
			return 0;
		}
		*(buf++) = *(m_lpFileMemPos++);
	}
	*buf = '\0';
	return 2;	// buffer over
}

//////////////////////////////////////////////////////////////////////////////
LRESULT CYFile::ReadLine2(LPSTR Senario){
	char buf[256];
	
	strcpy(Senario,"");	//	ꉞAIƂɃS~oȂ悤...
	if (ReadLine(buf)!=0) return 1;
	if (!strcmp(buf,"\"END\""))	return 1; // I
	strcpy(Senario,buf+1);	//	擪"폜
	
	while (true) {
		if (Senario[strlen(Senario)-1] == '\"') break;	//	f~^:="
		if (ReadLine(buf)!=0) return 1;
		strcat(Senario,"\n");
		strcat(Senario,buf);
	}
	Senario[strlen(Senario)-1] = '\0';
	return 0;
}

LRESULT	CYFile::ReadData(BYTE*p,DWORD size){
	if (m_lpFileMemPos == NULL) return 2; // ǂȂƂ́[II
	if (m_lpFileMemPos >= (LPSTR)m_lpFileAdr + m_dwFileSize) return 1;

	CopyMemory(p,m_lpFileMemPos,size);
	m_lpFileMemPos+=size;
	return 0;
}

//////////////////////////////////////////////////////////////////////////////
DWORD	CYFile::GetFileSize(void) {
	if (m_bEncord) return m_dwFileSize - 4;	//	SoCg
	return m_dwFileSize;
}

LPVOID	CYFile::GetFileMemory(void) {
	if (m_bEncord) return (BYTE*)m_lpFileAdr + 4;	//	ʃwb_̂SoCg
	return m_lpFileAdr;
}

LRESULT	CYFile::Encord(void){
	if (*(DWORD*)m_lpFileMemPos == 0x314B5059) return 1;	// already encording!!
	if (m_bEncord) return 1;	//	already encording!!
	
	DWORD size = m_dwFileSize+4;
	BYTE* m_lpFileAdr2 = (BYTE*)GlobalAlloc(GMEM_FIXED | GMEM_NOCOMPACT,size);
	for (DWORD i=0;i<size-4;i++){
		//	juœւ邾:p
		*(m_lpFileAdr2+i+4) =	(((*((BYTE*)m_lpFileAdr+i) & 0xf) << 4) +
								 ((*((BYTE*)m_lpFileAdr+i) &0xf0) >> 4)) ^ 0xcc;
	}
	*(DWORD*)m_lpFileAdr2 =  0x314B5059;	// YPK1:wb_t^

	ReleaseFileBuffer();

	m_lpFileAdr		= (LPVOID)m_lpFileAdr2;
	m_dwFileSize	= size;
	m_lpFileMemPos	= (LPSTR)m_lpFileAdr; // for ReadLine
	m_bEncord		= false;	//	falseɂ邱Ƃɂăwb_[t^
	return 0;
}

LRESULT	CYFile::GetParentDir(string& filename){						//	etH_Ԃ
// e.g. "c:\test1\test2\test3.exe" -> "c:\test1\test2\" -> "c:\test1\" -> "c:\" -> "c:\"
	//	̂PoCgڂKv...

	//	1.A\/ЂƂȂ΁A̓hCuȂ̂ŁAȂ
	//	2.\/Ȃ΁AJbg
	//	3.ԍŌ\/Äʒuȍ~Jbg
	
	string::iterator it = filename.begin();
	if (filename.substr(0,2)=="\\\\") {
		//	lbg[NpX
		it += 2;
	}

	string::iterator pos1,pos2;
	// pos1 : ŌɌ\/̈ʒu
	// pos2 : ŌォQԖڂɌ\/̈ʒu
	pos1 = pos2 = filename.end();	// not found

	bool bKanji=false;
	while (it != filename.end()) {
		if (bKanji) { bKanji=false; goto skip; }
		if (((BYTE)*it>=0x80 && (BYTE)*it<=0xa0) || ((BYTE)*it>=0xe0 && (BYTE)*it<=0xff)) {
			bKanji = true;	//	QoCgR[ĥPoCgڂł
		} else {
			bKanji = false;	//	QoCgR[ĥPoCgڂł͂Ȃ
			if (*it == '\\' || *it=='/') {
				pos2 = pos1;
				pos1 = it;
			}
		}
skip:;
		it++;
	}
	if (pos2==filename.end()) return 1;	// ЂƂ\/̂ȂAł
	if (pos1!=it-1) {
		filename.erase(pos1+1,filename.end());	// \\//łȂȂ΁AЂƂO\\//ȍ~
	} else {
		filename.erase(pos2+1,filename.end());	// pos1ȍ~
	}
	return 0;
}
