/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.deployer;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jp.sourceforge.deployer.ClassLoaderUnloadFailException;
import jp.sourceforge.deployer.ClassLoaderUnloadedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployerClassLoader
extends ClassLoader {
    private WeakReference<InternalURLClassLoader> wrCL;
    private InternalURLClassLoader cl;

    public DeployerClassLoader(File[] fileDirectories, File[] jarDirectories, ClassLoader parent) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (fileDirectories != null) {
            for (File f : fileDirectories) {
                if (f == null) continue;
                urlList.add(f.toURL());
            }
        }
        if (jarDirectories != null) {
            for (File f : jarDirectories) {
                if (f == null) continue;
                urlList.addAll(this.getJarFileList(f));
            }
        }
        this.cl = parent == null ? new InternalURLClassLoader(urlList.toArray(new URL[0])) : new InternalURLClassLoader(urlList.toArray(new URL[0]), parent);
        this.wrCL = new WeakReference<InternalURLClassLoader>(this.cl);
    }

    public DeployerClassLoader(File[] fileDirectories, File[] jarDirectories) throws MalformedURLException {
        this(fileDirectories, jarDirectories, null);
    }

    private List<URL> getJarFileList(File dir) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (dir == null) {
            return urlList;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return urlList;
        }
        for (File f : files) {
            if (f.isFile() && f.getName().toLowerCase().endsWith(".jar")) {
                urlList.add(f.toURL());
                continue;
            }
            if (!f.isDirectory()) continue;
            urlList.addAll(this.getJarFileList(f));
        }
        return urlList;
    }

    public void dispose() {
        this.dispose(0);
    }

    public void dispose(int timeout) {
        this.cl = null;
        long t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < (long)timeout || timeout <= 0) {
            System.gc();
            if (this.wrCL.get() == null) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.wrCL.get() != null) {
            throw new ClassLoaderUnloadFailException();
        }
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.findClass(name);
    }

    @Override
    protected String findLibrary(String libname) {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.findLibrary(libname);
    }

    @Override
    protected URL findResource(String name) {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.findResources(name);
    }

    @Override
    protected Package getPackage(String name) {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.getPackage(name);
    }

    @Override
    protected Package[] getPackages() {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.getPackages();
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.cl == null) {
            throw new ClassLoaderUnloadedException();
        }
        return this.cl.loadClass(name, resolve);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalURLClassLoader
    extends URLClassLoader {
        public InternalURLClassLoader(URL[] urls) {
            super(urls);
        }

        public InternalURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
            return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        @Override
        public String findLibrary(String libname) {
            return super.findLibrary(libname);
        }

        @Override
        public Package getPackage(String name) {
            return super.getPackage(name);
        }

        @Override
        public Package[] getPackages() {
            return super.getPackages();
        }

        @Override
        public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

