/*
 * Copyright (C) 2007 uguu at users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.deployer.server.bootstrap;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * deployer-serverを起動します。
 * </p>
 * 
 * @author $Author$
 * @version $Rev$ $Date$
 */
final class Bootstrap {

    /**
     * <p>
     * commonディレクトリの相対パス。
     * </p>
     */
    private static final String COMMON_DIR = "../common";

    /**
     * <p>
     * インスタンス化を禁止します。
     * </p>
     */
    private Bootstrap() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        // サーバ共通クラスローダを構築します。
        File commonDir = new File(Bootstrap.COMMON_DIR).getCanonicalFile();
        List<URL> commonUrlList = Bootstrap.getJarUrlList(commonDir);
        commonUrlList.add(commonDir.toURL());
        ClassLoader commonCL = new URLClassLoader(commonUrlList.toArray(new URL[0]));

        // デプロイヤー・クラスローダを構築します。
        File binDir = new File(".").getCanonicalFile();
        List<URL> binUrlList = Bootstrap.getJarUrlList(binDir);
        binUrlList.add(binDir.toURL());
        ClassLoader deployerCL = new URLClassLoader(binUrlList.toArray(new URL[0]), commonCL);

        // デプロイヤーを開始します。
        Class deployerClazz = deployerCL.loadClass("jp.sourceforge.deployer.server.core.DeployerServer");
        Object deployer = deployerClazz.newInstance();
        deployerClazz.getMethod("start").invoke(deployer);
    }

    private static List<URL> getJarUrlList(File dir) throws MalformedURLException {
        List<File> fileList = Bootstrap.getJarFileList(dir);
        List<URL> urlList = new ArrayList<URL>();

        for (File f : fileList) {
            urlList.add(f.toURL());
        }

        return urlList;
    }

    private static List<File> getJarFileList(File dir) {
        List<File> fileList = new ArrayList<File>();

        if (dir == null) {
            return fileList;
        }

        File[] files = dir.listFiles();
        if (files == null) {
            return fileList;
        }

        for (File f : files) {
            if (f.isFile() && f.getName().endsWith(".jar")) {
                fileList.add(f);
            } else if (f.isDirectory()) {
                fileList.addAll(Bootstrap.getJarFileList(f));
            }
        }

        return fileList;
    }

}
