/*
 * Copyright (C) 2007 uguu at users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.deployer;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * <p>
 * "jp.sourceforge.deployer.message"リソース・ファイルからメッセージを取得します。
 * </p>
 * 
 * @author $Author$
 * @version $Rev$ $Date$
 */
final class Message {

    /**
     * <p>
     * インスタンス化を禁止します。
     * </p>
     */
    private Message() {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * リソース・ファイルからメッセージを取得します。
     * </p>
     * 
     * @param messageID
     *            メッセージのID(リソースのキー)。
     * @param arguments
     *            メッセージに埋め込む引数。
     * @return メッセージ。
     */
    private static String format(String messageID, String... arguments) {
        ResourceBundle rb = ResourceBundle.getBundle("jp_sourceforge_deployer_message");
        String message = rb.getString(messageID);
        message = MessageFormat.format(message, (Object[]) arguments);
        return message;
    }

    static String classLoaderUnloaded() {
        return Message.format("classLoaderUnloaded");
    }

    static String classLoaderUnloadFail() {
        return Message.format("classLoaderUnloadFail");
    }

    static String directoryCreateFail(String dir) {
        return Message.format("directoryCreateFail", dir);
    }

    static String directoryDeleteFail(String dir) {
        return Message.format("directoryDeleteFail", dir);
    }

    static String fileCreateFail(String file) {
        return Message.format("fileCreateFail", file);
    }

    static String fileDeleteFail(String file) {
        return Message.format("fileDeleteFail", file);
    }

    static String fileMonitorFail() {
        return Message.format("fileMonitorFail");
    }

    static String argumentIsNull(String arg) {
        return Message.format("argumentIsNull", arg);
    }

    static String argumentIsNotDirectory(String arg) {
        return Message.format("argumentIsNotDirectory", arg);
    }

}
