#include	"monitor.h"

void	printPktInfo (void);

void    capture_read (void)
{
	int    res;
	time_t  atime;
	struct	in_table *in_table_next;
	struct	in_table *in_temp;
	struct	out_table *out_table_next;
	struct	out_table *out_temp;

        res = pcap_next_ex (cap_handle, &header,  &pkt_data);
        if (res == 0) return;
        else if (res == -1)
        {
                time(&atime);
                fprintf (LogFile, "%24.24s pcap_next_ex error %s\n", 
			ctime(&atime), pcap_geterr(cap_handle));
                fflush (LogFile);
                return;
        }
	if (header->len == 98)
	{
		time(&atime);
                TempIP.s_addr = pkt_data[26] | (pkt_data[27] << 8)
                    	| (pkt_data[28] << 16) | (pkt_data[29] << 24);
               	if (OwnMonIP.s_addr == TempIP.s_addr)
		{
			out_table_next = out_table_pnt;
			while (out_table_next)
			{
				if (!memcmp (out_table_next->frame_id, &pkt_data[54], 2)) break;
				out_table_next = out_table_next->next;
			}
			if (out_table_next == NULL)
			{
				out_table_next = malloc (sizeof (struct out_table));
				out_table_next->frame_id[0] = pkt_data[54];
				out_table_next->frame_id[1] = pkt_data[55];
				out_table_next->out_pkt = 0;
				time(&out_table_next->out_time);
				memcpy (out_table_next->call, &pkt_data[76], 8);
                      		fprintf (LogFile, "%24.24s 送信情報（エコー）\n", 
					ctime(&atime));
				out_table_next->next = out_table_pnt;
				out_table_pnt = out_table_next;
				printPktInfo();
			}
		}
                else
		{
			in_table_next = in_table_pnt;
			while (in_table_next)
			{
				if (!memcmp (in_table_next->frame_id, &pkt_data[54], 2)) break;
				in_table_next = in_table_next->next;
			}
			if (in_table_next == NULL)
			{
				in_table_next = malloc (sizeof (struct in_table));
				in_table_next->frame_id[0] = pkt_data[54];
				in_table_next->frame_id[1] = pkt_data[55];
				in_table_next->in_pkt = 0;
				time(&in_table_next->in_time);
				memcpy (in_table_next->call, &pkt_data[84], 8);
                		fprintf (LogFile, "%24.24s 受信情報\n", ctime(&atime));
				in_table_next->next = in_table_pnt;
				in_table_pnt = in_table_next;
				printPktInfo();
			}
		}
	}
	else if (header->len == 69)
	{
		in_table_next = in_table_pnt;
		while (in_table_next)
		{
			if ((in_table_next->frame_id[0] == pkt_data[54]) 
				&& (in_table_next->frame_id[1] == pkt_data[55]))
			{
				in_table_next->in_pkt++;
				time(&in_table_next->in_time);
				if (pkt_data[56] & 0x40)
				{
					time(&atime);
					fprintf (LogFile, "%24.24s 受信パケット数 %ld (from %8.8s)\n\n", 
						ctime(&atime), in_table_next->in_pkt, in_table_next->call);
					fflush (LogFile);
					if (in_table_next == in_table_pnt)
					{
						in_table_pnt = in_table_next->next;
						free (in_table_next);
					}
					else
					{
						in_temp = in_table_pnt;
						while (in_temp)
						{
							if (in_temp->next == in_table_next)
							{
								in_temp->next = in_table_next->next;
								free (in_table_next);
								break;
							}
							in_temp = in_temp->next;
						}
					}
						
				}
				break;
			}
			in_table_next = in_table_next->next;
		}
		out_table_next = out_table_pnt;
		while (out_table_next)
		{
			if ((out_table_next->frame_id[0] == pkt_data[54])
				&& (out_table_next->frame_id[1] == pkt_data[55]))
			{
				out_table_next->out_pkt++;
				time (&out_table_next->out_time);
				if (pkt_data[56] & 0x40)
				{
					time(&atime);
					fprintf (LogFile, "%24.24s 送信パケット数 %ld (to %8.8s)\n\n", 
						ctime(&atime), out_table_next->out_pkt, out_table_next->call);
					fflush (LogFile);
                                        if (out_table_next == out_table_pnt)
                                        {
                                                out_table_pnt = out_table_next->next;
                                                free (out_table_next);
                                        }
                                        else
                                        {
                                                out_temp = out_table_pnt;
                                                while (out_temp)
                                                {
                                                        if (out_temp->next == out_table_next)
                                                        {
                                                                out_temp->next = out_table_next->next;
                                                                free (out_table_next);
                                                                break;
                                                        }
                                                        out_temp = out_temp->next;
                                                }
					}
				}
				break;
			}
			out_table_next = out_table_next->next;
		}
	}

}


void	printPktInfo(void)
{
	fprintf (LogFile, "%24.24s RPT2:%8.8s RPT1:%8.8s Ur:%8.8s My:%8.8s My2:%4.4s\n\n",
		ctime(&atime),
		&pkt_data[68],
		&pkt_data[60],
		&pkt_data[76],
		&pkt_data[84],
		&pkt_data[92]);

	fprintf (LogFile, "%24.24s 送信元 %d.%d.%d.%d:%d  送信先 %d.%d.%d.%d:%d\n\n", 
		ctime(&atime),
		pkt_data[26] & 0xff, 
		pkt_data[27] & 0xff, 
		pkt_data[28] & 0xff, 
		pkt_data[29]  & 0xff,
		pkt_data[34]*256+pkt_data[35],
		pkt_data[30] & 0xff, 
		pkt_data[31] & 0xff, 
		pkt_data[32] & 0xff, 
		pkt_data[33] & 0xff, 
		pkt_data[36]*256+pkt_data[37]);
		fflush (LogFile);
}

void	packet_drop(void)
{
	time_t	cur_time;
	struct	out_table *out_table_next, *out_temp;
	struct	in_table  *in_table_next, *in_temp;

	time (&cur_time);

        in_table_next = in_table_pnt;
        while (in_table_next)
        {
                if ((cur_time - in_table_next->in_time) > 3)
                {
                        fprintf (LogFile, "%24.24s パケット欠落 from %8.8s\n\n", ctime(&cur_time), in_table_next->call);
                        fflush (LogFile);
                        if (in_table_next == in_table_pnt)
                        {
                                in_table_pnt = in_table_next->next;
                                free (in_table_next);
                        }
                        else
                        {
                                in_temp = in_table_pnt;
                                while (in_temp)
                                {
                                        if (in_temp->next == in_table_next)
                                        {
                                                in_temp->next = in_table_next->next;
                                                free (in_table_next);
                                                break;
                                        }
                                        in_temp = in_temp->next;
                                }
                        }
                        break;
                }
                in_table_next = in_table_next->next;
        }

	out_table_next = out_table_pnt;
	while (out_table_next)
	{
		if ((cur_time - out_table_next->out_time) > 3)
		{
			fprintf (LogFile, "%24.24s パケット欠落 to %8.8s\n\n", ctime(&cur_time), out_table_next->call);
			fflush (LogFile);
                	if (out_table_next == out_table_pnt)
                        {
                        	out_table_pnt = out_table_next->next;
                                free (out_table_next);
                        }
                        else
                        {
                        	out_temp = out_table_pnt;
                                while (out_temp)
                                {
                                	if (out_temp->next == out_table_next)
                                        {
                                        	out_temp->next = out_table_next->next;
                                                free (out_table_next);
                                                break;
                                        }
                                        out_temp = out_temp->next;
                                }
                      	}
			break; 
		}
		out_table_next = out_table_next->next;
	}

}

