#include "monitor.h"


void	handler (int sig)
{
	time_t	atime;

	if (sig == SIGTERM) sig_term = TRUE;
	else if (sig == SIGINT)  sig_term = TRUE;
	else if (sig == SIGUSR2)
	{
		time(&atime);
		if (debug_sw)
		{
			fprintf (LogFile, "%24.24s Leave Debug Mode\n",ctime(&atime));
			debug_sw = FALSE;
		}
		else
		{
			fprintf (LogFile, "%24.24s Enter Debug Mode\n",ctime(&atime));
			debug_sw = TRUE;
		}
		fflush (LogFile);
	}
}

int	handler_init(void)
{
	time (&atime);

	if (signal(SIGUSR1, handler) == SIG_ERR)
	{
		fprintf (LogFile, "%24.24s signal (SIGUSR1) error\n", ctime(&atime));
		fflush (LogFile);
		return FALSE;
	}	
	if (signal(SIGUSR2, handler) == SIG_ERR)
	{
		fprintf (LogFile, "%24.24s signal (SIGUSR2) error\n", ctime(&atime));
		fflush (LogFile);
                return FALSE;
        }
        if (signal(SIGTERM, handler) == SIG_ERR)
        {
                fprintf (LogFile, "%24.24s signal (SIGTERM) error\n", ctime(&atime));
                fflush (LogFile);
                return FALSE;
        }
        if (signal(SIGINT, handler) == SIG_ERR)
        {
                fprintf (LogFile, "%24.24s signal (SIGINT) error\n", ctime(&atime));
                fflush (LogFile);
                return FALSE;
        }
	return TRUE;
}
