#!/usr/local/bin/ruby
# -*- coding: utf-8 -*-
#
#= 共通ライブラリ集
#
#Autohr::    Kureha Hisame (http://lunardial.sakura.ne.jp/)
#Version::   1.0.0.0
#Copyright:: Copyright 2013 Kureha Hisame (http://lunardial.sakura.ne.jp/)
#License::   GPLv3

require "logger"

# = WebLoggerクラス
#
# ロガーを取得する為のクラスです
class WebLogger
  @@max_log_size = 10 * 1024 * 1024
  
  def self.get_logger(script_name = "", log_dir = "", release_flag = false)
    if script_name.empty?
      log_filename = "#{log_dir}/default.log"
      log_filename_bk = "#{log_dir}/default.log.bk.log"
    else
      log_filename = "#{log_dir}/" + File.basename(script_name, ".*") + ".log"
      log_filename_bk = "#{log_dir}/" + File.basename(script_name, ".*") + ".bk.log"
    end
    if File.exist?(log_filename)
      status = File::stat(log_filename)
      if status.size > @@max_log_size
        File.rename(log_filename, log_filename_bk)
      end
    end

    logger = Object::Logger.new(log_filename)

    if release_flag == true
      logger.level = Object::Logger::ERROR
    else
      logger.level = Object::Logger::DEBUG
    end

    logger
  end
end

# = HtmlWriterクラス
# 
# テンプレートファイル(*.erb)を読み込み、管理するクラスです
class HtmlWriter
  # 初期化メソッドです
  #
  # _template_ :: テンプレートファイル(*.erb)のパス
  # _binding_ :: binding変数
  def initialize(template, binding)
    @erb = ERB.new(myopen(template, "r:utf-8") {|f| f.read}, nil, "-")
    @binding = binding
  end

  # テンプレートファイルの文字列を返却するメソッドです
  def to_code
    @erb.result(@binding)
  end
end

# = Objectクラス
#
# 基本クラスのオーバーライドを行います
class Object
  # myopenメソッド
  #
  # ruby-1.9.x以降ではファイルを開いた際、エンコードの指定を行わないとエラーの原因になります。
  # ただしruby-1.8.6以前はエンコードの指定に対応していないため、独自メソッドを定義してファイルの入出力を行います。
  #
  # _arg[0]_ :: 入出力を行うファイルのパス
  # _arg[1]_ :: モードの指定。例 : w:utf-8(書き込みモード・UTF-8エンコードでファイルを開く)
  def myopen(*arg)
    mode = arg[1]
    rdonly_p = true
    case mode
    when String
      arg[1] = mode[/[^:]+/] if RUBY_VERSION < "1.8.7" && mode.include?(':')
      rdonly_p = /\A[^:]*[wa+]/ !~ mode
    when Numeric
      rdonly_p = !(mode & (IO::WRONY | IO::RDWR))
    end
    open(*arg) do |f|
      f.flock(rdonly_p ? File::LOCK_SH : File::LOCK_EX)
      return yield(f)
    end
  end
end

class NilClass
  def blank?
    nil?
  end
end

class Array
  def blank?
    empty?
  end
end

class String
  def blank?
    empty?
  end
end

