/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.cq.bs;

import java.util.Map;

import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.FileConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.FileCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.ciq.FileCrawlingConfigCIQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;

/**
 * The base condition-query of FILE_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public class BsFileCrawlingConfigCQ extends AbstractBsFileCrawlingConfigCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected FileCrawlingConfigCIQ _inlineQuery;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public BsFileCrawlingConfigCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                              Inline
    //                                                                              ======
    /**
     * Prepare inline query. <br />
     * {select ... from ... left outer join (select * from FILE_CRAWLING_CONFIG) where abc = [abc] ...}
     * @return Inline query. (NotNull)
     */
    public FileCrawlingConfigCIQ inline() {
        if (_inlineQuery == null) {
            _inlineQuery = new FileCrawlingConfigCIQ(getChildQuery(),
                    getSqlClause(), getAliasName(), getNestLevel(), this);
        }
        _inlineQuery.xsetOnClauseInline(false);
        return _inlineQuery;
    }

    /**
     * Prepare on-clause query. <br />
     * {select ... from ... left outer join FILE_CRAWLING_CONFIG on ... and abc = [abc] ...}
     * @return On-clause query. (NotNull)
     */
    public FileCrawlingConfigCIQ on() {
        if (isBaseQuery(this)) {
            throw new UnsupportedOperationException(
                    "Unsupported on-clause for local table!");
        }
        FileCrawlingConfigCIQ inlineQuery = inline();
        inlineQuery.xsetOnClauseInline(true);
        return inlineQuery;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    protected ConditionValue _id;

    public ConditionValue getId() {
        if (_id == null) {
            _id = nCV();
        }
        return _id;
    }

    protected ConditionValue getCValueId() {
        return getId();
    }

    protected Map<String, FileConfigToBrowserTypeMappingCQ> _id_InScopeSubQuery_FileConfigToBrowserTypeMappingListMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getId_InScopeSubQuery_FileConfigToBrowserTypeMappingList() {
        return _id_InScopeSubQuery_FileConfigToBrowserTypeMappingListMap;
    }

    public String keepId_InScopeSubQuery_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_InScopeSubQuery_FileConfigToBrowserTypeMappingListMap == null) {
            _id_InScopeSubQuery_FileConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_InScopeSubQuery_FileConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_InScopeSubQuery_FileConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_InScopeSubQuery_FileConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, FileConfigToBrowserTypeMappingCQ> _id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingListMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getId_NotInScopeSubQuery_FileConfigToBrowserTypeMappingList() {
        return _id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingListMap;
    }

    public String keepId_NotInScopeSubQuery_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingListMap == null) {
            _id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_NotInScopeSubQuery_FileConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, FileConfigToBrowserTypeMappingCQ> _id_ExistsSubQuery_FileConfigToBrowserTypeMappingListMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getId_ExistsSubQuery_FileConfigToBrowserTypeMappingList() {
        return _id_ExistsSubQuery_FileConfigToBrowserTypeMappingListMap;
    }

    public String keepId_ExistsSubQuery_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_ExistsSubQuery_FileConfigToBrowserTypeMappingListMap == null) {
            _id_ExistsSubQuery_FileConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_ExistsSubQuery_FileConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_ExistsSubQuery_FileConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_ExistsSubQuery_FileConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, FileConfigToBrowserTypeMappingCQ> _id_NotExistsSubQuery_FileConfigToBrowserTypeMappingListMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getId_NotExistsSubQuery_FileConfigToBrowserTypeMappingList() {
        return _id_NotExistsSubQuery_FileConfigToBrowserTypeMappingListMap;
    }

    public String keepId_NotExistsSubQuery_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_NotExistsSubQuery_FileConfigToBrowserTypeMappingListMap == null) {
            _id_NotExistsSubQuery_FileConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_NotExistsSubQuery_FileConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_NotExistsSubQuery_FileConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_NotExistsSubQuery_FileConfigToBrowserTypeMappingList." + key;
    }

    protected Map<String, FileConfigToBrowserTypeMappingCQ> _id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingListMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getId_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingList() {
        return _id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingListMap;
    }

    public String keepId_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingListMap == null) {
            _id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingListMap.put(
                key, subQuery);
        return "id_SpecifyDerivedReferrer_FileConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, FileConfigToBrowserTypeMappingCQ> _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListMap;

    public Map<String, FileConfigToBrowserTypeMappingCQ> getId_QueryDerivedReferrer_FileConfigToBrowserTypeMappingList() {
        return _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToBrowserTypeMappingList(
            FileConfigToBrowserTypeMappingCQ subQuery) {
        if (_id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListMap == null) {
            _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey"
                + (_id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListMap.put(key,
                subQuery);
        return "id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingList."
                + key;
    }

    protected Map<String, Object> _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameterMap;

    public Map<String, Object> getId_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameter() {
        return _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameterMap;
    }

    public String keepId_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameter(
            Object parameterValue) {
        if (_id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameterMap == null) {
            _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameterMap = newLinkedHashMap();
        }
        String key = "subQueryParameterKey"
                + (_id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameterMap
                        .size() + 1);
        _id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameterMap
                .put(key, parameterValue);
        return "id_QueryDerivedReferrer_FileConfigToBrowserTypeMappingListParameter."
                + key;
    }

    public BsFileCrawlingConfigCQ addOrderBy_Id_Asc() {
        regOBA("ID");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_Id_Desc() {
        regOBD("ID");
        return this;
    }

    protected ConditionValue _name;

    public ConditionValue getName() {
        if (_name == null) {
            _name = nCV();
        }
        return _name;
    }

    protected ConditionValue getCValueName() {
        return getName();
    }

    public BsFileCrawlingConfigCQ addOrderBy_Name_Asc() {
        regOBA("NAME");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_Name_Desc() {
        regOBD("NAME");
        return this;
    }

    protected ConditionValue _paths;

    public ConditionValue getPaths() {
        if (_paths == null) {
            _paths = nCV();
        }
        return _paths;
    }

    protected ConditionValue getCValuePaths() {
        return getPaths();
    }

    public BsFileCrawlingConfigCQ addOrderBy_Paths_Asc() {
        regOBA("PATHS");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_Paths_Desc() {
        regOBD("PATHS");
        return this;
    }

    protected ConditionValue _includedPaths;

    public ConditionValue getIncludedPaths() {
        if (_includedPaths == null) {
            _includedPaths = nCV();
        }
        return _includedPaths;
    }

    protected ConditionValue getCValueIncludedPaths() {
        return getIncludedPaths();
    }

    public BsFileCrawlingConfigCQ addOrderBy_IncludedPaths_Asc() {
        regOBA("INCLUDED_PATHS");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_IncludedPaths_Desc() {
        regOBD("INCLUDED_PATHS");
        return this;
    }

    protected ConditionValue _excludedPaths;

    public ConditionValue getExcludedPaths() {
        if (_excludedPaths == null) {
            _excludedPaths = nCV();
        }
        return _excludedPaths;
    }

    protected ConditionValue getCValueExcludedPaths() {
        return getExcludedPaths();
    }

    public BsFileCrawlingConfigCQ addOrderBy_ExcludedPaths_Asc() {
        regOBA("EXCLUDED_PATHS");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_ExcludedPaths_Desc() {
        regOBD("EXCLUDED_PATHS");
        return this;
    }

    protected ConditionValue _depth;

    public ConditionValue getDepth() {
        if (_depth == null) {
            _depth = nCV();
        }
        return _depth;
    }

    protected ConditionValue getCValueDepth() {
        return getDepth();
    }

    public BsFileCrawlingConfigCQ addOrderBy_Depth_Asc() {
        regOBA("DEPTH");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_Depth_Desc() {
        regOBD("DEPTH");
        return this;
    }

    protected ConditionValue _maxAccessCount;

    public ConditionValue getMaxAccessCount() {
        if (_maxAccessCount == null) {
            _maxAccessCount = nCV();
        }
        return _maxAccessCount;
    }

    protected ConditionValue getCValueMaxAccessCount() {
        return getMaxAccessCount();
    }

    public BsFileCrawlingConfigCQ addOrderBy_MaxAccessCount_Asc() {
        regOBA("MAX_ACCESS_COUNT");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_MaxAccessCount_Desc() {
        regOBD("MAX_ACCESS_COUNT");
        return this;
    }

    protected ConditionValue _numOfThread;

    public ConditionValue getNumOfThread() {
        if (_numOfThread == null) {
            _numOfThread = nCV();
        }
        return _numOfThread;
    }

    protected ConditionValue getCValueNumOfThread() {
        return getNumOfThread();
    }

    public BsFileCrawlingConfigCQ addOrderBy_NumOfThread_Asc() {
        regOBA("NUM_OF_THREAD");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_NumOfThread_Desc() {
        regOBD("NUM_OF_THREAD");
        return this;
    }

    protected ConditionValue _intervalTime;

    public ConditionValue getIntervalTime() {
        if (_intervalTime == null) {
            _intervalTime = nCV();
        }
        return _intervalTime;
    }

    protected ConditionValue getCValueIntervalTime() {
        return getIntervalTime();
    }

    public BsFileCrawlingConfigCQ addOrderBy_IntervalTime_Asc() {
        regOBA("INTERVAL_TIME");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_IntervalTime_Desc() {
        regOBD("INTERVAL_TIME");
        return this;
    }

    protected ConditionValue _available;

    public ConditionValue getAvailable() {
        if (_available == null) {
            _available = nCV();
        }
        return _available;
    }

    protected ConditionValue getCValueAvailable() {
        return getAvailable();
    }

    public BsFileCrawlingConfigCQ addOrderBy_Available_Asc() {
        regOBA("AVAILABLE");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_Available_Desc() {
        regOBD("AVAILABLE");
        return this;
    }

    protected ConditionValue _sortOrder;

    public ConditionValue getSortOrder() {
        if (_sortOrder == null) {
            _sortOrder = nCV();
        }
        return _sortOrder;
    }

    protected ConditionValue getCValueSortOrder() {
        return getSortOrder();
    }

    public BsFileCrawlingConfigCQ addOrderBy_SortOrder_Asc() {
        regOBA("SORT_ORDER");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_SortOrder_Desc() {
        regOBD("SORT_ORDER");
        return this;
    }

    protected ConditionValue _createdBy;

    public ConditionValue getCreatedBy() {
        if (_createdBy == null) {
            _createdBy = nCV();
        }
        return _createdBy;
    }

    protected ConditionValue getCValueCreatedBy() {
        return getCreatedBy();
    }

    public BsFileCrawlingConfigCQ addOrderBy_CreatedBy_Asc() {
        regOBA("CREATED_BY");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_CreatedBy_Desc() {
        regOBD("CREATED_BY");
        return this;
    }

    protected ConditionValue _createdTime;

    public ConditionValue getCreatedTime() {
        if (_createdTime == null) {
            _createdTime = nCV();
        }
        return _createdTime;
    }

    protected ConditionValue getCValueCreatedTime() {
        return getCreatedTime();
    }

    public BsFileCrawlingConfigCQ addOrderBy_CreatedTime_Asc() {
        regOBA("CREATED_TIME");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_CreatedTime_Desc() {
        regOBD("CREATED_TIME");
        return this;
    }

    protected ConditionValue _updatedBy;

    public ConditionValue getUpdatedBy() {
        if (_updatedBy == null) {
            _updatedBy = nCV();
        }
        return _updatedBy;
    }

    protected ConditionValue getCValueUpdatedBy() {
        return getUpdatedBy();
    }

    public BsFileCrawlingConfigCQ addOrderBy_UpdatedBy_Asc() {
        regOBA("UPDATED_BY");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_UpdatedBy_Desc() {
        regOBD("UPDATED_BY");
        return this;
    }

    protected ConditionValue _updatedTime;

    public ConditionValue getUpdatedTime() {
        if (_updatedTime == null) {
            _updatedTime = nCV();
        }
        return _updatedTime;
    }

    protected ConditionValue getCValueUpdatedTime() {
        return getUpdatedTime();
    }

    public BsFileCrawlingConfigCQ addOrderBy_UpdatedTime_Asc() {
        regOBA("UPDATED_TIME");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_UpdatedTime_Desc() {
        regOBD("UPDATED_TIME");
        return this;
    }

    protected ConditionValue _deletedBy;

    public ConditionValue getDeletedBy() {
        if (_deletedBy == null) {
            _deletedBy = nCV();
        }
        return _deletedBy;
    }

    protected ConditionValue getCValueDeletedBy() {
        return getDeletedBy();
    }

    public BsFileCrawlingConfigCQ addOrderBy_DeletedBy_Asc() {
        regOBA("DELETED_BY");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_DeletedBy_Desc() {
        regOBD("DELETED_BY");
        return this;
    }

    protected ConditionValue _deletedTime;

    public ConditionValue getDeletedTime() {
        if (_deletedTime == null) {
            _deletedTime = nCV();
        }
        return _deletedTime;
    }

    protected ConditionValue getCValueDeletedTime() {
        return getDeletedTime();
    }

    public BsFileCrawlingConfigCQ addOrderBy_DeletedTime_Asc() {
        regOBA("DELETED_TIME");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_DeletedTime_Desc() {
        regOBD("DELETED_TIME");
        return this;
    }

    protected ConditionValue _versionNo;

    public ConditionValue getVersionNo() {
        if (_versionNo == null) {
            _versionNo = nCV();
        }
        return _versionNo;
    }

    protected ConditionValue getCValueVersionNo() {
        return getVersionNo();
    }

    public BsFileCrawlingConfigCQ addOrderBy_VersionNo_Asc() {
        regOBA("VERSION_NO");
        return this;
    }

    public BsFileCrawlingConfigCQ addOrderBy_VersionNo_Desc() {
        regOBD("VERSION_NO");
        return this;
    }

    // ===================================================================================
    //                                                           Specified Derived OrderBy
    //                                                           =========================
    public BsFileCrawlingConfigCQ addSpecifiedDerivedOrderBy_Asc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Asc(aliasName);
        return this;
    }

    public BsFileCrawlingConfigCQ addSpecifiedDerivedOrderBy_Desc(
            String aliasName) {
        registerSpecifiedDerivedOrderBy_Desc(aliasName);
        return this;
    }

    // ===================================================================================
    //                                                                         Union Query
    //                                                                         ===========
    protected void reflectRelationOnUnionQuery(ConditionQuery baseQueryAsSuper,
            ConditionQuery unionQueryAsSuper) {
    }

    // ===================================================================================
    //                                                                       Foreign Query
    //                                                                       =============
    // ===================================================================================
    //                                                                     Scalar SubQuery
    //                                                                     ===============
    protected Map<String, FileCrawlingConfigCQ> _scalarSubQueryMap;

    public Map<String, FileCrawlingConfigCQ> getScalarSubQuery() {
        return _scalarSubQueryMap;
    }

    public String keepScalarSubQuery(FileCrawlingConfigCQ subQuery) {
        if (_scalarSubQueryMap == null) {
            _scalarSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_scalarSubQueryMap.size() + 1);
        _scalarSubQueryMap.put(key, subQuery);
        return "scalarSubQuery." + key;
    }

    // ===================================================================================
    //                                                             MySelf InScope SubQuery
    //                                                             =======================
    protected Map<String, FileCrawlingConfigCQ> _myselfInScopeSubQueryMap;

    public Map<String, FileCrawlingConfigCQ> getMyselfInScopeSubQuery() {
        return _myselfInScopeSubQueryMap;
    }

    public String keepMyselfInScopeSubQuery(FileCrawlingConfigCQ subQuery) {
        if (_myselfInScopeSubQueryMap == null) {
            _myselfInScopeSubQueryMap = newLinkedHashMap();
        }
        String key = "subQueryMapKey" + (_myselfInScopeSubQueryMap.size() + 1);
        _myselfInScopeSubQueryMap.put(key, subQuery);
        return "myselfInScopeSubQuery." + key;
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    String xCB() {
        return FileCrawlingConfigCB.class.getName();
    }

    String xCQ() {
        return FileCrawlingConfigCQ.class.getName();
    }

    String xMap() {
        return Map.class.getName();
    }
}
