<%@page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8" %>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
<meta http-equiv="content-style-type" content="text/css"/>
<meta http-equiv="content-script-type" content="text/javascript"/>
<title>Fess</title>
<link href="${f:url('/css/style.css')}" rel="stylesheet" type="text/css"/>
</head>
<body>
<div id="header">
	<s:form action="search">
		<div class="input">
			<s:link action="index" title="Fess Home">
				<img class="logo" src="${f:url('/images/logo-top.gif')}" alt="<bean:message key="labels.search_header_logo_alt"/>"/>
			</s:link>									
			<html:text styleClass="query" property="query" title="Search" size="50" maxlength="1000" />
			<input class="btn" type="submit" value="<bean:message key="labels.search"/>" name="search"/>
		</div>
	</s:form>
</div>

<c:choose>
<c:when test="${f:h(allRecordCount) != 0}">
<!-- query matched some document -->
<div id="subheader">
	<p>
		<bean:message key="labels.search_result_status" arg0="${f:h(query)}"
		arg1="${f:h(allRecordCount)}" arg2="${f:h(currentStartRecordNumber)}" arg3="${f:h(currentEndRecordNumber)}"/>
<c:if test="${execTime!=null}">
		<bean:message key="labels.search_result_time" arg0="${f:h(execTime)}"/>
</c:if>
	</p>
</div>

<div id="result">
	<div>
		<ol>
<c:forEach var="doc" varStatus="s" items="${documentItems}">
			<li>
				<h3 class="title">
					<a href="${doc.urlLink}">${f:h(doc.contentTitle)}</a>
				</h3>
				<div class="body">
${doc.contentDescription}				
					<br/>
					<cite>${f:h(doc.site)}</cite>
				</div>
			</li>
</c:forEach>
		</ol>
	</div>
</div>

<div id="subfooter">
	<p>
<c:if test="${existPrevPage}">
		<span><s:link href="prev?query=${f:u(query)}&pn=${f:u(currentPageNumber)}&num=${f:u(pageSize)}">&lt;&lt;<bean:message key="labels.prev_page"/></s:link></span>
</c:if>
<c:forEach var="pageNumber" varStatus="s" items="${pageNumberList}">
	<c:if test="${pageNumber == currentPageNumber}">
		<span>${pageNumber}</span>
	</c:if>
	<c:if test="${pageNumber != currentPageNumber}">
		<span><s:link href="move?query=${f:u(query)}&pn=${f:u(pageNumber)}&num=${f:u(pageSize)}">${f:h(pageNumber)}</s:link></span>
	</c:if>
</c:forEach>
<c:if test="${existNextPage}">
		<span><s:link href="next?query=${f:u(query)}&pn=${f:u(currentPageNumber)}&num=${f:u(pageSize)}"><bean:message key="labels.next_page"/>&gt;&gt;</s:link></span>
</c:if>
	</p>
</div>
</c:when>
<c:otherwise>
<!-- query did not match any document -->
<div id="subheader">
</div>
<div id="result">
<p>
<bean:message key="labels.did_not_match" arg0="${f:h(query)}"/>
</p>
</div>
</c:otherwise>
</c:choose>

<div id="footer">
	<hr/>
	<p class="left">
	</p>
	<p class="right"><bean:message key="labels.footer.copyright"/></p>
	<p>
	&nbsp;
	</p>
</div>
</body>
</html>



