/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.service;

import java.io.Serializable;

import javax.annotation.Resource;

import jp.sf.fess.entity.Document;
import jp.sf.fess.helper.QueryHelper;
import jp.sf.fess.solr.SolrServerGroup;
import jp.sf.fess.solr.SolrServerManager;
import jp.sf.fess.util.QueryResponseList;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;

public class SearchService implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected SolrServerManager solrServerManager;

    @Resource
    protected QueryHelper queryHelper;

    public QueryResponseList<Document> selectList(String query, int start,
            int rows) {
        SolrServerGroup solrServerGroup = solrServerManager
                .getSelectSolrServerGroup();

        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(queryHelper.build(query));
        solrQuery.setStart(start);
        solrQuery.setRows(rows);

        QueryResponse queryResponse = solrServerGroup.query(solrQuery,
                SolrRequest.METHOD.POST);
        return new QueryResponseList<Document>(queryResponse, Document.class,
                rows);
    }
}
