/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.exentity.OverlappingHost;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of OVERLAPPING_HOST. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class OverlappingHostDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final OverlappingHostDbm _instance = new OverlappingHostDbm();

    private OverlappingHostDbm() {
    }

    public static OverlappingHostDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    public String getTableDbName() {
        return "OVERLAPPING_HOST";
    }

    public String getTablePropertyName() {
        return "overlappingHost";
    }

    public String getTableSqlName() {
        return "OVERLAPPING_HOST";
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected ColumnInfo _columnId = cci("ID", null, "id", Long.class, true,
            true, null, null);

    protected ColumnInfo _columnRegularName = cci("REGULAR_NAME", null,
            "regularName", String.class, false, false, 1000, 0);

    protected ColumnInfo _columnOverlappingName = cci("OVERLAPPING_NAME", null,
            "overlappingName", String.class, false, false, 1000, 0);

    protected ColumnInfo _columnSortOrder = cci("SORT_ORDER", null,
            "sortOrder", Integer.class, false, false, null, null);

    protected ColumnInfo _columnCreatedBy = cci("CREATED_BY", null,
            "createdBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnCreatedTime = cci("CREATED_TIME", null,
            "createdTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnUpdatedBy = cci("UPDATED_BY", null,
            "updatedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME", null,
            "updatedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnDeletedBy = cci("DELETED_BY", null,
            "deletedBy", String.class, false, false, 255, 0);

    protected ColumnInfo _columnDeletedTime = cci("DELETED_TIME", null,
            "deletedTime", java.sql.Timestamp.class, false, false, null, null);

    protected ColumnInfo _columnVersionNo = cci("VERSION_NO", null,
            "versionNo", Integer.class, false, false, null, null,
            OptimisticLockType.VERSION_NO);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnRegularName() {
        return _columnRegularName;
    }

    public ColumnInfo columnOverlappingName() {
        return _columnOverlappingName;
    }

    public ColumnInfo columnSortOrder() {
        return _columnSortOrder;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    public boolean hasVersionNo() {
        return true;
    }

    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.OverlappingHost";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.OverlappingHostCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.OverlappingHostDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.OverlappingHostBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<OverlappingHost> getEntityType() {
        return OverlappingHost.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public OverlappingHost newMyEntity() {
        return new OverlappingHost();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    // -----------------------------------------------------
    //                                                Accept
    //                                                ------
    public void acceptPrimaryKeyMap(Entity entity,
            Map<String, ? extends Object> primaryKeyMap) {
        doAcceptPrimaryKeyMap((OverlappingHost) entity, primaryKeyMap, _epsMap);
    }

    public void acceptPrimaryKeyMapString(Entity entity,
            String primaryKeyMapString) {
        MapStringUtil.acceptPrimaryKeyMapString(primaryKeyMapString, entity);
    }

    public void acceptColumnValueMap(Entity entity,
            Map<String, ? extends Object> columnValueMap) {
        doAcceptColumnValueMap((OverlappingHost) entity, columnValueMap,
                _epsMap);
    }

    public void acceptColumnValueMapString(Entity entity,
            String columnValueMapString) {
        MapStringUtil.acceptColumnValueMapString(columnValueMapString, entity);
    }

    // -----------------------------------------------------
    //                                               Extract
    //                                               -------
    public String extractPrimaryKeyMapString(Entity entity) {
        return MapStringUtil.extractPrimaryKeyMapString(entity);
    }

    public String extractPrimaryKeyMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractPrimaryKeyMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    public String extractColumnValueMapString(Entity entity) {
        return MapStringUtil.extractColumnValueMapString(entity);
    }

    public String extractColumnValueMapString(Entity entity, String startBrace,
            String endBrace, String delimiter, String equal) {
        return doExtractColumnValueMapString(entity, startBrace, endBrace,
                delimiter, equal);
    }

    // -----------------------------------------------------
    //                                               Convert
    //                                               -------
    public List<Object> convertToColumnValueList(Entity entity) {
        return newArrayList(convertToColumnValueMap(entity).values());
    }

    public Map<String, Object> convertToColumnValueMap(Entity entity) {
        return doConvertToColumnValueMap(entity);
    }

    public List<String> convertToColumnStringValueList(Entity entity) {
        return newArrayList(convertToColumnStringValueMap(entity).values());
    }

    public Map<String, String> convertToColumnStringValueMap(Entity entity) {
        return doConvertToColumnStringValueMap(entity);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<OverlappingHost>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsRegularName(), columnRegularName());
        setupEps(_epsMap, new EpsOverlappingName(), columnOverlappingName());
        setupEps(_epsMap, new EpsSortOrder(), columnSortOrder());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((OverlappingHost) entity, value);
    }

    public static class EpsId implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setId((Long) v);
        }
    }

    public static class EpsRegularName implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setRegularName((String) v);
        }
    }

    public static class EpsOverlappingName implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setOverlappingName((String) v);
        }
    }

    public static class EpsSortOrder implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setSortOrder((Integer) v);
        }
    }

    public static class EpsCreatedBy implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsVersionNo implements Eps<OverlappingHost> {
        public void setup(OverlappingHost e, Object v) {
            e.setVersionNo((Integer) v);
        }
    }
}
