/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.helper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

import jp.sf.fess.db.exentity.PathMapping;

public class PathMappingHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    private static final Map<String, List<PathMapping>> PATH_MAPPING_MAP = new HashMap<String, List<PathMapping>>();

    public void setPathMappingList(String sessionId,
            List<PathMapping> pathMappingList) {
        if (sessionId != null) {
            if (pathMappingList != null) {
                PATH_MAPPING_MAP.put(sessionId, pathMappingList);
            } else {
                removePathMappingList(sessionId);
            }
        }
    }

    public void removePathMappingList(String sessionId) {
        PATH_MAPPING_MAP.remove(sessionId);
    }

    public List<PathMapping> getPathMappingList(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return PATH_MAPPING_MAP.get(sessionId);
    }

    public String replaceUrl(String sessionId, String url) {
        List<PathMapping> pathMappingList = getPathMappingList(sessionId);
        if (pathMappingList == null) {
            return url;
        }

        for (PathMapping pathMapping : pathMappingList) {
            Matcher matcher = pathMapping.getMatcher(url);
            if (matcher.find()) {
                url = matcher.replaceAll(pathMapping.getReplacement());
            }
        }
        return url;
    }
}
