/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.DataConfigToBrowserTypeMappingDbm;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of DATA_CONFIG_TO_BROWSER_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, BROWSER_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     BROWSER_TYPE, DATA_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     browserType, dataCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToBrowserTypeMappingBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return DataConfigToBrowserTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public DataConfigToBrowserTypeMappingDbm getMyDBMeta() {
        return DataConfigToBrowserTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public DataConfigToBrowserTypeMapping newMyEntity() {
        return new DataConfigToBrowserTypeMapping();
    }

    public DataConfigToBrowserTypeMappingCB newMyConditionBean() {
        return new DataConfigToBrowserTypeMappingCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(DataConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of DataConfigToBrowserTypeMapping. (NotNull)
     */
    public void selectCursor(DataConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<DataConfigToBrowserTypeMapping> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<DataConfigToBrowserTypeMapping>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToBrowserTypeMapping selectEntity(
            final DataConfigToBrowserTypeMappingCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<DataConfigToBrowserTypeMapping, DataConfigToBrowserTypeMappingCB>() {
                    public List<DataConfigToBrowserTypeMapping> callbackSelectList(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToBrowserTypeMapping selectEntityWithDeletedCheck(
            final DataConfigToBrowserTypeMappingCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<DataConfigToBrowserTypeMapping, DataConfigToBrowserTypeMappingCB>() {
                    public List<DataConfigToBrowserTypeMapping> callbackSelectList(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public DataConfigToBrowserTypeMapping selectByPKValueWithDeletedCheck(
            Long id) {
        DataConfigToBrowserTypeMapping entity = new DataConfigToBrowserTypeMapping();
        entity.setId(id);
        final DataConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<DataConfigToBrowserTypeMapping> selectList(
            DataConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<DataConfigToBrowserTypeMapping>(
                getTableDbName()).buildListResultBean(cb,
                delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of DataConfigToBrowserTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<DataConfigToBrowserTypeMapping> selectPage(
            final DataConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<DataConfigToBrowserTypeMapping> invoker = new PagingInvoker<DataConfigToBrowserTypeMapping>(
                getTableDbName());
        final PagingHandler<DataConfigToBrowserTypeMapping> handler = new PagingHandler<DataConfigToBrowserTypeMapping>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<DataConfigToBrowserTypeMapping> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * dataConfigToBrowserTypeMappingBhv.scalarSelect(Date.class).max(new ScalarQuery(DataConfigToBrowserTypeMappingCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<DataConfigToBrowserTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        DataConfigToBrowserTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<DataConfigToBrowserTypeMappingCB, RESULT>(cb,
                resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'BrowserType'.
     * @param dataConfigToBrowserTypeMappingList The list of dataConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<BrowserType> pulloutBrowserType(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<DataConfigToBrowserTypeMapping, BrowserType>() {
                    public BrowserType callbackGetForeignEntity(
                            DataConfigToBrowserTypeMapping entity) {
                        return entity.getBrowserType();
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'DataCrawlingConfig'.
     * @param dataConfigToBrowserTypeMappingList The list of dataConfigToBrowserTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<DataCrawlingConfig> pulloutDataCrawlingConfig(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        return helpPulloutInternally(
                dataConfigToBrowserTypeMappingList,
                new InternalPulloutCallback<DataConfigToBrowserTypeMapping, DataCrawlingConfig>() {
                    public DataCrawlingConfig callbackGetForeignEntity(
                            DataConfigToBrowserTypeMapping entity) {
                        return entity.getDataCrawlingConfig();
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param dataConfigToBrowserTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        assertEntityNotNull(dataConfigToBrowserTypeMapping);
        delegateInsert(dataConfigToBrowserTypeMapping);
    }

    @Override
    protected void doCreate(Entity dataConfigToBrowserTypeMapping) {
        insert((DataConfigToBrowserTypeMapping) dataConfigToBrowserTypeMapping);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataConfigToBrowserTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        helpUpdateInternally(dataConfigToBrowserTypeMapping,
                new InternalUpdateCallback<DataConfigToBrowserTypeMapping>() {
                    public int callbackDelegateUpdate(
                            DataConfigToBrowserTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((DataConfigToBrowserTypeMapping) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((DataConfigToBrowserTypeMapping) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param dataConfigToBrowserTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        helpInsertOrUpdateInternally(
                dataConfigToBrowserTypeMapping,
                new InternalInsertOrUpdateCallback<DataConfigToBrowserTypeMapping, DataConfigToBrowserTypeMappingCB>() {
                    public void callbackInsert(
                            DataConfigToBrowserTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            DataConfigToBrowserTypeMapping entity) {
                        update(entity);
                    }

                    public DataConfigToBrowserTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity dataConfigToBrowserTypeMapping) {
        insertOrUpdate((DataConfigToBrowserTypeMapping) dataConfigToBrowserTypeMapping);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((DataConfigToBrowserTypeMapping) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param dataConfigToBrowserTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping) {
        helpDeleteInternally(dataConfigToBrowserTypeMapping,
                new InternalDeleteCallback<DataConfigToBrowserTypeMapping>() {
                    public int callbackDelegateDelete(
                            DataConfigToBrowserTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity dataConfigToBrowserTypeMapping) {
        delete((DataConfigToBrowserTypeMapping) dataConfigToBrowserTypeMapping);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        assertObjectNotNull("dataConfigToBrowserTypeMappingList",
                dataConfigToBrowserTypeMappingList);
        return delegateInsertList(dataConfigToBrowserTypeMappingList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        assertObjectNotNull("dataConfigToBrowserTypeMappingList",
                dataConfigToBrowserTypeMappingList);
        return delegateUpdateList(dataConfigToBrowserTypeMappingList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param dataConfigToBrowserTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<DataConfigToBrowserTypeMapping> dataConfigToBrowserTypeMappingList) {
        assertObjectNotNull("dataConfigToBrowserTypeMappingList",
                dataConfigToBrowserTypeMappingList);
        return delegateDeleteList(dataConfigToBrowserTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param dataConfigToBrowserTypeMapping Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            DataConfigToBrowserTypeMapping dataConfigToBrowserTypeMapping,
            DataConfigToBrowserTypeMappingCB cb) {
        assertObjectNotNull("dataConfigToBrowserTypeMapping",
                dataConfigToBrowserTypeMapping);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(dataConfigToBrowserTypeMapping);
        filterEntityOfUpdate(dataConfigToBrowserTypeMapping);
        assertEntityOfUpdate(dataConfigToBrowserTypeMapping);
        return invoke(createQueryUpdateEntityCBCommand(
                dataConfigToBrowserTypeMapping, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(DataConfigToBrowserTypeMappingCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(DataConfigToBrowserTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(DataConfigToBrowserTypeMappingCB cb,
            EntityRowHandler<DataConfigToBrowserTypeMapping> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                DataConfigToBrowserTypeMapping.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((DataConfigToBrowserTypeMappingCB) cb);
    }

    protected List<DataConfigToBrowserTypeMapping> delegateSelectList(
            DataConfigToBrowserTypeMappingCB cb) {
        return invoke(createSelectListCBCommand(cb,
                DataConfigToBrowserTypeMapping.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((DataConfigToBrowserTypeMappingCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(DataConfigToBrowserTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(DataConfigToBrowserTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(DataConfigToBrowserTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<DataConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<DataConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<DataConfigToBrowserTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected DataConfigToBrowserTypeMapping downcast(Entity entity) {
        return helpDowncastInternally(entity,
                DataConfigToBrowserTypeMapping.class);
    }
}
