/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.CrawlingSessionInfoDbm;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.db.exentity.CrawlingSessionInfo;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of CRAWLING_SESSION_INFO as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, CRAWLING_SESSION_ID, KEY, VALUE, CREATED_TIME
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     CRAWLING_SESSION
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     crawlingSession
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsCrawlingSessionInfoBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "CRAWLING_SESSION_INFO";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return CrawlingSessionInfoDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public CrawlingSessionInfoDbm getMyDBMeta() {
        return CrawlingSessionInfoDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public CrawlingSessionInfo newMyEntity() {
        return new CrawlingSessionInfo();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public CrawlingSessionInfoCB newMyConditionBean() {
        return new CrawlingSessionInfoCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * int count = crawlingSessionInfoBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The selected count.
     */
    public int selectCount(CrawlingSessionInfoCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(CrawlingSessionInfoCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * crawlingSessionInfoBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;CrawlingSessionInfo&gt;() {
     *     public void handle(CrawlingSessionInfo entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @param entityRowHandler The handler of entity row of CrawlingSessionInfo. (NotNull)
     */
    public void selectCursor(CrawlingSessionInfoCB cb,
            EntityRowHandler<CrawlingSessionInfo> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> void doSelectCursor(
            CrawlingSessionInfoCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<CrawlingSessionInfo>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * CrawlingSessionInfo crawlingSessionInfo = crawlingSessionInfoBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (crawlingSessionInfo != null) {
     *     ... = crawlingSessionInfo.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSessionInfo selectEntity(CrawlingSessionInfoCB cb) {
        return doSelectEntity(cb, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> ENTITY doSelectEntity(
            final CrawlingSessionInfoCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, CrawlingSessionInfoCB>() {
                    public List<ENTITY> callbackSelectList(
                            CrawlingSessionInfoCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * CrawlingSessionInfo crawlingSessionInfo = crawlingSessionInfoBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = crawlingSessionInfo.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSessionInfo selectEntityWithDeletedCheck(
            CrawlingSessionInfoCB cb) {
        return doSelectEntityWithDeletedCheck(cb, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> ENTITY doSelectEntityWithDeletedCheck(
            final CrawlingSessionInfoCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, CrawlingSessionInfoCB>() {
                    public List<ENTITY> callbackSelectList(
                            CrawlingSessionInfoCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSessionInfo selectByPKValue(Long id) {
        return doSelectByPKValue(id, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public CrawlingSessionInfo selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private CrawlingSessionInfoCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        CrawlingSessionInfoCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;CrawlingSessionInfo&gt; crawlingSessionInfoList = crawlingSessionInfoBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (CrawlingSessionInfo crawlingSessionInfo : crawlingSessionInfoList) {
     *     ... = crawlingSessionInfo.get...();
     * }
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<CrawlingSessionInfo> selectList(
            CrawlingSessionInfoCB cb) {
        return doSelectList(cb, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> ListResultBean<ENTITY> doSelectList(
            CrawlingSessionInfoCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, CrawlingSessionInfoCB>() {
                    public List<ENTITY> callbackSelectList(
                            CrawlingSessionInfoCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;CrawlingSessionInfo&gt; page = crawlingSessionInfoBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (CrawlingSessionInfo crawlingSessionInfo : page) {
     *     ... = crawlingSessionInfo.get...();
     * }
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<CrawlingSessionInfo> selectPage(
            CrawlingSessionInfoCB cb) {
        return doSelectPage(cb, CrawlingSessionInfo.class);
    }

    protected <ENTITY extends CrawlingSessionInfo> PagingResultBean<ENTITY> doSelectPage(
            CrawlingSessionInfoCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, CrawlingSessionInfoCB>() {
                    public int callbackSelectCount(CrawlingSessionInfoCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            CrawlingSessionInfoCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * crawlingSessionInfoBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(CrawlingSessionInfoCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<CrawlingSessionInfoCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends CrawlingSessionInfoCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'CrawlingSession'.
     * @param crawlingSessionInfoList The list of crawlingSessionInfo. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<CrawlingSession> pulloutCrawlingSession(
            List<CrawlingSessionInfo> crawlingSessionInfoList) {
        return helpPulloutInternally(
                crawlingSessionInfoList,
                new InternalPulloutCallback<CrawlingSessionInfo, CrawlingSession>() {
                    public CrawlingSession getFr(CrawlingSessionInfo e) {
                        return e.getCrawlingSession();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(CrawlingSession e,
                            List<CrawlingSessionInfo> ls) {
                        e.setCrawlingSessionInfoList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * crawlingSessionInfo.setFoo...(value);
     * crawlingSessionInfo.setBar...(value);
     * crawlingSessionInfoBhv.<span style="color: #FD4747">insert</span>(crawlingSessionInfo);
     * ... = crawlingSessionInfo.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param crawlingSessionInfo The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(CrawlingSessionInfo crawlingSessionInfo) {
        assertEntityNotNull(crawlingSessionInfo);
        delegateInsert(crawlingSessionInfo);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
     * crawlingSessionInfo.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * crawlingSessionInfo.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * crawlingSessionInfo.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     crawlingSessionInfoBhv.<span style="color: #FD4747">update</span>(crawlingSessionInfo);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param crawlingSessionInfo The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final CrawlingSessionInfo crawlingSessionInfo) {
        helpUpdateInternally(crawlingSessionInfo,
                new InternalUpdateCallback<CrawlingSessionInfo>() {
                    public int callbackDelegateUpdate(CrawlingSessionInfo entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param crawlingSessionInfo The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final CrawlingSessionInfo crawlingSessionInfo) {
        helpInsertOrUpdateInternally(
                crawlingSessionInfo,
                new InternalInsertOrUpdateCallback<CrawlingSessionInfo, CrawlingSessionInfoCB>() {
                    public void callbackInsert(CrawlingSessionInfo entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(CrawlingSessionInfo entity) {
                        update(entity);
                    }

                    public CrawlingSessionInfoCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(CrawlingSessionInfoCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
     * crawlingSessionInfo.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * crawlingSessionInfo.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     crawlingSessionInfoBhv.<span style="color: #FD4747">delete</span>(crawlingSessionInfo);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param crawlingSessionInfo The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(CrawlingSessionInfo crawlingSessionInfo) {
        helpDeleteInternally(crawlingSessionInfo,
                new InternalDeleteCallback<CrawlingSessionInfo>() {
                    public int callbackDelegateDelete(CrawlingSessionInfo entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionInfoList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<CrawlingSessionInfo> crawlingSessionInfoList) {
        assertObjectNotNull("crawlingSessionInfoList", crawlingSessionInfoList);
        return delegateInsertList(crawlingSessionInfoList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionInfoList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<CrawlingSessionInfo> crawlingSessionInfoList) {
        assertObjectNotNull("crawlingSessionInfoList", crawlingSessionInfoList);
        return delegateUpdateList(crawlingSessionInfoList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param crawlingSessionInfoList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<CrawlingSessionInfo> crawlingSessionInfoList) {
        assertObjectNotNull("crawlingSessionInfoList", crawlingSessionInfoList);
        return delegateDeleteList(crawlingSessionInfoList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//crawlingSessionInfo.setPK...(value);</span>
     * crawlingSessionInfo.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//crawlingSessionInfo.setVersionNo(value);</span>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * crawlingSessionInfoBhv.<span style="color: #FD4747">queryUpdate</span>(crawlingSessionInfo, cb);
     * </pre>
     * @param crawlingSessionInfo The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(CrawlingSessionInfo crawlingSessionInfo,
            CrawlingSessionInfoCB cb) {
        return delegateQueryUpdate(crawlingSessionInfo, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * crawlingSessionInfoBhv.<span style="color: #FD4747">queryDelete</span>(crawlingSessionInfo, cb);
     * </pre>
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(CrawlingSessionInfoCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
     * crawlingSessionInfo.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * crawlingSessionInfo.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * crawlingSessionInfo.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;CrawlingSessionInfoCB&gt; option = new UpdateOption&lt;CrawlingSessionInfoCB&gt;();
     *     option.self(new SpecifyQuery&lt;CrawlingSessionInfoCB&gt;() {
     *         public void specify(CrawlingSessionInfoCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     crawlingSessionInfoBhv.<span style="color: #FD4747">varyingUpdate</span>(crawlingSessionInfo, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param crawlingSessionInfo The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(CrawlingSessionInfo crawlingSessionInfo,
            final UpdateOption<CrawlingSessionInfoCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(crawlingSessionInfo,
                new InternalUpdateCallback<CrawlingSessionInfo>() {
                    public int callbackDelegateUpdate(CrawlingSessionInfo entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * CrawlingSessionInfo crawlingSessionInfo = new CrawlingSessionInfo();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//crawlingSessionInfo.setPK...(value);</span>
     * crawlingSessionInfo.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//crawlingSessionInfo.setVersionNo(value);</span>
     * CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;CrawlingSessionInfoCB&gt; option = new UpdateOption&lt;CrawlingSessionInfoCB&gt;();
     * option.self(new SpecifyQuery&lt;CrawlingSessionInfoCB&gt;() {
     *     public void specify(CrawlingSessionInfoCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * crawlingSessionInfoBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(crawlingSessionInfo, cb, option);
     * </pre>
     * @param crawlingSessionInfo The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of CrawlingSessionInfo. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(CrawlingSessionInfo crawlingSessionInfo,
            CrawlingSessionInfoCB cb,
            final UpdateOption<CrawlingSessionInfoCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(crawlingSessionInfo, cb, option);
    }

    protected void processVaryingUpdate(
            UpdateOption<CrawlingSessionInfoCB> option) {
        assertUpdateOptionNotNull(option);
        CrawlingSessionInfoCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(CrawlingSessionInfoCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends CrawlingSessionInfo> void delegateSelectCursor(
            CrawlingSessionInfoCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends CrawlingSessionInfo> List<ENTITY> delegateSelectList(
            CrawlingSessionInfoCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(CrawlingSessionInfo e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(CrawlingSessionInfo e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(CrawlingSessionInfo e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<CrawlingSessionInfo> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<CrawlingSessionInfo> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<CrawlingSessionInfo> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(CrawlingSessionInfo e,
            CrawlingSessionInfoCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(CrawlingSessionInfoCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(CrawlingSessionInfo e,
            UpdateOption<CrawlingSessionInfoCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(CrawlingSessionInfo e,
            CrawlingSessionInfoCB cb, UpdateOption<CrawlingSessionInfoCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected CrawlingSessionInfo downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, CrawlingSessionInfo.class);
    }

    protected CrawlingSessionInfoCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                CrawlingSessionInfoCB.class);
    }
}
