/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.Set;

import jp.sf.fess.db.allcommon.CDef;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of PATH_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, REGEX, REPLACEMENT, PROCESS_TYPE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsPathMapping implements Entity, Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** REGEX: {NotNull, VARCHAR(1000)} */
    protected String _regex;

    /** REPLACEMENT: {NotNull, VARCHAR(1000)} */
    protected String _replacement;

    /** PROCESS_TYPE: {NotNull, VARCHAR(1), classification=ProcessType} */
    protected String _processType;

    /** SORT_ORDER: {NotNull, INTEGER(10)} */
    protected Integer _sortOrder;

    /** CREATED_BY: {NotNull, VARCHAR(255)} */
    protected String _createdBy;

    /** CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _createdTime;

    /** UPDATED_BY: {VARCHAR(255)} */
    protected String _updatedBy;

    /** UPDATED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _updatedTime;

    /** DELETED_BY: {VARCHAR(255)} */
    protected String _deletedBy;

    /** DELETED_TIME: {TIMESTAMP(23, 10)} */
    protected java.sql.Timestamp _deletedTime;

    /** VERSION_NO: {NotNull, INTEGER(10)} */
    protected Integer _versionNo;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected EntityModifiedProperties _modifiedProperties = newEntityModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    public String getTableDbName() {
        return "PATH_MAPPING";
    }

    /**
     * {@inheritDoc}
     */
    public String getTablePropertyName() { // according to Java Beans rule
        return "pathMapping";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                             Classification Property
    //                                                             =======================
    /**
     * Set the value of processType as the classification of ProcessType. <br />
     * Processing Type
     * @param cdef The instance of classification definition (as ENUM type). (Nullable)
     */
    public void setProcessTypeAsProcessType(CDef.ProcessType cdef) {
        setProcessType(cdef != null ? cdef.code() : null);
    }

    /**
     * Get the value of processType as the classification of ProcessType. <br />
     * Processing Type
     * <p>It's treated as case insensitive and if the code value is null, it returns null.</p>
     * @return The instance of classification definition (as ENUM type). (Nullable)
     */
    public CDef.ProcessType getProcessTypeAsProcessType() {
        return CDef.ProcessType.codeOf(getProcessType());
    }

    // ===================================================================================
    //                                                              Classification Setting
    //                                                              ======================
    /**
     * Set the value of processType as Crawling. <br />
     * Crawling: Process When Crawling
     */
    public void setProcessType_Crawling() {
        setProcessTypeAsProcessType(CDef.ProcessType.Crawling);
    }

    /**
     * Same as setProcessType_Crawling. <br />
     * Crawling: Process When Crawling
     */
    public void classifyProcessTypeCrawling() {
        setProcessType_Crawling();
    }

    /**
     * Set the value of processType as Displaying. <br />
     * Displaying: Process When Displaying
     */
    public void setProcessType_Displaying() {
        setProcessTypeAsProcessType(CDef.ProcessType.Displaying);
    }

    /**
     * Same as setProcessType_Displaying. <br />
     * Displaying: Process When Displaying
     */
    public void classifyProcessTypeDisplaying() {
        setProcessType_Displaying();
    }

    /**
     * Set the value of processType as Both. <br />
     * Both: Process When Crawling/Displaying
     */
    public void setProcessType_Both() {
        setProcessTypeAsProcessType(CDef.ProcessType.Both);
    }

    /**
     * Same as setProcessType_Both. <br />
     * Both: Process When Crawling/Displaying
     */
    public void classifyProcessTypeBoth() {
        setProcessType_Both();
    }

    /**
     * Same as setProcessTypeAsProcessType(cdef). <br />
     * @param cdef The instance of classification definition (as ENUM type). (Nullable)
     */
    public void classifyProcessType(CDef.ProcessType cdef) {
        setProcessTypeAsProcessType(cdef);
    }

    // ===================================================================================
    //                                                        Classification Determination
    //                                                        ============================
    /**
     * Is the value of processType 'Crawling'? <br />
     * Crawling: Process When Crawling
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isProcessTypeCrawling() {
        CDef.ProcessType cdef = getProcessTypeAsProcessType();
        return cdef != null ? cdef.equals(CDef.ProcessType.Crawling) : false;
    }

    /**
     * Is the value of processType 'Displaying'? <br />
     * Displaying: Process When Displaying
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isProcessTypeDisplaying() {
        CDef.ProcessType cdef = getProcessTypeAsProcessType();
        return cdef != null ? cdef.equals(CDef.ProcessType.Displaying) : false;
    }

    /**
     * Is the value of processType 'Both'? <br />
     * Both: Process When Crawling/Displaying
     * <p>It's treated as case insensitive and if the code value is null, it returns false.</p>
     * @return Determination.
     */
    public boolean isProcessTypeBoth() {
        CDef.ProcessType cdef = getProcessTypeAsProcessType();
        return cdef != null ? cdef.equals(CDef.ProcessType.Both) : false;
    }

    // ===================================================================================
    //                                                           Classification Name/Alias
    //                                                           =========================
    /**
     * Get the value of the column 'processType' as classification name.
     * @return The string of classification name. (Nullable)
     */
    public String getProcessTypeName() {
        CDef.ProcessType cdef = getProcessTypeAsProcessType();
        return cdef != null ? cdef.name() : null;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    public Set<String> getModifiedPropertyNames() {
        return _modifiedProperties.getPropertyNames();
    }

    protected EntityModifiedProperties newEntityModifiedProperties() {
        return new EntityModifiedProperties();
    }

    /**
     * {@inheritDoc}
     */
    public void clearModifiedPropertyNames() {
        _modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasModification() {
        return !_modifiedProperties.isEmpty();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (Nullable)
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null || !(other instanceof BsPathMapping)) {
            return false;
        }
        BsPathMapping otherEntity = (BsPathMapping) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(Object value1, Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    public int hashCode() {
        int result = 17;
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(int result, Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    public String toStringWithRelation() {
        StringBuilder sb = new StringBuilder();
        sb.append(toString());
        return sb.toString();
    }

    /**
     * @param name The name for display. (Nullable: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    public String buildDisplayString(String name, boolean column,
            boolean relation) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        String c = ", ";
        StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getRegex());
        sb.append(c).append(getReplacement());
        sb.append(c).append(getProcessType());
        sb.append(c).append(getSortOrder());
        sb.append(c).append(getCreatedBy());
        sb.append(c).append(getCreatedTime());
        sb.append(c).append(getUpdatedBy());
        sb.append(c).append(getUpdatedTime());
        sb.append(c).append(getDeletedBy());
        sb.append(c).append(getDeletedTime());
        sb.append(c).append(getVersionNo());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        return "";
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (Nullable)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (Nullable)
     */
    public void setId(Long id) {
        _modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * [get] REGEX: {NotNull, VARCHAR(1000)} <br />
     * @return The value of the column 'REGEX'. (Nullable)
     */
    public String getRegex() {
        return _regex;
    }

    /**
     * [set] REGEX: {NotNull, VARCHAR(1000)} <br />
     * @param regex The value of the column 'REGEX'. (Nullable)
     */
    public void setRegex(String regex) {
        _modifiedProperties.addPropertyName("regex");
        this._regex = regex;
    }

    /**
     * [get] REPLACEMENT: {NotNull, VARCHAR(1000)} <br />
     * @return The value of the column 'REPLACEMENT'. (Nullable)
     */
    public String getReplacement() {
        return _replacement;
    }

    /**
     * [set] REPLACEMENT: {NotNull, VARCHAR(1000)} <br />
     * @param replacement The value of the column 'REPLACEMENT'. (Nullable)
     */
    public void setReplacement(String replacement) {
        _modifiedProperties.addPropertyName("replacement");
        this._replacement = replacement;
    }

    /**
     * [get] PROCESS_TYPE: {NotNull, VARCHAR(1), classification=ProcessType} <br />
     * @return The value of the column 'PROCESS_TYPE'. (Nullable)
     */
    public String getProcessType() {
        return _processType;
    }

    /**
     * [set] PROCESS_TYPE: {NotNull, VARCHAR(1), classification=ProcessType} <br />
     * @param processType The value of the column 'PROCESS_TYPE'. (Nullable)
     */
    public void setProcessType(String processType) {
        _modifiedProperties.addPropertyName("processType");
        this._processType = processType;
    }

    /**
     * [get] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'SORT_ORDER'. (Nullable)
     */
    public Integer getSortOrder() {
        return _sortOrder;
    }

    /**
     * [set] SORT_ORDER: {NotNull, INTEGER(10)} <br />
     * @param sortOrder The value of the column 'SORT_ORDER'. (Nullable)
     */
    public void setSortOrder(Integer sortOrder) {
        _modifiedProperties.addPropertyName("sortOrder");
        this._sortOrder = sortOrder;
    }

    /**
     * [get] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @return The value of the column 'CREATED_BY'. (Nullable)
     */
    public String getCreatedBy() {
        return _createdBy;
    }

    /**
     * [set] CREATED_BY: {NotNull, VARCHAR(255)} <br />
     * @param createdBy The value of the column 'CREATED_BY'. (Nullable)
     */
    public void setCreatedBy(String createdBy) {
        _modifiedProperties.addPropertyName("createdBy");
        this._createdBy = createdBy;
    }

    /**
     * [get] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'CREATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getCreatedTime() {
        return _createdTime;
    }

    /**
     * [set] CREATED_TIME: {NotNull, TIMESTAMP(23, 10)} <br />
     * @param createdTime The value of the column 'CREATED_TIME'. (Nullable)
     */
    public void setCreatedTime(java.sql.Timestamp createdTime) {
        _modifiedProperties.addPropertyName("createdTime");
        this._createdTime = createdTime;
    }

    /**
     * [get] UPDATED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'UPDATED_BY'. (Nullable)
     */
    public String getUpdatedBy() {
        return _updatedBy;
    }

    /**
     * [set] UPDATED_BY: {VARCHAR(255)} <br />
     * @param updatedBy The value of the column 'UPDATED_BY'. (Nullable)
     */
    public void setUpdatedBy(String updatedBy) {
        _modifiedProperties.addPropertyName("updatedBy");
        this._updatedBy = updatedBy;
    }

    /**
     * [get] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getUpdatedTime() {
        return _updatedTime;
    }

    /**
     * [set] UPDATED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param updatedTime The value of the column 'UPDATED_TIME'. (Nullable)
     */
    public void setUpdatedTime(java.sql.Timestamp updatedTime) {
        _modifiedProperties.addPropertyName("updatedTime");
        this._updatedTime = updatedTime;
    }

    /**
     * [get] DELETED_BY: {VARCHAR(255)} <br />
     * @return The value of the column 'DELETED_BY'. (Nullable)
     */
    public String getDeletedBy() {
        return _deletedBy;
    }

    /**
     * [set] DELETED_BY: {VARCHAR(255)} <br />
     * @param deletedBy The value of the column 'DELETED_BY'. (Nullable)
     */
    public void setDeletedBy(String deletedBy) {
        _modifiedProperties.addPropertyName("deletedBy");
        this._deletedBy = deletedBy;
    }

    /**
     * [get] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @return The value of the column 'DELETED_TIME'. (Nullable)
     */
    public java.sql.Timestamp getDeletedTime() {
        return _deletedTime;
    }

    /**
     * [set] DELETED_TIME: {TIMESTAMP(23, 10)} <br />
     * @param deletedTime The value of the column 'DELETED_TIME'. (Nullable)
     */
    public void setDeletedTime(java.sql.Timestamp deletedTime) {
        _modifiedProperties.addPropertyName("deletedTime");
        this._deletedTime = deletedTime;
    }

    /**
     * [get] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @return The value of the column 'VERSION_NO'. (Nullable)
     */
    public Integer getVersionNo() {
        return _versionNo;
    }

    /**
     * [set] VERSION_NO: {NotNull, INTEGER(10)} <br />
     * @param versionNo The value of the column 'VERSION_NO'. (Nullable)
     */
    public void setVersionNo(Integer versionNo) {
        _modifiedProperties.addPropertyName("versionNo");
        this._versionNo = versionNo;
    }
}
