/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.bs;

import java.util.Collection;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.cbean.FailureUrlCB;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.WebCrawlingConfigCB;
import jp.sf.fess.db.cbean.cq.FailureUrlCQ;
import jp.sf.fess.db.cbean.cq.RequestHeaderCQ;
import jp.sf.fess.db.cbean.cq.WebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToBrowserTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToLabelTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebConfigToRoleTypeMappingCQ;
import jp.sf.fess.db.cbean.cq.WebCrawlingConfigCQ;

import org.seasar.dbflute.cbean.AbstractConditionQuery;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.chelper.HpQDRFunction;
import org.seasar.dbflute.cbean.chelper.HpQDRSetupper;
import org.seasar.dbflute.cbean.chelper.HpSSQFunction;
import org.seasar.dbflute.cbean.chelper.HpSSQSetupper;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DateFromToOption;
import org.seasar.dbflute.cbean.coption.FromToOption;
import org.seasar.dbflute.cbean.coption.LikeSearchOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The abstract condition-query of WEB_CRAWLING_CONFIG.
 * @author DBFlute(AutoGenerator)
 */
public abstract class AbstractBsWebCrawlingConfigCQ extends
        AbstractConditionQuery {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public AbstractBsWebCrawlingConfigCQ(ConditionQuery childQuery,
            SqlClause sqlClause, String aliasName, int nestLevel) {
        super(childQuery, sqlClause, aliasName, nestLevel);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "WEB_CRAWLING_CONFIG";
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * ID: {PK, ID, NotNull, BIGINT(19)}
     * @param id The value of id as equal.
     */
    public void setId_Equal(Long id) {
        doSetId_Equal(id);
    }

    protected void doSetId_Equal(Long id) {
        regId(CK_EQ, id);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as notEqual.
     */
    public void setId_NotEqual(Long id) {
        doSetId_NotEqual(id);
    }

    protected void doSetId_NotEqual(Long id) {
        regId(CK_NES, id);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterThan.
     */
    public void setId_GreaterThan(Long id) {
        regId(CK_GT, id);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessThan.
     */
    public void setId_LessThan(Long id) {
        regId(CK_LT, id);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as greaterEqual.
     */
    public void setId_GreaterEqual(Long id) {
        regId(CK_GE, id);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param id The value of id as lessEqual.
     */
    public void setId_LessEqual(Long id) {
        regId(CK_LE, id);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as inScope.
     */
    public void setId_InScope(Collection<Long> idList) {
        doSetId_InScope(idList);
    }

    protected void doSetId_InScope(Collection<Long> idList) {
        regINS(CK_INS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param idList The collection of id as notInScope.
     */
    public void setId_NotInScope(Collection<Long> idList) {
        doSetId_NotInScope(idList);
    }

    protected void doSetId_NotInScope(Collection<Long> idList) {
        regINS(CK_NINS, cTL(idList), getCValueId(), "ID");
    }

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select WEB_CONFIG_ID from FAILURE_URL where ...)} <br />
     * FAILURE_URL as 'failureUrlList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsFailureUrlList</span>(new SubQuery&lt;FailureUrlCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of FailureUrlList for 'exists'. (NotNull)
     */
    public void existsFailureUrlList(SubQuery<FailureUrlCB> subQuery) {
        assertObjectNotNull("subQuery<FailureUrlCB>", subQuery);
        FailureUrlCB cb = new FailureUrlCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_FailureUrlList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_FailureUrlList(
            FailureUrlCQ subQuery);

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select WEB_CRAWLING_CONFIG_ID from REQUEST_HEADER where ...)} <br />
     * REQUEST_HEADER as 'requestHeaderList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsRequestHeaderList</span>(new SubQuery&lt;RequestHeaderCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of RequestHeaderList for 'exists'. (NotNull)
     */
    public void existsRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery);

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select WEB_CRAWLING_CONFIG_ID from WEB_AUTHENTICATION where ...)} <br />
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsWebAuthenticationList</span>(new SubQuery&lt;WebAuthenticationCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of WebAuthenticationList for 'exists'. (NotNull)
     */
    public void existsWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsWebConfigToBrowserTypeMappingList</span>(new SubQuery&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of WebConfigToBrowserTypeMappingList for 'exists'. (NotNull)
     */
    public void existsWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_LABEL_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsWebConfigToLabelTypeMappingList</span>(new SubQuery&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of WebConfigToLabelTypeMappingList for 'exists'. (NotNull)
     */
    public void existsWebConfigToLabelTypeMappingList(
            SubQuery<WebConfigToLabelTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToLabelTypeMappingCB>", subQuery);
        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_WebConfigToLabelTypeMappingList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery);

    /**
     * Set up ExistsReferrer (co-related sub-query). <br />
     * {exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_ROLE_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">existsWebConfigToRoleTypeMappingList</span>(new SubQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of WebConfigToRoleTypeMappingList for 'exists'. (NotNull)
     */
    public void existsWebConfigToRoleTypeMappingList(
            SubQuery<WebConfigToRoleTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToRoleTypeMappingCB>", subQuery);
        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_ExistsReferrer_WebConfigToRoleTypeMappingList(cb
                .query()); // for saving query-value.
        registerExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_ExistsReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select WEB_CONFIG_ID from FAILURE_URL where ...)} <br />
     * FAILURE_URL as 'failureUrlList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsFailureUrlList</span>(new SubQuery&lt;FailureUrlCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_FailureUrlList for 'not exists'. (NotNull)
     */
    public void notExistsFailureUrlList(SubQuery<FailureUrlCB> subQuery) {
        assertObjectNotNull("subQuery<FailureUrlCB>", subQuery);
        FailureUrlCB cb = new FailureUrlCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_FailureUrlList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_FailureUrlList(
            FailureUrlCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select WEB_CRAWLING_CONFIG_ID from REQUEST_HEADER where ...)} <br />
     * REQUEST_HEADER as 'requestHeaderList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsRequestHeaderList</span>(new SubQuery&lt;RequestHeaderCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_RequestHeaderList for 'not exists'. (NotNull)
     */
    public void notExistsRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select WEB_CRAWLING_CONFIG_ID from WEB_AUTHENTICATION where ...)} <br />
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsWebAuthenticationList</span>(new SubQuery&lt;WebAuthenticationCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_WebAuthenticationList for 'not exists'. (NotNull)
     */
    public void notExistsWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsWebConfigToBrowserTypeMappingList</span>(new SubQuery&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_WebConfigToBrowserTypeMappingList for 'not exists'. (NotNull)
     */
    public void notExistsWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_LABEL_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsWebConfigToLabelTypeMappingList</span>(new SubQuery&lt;WebConfigToLabelTypeMappingCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_WebConfigToLabelTypeMappingList for 'not exists'. (NotNull)
     */
    public void notExistsWebConfigToLabelTypeMappingList(
            SubQuery<WebConfigToLabelTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToLabelTypeMappingCB>", subQuery);
        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_WebConfigToLabelTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery);

    /**
     * Set up NotExistsReferrer (co-related sub-query). <br />
     * {not exists (select WEB_CONFIG_ID from WEB_CONFIG_TO_ROLE_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * <pre>
     * cb.query().<span style="color: #FD4747">notExistsWebConfigToRoleTypeMappingList</span>(new SubQuery&lt;WebConfigToRoleTypeMappingCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param subQuery The sub-query of Id_NotExistsReferrer_WebConfigToRoleTypeMappingList for 'not exists'. (NotNull)
     */
    public void notExistsWebConfigToRoleTypeMappingList(
            SubQuery<WebConfigToRoleTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToRoleTypeMappingCB>", subQuery);
        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
        cb.xsetupForExistsReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotExistsReferrer_WebConfigToRoleTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotExistsReferrer(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotExistsReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select WEB_CONFIG_ID from FAILURE_URL where ...)} <br />
     * FAILURE_URL as 'failureUrlList'.
     * @param subQuery The sub-query of FailureUrlList for 'in-scope'. (NotNull)
     */
    public void inScopeFailureUrlList(SubQuery<FailureUrlCB> subQuery) {
        assertObjectNotNull("subQuery<FailureUrlCB>", subQuery);
        FailureUrlCB cb = new FailureUrlCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_FailureUrlList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_FailureUrlList(
            FailureUrlCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select WEB_CRAWLING_CONFIG_ID from REQUEST_HEADER where ...)} <br />
     * REQUEST_HEADER as 'requestHeaderList'.
     * @param subQuery The sub-query of RequestHeaderList for 'in-scope'. (NotNull)
     */
    public void inScopeRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_RequestHeaderList(
            RequestHeaderCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select WEB_CRAWLING_CONFIG_ID from WEB_AUTHENTICATION where ...)} <br />
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @param subQuery The sub-query of WebAuthenticationList for 'in-scope'. (NotNull)
     */
    public void inScopeWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select WEB_CONFIG_ID from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @param subQuery The sub-query of WebConfigToBrowserTypeMappingList for 'in-scope'. (NotNull)
     */
    public void inScopeWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select WEB_CONFIG_ID from WEB_CONFIG_TO_LABEL_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @param subQuery The sub-query of WebConfigToLabelTypeMappingList for 'in-scope'. (NotNull)
     */
    public void inScopeWebConfigToLabelTypeMappingList(
            SubQuery<WebConfigToLabelTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToLabelTypeMappingCB>", subQuery);
        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_WebConfigToLabelTypeMappingList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery);

    /**
     * Set up InScopeRelation (sub-query). <br />
     * {in (select WEB_CONFIG_ID from WEB_CONFIG_TO_ROLE_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @param subQuery The sub-query of WebConfigToRoleTypeMappingList for 'in-scope'. (NotNull)
     */
    public void inScopeWebConfigToRoleTypeMappingList(
            SubQuery<WebConfigToRoleTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToRoleTypeMappingCB>", subQuery);
        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_InScopeRelation_WebConfigToRoleTypeMappingList(cb
                .query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_InScopeRelation_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select WEB_CONFIG_ID from FAILURE_URL where ...)} <br />
     * FAILURE_URL as 'failureUrlList'.
     * @param subQuery The sub-query of FailureUrlList for 'not in-scope'. (NotNull)
     */
    public void notInScopeFailureUrlList(SubQuery<FailureUrlCB> subQuery) {
        assertObjectNotNull("subQuery<FailureUrlCB>", subQuery);
        FailureUrlCB cb = new FailureUrlCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_FailureUrlList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_FailureUrlList(
            FailureUrlCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select WEB_CRAWLING_CONFIG_ID from REQUEST_HEADER where ...)} <br />
     * REQUEST_HEADER as 'requestHeaderList'.
     * @param subQuery The sub-query of RequestHeaderList for 'not in-scope'. (NotNull)
     */
    public void notInScopeRequestHeaderList(SubQuery<RequestHeaderCB> subQuery) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_RequestHeaderList(
            RequestHeaderCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select WEB_CRAWLING_CONFIG_ID from WEB_AUTHENTICATION where ...)} <br />
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @param subQuery The sub-query of WebAuthenticationList for 'not in-scope'. (NotNull)
     */
    public void notInScopeWebAuthenticationList(
            SubQuery<WebAuthenticationCB> subQuery) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "WEB_CRAWLING_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select WEB_CONFIG_ID from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @param subQuery The sub-query of WebConfigToBrowserTypeMappingList for 'not in-scope'. (NotNull)
     */
    public void notInScopeWebConfigToBrowserTypeMappingList(
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select WEB_CONFIG_ID from WEB_CONFIG_TO_LABEL_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @param subQuery The sub-query of WebConfigToLabelTypeMappingList for 'not in-scope'. (NotNull)
     */
    public void notInScopeWebConfigToLabelTypeMappingList(
            SubQuery<WebConfigToLabelTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToLabelTypeMappingCB>", subQuery);
        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_WebConfigToLabelTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery);

    /**
     * Set up NotInScopeRelation (sub-query). <br />
     * {not in (select WEB_CONFIG_ID from WEB_CONFIG_TO_ROLE_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @param subQuery The sub-query of WebConfigToRoleTypeMappingList for 'not in-scope'. (NotNull)
     */
    public void notInScopeWebConfigToRoleTypeMappingList(
            SubQuery<WebConfigToRoleTypeMappingCB> subQuery) {
        assertObjectNotNull("subQuery<WebConfigToRoleTypeMappingCB>", subQuery);
        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_NotInScopeRelation_WebConfigToRoleTypeMappingList(cb
                .query()); // for saving query-value.
        registerNotInScopeRelation(cb.query(), "ID", "WEB_CONFIG_ID",
                subQueryPropertyName);
    }

    public abstract String keepId_NotInScopeRelation_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery);

    public void xsderiveFailureUrlList(String function,
            SubQuery<FailureUrlCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<FailureUrlCB>", subQuery);
        FailureUrlCB cb = new FailureUrlCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_FailureUrlList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_FailureUrlList(
            FailureUrlCQ subQuery);

    public void xsderiveRequestHeaderList(String function,
            SubQuery<RequestHeaderCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_RequestHeaderList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery);

    public void xsderiveWebAuthenticationList(String function,
            SubQuery<WebAuthenticationCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_WebAuthenticationList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    public void xsderiveWebConfigToBrowserTypeMappingList(String function,
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    public void xsderiveWebConfigToLabelTypeMappingList(String function,
            SubQuery<WebConfigToLabelTypeMappingCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<WebConfigToLabelTypeMappingCB>", subQuery);
        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery);

    public void xsderiveWebConfigToRoleTypeMappingList(String function,
            SubQuery<WebConfigToRoleTypeMappingCB> subQuery, String aliasName) {
        assertObjectNotNull("subQuery<WebConfigToRoleTypeMappingCB>", subQuery);
        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList(cb
                .query()); // for saving query-value.
        registerSpecifyDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, aliasName);
    }

    public abstract String keepId_SpecifyDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from FAILURE_URL where ...)} <br />
     * FAILURE_URL as 'failureUrlList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<FailureUrlCB> derivedFailureUrlList() {
        return xcreateQDRFunctionFailureUrlList();
    }

    protected HpQDRFunction<FailureUrlCB> xcreateQDRFunctionFailureUrlList() {
        return new HpQDRFunction<FailureUrlCB>(
                new HpQDRSetupper<FailureUrlCB>() {
                    public void setup(String function,
                            SubQuery<FailureUrlCB> subQuery, String operand,
                            Object value) {
                        xqderiveFailureUrlList(function, subQuery, operand,
                                value);
                    }
                });
    }

    public void xqderiveFailureUrlList(String function,
            SubQuery<FailureUrlCB> subQuery, String operand, Object value) {
        assertObjectNotNull("subQuery<FailureUrlCB>", subQuery);
        FailureUrlCB cb = new FailureUrlCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_FailureUrlList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_FailureUrlListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_FailureUrlList(
            FailureUrlCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_FailureUrlListParameter(
            Object parameterValue);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from REQUEST_HEADER where ...)} <br />
     * REQUEST_HEADER as 'requestHeaderList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<RequestHeaderCB> derivedRequestHeaderList() {
        return xcreateQDRFunctionRequestHeaderList();
    }

    protected HpQDRFunction<RequestHeaderCB> xcreateQDRFunctionRequestHeaderList() {
        return new HpQDRFunction<RequestHeaderCB>(
                new HpQDRSetupper<RequestHeaderCB>() {
                    public void setup(String function,
                            SubQuery<RequestHeaderCB> subQuery, String operand,
                            Object value) {
                        xqderiveRequestHeaderList(function, subQuery, operand,
                                value);
                    }
                });
    }

    public void xqderiveRequestHeaderList(String function,
            SubQuery<RequestHeaderCB> subQuery, String operand, Object value) {
        assertObjectNotNull("subQuery<RequestHeaderCB>", subQuery);
        RequestHeaderCB cb = new RequestHeaderCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_RequestHeaderList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_RequestHeaderListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_RequestHeaderList(
            RequestHeaderCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_RequestHeaderListParameter(
            Object parameterValue);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from WEB_AUTHENTICATION where ...)} <br />
     * WEB_AUTHENTICATION as 'webAuthenticationList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<WebAuthenticationCB> derivedWebAuthenticationList() {
        return xcreateQDRFunctionWebAuthenticationList();
    }

    protected HpQDRFunction<WebAuthenticationCB> xcreateQDRFunctionWebAuthenticationList() {
        return new HpQDRFunction<WebAuthenticationCB>(
                new HpQDRSetupper<WebAuthenticationCB>() {
                    public void setup(String function,
                            SubQuery<WebAuthenticationCB> subQuery,
                            String operand, Object value) {
                        xqderiveWebAuthenticationList(function, subQuery,
                                operand, value);
                    }
                });
    }

    public void xqderiveWebAuthenticationList(String function,
            SubQuery<WebAuthenticationCB> subQuery, String operand, Object value) {
        assertObjectNotNull("subQuery<WebAuthenticationCB>", subQuery);
        WebAuthenticationCB cb = new WebAuthenticationCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_WebAuthenticationList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_WebAuthenticationListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CRAWLING_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_WebAuthenticationList(
            WebAuthenticationCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_WebAuthenticationListParameter(
            Object parameterValue);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from WEB_CONFIG_TO_BROWSER_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_BROWSER_TYPE_MAPPING as 'webConfigToBrowserTypeMappingList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<WebConfigToBrowserTypeMappingCB> derivedWebConfigToBrowserTypeMappingList() {
        return xcreateQDRFunctionWebConfigToBrowserTypeMappingList();
    }

    protected HpQDRFunction<WebConfigToBrowserTypeMappingCB> xcreateQDRFunctionWebConfigToBrowserTypeMappingList() {
        return new HpQDRFunction<WebConfigToBrowserTypeMappingCB>(
                new HpQDRSetupper<WebConfigToBrowserTypeMappingCB>() {
                    public void setup(String function,
                            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery,
                            String operand, Object value) {
                        xqderiveWebConfigToBrowserTypeMappingList(function,
                                subQuery, operand, value);
                    }
                });
    }

    public void xqderiveWebConfigToBrowserTypeMappingList(String function,
            SubQuery<WebConfigToBrowserTypeMappingCB> subQuery, String operand,
            Object value) {
        assertObjectNotNull("subQuery<WebConfigToBrowserTypeMappingCB>",
                subQuery);
        WebConfigToBrowserTypeMappingCB cb = new WebConfigToBrowserTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingList(
            WebConfigToBrowserTypeMappingCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_WebConfigToBrowserTypeMappingListParameter(
            Object parameterValue);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from WEB_CONFIG_TO_LABEL_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_LABEL_TYPE_MAPPING as 'webConfigToLabelTypeMappingList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<WebConfigToLabelTypeMappingCB> derivedWebConfigToLabelTypeMappingList() {
        return xcreateQDRFunctionWebConfigToLabelTypeMappingList();
    }

    protected HpQDRFunction<WebConfigToLabelTypeMappingCB> xcreateQDRFunctionWebConfigToLabelTypeMappingList() {
        return new HpQDRFunction<WebConfigToLabelTypeMappingCB>(
                new HpQDRSetupper<WebConfigToLabelTypeMappingCB>() {
                    public void setup(String function,
                            SubQuery<WebConfigToLabelTypeMappingCB> subQuery,
                            String operand, Object value) {
                        xqderiveWebConfigToLabelTypeMappingList(function,
                                subQuery, operand, value);
                    }
                });
    }

    public void xqderiveWebConfigToLabelTypeMappingList(String function,
            SubQuery<WebConfigToLabelTypeMappingCB> subQuery, String operand,
            Object value) {
        assertObjectNotNull("subQuery<WebConfigToLabelTypeMappingCB>", subQuery);
        WebConfigToLabelTypeMappingCB cb = new WebConfigToLabelTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingList(
            WebConfigToLabelTypeMappingCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_WebConfigToLabelTypeMappingListParameter(
            Object parameterValue);

    /**
     * Prepare for (Query)DerivedReferrer. <br />
     * {FOO &lt;= (select max(BAR) from WEB_CONFIG_TO_ROLE_TYPE_MAPPING where ...)} <br />
     * WEB_CONFIG_TO_ROLE_TYPE_MAPPING as 'webConfigToRoleTypeMappingList'.
     * @return The object to set up a function for referrer table. (NotNull)
     */
    public HpQDRFunction<WebConfigToRoleTypeMappingCB> derivedWebConfigToRoleTypeMappingList() {
        return xcreateQDRFunctionWebConfigToRoleTypeMappingList();
    }

    protected HpQDRFunction<WebConfigToRoleTypeMappingCB> xcreateQDRFunctionWebConfigToRoleTypeMappingList() {
        return new HpQDRFunction<WebConfigToRoleTypeMappingCB>(
                new HpQDRSetupper<WebConfigToRoleTypeMappingCB>() {
                    public void setup(String function,
                            SubQuery<WebConfigToRoleTypeMappingCB> subQuery,
                            String operand, Object value) {
                        xqderiveWebConfigToRoleTypeMappingList(function,
                                subQuery, operand, value);
                    }
                });
    }

    public void xqderiveWebConfigToRoleTypeMappingList(String function,
            SubQuery<WebConfigToRoleTypeMappingCB> subQuery, String operand,
            Object value) {
        assertObjectNotNull("subQuery<WebConfigToRoleTypeMappingCB>", subQuery);
        WebConfigToRoleTypeMappingCB cb = new WebConfigToRoleTypeMappingCB();
        cb.xsetupForDerivedReferrer();
        subQuery.query(cb);
        String subQueryPropertyName = keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList(cb
                .query()); // for saving query-value.
        String parameterPropertyName = keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter(value);
        registerQueryDerivedReferrer(function, cb.query(), "ID",
                "WEB_CONFIG_ID", subQueryPropertyName, operand, value,
                parameterPropertyName);
    }

    public abstract String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingList(
            WebConfigToRoleTypeMappingCQ subQuery);

    public abstract String keepId_QueryDerivedReferrer_WebConfigToRoleTypeMappingListParameter(
            Object parameterValue);

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setId_IsNull() {
        regId(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setId_IsNotNull() {
        regId(CK_ISNN, DOBJ);
    }

    protected void regId(ConditionKey k, Object v) {
        regQ(k, v, getCValueId(), "ID");
    }

    abstract protected ConditionValue getCValueId();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * NAME: {NotNull, VARCHAR(200)}
     * @param name The value of name as equal.
     */
    public void setName_Equal(String name) {
        doSetName_Equal(fRES(name));
    }

    protected void doSetName_Equal(String name) {
        regName(CK_EQ, name);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as notEqual.
     */
    public void setName_NotEqual(String name) {
        doSetName_NotEqual(fRES(name));
    }

    protected void doSetName_NotEqual(String name) {
        regName(CK_NES, name);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as greaterThan.
     */
    public void setName_GreaterThan(String name) {
        regName(CK_GT, fRES(name));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as lessThan.
     */
    public void setName_LessThan(String name) {
        regName(CK_LT, fRES(name));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as greaterEqual.
     */
    public void setName_GreaterEqual(String name) {
        regName(CK_GE, fRES(name));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param name The value of name as lessEqual.
     */
    public void setName_LessEqual(String name) {
        regName(CK_LE, fRES(name));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param nameList The collection of name as inScope.
     */
    public void setName_InScope(Collection<String> nameList) {
        doSetName_InScope(nameList);
    }

    public void doSetName_InScope(Collection<String> nameList) {
        regINS(CK_INS, cTL(nameList), getCValueName(), "NAME");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param nameList The collection of name as notInScope.
     */
    public void setName_NotInScope(Collection<String> nameList) {
        doSetName_NotInScope(nameList);
    }

    public void doSetName_NotInScope(Collection<String> nameList) {
        regINS(CK_NINS, cTL(nameList), getCValueName(), "NAME");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param name The value of name as prefixSearch.
     */
    public void setName_PrefixSearch(String name) {
        setName_LikeSearch(name, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param name The value of name as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setName_LikeSearch(String name,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(name), getCValueName(), "NAME", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param name The value of name as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setName_NotLikeSearch(String name,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(name), getCValueName(), "NAME", likeSearchOption);
    }

    protected void regName(ConditionKey k, Object v) {
        regQ(k, v, getCValueName(), "NAME");
    }

    abstract protected ConditionValue getCValueName();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * URLS: {NotNull, VARCHAR(4000)}
     * @param urls The value of urls as equal.
     */
    public void setUrls_Equal(String urls) {
        doSetUrls_Equal(fRES(urls));
    }

    protected void doSetUrls_Equal(String urls) {
        regUrls(CK_EQ, urls);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as notEqual.
     */
    public void setUrls_NotEqual(String urls) {
        doSetUrls_NotEqual(fRES(urls));
    }

    protected void doSetUrls_NotEqual(String urls) {
        regUrls(CK_NES, urls);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as greaterThan.
     */
    public void setUrls_GreaterThan(String urls) {
        regUrls(CK_GT, fRES(urls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as lessThan.
     */
    public void setUrls_LessThan(String urls) {
        regUrls(CK_LT, fRES(urls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as greaterEqual.
     */
    public void setUrls_GreaterEqual(String urls) {
        regUrls(CK_GE, fRES(urls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param urls The value of urls as lessEqual.
     */
    public void setUrls_LessEqual(String urls) {
        regUrls(CK_LE, fRES(urls));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param urlsList The collection of urls as inScope.
     */
    public void setUrls_InScope(Collection<String> urlsList) {
        doSetUrls_InScope(urlsList);
    }

    public void doSetUrls_InScope(Collection<String> urlsList) {
        regINS(CK_INS, cTL(urlsList), getCValueUrls(), "URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param urlsList The collection of urls as notInScope.
     */
    public void setUrls_NotInScope(Collection<String> urlsList) {
        doSetUrls_NotInScope(urlsList);
    }

    public void doSetUrls_NotInScope(Collection<String> urlsList) {
        regINS(CK_NINS, cTL(urlsList), getCValueUrls(), "URLS");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param urls The value of urls as prefixSearch.
     */
    public void setUrls_PrefixSearch(String urls) {
        setUrls_LikeSearch(urls, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param urls The value of urls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUrls_LikeSearch(String urls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(urls), getCValueUrls(), "URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param urls The value of urls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUrls_NotLikeSearch(String urls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(urls), getCValueUrls(), "URLS", likeSearchOption);
    }

    protected void regUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueUrls(), "URLS");
    }

    abstract protected ConditionValue getCValueUrls();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * INCLUDED_URLS: {VARCHAR(4000)}
     * @param includedUrls The value of includedUrls as equal.
     */
    public void setIncludedUrls_Equal(String includedUrls) {
        doSetIncludedUrls_Equal(fRES(includedUrls));
    }

    protected void doSetIncludedUrls_Equal(String includedUrls) {
        regIncludedUrls(CK_EQ, includedUrls);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as notEqual.
     */
    public void setIncludedUrls_NotEqual(String includedUrls) {
        doSetIncludedUrls_NotEqual(fRES(includedUrls));
    }

    protected void doSetIncludedUrls_NotEqual(String includedUrls) {
        regIncludedUrls(CK_NES, includedUrls);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as greaterThan.
     */
    public void setIncludedUrls_GreaterThan(String includedUrls) {
        regIncludedUrls(CK_GT, fRES(includedUrls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as lessThan.
     */
    public void setIncludedUrls_LessThan(String includedUrls) {
        regIncludedUrls(CK_LT, fRES(includedUrls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as greaterEqual.
     */
    public void setIncludedUrls_GreaterEqual(String includedUrls) {
        regIncludedUrls(CK_GE, fRES(includedUrls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedUrls The value of includedUrls as lessEqual.
     */
    public void setIncludedUrls_LessEqual(String includedUrls) {
        regIncludedUrls(CK_LE, fRES(includedUrls));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param includedUrlsList The collection of includedUrls as inScope.
     */
    public void setIncludedUrls_InScope(Collection<String> includedUrlsList) {
        doSetIncludedUrls_InScope(includedUrlsList);
    }

    public void doSetIncludedUrls_InScope(Collection<String> includedUrlsList) {
        regINS(CK_INS, cTL(includedUrlsList), getCValueIncludedUrls(),
                "INCLUDED_URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param includedUrlsList The collection of includedUrls as notInScope.
     */
    public void setIncludedUrls_NotInScope(Collection<String> includedUrlsList) {
        doSetIncludedUrls_NotInScope(includedUrlsList);
    }

    public void doSetIncludedUrls_NotInScope(Collection<String> includedUrlsList) {
        regINS(CK_NINS, cTL(includedUrlsList), getCValueIncludedUrls(),
                "INCLUDED_URLS");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedUrls The value of includedUrls as prefixSearch.
     */
    public void setIncludedUrls_PrefixSearch(String includedUrls) {
        setIncludedUrls_LikeSearch(includedUrls, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedUrls The value of includedUrls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setIncludedUrls_LikeSearch(String includedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(includedUrls), getCValueIncludedUrls(),
                "INCLUDED_URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedUrls The value of includedUrls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setIncludedUrls_NotLikeSearch(String includedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(includedUrls), getCValueIncludedUrls(),
                "INCLUDED_URLS", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setIncludedUrls_IsNull() {
        regIncludedUrls(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setIncludedUrls_IsNotNull() {
        regIncludedUrls(CK_ISNN, DOBJ);
    }

    protected void regIncludedUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueIncludedUrls(), "INCLUDED_URLS");
    }

    abstract protected ConditionValue getCValueIncludedUrls();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * EXCLUDED_URLS: {VARCHAR(4000)}
     * @param excludedUrls The value of excludedUrls as equal.
     */
    public void setExcludedUrls_Equal(String excludedUrls) {
        doSetExcludedUrls_Equal(fRES(excludedUrls));
    }

    protected void doSetExcludedUrls_Equal(String excludedUrls) {
        regExcludedUrls(CK_EQ, excludedUrls);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as notEqual.
     */
    public void setExcludedUrls_NotEqual(String excludedUrls) {
        doSetExcludedUrls_NotEqual(fRES(excludedUrls));
    }

    protected void doSetExcludedUrls_NotEqual(String excludedUrls) {
        regExcludedUrls(CK_NES, excludedUrls);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as greaterThan.
     */
    public void setExcludedUrls_GreaterThan(String excludedUrls) {
        regExcludedUrls(CK_GT, fRES(excludedUrls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as lessThan.
     */
    public void setExcludedUrls_LessThan(String excludedUrls) {
        regExcludedUrls(CK_LT, fRES(excludedUrls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as greaterEqual.
     */
    public void setExcludedUrls_GreaterEqual(String excludedUrls) {
        regExcludedUrls(CK_GE, fRES(excludedUrls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedUrls The value of excludedUrls as lessEqual.
     */
    public void setExcludedUrls_LessEqual(String excludedUrls) {
        regExcludedUrls(CK_LE, fRES(excludedUrls));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param excludedUrlsList The collection of excludedUrls as inScope.
     */
    public void setExcludedUrls_InScope(Collection<String> excludedUrlsList) {
        doSetExcludedUrls_InScope(excludedUrlsList);
    }

    public void doSetExcludedUrls_InScope(Collection<String> excludedUrlsList) {
        regINS(CK_INS, cTL(excludedUrlsList), getCValueExcludedUrls(),
                "EXCLUDED_URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param excludedUrlsList The collection of excludedUrls as notInScope.
     */
    public void setExcludedUrls_NotInScope(Collection<String> excludedUrlsList) {
        doSetExcludedUrls_NotInScope(excludedUrlsList);
    }

    public void doSetExcludedUrls_NotInScope(Collection<String> excludedUrlsList) {
        regINS(CK_NINS, cTL(excludedUrlsList), getCValueExcludedUrls(),
                "EXCLUDED_URLS");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedUrls The value of excludedUrls as prefixSearch.
     */
    public void setExcludedUrls_PrefixSearch(String excludedUrls) {
        setExcludedUrls_LikeSearch(excludedUrls, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedUrls The value of excludedUrls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setExcludedUrls_LikeSearch(String excludedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(excludedUrls), getCValueExcludedUrls(),
                "EXCLUDED_URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedUrls The value of excludedUrls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setExcludedUrls_NotLikeSearch(String excludedUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(excludedUrls), getCValueExcludedUrls(),
                "EXCLUDED_URLS", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setExcludedUrls_IsNull() {
        regExcludedUrls(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setExcludedUrls_IsNotNull() {
        regExcludedUrls(CK_ISNN, DOBJ);
    }

    protected void regExcludedUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueExcludedUrls(), "EXCLUDED_URLS");
    }

    abstract protected ConditionValue getCValueExcludedUrls();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * INCLUDED_DOC_URLS: {VARCHAR(4000)}
     * @param includedDocUrls The value of includedDocUrls as equal.
     */
    public void setIncludedDocUrls_Equal(String includedDocUrls) {
        doSetIncludedDocUrls_Equal(fRES(includedDocUrls));
    }

    protected void doSetIncludedDocUrls_Equal(String includedDocUrls) {
        regIncludedDocUrls(CK_EQ, includedDocUrls);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedDocUrls The value of includedDocUrls as notEqual.
     */
    public void setIncludedDocUrls_NotEqual(String includedDocUrls) {
        doSetIncludedDocUrls_NotEqual(fRES(includedDocUrls));
    }

    protected void doSetIncludedDocUrls_NotEqual(String includedDocUrls) {
        regIncludedDocUrls(CK_NES, includedDocUrls);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedDocUrls The value of includedDocUrls as greaterThan.
     */
    public void setIncludedDocUrls_GreaterThan(String includedDocUrls) {
        regIncludedDocUrls(CK_GT, fRES(includedDocUrls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedDocUrls The value of includedDocUrls as lessThan.
     */
    public void setIncludedDocUrls_LessThan(String includedDocUrls) {
        regIncludedDocUrls(CK_LT, fRES(includedDocUrls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedDocUrls The value of includedDocUrls as greaterEqual.
     */
    public void setIncludedDocUrls_GreaterEqual(String includedDocUrls) {
        regIncludedDocUrls(CK_GE, fRES(includedDocUrls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param includedDocUrls The value of includedDocUrls as lessEqual.
     */
    public void setIncludedDocUrls_LessEqual(String includedDocUrls) {
        regIncludedDocUrls(CK_LE, fRES(includedDocUrls));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param includedDocUrlsList The collection of includedDocUrls as inScope.
     */
    public void setIncludedDocUrls_InScope(
            Collection<String> includedDocUrlsList) {
        doSetIncludedDocUrls_InScope(includedDocUrlsList);
    }

    public void doSetIncludedDocUrls_InScope(
            Collection<String> includedDocUrlsList) {
        regINS(CK_INS, cTL(includedDocUrlsList), getCValueIncludedDocUrls(),
                "INCLUDED_DOC_URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param includedDocUrlsList The collection of includedDocUrls as notInScope.
     */
    public void setIncludedDocUrls_NotInScope(
            Collection<String> includedDocUrlsList) {
        doSetIncludedDocUrls_NotInScope(includedDocUrlsList);
    }

    public void doSetIncludedDocUrls_NotInScope(
            Collection<String> includedDocUrlsList) {
        regINS(CK_NINS, cTL(includedDocUrlsList), getCValueIncludedDocUrls(),
                "INCLUDED_DOC_URLS");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedDocUrls The value of includedDocUrls as prefixSearch.
     */
    public void setIncludedDocUrls_PrefixSearch(String includedDocUrls) {
        setIncludedDocUrls_LikeSearch(includedDocUrls, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedDocUrls The value of includedDocUrls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setIncludedDocUrls_LikeSearch(String includedDocUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(includedDocUrls), getCValueIncludedDocUrls(),
                "INCLUDED_DOC_URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param includedDocUrls The value of includedDocUrls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setIncludedDocUrls_NotLikeSearch(String includedDocUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(includedDocUrls), getCValueIncludedDocUrls(),
                "INCLUDED_DOC_URLS", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setIncludedDocUrls_IsNull() {
        regIncludedDocUrls(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setIncludedDocUrls_IsNotNull() {
        regIncludedDocUrls(CK_ISNN, DOBJ);
    }

    protected void regIncludedDocUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueIncludedDocUrls(), "INCLUDED_DOC_URLS");
    }

    abstract protected ConditionValue getCValueIncludedDocUrls();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * EXCLUDED_DOC_URLS: {VARCHAR(4000)}
     * @param excludedDocUrls The value of excludedDocUrls as equal.
     */
    public void setExcludedDocUrls_Equal(String excludedDocUrls) {
        doSetExcludedDocUrls_Equal(fRES(excludedDocUrls));
    }

    protected void doSetExcludedDocUrls_Equal(String excludedDocUrls) {
        regExcludedDocUrls(CK_EQ, excludedDocUrls);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as notEqual.
     */
    public void setExcludedDocUrls_NotEqual(String excludedDocUrls) {
        doSetExcludedDocUrls_NotEqual(fRES(excludedDocUrls));
    }

    protected void doSetExcludedDocUrls_NotEqual(String excludedDocUrls) {
        regExcludedDocUrls(CK_NES, excludedDocUrls);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as greaterThan.
     */
    public void setExcludedDocUrls_GreaterThan(String excludedDocUrls) {
        regExcludedDocUrls(CK_GT, fRES(excludedDocUrls));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as lessThan.
     */
    public void setExcludedDocUrls_LessThan(String excludedDocUrls) {
        regExcludedDocUrls(CK_LT, fRES(excludedDocUrls));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as greaterEqual.
     */
    public void setExcludedDocUrls_GreaterEqual(String excludedDocUrls) {
        regExcludedDocUrls(CK_GE, fRES(excludedDocUrls));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as lessEqual.
     */
    public void setExcludedDocUrls_LessEqual(String excludedDocUrls) {
        regExcludedDocUrls(CK_LE, fRES(excludedDocUrls));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param excludedDocUrlsList The collection of excludedDocUrls as inScope.
     */
    public void setExcludedDocUrls_InScope(
            Collection<String> excludedDocUrlsList) {
        doSetExcludedDocUrls_InScope(excludedDocUrlsList);
    }

    public void doSetExcludedDocUrls_InScope(
            Collection<String> excludedDocUrlsList) {
        regINS(CK_INS, cTL(excludedDocUrlsList), getCValueExcludedDocUrls(),
                "EXCLUDED_DOC_URLS");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param excludedDocUrlsList The collection of excludedDocUrls as notInScope.
     */
    public void setExcludedDocUrls_NotInScope(
            Collection<String> excludedDocUrlsList) {
        doSetExcludedDocUrls_NotInScope(excludedDocUrlsList);
    }

    public void doSetExcludedDocUrls_NotInScope(
            Collection<String> excludedDocUrlsList) {
        regINS(CK_NINS, cTL(excludedDocUrlsList), getCValueExcludedDocUrls(),
                "EXCLUDED_DOC_URLS");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as prefixSearch.
     */
    public void setExcludedDocUrls_PrefixSearch(String excludedDocUrls) {
        setExcludedDocUrls_LikeSearch(excludedDocUrls, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setExcludedDocUrls_LikeSearch(String excludedDocUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(excludedDocUrls), getCValueExcludedDocUrls(),
                "EXCLUDED_DOC_URLS", likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param excludedDocUrls The value of excludedDocUrls as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setExcludedDocUrls_NotLikeSearch(String excludedDocUrls,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(excludedDocUrls), getCValueExcludedDocUrls(),
                "EXCLUDED_DOC_URLS", likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setExcludedDocUrls_IsNull() {
        regExcludedDocUrls(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setExcludedDocUrls_IsNotNull() {
        regExcludedDocUrls(CK_ISNN, DOBJ);
    }

    protected void regExcludedDocUrls(ConditionKey k, Object v) {
        regQ(k, v, getCValueExcludedDocUrls(), "EXCLUDED_DOC_URLS");
    }

    abstract protected ConditionValue getCValueExcludedDocUrls();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * DEPTH: {INTEGER(10)}
     * @param depth The value of depth as equal.
     */
    public void setDepth_Equal(Integer depth) {
        doSetDepth_Equal(depth);
    }

    protected void doSetDepth_Equal(Integer depth) {
        regDepth(CK_EQ, depth);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as notEqual.
     */
    public void setDepth_NotEqual(Integer depth) {
        doSetDepth_NotEqual(depth);
    }

    protected void doSetDepth_NotEqual(Integer depth) {
        regDepth(CK_NES, depth);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as greaterThan.
     */
    public void setDepth_GreaterThan(Integer depth) {
        regDepth(CK_GT, depth);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as lessThan.
     */
    public void setDepth_LessThan(Integer depth) {
        regDepth(CK_LT, depth);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as greaterEqual.
     */
    public void setDepth_GreaterEqual(Integer depth) {
        regDepth(CK_GE, depth);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param depth The value of depth as lessEqual.
     */
    public void setDepth_LessEqual(Integer depth) {
        regDepth(CK_LE, depth);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param depthList The collection of depth as inScope.
     */
    public void setDepth_InScope(Collection<Integer> depthList) {
        doSetDepth_InScope(depthList);
    }

    protected void doSetDepth_InScope(Collection<Integer> depthList) {
        regINS(CK_INS, cTL(depthList), getCValueDepth(), "DEPTH");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param depthList The collection of depth as notInScope.
     */
    public void setDepth_NotInScope(Collection<Integer> depthList) {
        doSetDepth_NotInScope(depthList);
    }

    protected void doSetDepth_NotInScope(Collection<Integer> depthList) {
        regINS(CK_NINS, cTL(depthList), getCValueDepth(), "DEPTH");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDepth_IsNull() {
        regDepth(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDepth_IsNotNull() {
        regDepth(CK_ISNN, DOBJ);
    }

    protected void regDepth(ConditionKey k, Object v) {
        regQ(k, v, getCValueDepth(), "DEPTH");
    }

    abstract protected ConditionValue getCValueDepth();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * MAX_ACCESS_COUNT: {BIGINT(19)}
     * @param maxAccessCount The value of maxAccessCount as equal.
     */
    public void setMaxAccessCount_Equal(Long maxAccessCount) {
        doSetMaxAccessCount_Equal(maxAccessCount);
    }

    protected void doSetMaxAccessCount_Equal(Long maxAccessCount) {
        regMaxAccessCount(CK_EQ, maxAccessCount);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as notEqual.
     */
    public void setMaxAccessCount_NotEqual(Long maxAccessCount) {
        doSetMaxAccessCount_NotEqual(maxAccessCount);
    }

    protected void doSetMaxAccessCount_NotEqual(Long maxAccessCount) {
        regMaxAccessCount(CK_NES, maxAccessCount);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as greaterThan.
     */
    public void setMaxAccessCount_GreaterThan(Long maxAccessCount) {
        regMaxAccessCount(CK_GT, maxAccessCount);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as lessThan.
     */
    public void setMaxAccessCount_LessThan(Long maxAccessCount) {
        regMaxAccessCount(CK_LT, maxAccessCount);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as greaterEqual.
     */
    public void setMaxAccessCount_GreaterEqual(Long maxAccessCount) {
        regMaxAccessCount(CK_GE, maxAccessCount);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param maxAccessCount The value of maxAccessCount as lessEqual.
     */
    public void setMaxAccessCount_LessEqual(Long maxAccessCount) {
        regMaxAccessCount(CK_LE, maxAccessCount);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param maxAccessCountList The collection of maxAccessCount as inScope.
     */
    public void setMaxAccessCount_InScope(Collection<Long> maxAccessCountList) {
        doSetMaxAccessCount_InScope(maxAccessCountList);
    }

    protected void doSetMaxAccessCount_InScope(
            Collection<Long> maxAccessCountList) {
        regINS(CK_INS, cTL(maxAccessCountList), getCValueMaxAccessCount(),
                "MAX_ACCESS_COUNT");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param maxAccessCountList The collection of maxAccessCount as notInScope.
     */
    public void setMaxAccessCount_NotInScope(Collection<Long> maxAccessCountList) {
        doSetMaxAccessCount_NotInScope(maxAccessCountList);
    }

    protected void doSetMaxAccessCount_NotInScope(
            Collection<Long> maxAccessCountList) {
        regINS(CK_NINS, cTL(maxAccessCountList), getCValueMaxAccessCount(),
                "MAX_ACCESS_COUNT");
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setMaxAccessCount_IsNull() {
        regMaxAccessCount(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setMaxAccessCount_IsNotNull() {
        regMaxAccessCount(CK_ISNN, DOBJ);
    }

    protected void regMaxAccessCount(ConditionKey k, Object v) {
        regQ(k, v, getCValueMaxAccessCount(), "MAX_ACCESS_COUNT");
    }

    abstract protected ConditionValue getCValueMaxAccessCount();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * USER_AGENT: {NotNull, VARCHAR(200)}
     * @param userAgent The value of userAgent as equal.
     */
    public void setUserAgent_Equal(String userAgent) {
        doSetUserAgent_Equal(fRES(userAgent));
    }

    protected void doSetUserAgent_Equal(String userAgent) {
        regUserAgent(CK_EQ, userAgent);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as notEqual.
     */
    public void setUserAgent_NotEqual(String userAgent) {
        doSetUserAgent_NotEqual(fRES(userAgent));
    }

    protected void doSetUserAgent_NotEqual(String userAgent) {
        regUserAgent(CK_NES, userAgent);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as greaterThan.
     */
    public void setUserAgent_GreaterThan(String userAgent) {
        regUserAgent(CK_GT, fRES(userAgent));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as lessThan.
     */
    public void setUserAgent_LessThan(String userAgent) {
        regUserAgent(CK_LT, fRES(userAgent));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as greaterEqual.
     */
    public void setUserAgent_GreaterEqual(String userAgent) {
        regUserAgent(CK_GE, fRES(userAgent));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param userAgent The value of userAgent as lessEqual.
     */
    public void setUserAgent_LessEqual(String userAgent) {
        regUserAgent(CK_LE, fRES(userAgent));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userAgentList The collection of userAgent as inScope.
     */
    public void setUserAgent_InScope(Collection<String> userAgentList) {
        doSetUserAgent_InScope(userAgentList);
    }

    public void doSetUserAgent_InScope(Collection<String> userAgentList) {
        regINS(CK_INS, cTL(userAgentList), getCValueUserAgent(), "USER_AGENT");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param userAgentList The collection of userAgent as notInScope.
     */
    public void setUserAgent_NotInScope(Collection<String> userAgentList) {
        doSetUserAgent_NotInScope(userAgentList);
    }

    public void doSetUserAgent_NotInScope(Collection<String> userAgentList) {
        regINS(CK_NINS, cTL(userAgentList), getCValueUserAgent(), "USER_AGENT");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as prefixSearch.
     */
    public void setUserAgent_PrefixSearch(String userAgent) {
        setUserAgent_LikeSearch(userAgent, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUserAgent_LikeSearch(String userAgent,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(userAgent), getCValueUserAgent(), "USER_AGENT",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param userAgent The value of userAgent as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUserAgent_NotLikeSearch(String userAgent,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(userAgent), getCValueUserAgent(), "USER_AGENT",
                likeSearchOption);
    }

    protected void regUserAgent(ConditionKey k, Object v) {
        regQ(k, v, getCValueUserAgent(), "USER_AGENT");
    }

    abstract protected ConditionValue getCValueUserAgent();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * NUM_OF_THREAD: {NotNull, INTEGER(10)}
     * @param numOfThread The value of numOfThread as equal.
     */
    public void setNumOfThread_Equal(Integer numOfThread) {
        doSetNumOfThread_Equal(numOfThread);
    }

    protected void doSetNumOfThread_Equal(Integer numOfThread) {
        regNumOfThread(CK_EQ, numOfThread);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as notEqual.
     */
    public void setNumOfThread_NotEqual(Integer numOfThread) {
        doSetNumOfThread_NotEqual(numOfThread);
    }

    protected void doSetNumOfThread_NotEqual(Integer numOfThread) {
        regNumOfThread(CK_NES, numOfThread);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as greaterThan.
     */
    public void setNumOfThread_GreaterThan(Integer numOfThread) {
        regNumOfThread(CK_GT, numOfThread);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as lessThan.
     */
    public void setNumOfThread_LessThan(Integer numOfThread) {
        regNumOfThread(CK_LT, numOfThread);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as greaterEqual.
     */
    public void setNumOfThread_GreaterEqual(Integer numOfThread) {
        regNumOfThread(CK_GE, numOfThread);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param numOfThread The value of numOfThread as lessEqual.
     */
    public void setNumOfThread_LessEqual(Integer numOfThread) {
        regNumOfThread(CK_LE, numOfThread);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param numOfThreadList The collection of numOfThread as inScope.
     */
    public void setNumOfThread_InScope(Collection<Integer> numOfThreadList) {
        doSetNumOfThread_InScope(numOfThreadList);
    }

    protected void doSetNumOfThread_InScope(Collection<Integer> numOfThreadList) {
        regINS(CK_INS, cTL(numOfThreadList), getCValueNumOfThread(),
                "NUM_OF_THREAD");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param numOfThreadList The collection of numOfThread as notInScope.
     */
    public void setNumOfThread_NotInScope(Collection<Integer> numOfThreadList) {
        doSetNumOfThread_NotInScope(numOfThreadList);
    }

    protected void doSetNumOfThread_NotInScope(
            Collection<Integer> numOfThreadList) {
        regINS(CK_NINS, cTL(numOfThreadList), getCValueNumOfThread(),
                "NUM_OF_THREAD");
    }

    protected void regNumOfThread(ConditionKey k, Object v) {
        regQ(k, v, getCValueNumOfThread(), "NUM_OF_THREAD");
    }

    abstract protected ConditionValue getCValueNumOfThread();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * INTERVAL_TIME: {NotNull, INTEGER(10)}
     * @param intervalTime The value of intervalTime as equal.
     */
    public void setIntervalTime_Equal(Integer intervalTime) {
        doSetIntervalTime_Equal(intervalTime);
    }

    protected void doSetIntervalTime_Equal(Integer intervalTime) {
        regIntervalTime(CK_EQ, intervalTime);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as notEqual.
     */
    public void setIntervalTime_NotEqual(Integer intervalTime) {
        doSetIntervalTime_NotEqual(intervalTime);
    }

    protected void doSetIntervalTime_NotEqual(Integer intervalTime) {
        regIntervalTime(CK_NES, intervalTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as greaterThan.
     */
    public void setIntervalTime_GreaterThan(Integer intervalTime) {
        regIntervalTime(CK_GT, intervalTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as lessThan.
     */
    public void setIntervalTime_LessThan(Integer intervalTime) {
        regIntervalTime(CK_LT, intervalTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as greaterEqual.
     */
    public void setIntervalTime_GreaterEqual(Integer intervalTime) {
        regIntervalTime(CK_GE, intervalTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param intervalTime The value of intervalTime as lessEqual.
     */
    public void setIntervalTime_LessEqual(Integer intervalTime) {
        regIntervalTime(CK_LE, intervalTime);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param intervalTimeList The collection of intervalTime as inScope.
     */
    public void setIntervalTime_InScope(Collection<Integer> intervalTimeList) {
        doSetIntervalTime_InScope(intervalTimeList);
    }

    protected void doSetIntervalTime_InScope(
            Collection<Integer> intervalTimeList) {
        regINS(CK_INS, cTL(intervalTimeList), getCValueIntervalTime(),
                "INTERVAL_TIME");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param intervalTimeList The collection of intervalTime as notInScope.
     */
    public void setIntervalTime_NotInScope(Collection<Integer> intervalTimeList) {
        doSetIntervalTime_NotInScope(intervalTimeList);
    }

    protected void doSetIntervalTime_NotInScope(
            Collection<Integer> intervalTimeList) {
        regINS(CK_NINS, cTL(intervalTimeList), getCValueIntervalTime(),
                "INTERVAL_TIME");
    }

    protected void regIntervalTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueIntervalTime(), "INTERVAL_TIME");
    }

    abstract protected ConditionValue getCValueIntervalTime();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * BOOST: {NotNull, DOUBLE(17)}
     * @param boost The value of boost as equal.
     */
    public void setBoost_Equal(java.math.BigDecimal boost) {
        doSetBoost_Equal(boost);
    }

    protected void doSetBoost_Equal(java.math.BigDecimal boost) {
        regBoost(CK_EQ, boost);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param boost The value of boost as notEqual.
     */
    public void setBoost_NotEqual(java.math.BigDecimal boost) {
        doSetBoost_NotEqual(boost);
    }

    protected void doSetBoost_NotEqual(java.math.BigDecimal boost) {
        regBoost(CK_NES, boost);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param boost The value of boost as greaterThan.
     */
    public void setBoost_GreaterThan(java.math.BigDecimal boost) {
        regBoost(CK_GT, boost);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param boost The value of boost as lessThan.
     */
    public void setBoost_LessThan(java.math.BigDecimal boost) {
        regBoost(CK_LT, boost);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param boost The value of boost as greaterEqual.
     */
    public void setBoost_GreaterEqual(java.math.BigDecimal boost) {
        regBoost(CK_GE, boost);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param boost The value of boost as lessEqual.
     */
    public void setBoost_LessEqual(java.math.BigDecimal boost) {
        regBoost(CK_LE, boost);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param boostList The collection of boost as inScope.
     */
    public void setBoost_InScope(Collection<java.math.BigDecimal> boostList) {
        doSetBoost_InScope(boostList);
    }

    protected void doSetBoost_InScope(Collection<java.math.BigDecimal> boostList) {
        regINS(CK_INS, cTL(boostList), getCValueBoost(), "BOOST");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param boostList The collection of boost as notInScope.
     */
    public void setBoost_NotInScope(Collection<java.math.BigDecimal> boostList) {
        doSetBoost_NotInScope(boostList);
    }

    protected void doSetBoost_NotInScope(
            Collection<java.math.BigDecimal> boostList) {
        regINS(CK_NINS, cTL(boostList), getCValueBoost(), "BOOST");
    }

    protected void regBoost(ConditionKey k, Object v) {
        regQ(k, v, getCValueBoost(), "BOOST");
    }

    abstract protected ConditionValue getCValueBoost();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * AVAILABLE: {NotNull, VARCHAR(1)}
     * @param available The value of available as equal.
     */
    public void setAvailable_Equal(String available) {
        doSetAvailable_Equal(fRES(available));
    }

    protected void doSetAvailable_Equal(String available) {
        regAvailable(CK_EQ, available);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as notEqual.
     */
    public void setAvailable_NotEqual(String available) {
        doSetAvailable_NotEqual(fRES(available));
    }

    protected void doSetAvailable_NotEqual(String available) {
        regAvailable(CK_NES, available);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as greaterThan.
     */
    public void setAvailable_GreaterThan(String available) {
        regAvailable(CK_GT, fRES(available));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as lessThan.
     */
    public void setAvailable_LessThan(String available) {
        regAvailable(CK_LT, fRES(available));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as greaterEqual.
     */
    public void setAvailable_GreaterEqual(String available) {
        regAvailable(CK_GE, fRES(available));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param available The value of available as lessEqual.
     */
    public void setAvailable_LessEqual(String available) {
        regAvailable(CK_LE, fRES(available));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param availableList The collection of available as inScope.
     */
    public void setAvailable_InScope(Collection<String> availableList) {
        doSetAvailable_InScope(availableList);
    }

    public void doSetAvailable_InScope(Collection<String> availableList) {
        regINS(CK_INS, cTL(availableList), getCValueAvailable(), "AVAILABLE");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param availableList The collection of available as notInScope.
     */
    public void setAvailable_NotInScope(Collection<String> availableList) {
        doSetAvailable_NotInScope(availableList);
    }

    public void doSetAvailable_NotInScope(Collection<String> availableList) {
        regINS(CK_NINS, cTL(availableList), getCValueAvailable(), "AVAILABLE");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param available The value of available as prefixSearch.
     */
    public void setAvailable_PrefixSearch(String available) {
        setAvailable_LikeSearch(available, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param available The value of available as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setAvailable_LikeSearch(String available,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(available), getCValueAvailable(), "AVAILABLE",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param available The value of available as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setAvailable_NotLikeSearch(String available,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(available), getCValueAvailable(), "AVAILABLE",
                likeSearchOption);
    }

    protected void regAvailable(ConditionKey k, Object v) {
        regQ(k, v, getCValueAvailable(), "AVAILABLE");
    }

    abstract protected ConditionValue getCValueAvailable();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * SORT_ORDER: {NotNull, INTEGER(10)}
     * @param sortOrder The value of sortOrder as equal.
     */
    public void setSortOrder_Equal(Integer sortOrder) {
        doSetSortOrder_Equal(sortOrder);
    }

    protected void doSetSortOrder_Equal(Integer sortOrder) {
        regSortOrder(CK_EQ, sortOrder);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as notEqual.
     */
    public void setSortOrder_NotEqual(Integer sortOrder) {
        doSetSortOrder_NotEqual(sortOrder);
    }

    protected void doSetSortOrder_NotEqual(Integer sortOrder) {
        regSortOrder(CK_NES, sortOrder);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as greaterThan.
     */
    public void setSortOrder_GreaterThan(Integer sortOrder) {
        regSortOrder(CK_GT, sortOrder);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as lessThan.
     */
    public void setSortOrder_LessThan(Integer sortOrder) {
        regSortOrder(CK_LT, sortOrder);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as greaterEqual.
     */
    public void setSortOrder_GreaterEqual(Integer sortOrder) {
        regSortOrder(CK_GE, sortOrder);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param sortOrder The value of sortOrder as lessEqual.
     */
    public void setSortOrder_LessEqual(Integer sortOrder) {
        regSortOrder(CK_LE, sortOrder);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param sortOrderList The collection of sortOrder as inScope.
     */
    public void setSortOrder_InScope(Collection<Integer> sortOrderList) {
        doSetSortOrder_InScope(sortOrderList);
    }

    protected void doSetSortOrder_InScope(Collection<Integer> sortOrderList) {
        regINS(CK_INS, cTL(sortOrderList), getCValueSortOrder(), "SORT_ORDER");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param sortOrderList The collection of sortOrder as notInScope.
     */
    public void setSortOrder_NotInScope(Collection<Integer> sortOrderList) {
        doSetSortOrder_NotInScope(sortOrderList);
    }

    protected void doSetSortOrder_NotInScope(Collection<Integer> sortOrderList) {
        regINS(CK_NINS, cTL(sortOrderList), getCValueSortOrder(), "SORT_ORDER");
    }

    protected void regSortOrder(ConditionKey k, Object v) {
        regQ(k, v, getCValueSortOrder(), "SORT_ORDER");
    }

    abstract protected ConditionValue getCValueSortOrder();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * CREATED_BY: {NotNull, VARCHAR(255)}
     * @param createdBy The value of createdBy as equal.
     */
    public void setCreatedBy_Equal(String createdBy) {
        doSetCreatedBy_Equal(fRES(createdBy));
    }

    protected void doSetCreatedBy_Equal(String createdBy) {
        regCreatedBy(CK_EQ, createdBy);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as notEqual.
     */
    public void setCreatedBy_NotEqual(String createdBy) {
        doSetCreatedBy_NotEqual(fRES(createdBy));
    }

    protected void doSetCreatedBy_NotEqual(String createdBy) {
        regCreatedBy(CK_NES, createdBy);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as greaterThan.
     */
    public void setCreatedBy_GreaterThan(String createdBy) {
        regCreatedBy(CK_GT, fRES(createdBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as lessThan.
     */
    public void setCreatedBy_LessThan(String createdBy) {
        regCreatedBy(CK_LT, fRES(createdBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as greaterEqual.
     */
    public void setCreatedBy_GreaterEqual(String createdBy) {
        regCreatedBy(CK_GE, fRES(createdBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param createdBy The value of createdBy as lessEqual.
     */
    public void setCreatedBy_LessEqual(String createdBy) {
        regCreatedBy(CK_LE, fRES(createdBy));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param createdByList The collection of createdBy as inScope.
     */
    public void setCreatedBy_InScope(Collection<String> createdByList) {
        doSetCreatedBy_InScope(createdByList);
    }

    public void doSetCreatedBy_InScope(Collection<String> createdByList) {
        regINS(CK_INS, cTL(createdByList), getCValueCreatedBy(), "CREATED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param createdByList The collection of createdBy as notInScope.
     */
    public void setCreatedBy_NotInScope(Collection<String> createdByList) {
        doSetCreatedBy_NotInScope(createdByList);
    }

    public void doSetCreatedBy_NotInScope(Collection<String> createdByList) {
        regINS(CK_NINS, cTL(createdByList), getCValueCreatedBy(), "CREATED_BY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as prefixSearch.
     */
    public void setCreatedBy_PrefixSearch(String createdBy) {
        setCreatedBy_LikeSearch(createdBy, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setCreatedBy_LikeSearch(String createdBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(createdBy), getCValueCreatedBy(), "CREATED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param createdBy The value of createdBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setCreatedBy_NotLikeSearch(String createdBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(createdBy), getCValueCreatedBy(), "CREATED_BY",
                likeSearchOption);
    }

    protected void regCreatedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedBy(), "CREATED_BY");
    }

    abstract protected ConditionValue getCValueCreatedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * CREATED_TIME: {NotNull, TIMESTAMP(23, 10)}
     * @param createdTime The value of createdTime as equal.
     */
    public void setCreatedTime_Equal(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_EQ, createdTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterThan.
     */
    public void setCreatedTime_GreaterThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GT, createdTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessThan.
     */
    public void setCreatedTime_LessThan(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LT, createdTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as greaterEqual.
     */
    public void setCreatedTime_GreaterEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_GE, createdTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param createdTime The value of createdTime as lessEqual.
     */
    public void setCreatedTime_LessEqual(java.sql.Timestamp createdTime) {
        regCreatedTime(CK_LE, createdTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of createdTime. (Nullable)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of createdTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setCreatedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueCreatedTime(),
                "CREATED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of createdTime. (Nullable)
     * @param toDate The to-date(yyyy/MM/dd) of createdTime. (Nullable)
     */
    public void setCreatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setCreatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    protected void regCreatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueCreatedTime(), "CREATED_TIME");
    }

    abstract protected ConditionValue getCValueCreatedTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * UPDATED_BY: {VARCHAR(255)}
     * @param updatedBy The value of updatedBy as equal.
     */
    public void setUpdatedBy_Equal(String updatedBy) {
        doSetUpdatedBy_Equal(fRES(updatedBy));
    }

    protected void doSetUpdatedBy_Equal(String updatedBy) {
        regUpdatedBy(CK_EQ, updatedBy);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as notEqual.
     */
    public void setUpdatedBy_NotEqual(String updatedBy) {
        doSetUpdatedBy_NotEqual(fRES(updatedBy));
    }

    protected void doSetUpdatedBy_NotEqual(String updatedBy) {
        regUpdatedBy(CK_NES, updatedBy);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as greaterThan.
     */
    public void setUpdatedBy_GreaterThan(String updatedBy) {
        regUpdatedBy(CK_GT, fRES(updatedBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as lessThan.
     */
    public void setUpdatedBy_LessThan(String updatedBy) {
        regUpdatedBy(CK_LT, fRES(updatedBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as greaterEqual.
     */
    public void setUpdatedBy_GreaterEqual(String updatedBy) {
        regUpdatedBy(CK_GE, fRES(updatedBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param updatedBy The value of updatedBy as lessEqual.
     */
    public void setUpdatedBy_LessEqual(String updatedBy) {
        regUpdatedBy(CK_LE, fRES(updatedBy));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param updatedByList The collection of updatedBy as inScope.
     */
    public void setUpdatedBy_InScope(Collection<String> updatedByList) {
        doSetUpdatedBy_InScope(updatedByList);
    }

    public void doSetUpdatedBy_InScope(Collection<String> updatedByList) {
        regINS(CK_INS, cTL(updatedByList), getCValueUpdatedBy(), "UPDATED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param updatedByList The collection of updatedBy as notInScope.
     */
    public void setUpdatedBy_NotInScope(Collection<String> updatedByList) {
        doSetUpdatedBy_NotInScope(updatedByList);
    }

    public void doSetUpdatedBy_NotInScope(Collection<String> updatedByList) {
        regINS(CK_NINS, cTL(updatedByList), getCValueUpdatedBy(), "UPDATED_BY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as prefixSearch.
     */
    public void setUpdatedBy_PrefixSearch(String updatedBy) {
        setUpdatedBy_LikeSearch(updatedBy, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setUpdatedBy_LikeSearch(String updatedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(updatedBy), getCValueUpdatedBy(), "UPDATED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param updatedBy The value of updatedBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setUpdatedBy_NotLikeSearch(String updatedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(updatedBy), getCValueUpdatedBy(), "UPDATED_BY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUpdatedBy_IsNull() {
        regUpdatedBy(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUpdatedBy_IsNotNull() {
        regUpdatedBy(CK_ISNN, DOBJ);
    }

    protected void regUpdatedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueUpdatedBy(), "UPDATED_BY");
    }

    abstract protected ConditionValue getCValueUpdatedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * UPDATED_TIME: {TIMESTAMP(23, 10)}
     * @param updatedTime The value of updatedTime as equal.
     */
    public void setUpdatedTime_Equal(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_EQ, updatedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as greaterThan.
     */
    public void setUpdatedTime_GreaterThan(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_GT, updatedTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as lessThan.
     */
    public void setUpdatedTime_LessThan(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_LT, updatedTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as greaterEqual.
     */
    public void setUpdatedTime_GreaterEqual(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_GE, updatedTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param updatedTime The value of updatedTime as lessEqual.
     */
    public void setUpdatedTime_LessEqual(java.sql.Timestamp updatedTime) {
        regUpdatedTime(CK_LE, updatedTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of updatedTime. (Nullable)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of updatedTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setUpdatedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueUpdatedTime(),
                "UPDATED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of updatedTime. (Nullable)
     * @param toDate The to-date(yyyy/MM/dd) of updatedTime. (Nullable)
     */
    public void setUpdatedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setUpdatedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setUpdatedTime_IsNull() {
        regUpdatedTime(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setUpdatedTime_IsNotNull() {
        regUpdatedTime(CK_ISNN, DOBJ);
    }

    protected void regUpdatedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueUpdatedTime(), "UPDATED_TIME");
    }

    abstract protected ConditionValue getCValueUpdatedTime();

    /**
     * Equal(=). And NullOrEmptyIgnored, OnlyOnceRegistered. <br />
     * DELETED_BY: {VARCHAR(255)}
     * @param deletedBy The value of deletedBy as equal.
     */
    public void setDeletedBy_Equal(String deletedBy) {
        doSetDeletedBy_Equal(fRES(deletedBy));
    }

    protected void doSetDeletedBy_Equal(String deletedBy) {
        regDeletedBy(CK_EQ, deletedBy);
    }

    /**
     * NotEqual(&lt;&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as notEqual.
     */
    public void setDeletedBy_NotEqual(String deletedBy) {
        doSetDeletedBy_NotEqual(fRES(deletedBy));
    }

    protected void doSetDeletedBy_NotEqual(String deletedBy) {
        regDeletedBy(CK_NES, deletedBy);
    }

    /**
     * GreaterThan(&gt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as greaterThan.
     */
    public void setDeletedBy_GreaterThan(String deletedBy) {
        regDeletedBy(CK_GT, fRES(deletedBy));
    }

    /**
     * LessThan(&lt;). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as lessThan.
     */
    public void setDeletedBy_LessThan(String deletedBy) {
        regDeletedBy(CK_LT, fRES(deletedBy));
    }

    /**
     * GreaterEqual(&gt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as greaterEqual.
     */
    public void setDeletedBy_GreaterEqual(String deletedBy) {
        regDeletedBy(CK_GE, fRES(deletedBy));
    }

    /**
     * LessEqual(&lt;=). And NullOrEmptyIgnored, OnlyOnceRegistered.
     * @param deletedBy The value of deletedBy as lessEqual.
     */
    public void setDeletedBy_LessEqual(String deletedBy) {
        regDeletedBy(CK_LE, fRES(deletedBy));
    }

    /**
     * InScope(in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param deletedByList The collection of deletedBy as inScope.
     */
    public void setDeletedBy_InScope(Collection<String> deletedByList) {
        doSetDeletedBy_InScope(deletedByList);
    }

    public void doSetDeletedBy_InScope(Collection<String> deletedByList) {
        regINS(CK_INS, cTL(deletedByList), getCValueDeletedBy(), "DELETED_BY");
    }

    /**
     * NotInScope(not in ('a', 'b')). And NullOrEmptyIgnored, NullOrEmptyElementIgnored, SeveralRegistered.
     * @param deletedByList The collection of deletedBy as notInScope.
     */
    public void setDeletedBy_NotInScope(Collection<String> deletedByList) {
        doSetDeletedBy_NotInScope(deletedByList);
    }

    public void doSetDeletedBy_NotInScope(Collection<String> deletedByList) {
        regINS(CK_NINS, cTL(deletedByList), getCValueDeletedBy(), "DELETED_BY");
    }

    /**
     * PrefixSearch(like 'xxx%' escape ...). And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as prefixSearch.
     */
    public void setDeletedBy_PrefixSearch(String deletedBy) {
        setDeletedBy_LikeSearch(deletedBy, cLSOP());
    }

    /**
     * LikeSearch with various options. (versatile) {like '%xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as likeSearch.
     * @param likeSearchOption The option of like-search. (NotNull)
     */
    public void setDeletedBy_LikeSearch(String deletedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_LS, fRES(deletedBy), getCValueDeletedBy(), "DELETED_BY",
                likeSearchOption);
    }

    /**
     * NotLikeSearch with various options. (versatile) {not like 'xxx%' escape ...} <br />
     * And NullOrEmptyIgnored, SeveralRegistered.
     * @param deletedBy The value of deletedBy as notLikeSearch.
     * @param likeSearchOption The option of not-like-search. (NotNull)
     */
    public void setDeletedBy_NotLikeSearch(String deletedBy,
            LikeSearchOption likeSearchOption) {
        regLSQ(CK_NLS, fRES(deletedBy), getCValueDeletedBy(), "DELETED_BY",
                likeSearchOption);
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDeletedBy_IsNull() {
        regDeletedBy(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDeletedBy_IsNotNull() {
        regDeletedBy(CK_ISNN, DOBJ);
    }

    protected void regDeletedBy(ConditionKey k, Object v) {
        regQ(k, v, getCValueDeletedBy(), "DELETED_BY");
    }

    abstract protected ConditionValue getCValueDeletedBy();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * DELETED_TIME: {TIMESTAMP(23, 10)}
     * @param deletedTime The value of deletedTime as equal.
     */
    public void setDeletedTime_Equal(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_EQ, deletedTime);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as greaterThan.
     */
    public void setDeletedTime_GreaterThan(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_GT, deletedTime);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as lessThan.
     */
    public void setDeletedTime_LessThan(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_LT, deletedTime);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as greaterEqual.
     */
    public void setDeletedTime_GreaterEqual(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_GE, deletedTime);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param deletedTime The value of deletedTime as lessEqual.
     */
    public void setDeletedTime_LessEqual(java.sql.Timestamp deletedTime) {
        regDeletedTime(CK_LE, deletedTime);
    }

    /**
     * FromTo with various options. (versatile) <br />
     * {(default) fromDatetime &lt;= column &lt;= toDatetime} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * @param fromDatetime The from-datetime(yyyy/MM/dd HH:mm:ss.SSS) of deletedTime. (Nullable)
     * @param toDatetime The to-datetime(yyyy/MM/dd HH:mm:ss.SSS) of deletedTime. (Nullable)
     * @param fromToOption The option of from-to. (NotNull)
     */
    public void setDeletedTime_FromTo(java.util.Date fromDatetime,
            java.util.Date toDatetime, FromToOption fromToOption) {
        regFTQ((fromDatetime != null ? new java.sql.Timestamp(
                fromDatetime.getTime()) : null),
                (toDatetime != null ? new java.sql.Timestamp(toDatetime
                        .getTime()) : null), getCValueDeletedTime(),
                "DELETED_TIME", fromToOption);
    }

    /**
     * DateFromTo. (Date means yyyy/MM/dd) <br />
     * {fromDate &lt;= column &lt; toDate + 1 day} <br />
     * And NullIgnored, OnlyOnceRegistered.
     * <pre>
     * ex) from:{2007/04/10 08:24:53} to:{2007/04/16 14:36:29}
     *     --&gt; column &gt;= '2007/04/10 00:00:00'
     *     and column <span style="color: #FD4747">&lt; '2007/04/17 00:00:00'</span>
     * </pre>
     * @param fromDate The from-date(yyyy/MM/dd) of deletedTime. (Nullable)
     * @param toDate The to-date(yyyy/MM/dd) of deletedTime. (Nullable)
     */
    public void setDeletedTime_DateFromTo(java.util.Date fromDate,
            java.util.Date toDate) {
        setDeletedTime_FromTo(fromDate, toDate, new DateFromToOption());
    }

    /**
     * IsNull(is null). And OnlyOnceRegistered.
     */
    public void setDeletedTime_IsNull() {
        regDeletedTime(CK_ISN, DOBJ);
    }

    /**
     * IsNotNull(is not null). And OnlyOnceRegistered.
     */
    public void setDeletedTime_IsNotNull() {
        regDeletedTime(CK_ISNN, DOBJ);
    }

    protected void regDeletedTime(ConditionKey k, Object v) {
        regQ(k, v, getCValueDeletedTime(), "DELETED_TIME");
    }

    abstract protected ConditionValue getCValueDeletedTime();

    /**
     * Equal(=). And NullIgnored, OnlyOnceRegistered. <br />
     * VERSION_NO: {NotNull, INTEGER(10)}
     * @param versionNo The value of versionNo as equal.
     */
    public void setVersionNo_Equal(Integer versionNo) {
        doSetVersionNo_Equal(versionNo);
    }

    protected void doSetVersionNo_Equal(Integer versionNo) {
        regVersionNo(CK_EQ, versionNo);
    }

    /**
     * NotEqual(&lt;&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as notEqual.
     */
    public void setVersionNo_NotEqual(Integer versionNo) {
        doSetVersionNo_NotEqual(versionNo);
    }

    protected void doSetVersionNo_NotEqual(Integer versionNo) {
        regVersionNo(CK_NES, versionNo);
    }

    /**
     * GreaterThan(&gt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as greaterThan.
     */
    public void setVersionNo_GreaterThan(Integer versionNo) {
        regVersionNo(CK_GT, versionNo);
    }

    /**
     * LessThan(&lt;). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as lessThan.
     */
    public void setVersionNo_LessThan(Integer versionNo) {
        regVersionNo(CK_LT, versionNo);
    }

    /**
     * GreaterEqual(&gt;=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as greaterEqual.
     */
    public void setVersionNo_GreaterEqual(Integer versionNo) {
        regVersionNo(CK_GE, versionNo);
    }

    /**
     * LessEqual(&lt;=). And NullIgnored, OnlyOnceRegistered.
     * @param versionNo The value of versionNo as lessEqual.
     */
    public void setVersionNo_LessEqual(Integer versionNo) {
        regVersionNo(CK_LE, versionNo);
    }

    /**
     * InScope(in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param versionNoList The collection of versionNo as inScope.
     */
    public void setVersionNo_InScope(Collection<Integer> versionNoList) {
        doSetVersionNo_InScope(versionNoList);
    }

    protected void doSetVersionNo_InScope(Collection<Integer> versionNoList) {
        regINS(CK_INS, cTL(versionNoList), getCValueVersionNo(), "VERSION_NO");
    }

    /**
     * NotInScope(not in (1, 2)). And NullIgnored, NullElementIgnored, SeveralRegistered.
     * @param versionNoList The collection of versionNo as notInScope.
     */
    public void setVersionNo_NotInScope(Collection<Integer> versionNoList) {
        doSetVersionNo_NotInScope(versionNoList);
    }

    protected void doSetVersionNo_NotInScope(Collection<Integer> versionNoList) {
        regINS(CK_NINS, cTL(versionNoList), getCValueVersionNo(), "VERSION_NO");
    }

    protected void regVersionNo(ConditionKey k, Object v) {
        regQ(k, v, getCValueVersionNo(), "VERSION_NO");
    }

    abstract protected ConditionValue getCValueVersionNo();

    // ===================================================================================
    //                                                                    Scalar Condition
    //                                                                    ================
    /**
     * Prepare ScalarCondition as equal. <br />
     * {where FOO = (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_Equal()</span>.max(new SubQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.specify().setXxx... // derived column for function
     *         subCB.query().setYyy...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<WebCrawlingConfigCB> scalar_Equal() {
        return xcreateSSQFunction(CK_EQ.getOperand());
    }

    /**
     * Prepare ScalarCondition as equal. <br />
     * {where FOO &lt;&gt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_NotEqual()</span>.max(new SubQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.specify().setXxx... // derived column for function
     *         subCB.query().setYyy...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<WebCrawlingConfigCB> scalar_NotEqual() {
        return xcreateSSQFunction(CK_NES.getOperand());
    }

    /**
     * Prepare ScalarCondition as greaterThan. <br />
     * {where FOO &gt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_GreaterThan()</span>.max(new SubQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<WebCrawlingConfigCB> scalar_GreaterThan() {
        return xcreateSSQFunction(CK_GT.getOperand());
    }

    /**
     * Prepare ScalarCondition as lessThan. <br />
     * {where FOO &lt; (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_LessThan()</span>.max(new SubQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<WebCrawlingConfigCB> scalar_LessThan() {
        return xcreateSSQFunction(CK_LT.getOperand());
    }

    /**
     * Prepare ScalarCondition as greaterEqual. <br />
     * {where FOO &gt;= (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_GreaterEqual()</span>.max(new SubQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<WebCrawlingConfigCB> scalar_GreaterEqual() {
        return xcreateSSQFunction(CK_GE.getOperand());
    }

    /**
     * Prepare ScalarCondition as lessEqual. <br />
     * {where FOO &lt;= (select max(BAR) from ...)
     * <pre>
     * cb.query().<span style="color: #FD4747">scalar_LessEqual()</span>.max(new SubQuery&lt;WebCrawlingConfigCB&gt;() {
     *     public void query(WebCrawlingConfigCB subCB) {
     *         subCB.specify().setFoo... // derived column for function
     *         subCB.query().setBar...
     *     }
     * });
     * </pre>
     * @return The object to set up a function. (NotNull)
     */
    public HpSSQFunction<WebCrawlingConfigCB> scalar_LessEqual() {
        return xcreateSSQFunction(CK_LE.getOperand());
    }

    protected HpSSQFunction<WebCrawlingConfigCB> xcreateSSQFunction(
            final String operand) {
        return new HpSSQFunction<WebCrawlingConfigCB>(
                new HpSSQSetupper<WebCrawlingConfigCB>() {
                    public void setup(String function,
                            SubQuery<WebCrawlingConfigCB> subQuery) {
                        xscalarCondition(function, subQuery, operand);
                    }
                });
    }

    protected void xscalarCondition(String function,
            SubQuery<WebCrawlingConfigCB> subQuery, String operand) {
        assertObjectNotNull("subQuery<WebCrawlingConfigCB>", subQuery);
        WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
        cb.xsetupForScalarCondition();
        subQuery.query(cb);
        String subQueryPropertyName = keepScalarCondition(cb.query()); // for saving query-value.
        registerScalarCondition(function, cb.query(), subQueryPropertyName,
                operand);
    }

    public abstract String keepScalarCondition(WebCrawlingConfigCQ subQuery);

    // ===================================================================================
    //                                                                      Myself InScope
    //                                                                      ==============
    /**
     * Myself InScope (SubQuery). {mainly for CLOB and Union}
     * @param subQuery The implementation of sub query. (NotNull)
     */
    public void myselfInScope(SubQuery<WebCrawlingConfigCB> subQuery) {
        assertObjectNotNull("subQuery<WebCrawlingConfigCB>", subQuery);
        WebCrawlingConfigCB cb = new WebCrawlingConfigCB();
        cb.xsetupForInScopeRelation();
        subQuery.query(cb);
        String subQueryPropertyName = keepMyselfInScopeRelation(cb.query()); // for saving query-value.
        registerInScopeRelation(cb.query(), "ID", "ID", subQueryPropertyName);
    }

    public abstract String keepMyselfInScopeRelation(
            WebCrawlingConfigCQ subQuery);

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xabCB() {
        return WebCrawlingConfigCB.class.getName();
    }

    protected String xabCQ() {
        return WebCrawlingConfigCQ.class.getName();
    }

    protected String xabLSO() {
        return LikeSearchOption.class.getName();
    }

    protected String xabSSQS() {
        return HpSSQSetupper.class.getName();
    }
}
