/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.exentity;

import java.util.Map;

import jp.sf.fess.Constants;
import jp.sf.fess.db.bsentity.BsWebAuthentication;
import jp.sf.fess.util.ParameterUtil;

import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.NTLMScheme;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.client.http.Authentication;
import org.seasar.robot.client.http.impl.AuthenticationImpl;
import org.seasar.robot.client.http.ntlm.JcifsEngine;

/**
 * The entity of WEB_AUTHENTICATION.
 * <p>
 * You can implement your original methods here.
 * This class remains when re-generating.
 * </p>
 * @author DBFlute(AutoGenerator)
 */
public class WebAuthentication extends BsWebAuthentication {

    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    public Authentication getAuthentication() {
        return new AuthenticationImpl(getAuthScope(), getCredentials(),
                getAuthScheme());
    }

    private AuthScheme getAuthScheme() {
        if (Constants.BASIC.equals(getProtocolScheme())) {
            return new BasicScheme();
        } else if (Constants.DIGEST.equals(getProtocolScheme())) {
            return new DigestScheme();
        } else if (Constants.NTLM.equals(getProtocolScheme())) {
            return new NTLMScheme(new JcifsEngine());
        }
        return null;
    }

    private AuthScope getAuthScope() {
        if (StringUtil.isBlank(getHostname())) {
            return AuthScope.ANY;
        }

        int p;
        if (getPort() == null) {
            p = AuthScope.ANY_PORT;
        } else {
            p = getPort().intValue();
        }

        String r = getAuthRealm();
        if (StringUtil.isBlank(r)) {
            r = AuthScope.ANY_REALM;
        }

        String s = getProtocolScheme();
        if (StringUtil.isBlank(s) || Constants.NTLM.equals(s)) {
            s = AuthScope.ANY_SCHEME;
        }

        return new AuthScope(getHostname(), p, r, s);
    }

    private Credentials getCredentials() {
        if (StringUtil.isEmpty(getUsername())) {
            throw new RobotSystemException("username is empty.");
        }

        if (Constants.NTLM.equals(getProtocolScheme())) {
            Map<String, String> parameterMap = ParameterUtil
                    .convertParameterMap(getParameters());
            String workstation = parameterMap.get("workstation");
            String domain = parameterMap.get("domain");
            return new NTCredentials(getUsername(), getPassword(),
                    workstation == null ? "" : workstation, domain == null ? ""
                            : domain);
        }

        return new UsernamePasswordCredentials(getUsername(),
                getPassword() == null ? "" : getPassword());
    }

}
