/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.BrowserTypeDbm;
import jp.sf.fess.db.cbean.BrowserTypeCB;
import jp.sf.fess.db.cbean.DataConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.WebConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.exbhv.DataConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.WebConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.DataConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.WebConfigToBrowserTypeMapping;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of BROWSER_TYPE as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     DATA_CONFIG_TO_BROWSER_TYPE_MAPPING, FILE_CONFIG_TO_BROWSER_TYPE_MAPPING, WEB_CONFIG_TO_BROWSER_TYPE_MAPPING
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     dataConfigToBrowserTypeMappingList, fileConfigToBrowserTypeMappingList, webConfigToBrowserTypeMappingList
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsBrowserTypeBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "BROWSER_TYPE";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return BrowserTypeDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public BrowserTypeDbm getMyDBMeta() {
        return BrowserTypeDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public BrowserType newMyEntity() {
        return new BrowserType();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public BrowserTypeCB newMyConditionBean() {
        return new BrowserTypeCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * int count = browserTypeBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected count.
     */
    public int selectCount(BrowserTypeCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(BrowserTypeCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;BrowserType&gt;() {
     *     public void handle(BrowserType entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param entityRowHandler The handler of entity row of BrowserType. (NotNull)
     */
    public void selectCursor(BrowserTypeCB cb,
            EntityRowHandler<BrowserType> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> void doSelectCursor(
            BrowserTypeCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<BrowserType>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * BrowserType browserType = browserTypeBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (browserType != null) {
     *     ... = browserType.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectEntity(BrowserTypeCB cb) {
        return doSelectEntity(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectEntity(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, BrowserTypeCB>() {
                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * BrowserType browserType = browserTypeBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = browserType.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectEntityWithDeletedCheck(BrowserTypeCB cb) {
        return doSelectEntityWithDeletedCheck(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectEntityWithDeletedCheck(
            final BrowserTypeCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, BrowserTypeCB>() {
                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectByPKValue(Long id) {
        return doSelectByPKValue(id, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public BrowserType selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private BrowserTypeCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        BrowserTypeCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;BrowserType&gt; browserTypeList = browserTypeBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<BrowserType> selectList(BrowserTypeCB cb) {
        return doSelectList(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> ListResultBean<ENTITY> doSelectList(
            BrowserTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, BrowserTypeCB>() {
                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;BrowserType&gt; page = browserTypeBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (BrowserType browserType : page) {
     *     ... = browserType.get...();
     * }
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<BrowserType> selectPage(BrowserTypeCB cb) {
        return doSelectPage(cb, BrowserType.class);
    }

    protected <ENTITY extends BrowserType> PagingResultBean<ENTITY> doSelectPage(
            BrowserTypeCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, BrowserTypeCB>() {
                    public int callbackSelectCount(BrowserTypeCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(BrowserTypeCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<BrowserTypeCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends BrowserTypeCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            BrowserType browserType,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of dataConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadDataConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;DataConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(DataConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getDataConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            ConditionBeanSetupper<DataConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadDataConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            BrowserType browserType,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadDataConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadDataConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            LoadReferrerOption<DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final DataConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(DataConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, DataConfigToBrowserTypeMappingCB, DataConfigToBrowserTypeMapping>() {
                    public Long getPKVal(BrowserType e) {
                        return e.getId();
                    }

                    public void setRfLs(BrowserType e,
                            List<DataConfigToBrowserTypeMapping> ls) {
                        e.setDataConfigToBrowserTypeMappingList(ls);
                    }

                    public DataConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(DataConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(DataConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    public List<DataConfigToBrowserTypeMapping> selRfLs(
                            DataConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(DataConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    public void setlcEt(DataConfigToBrowserTypeMapping re,
                            BrowserType le) {
                        re.setBrowserType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            BrowserType browserType,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of fileConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadFileConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;FileConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(FileConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getFileConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadFileConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            BrowserType browserType,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadFileConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadFileConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            LoadReferrerOption<FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final FileConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(FileConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, FileConfigToBrowserTypeMappingCB, FileConfigToBrowserTypeMapping>() {
                    public Long getPKVal(BrowserType e) {
                        return e.getId();
                    }

                    public void setRfLs(BrowserType e,
                            List<FileConfigToBrowserTypeMapping> ls) {
                        e.setFileConfigToBrowserTypeMappingList(ls);
                    }

                    public FileConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(FileConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(FileConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    public List<FileConfigToBrowserTypeMapping> selRfLs(
                            FileConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(FileConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    public void setlcEt(FileConfigToBrowserTypeMapping re,
                            BrowserType le) {
                        re.setBrowserType(le);
                    }
                });
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            BrowserType browserType,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserType, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                conditionBeanSetupper);
    }

    /**
     * Load referrer of webConfigToBrowserTypeMappingList with the set-upper for condition-bean of referrer.
     * <pre>
     * browserTypeBhv.<span style="color: #FD4747">loadWebConfigToBrowserTypeMappingList</span>(browserTypeList, new ConditionBeanSetupper&lt;WebConfigToBrowserTypeMappingCB&gt;() {
     *     public void setup(WebConfigToBrowserTypeMappingCB cb) {
     *         cb.setupSelect...();
     *         cb.query().setFoo...(value);
     *         cb.query().addOrderBy_Bar...(); <span style="color: #3F7E5E">// basically you should order referrer list</span>
     *     }
     * });
     * for (BrowserType browserType : browserTypeList) {
     *     ... = browserType.<span style="color: #FD4747">getWebConfigToBrowserTypeMappingList()</span>;
     * }
     * </pre>
     * About internal policy, the value of primary key(and others too) is treated as case-insensitive. <br />
     * The condition-bean that the set-upper provides have settings before you touch it. It is as follows:
     * <pre>
     * cb.query().setBrowserTypeId_InScope(pkList);
     * cb.query().addOrderBy_BrowserTypeId_Asc();
     * </pre>
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param conditionBeanSetupper The instance of referrer condition-bean set-upper for registering referrer condition. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            ConditionBeanSetupper<WebConfigToBrowserTypeMappingCB> conditionBeanSetupper) {
        xassLRArg(browserTypeList, conditionBeanSetupper);
        loadWebConfigToBrowserTypeMappingList(
                browserTypeList,
                new LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>(
                        conditionBeanSetupper));
    }

    /**
     * {Refer to overload method that has an argument of the list of entity.}
     * @param browserType The entity of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            BrowserType browserType,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserType, loadReferrerOption);
        loadWebConfigToBrowserTypeMappingList(xnewLRLs(browserType),
                loadReferrerOption);
    }

    /**
     * {Refer to overload method that has an argument of condition-bean setupper.}
     * @param browserTypeList The entity list of browserType. (NotNull)
     * @param loadReferrerOption The option of load-referrer. (NotNull)
     */
    public void loadWebConfigToBrowserTypeMappingList(
            List<BrowserType> browserTypeList,
            LoadReferrerOption<WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping> loadReferrerOption) {
        xassLRArg(browserTypeList, loadReferrerOption);
        if (browserTypeList.isEmpty()) {
            return;
        }
        final WebConfigToBrowserTypeMappingBhv referrerBhv = xgetBSFLR()
                .select(WebConfigToBrowserTypeMappingBhv.class);
        helpLoadReferrerInternally(
                browserTypeList,
                loadReferrerOption,
                new InternalLoadReferrerCallback<BrowserType, Long, WebConfigToBrowserTypeMappingCB, WebConfigToBrowserTypeMapping>() {
                    public Long getPKVal(BrowserType e) {
                        return e.getId();
                    }

                    public void setRfLs(BrowserType e,
                            List<WebConfigToBrowserTypeMapping> ls) {
                        e.setWebConfigToBrowserTypeMappingList(ls);
                    }

                    public WebConfigToBrowserTypeMappingCB newMyCB() {
                        return referrerBhv.newMyConditionBean();
                    }

                    public void qyFKIn(WebConfigToBrowserTypeMappingCB cb,
                            List<Long> ls) {
                        cb.query().setBrowserTypeId_InScope(ls);
                    }

                    public void qyOdFKAsc(WebConfigToBrowserTypeMappingCB cb) {
                        cb.query().addOrderBy_BrowserTypeId_Asc();
                    }

                    public List<WebConfigToBrowserTypeMapping> selRfLs(
                            WebConfigToBrowserTypeMappingCB cb) {
                        return referrerBhv.selectList(cb);
                    }

                    public Long getFKVal(WebConfigToBrowserTypeMapping e) {
                        return e.getBrowserTypeId();
                    }

                    public void setlcEt(WebConfigToBrowserTypeMapping re,
                            BrowserType le) {
                        re.setBrowserType(le);
                    }
                });
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * browserType.setFoo...(value);
     * browserType.setBar...(value);
     * browserTypeBhv.<span style="color: #FD4747">insert</span>(browserType);
     * ... = browserType.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param browserType The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(BrowserType browserType) {
        assertEntityNotNull(browserType);
        delegateInsert(browserType);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     browserTypeBhv.<span style="color: #FD4747">update</span>(browserType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final BrowserType browserType) {
        helpUpdateInternally(browserType,
                new InternalUpdateCallback<BrowserType>() {
                    public int callbackDelegateUpdate(BrowserType entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">updateNonstrict</span>(browserType);
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final BrowserType browserType) {
        helpUpdateNonstrictInternally(browserType,
                new InternalUpdateNonstrictCallback<BrowserType>() {
                    public int callbackDelegateUpdateNonstrict(
                            BrowserType entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param browserType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final BrowserType browserType) {
        helpInsertOrUpdateInternally(
                browserType,
                new InternalInsertOrUpdateCallback<BrowserType, BrowserTypeCB>() {
                    public void callbackInsert(BrowserType entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(BrowserType entity) {
                        update(entity);
                    }

                    public BrowserTypeCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(BrowserTypeCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param browserType The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(BrowserType browserType) {
        helpInsertOrUpdateInternally(browserType,
                new InternalInsertOrUpdateNonstrictCallback<BrowserType>() {
                    public void callbackInsert(BrowserType entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(BrowserType entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     browserTypeBhv.<span style="color: #FD4747">delete</span>(browserType);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param browserType The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(BrowserType browserType) {
        helpDeleteInternally(browserType,
                new InternalDeleteCallback<BrowserType>() {
                    public int callbackDelegateDelete(BrowserType entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">deleteNonstrict</span>(browserType);
     * </pre>
     * @param browserType Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(BrowserType browserType) {
        helpDeleteNonstrictInternally(browserType,
                new InternalDeleteNonstrictCallback<BrowserType>() {
                    public int callbackDelegateDeleteNonstrict(
                            BrowserType entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * browserTypeBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(browserType);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param browserType Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(BrowserType browserType) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                browserType,
                new InternalDeleteNonstrictIgnoreDeletedCallback<BrowserType>() {
                    public int callbackDelegateDeleteNonstrict(
                            BrowserType entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<BrowserType> browserTypeList) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        return delegateInsertList(browserTypeList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<BrowserType> browserTypeList) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        return delegateUpdateList(browserTypeList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<BrowserType> browserTypeList) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        return delegateUpdateListNonstrict(browserTypeList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<BrowserType> browserTypeList) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        return delegateDeleteList(browserTypeList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param browserTypeList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<BrowserType> browserTypeList) {
        assertObjectNotNull("browserTypeList", browserTypeList);
        return delegateDeleteListNonstrict(browserTypeList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//browserType.setPK...(value);</span>
     * browserType.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">queryUpdate</span>(browserType, cb);
     * </pre>
     * @param browserType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(BrowserType browserType, BrowserTypeCB cb) {
        return delegateQueryUpdate(browserType, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * browserTypeBhv.<span style="color: #FD4747">queryDelete</span>(browserType, cb);
     * </pre>
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(BrowserTypeCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * browserType.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     *     option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *         public void specify(BrowserTypeCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     browserTypeBhv.<span style="color: #FD4747">varyingUpdate</span>(browserType, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(browserType,
                new InternalUpdateCallback<BrowserType>() {
                    public int callbackDelegateUpdate(BrowserType entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * browserType.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *     public void specify(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * browserTypeBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(browserType, option);
     * </pre>
     * @param browserType The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(BrowserType browserType,
            final UpdateOption<BrowserTypeCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(browserType,
                new InternalUpdateNonstrictCallback<BrowserType>() {
                    public int callbackDelegateUpdateNonstrict(
                            BrowserType entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * BrowserType browserType = new BrowserType();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//browserType.setPK...(value);</span>
     * browserType.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//browserType.setVersionNo(value);</span>
     * BrowserTypeCB cb = new BrowserTypeCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;BrowserTypeCB&gt; option = new UpdateOption&lt;BrowserTypeCB&gt;();
     * option.self(new SpecifyQuery&lt;BrowserTypeCB&gt;() {
     *     public void specify(BrowserTypeCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * browserTypeBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(browserType, cb, option);
     * </pre>
     * @param browserType The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of BrowserType. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(BrowserType browserType, BrowserTypeCB cb,
            final UpdateOption<BrowserTypeCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(browserType, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<BrowserTypeCB> option) {
        assertUpdateOptionNotNull(option);
        BrowserTypeCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(BrowserTypeCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends BrowserType> void delegateSelectCursor(
            BrowserTypeCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends BrowserType> List<ENTITY> delegateSelectList(
            BrowserTypeCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(BrowserType e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(BrowserType e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(BrowserType e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(BrowserType e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(BrowserType e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<BrowserType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<BrowserType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<BrowserType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<BrowserType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<BrowserType> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(BrowserType e, BrowserTypeCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(BrowserTypeCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(BrowserType e,
            UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(BrowserType e,
            UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(BrowserType e, BrowserTypeCB cb,
            UpdateOption<BrowserTypeCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected BrowserType downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, BrowserType.class);
    }

    protected BrowserTypeCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, BrowserTypeCB.class);
    }
}
