/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.cbean.cq.ciq;

import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.cbean.cq.WebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.WebCrawlingConfigCQ;
import jp.sf.fess.db.cbean.cq.bs.AbstractBsWebAuthenticationCQ;
import jp.sf.fess.db.cbean.cq.bs.BsWebAuthenticationCQ;

import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/**
 * The condition-query for in-line of WEB_AUTHENTICATION.
 * @author DBFlute(AutoGenerator)
 */
public class WebAuthenticationCIQ extends AbstractBsWebAuthenticationCQ {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    protected BsWebAuthenticationCQ _myCQ;

    // ===================================================================================
    //                                                                         Constructor
    //                                                                         ===========
    public WebAuthenticationCIQ(ConditionQuery childQuery, SqlClause sqlClause,
            String aliasName, int nestLevel, BsWebAuthenticationCQ myCQ) {
        super(childQuery, sqlClause, aliasName, nestLevel);
        _myCQ = myCQ;
        _foreignPropertyName = _myCQ.getForeignPropertyName(); // accept foreign property name
        _relationPath = _myCQ.getRelationPath(); // accept relation path
    }

    // ===================================================================================
    //                                                             Override about Register
    //                                                             =======================
    @Override
    protected void reflectRelationOnUnionQuery(ConditionQuery bq,
            ConditionQuery uq) {
        String msg = "InlineView must not need UNION method: " + bq + " : "
                + uq;
        throw new IllegalConditionBeanOperationException(msg);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col) {
        regIQ(k, v, cv, col);
    }

    @Override
    protected void setupConditionValueAndRegisterWhereClause(ConditionKey k,
            Object v, ConditionValue cv, String col, ConditionOption op) {
        regIQ(k, v, cv, col, op);
    }

    @Override
    protected void registerWhereClause(String wc) {
        registerInlineWhereClause(wc);
    }

    @Override
    protected boolean isInScopeRelationSuppressLocalAliasName() {
        if (_onClauseInline) {
            throw new IllegalConditionBeanOperationException(
                    "InScopeRelation on OnClause is unsupported.");
        }
        return true;
    }

    // ===================================================================================
    //                                                                Override about Query
    //                                                                ====================
    protected ConditionValue getCValueId() {
        return _myCQ.getId();
    }

    protected ConditionValue getCValueHostname() {
        return _myCQ.getHostname();
    }

    protected ConditionValue getCValuePort() {
        return _myCQ.getPort();
    }

    protected ConditionValue getCValueAuthRealm() {
        return _myCQ.getAuthRealm();
    }

    protected ConditionValue getCValueProtocolScheme() {
        return _myCQ.getProtocolScheme();
    }

    protected ConditionValue getCValueUsername() {
        return _myCQ.getUsername();
    }

    protected ConditionValue getCValuePassword() {
        return _myCQ.getPassword();
    }

    protected ConditionValue getCValueParameters() {
        return _myCQ.getParameters();
    }

    protected ConditionValue getCValueWebCrawlingConfigId() {
        return _myCQ.getWebCrawlingConfigId();
    }

    public String keepWebCrawlingConfigId_InScopeRelation_WebCrawlingConfig(
            WebCrawlingConfigCQ sq) {
        return _myCQ
                .keepWebCrawlingConfigId_InScopeRelation_WebCrawlingConfig(sq);
    }

    public String keepWebCrawlingConfigId_NotInScopeRelation_WebCrawlingConfig(
            WebCrawlingConfigCQ sq) {
        return _myCQ
                .keepWebCrawlingConfigId_NotInScopeRelation_WebCrawlingConfig(sq);
    }

    protected ConditionValue getCValueCreatedBy() {
        return _myCQ.getCreatedBy();
    }

    protected ConditionValue getCValueCreatedTime() {
        return _myCQ.getCreatedTime();
    }

    protected ConditionValue getCValueUpdatedBy() {
        return _myCQ.getUpdatedBy();
    }

    protected ConditionValue getCValueUpdatedTime() {
        return _myCQ.getUpdatedTime();
    }

    protected ConditionValue getCValueDeletedBy() {
        return _myCQ.getDeletedBy();
    }

    protected ConditionValue getCValueDeletedTime() {
        return _myCQ.getDeletedTime();
    }

    protected ConditionValue getCValueVersionNo() {
        return _myCQ.getVersionNo();
    }

    public String keepScalarCondition(WebAuthenticationCQ subQuery) {
        throwIICBOE("ScalarCondition");
        return null;
    }

    public String keepMyselfInScopeRelation(WebAuthenticationCQ subQuery) {
        throwIICBOE("MyselfInScopeRelation");
        return null;
    }

    protected void throwIICBOE(String name) { // throwInlineIllegalConditionBeanOperationException()
        throw new IllegalConditionBeanOperationException(name
                + " at InlineView is unsupported.");
    }

    // ===================================================================================
    //                                                                       Very Internal
    //                                                                       =============
    // very internal (for suppressing warn about 'Not Use Import')
    protected String xinCB() {
        return WebAuthenticationCB.class.getName();
    }

    protected String xinCQ() {
        return WebAuthenticationCQ.class.getName();
    }
}
