/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task;

import java.lang.annotation.Annotation;

import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.annotation.task.Task;

public interface TaskAnnotationReader {

    public interface TriggerAnnotationHandler {
        TaskTrigger process(Annotation annotaion,
                Class<?> triggerAnnotationClass);
    }

    public void setup(Class<?> taskClass);

    public boolean hasTaskAnnotation();

    public boolean hasTriggerAnnotation();

    public boolean hasTriggerProperty();

    public Task getTaskAnnotation();

    public TaskTrigger getTriggerAnnotationClass(
            TriggerAnnotationHandler triggerAnnotationHandler);

}
