package org.seasar.chronos.core.task.state.impl;

import java.util.concurrent.TimeUnit;

import org.seasar.chronos.core.task.state.TaskExecuteContext;
import org.seasar.chronos.core.task.strategy.TaskExecuteStrategy;

public class TaskExecuteStateStarted extends AbstractTaskExecuteState {

    public TaskExecuteStateStarted(final TaskExecuteStrategy taskExecuteStrategy) {
        super(taskExecuteStrategy);
    }

    @Override
    public boolean await(final TaskExecuteContext context, final long time,
            final TimeUnit timeUnit) throws InterruptedException {
        return getTaskExecuteStrategy().await(time, timeUnit);

    }

    @Override
    public boolean cancel(final TaskExecuteContext context) {
        final boolean result = getTaskExecuteStrategy().cancel();
        return result;
    }

    @Override
    public void destroy(final AbstractTaskExecuteContext context) {

    }

    @Override
    public void execute(final TaskExecuteContext context,
            final String startTaskName) throws InterruptedException {
        getTaskExecuteStrategy().execute(startTaskName);
    }

    @Override
    public String finish(final AbstractTaskExecuteContext context)
            throws InterruptedException {
        final String result = getTaskExecuteStrategy().end();
        changeState(context, context.getTaskExecuteStateFinished());
        return result;
    }

    @Override
    public void initialize(final AbstractTaskExecuteContext context) {

    }

    @Override
    public String start(final AbstractTaskExecuteContext context)
            throws InterruptedException {
        return null;
    }

    @Override
    public void waitOne() throws InterruptedException {
        getTaskExecuteStrategy().waitOne();
    }

}
