/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.math;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.antcontrib.math.Evaluateable;
import org.apache.tools.ant.BuildException;

public class Math {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$net$sf$antcontrib$math$Math;

    public static final Number evaluate(String operation, String datatype, boolean strict, Evaluateable[] operands) {
        if (datatype == null) {
            datatype = "double";
        }
        try {
            operation = operation.toLowerCase();
            Method m = (class$net$sf$antcontrib$math$Math == null ? (class$net$sf$antcontrib$math$Math = Math.class$("net.sf.antcontrib.math.Math")) : class$net$sf$antcontrib$math$Math).getDeclaredMethod(operation, class$java$lang$String == null ? (class$java$lang$String = Math.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, operands.getClass());
            Number n = (Number)m.invoke(null, datatype, strict ? Boolean.TRUE : Boolean.FALSE, operands);
            return n;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        return null;
    }

    public static final Number add(String datatype, boolean strict, Evaluateable[] operands) {
        Number result = null;
        Number[] numbers = new Number[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            numbers[i] = operands[i].evaluate();
        }
        if (datatype.equalsIgnoreCase("int")) {
            int sum = 0;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i].intValue();
            }
            result = new Integer(sum);
        } else if (datatype.equalsIgnoreCase("long")) {
            long sum = 0L;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i].longValue();
            }
            result = new Long(sum);
        } else if (datatype.equalsIgnoreCase("float")) {
            float sum = 0.0f;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i].floatValue();
            }
            result = new Float(sum);
        } else if (datatype.equalsIgnoreCase("double")) {
            double sum = 0.0;
            for (int i = 0; i < numbers.length; ++i) {
                sum += numbers[i].doubleValue();
            }
            result = new Double(sum);
        }
        return result;
    }

    public static final Number subtract(String datatype, boolean strict, Evaluateable[] operands) {
        Number result = null;
        Number[] numbers = new Number[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            numbers[i] = operands[i].evaluate();
        }
        if (datatype.equalsIgnoreCase("int")) {
            int sum = numbers[0].intValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum -= numbers[i].intValue();
            }
            result = new Integer(sum);
        } else if (datatype.equalsIgnoreCase("long")) {
            long sum = numbers[0].longValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum -= numbers[i].longValue();
            }
            result = new Long(sum);
        } else if (datatype.equalsIgnoreCase("float")) {
            float sum = numbers[0].floatValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum -= numbers[i].floatValue();
            }
            result = new Float(sum);
        } else if (datatype.equalsIgnoreCase("double")) {
            double sum = numbers[0].doubleValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum -= numbers[i].doubleValue();
            }
            result = new Double(sum);
        }
        return result;
    }

    public static final Number multiply(String datatype, boolean strict, Evaluateable[] operands) {
        Number result = null;
        Number[] numbers = new Number[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            numbers[i] = operands[i].evaluate();
        }
        if (datatype.equalsIgnoreCase("int")) {
            int sum = 1;
            for (int i = 0; i < numbers.length; ++i) {
                sum *= numbers[i].intValue();
            }
            result = new Integer(sum);
        } else if (datatype.equalsIgnoreCase("long")) {
            long sum = 1L;
            for (int i = 0; i < numbers.length; ++i) {
                sum *= numbers[i].longValue();
            }
            result = new Long(sum);
        } else if (datatype.equalsIgnoreCase("float")) {
            float sum = 1.0f;
            for (int i = 0; i < numbers.length; ++i) {
                sum *= numbers[i].floatValue();
            }
            result = new Float(sum);
        } else if (datatype.equalsIgnoreCase("double")) {
            double sum = 1.0;
            for (int i = 0; i < numbers.length; ++i) {
                sum *= numbers[i].doubleValue();
            }
            result = new Double(sum);
        }
        return result;
    }

    public static final Number divide(String datatype, boolean strict, Evaluateable[] operands) {
        Number result = null;
        Number[] numbers = new Number[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            numbers[i] = operands[i].evaluate();
        }
        if (datatype.equalsIgnoreCase("int")) {
            int sum = numbers[0].intValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum /= numbers[i].intValue();
            }
            result = new Integer(sum);
        } else if (datatype.equalsIgnoreCase("long")) {
            long sum = numbers[0].longValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum /= numbers[i].longValue();
            }
            result = new Long(sum);
        } else if (datatype.equalsIgnoreCase("float")) {
            float sum = numbers[0].floatValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum /= numbers[i].floatValue();
            }
            result = new Float(sum);
        } else if (datatype.equalsIgnoreCase("double")) {
            double sum = numbers[0].doubleValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum /= numbers[i].doubleValue();
            }
            result = new Double(sum);
        }
        return result;
    }

    public static final Number mod(String datatype, boolean strict, Evaluateable[] operands) {
        Number result = null;
        Number[] numbers = new Number[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            numbers[i] = operands[i].evaluate();
        }
        if (datatype.equalsIgnoreCase("int")) {
            int sum = numbers[0].intValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum %= numbers[i].intValue();
            }
            result = new Integer(sum);
        } else if (datatype.equalsIgnoreCase("long")) {
            long sum = numbers[0].longValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum %= numbers[i].longValue();
            }
            result = new Long(sum);
        } else if (datatype.equalsIgnoreCase("float")) {
            float sum = numbers[0].floatValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum %= numbers[i].floatValue();
            }
            result = new Float(sum);
        } else if (datatype.equalsIgnoreCase("double")) {
            double sum = numbers[0].doubleValue();
            for (int i = 1; i < numbers.length; ++i) {
                sum %= numbers[i].doubleValue();
            }
            result = new Double(sum);
        }
        return result;
    }

    public static final Number convert(Number n, String datatype) {
        if (datatype == null) {
            datatype = "double";
        }
        if (datatype.equals("int")) {
            return new Integer(n.intValue());
        }
        if (datatype.equals("long")) {
            return new Long(n.longValue());
        }
        if (datatype.equals("float")) {
            return new Float(n.floatValue());
        }
        if (datatype.equals("double")) {
            return new Double(n.doubleValue());
        }
        throw new BuildException("Invalid datatype.");
    }

    public static final Number execute(String method, String datatype, boolean strict, Class[] paramTypes, Object[] params) {
        try {
            Class<?> c = null;
            c = strict ? Thread.currentThread().getContextClassLoader().loadClass("java.lang.StrictMath") : Thread.currentThread().getContextClassLoader().loadClass("java.lang.Math");
            Method m = c.getDeclaredMethod(method, paramTypes);
            Number n = (Number)m.invoke(null, params);
            return Math.convert(n, datatype);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static final Number random(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.execute("random", datatype, strict, new Class[0], new Object[0]);
    }

    public static Class getPrimitiveClass(String datatype) {
        if (datatype == null) {
            return Double.TYPE;
        }
        if (datatype.equals("int")) {
            return Integer.TYPE;
        }
        if (datatype.equals("long")) {
            return Long.TYPE;
        }
        if (datatype.equals("float")) {
            return Float.TYPE;
        }
        if (datatype.equals("double")) {
            return Double.TYPE;
        }
        throw new BuildException("Invalid datatype.");
    }

    public static final Number abs(String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), datatype)};
        Class[] params = new Class[]{Math.getPrimitiveClass(datatype)};
        return Math.execute("abs", datatype, strict, params, ops);
    }

    private static final Number doOneDoubleArg(String operation, String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), "double")};
        Class[] params = new Class[]{Double.TYPE};
        return Math.execute(operation, datatype, strict, params, ops);
    }

    public static final Number acos(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("acos", datatype, strict, operands);
    }

    public static final Number asin(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("asin", datatype, strict, operands);
    }

    public static final Number atan(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("atan", datatype, strict, operands);
    }

    public static final Number atan2(String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), "double"), Math.convert(operands[1].evaluate(), "double")};
        Class[] params = new Class[]{Double.TYPE, Double.TYPE};
        return Math.execute("atan2", datatype, strict, params, ops);
    }

    public static final Number sin(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("sin", datatype, strict, operands);
    }

    public static final Number tan(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("sin", datatype, strict, operands);
    }

    public static final Number cos(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("cos", datatype, strict, operands);
    }

    public static final Number ceil(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("ceil", datatype, strict, operands);
    }

    public static final Number floor(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("floor", datatype, strict, operands);
    }

    public static final Number exp(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("exp", datatype, strict, operands);
    }

    public static final Number rint(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("rint", datatype, strict, operands);
    }

    public static final Number round(String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), datatype)};
        Class[] params = new Class[]{Math.getPrimitiveClass(datatype)};
        return Math.execute("round", datatype, strict, params, ops);
    }

    public static final Number sqrt(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("sqrt", datatype, strict, operands);
    }

    public static final Number degrees(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.todegrees(datatype, strict, operands);
    }

    public static final Number todegrees(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("toDegrees", datatype, strict, operands);
    }

    public static final Number radians(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.toradians(datatype, strict, operands);
    }

    public static final Number toradians(String datatype, boolean strict, Evaluateable[] operands) {
        return Math.doOneDoubleArg("toRadians", datatype, strict, operands);
    }

    public static final Number ieeeremainder(String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), "double"), Math.convert(operands[1].evaluate(), "double")};
        Class[] params = new Class[]{Double.TYPE, Double.TYPE};
        return Math.execute("IEEERemainder", datatype, strict, params, ops);
    }

    public static final Number min(String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), datatype), Math.convert(operands[1].evaluate(), datatype)};
        Class[] params = new Class[]{Math.getPrimitiveClass(datatype), Math.getPrimitiveClass(datatype)};
        return Math.execute("min", datatype, strict, params, ops);
    }

    public static final Number max(String datatype, boolean strict, Evaluateable[] operands) {
        Object[] ops = new Object[]{Math.convert(operands[0].evaluate(), datatype), Math.convert(operands[1].evaluate(), datatype)};
        Class[] params = new Class[]{Math.getPrimitiveClass(datatype), Math.getPrimitiveClass(datatype)};
        return Math.execute("max", datatype, strict, params, ops);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

