/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.transformer;

import org.apache.commons.lang.StringUtils;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.transformer.impl.XpathTransformer;

public abstract class AbstractFessXpathTransformer extends XpathTransformer {
    public int maxSiteLength = 50;

    public String unknownHostname = "unknown";

    protected String getHost(String url) {
        if (StringUtil.isBlank(url)) {
            return ""; // empty
        }

        String originalUrl = url;

        int idx = url.indexOf("://");
        if (idx >= 0) {
            url = url.substring(idx + 3);
        }

        idx = url.indexOf("/");
        if (idx >= 0) {
            url = url.substring(0, idx);
        }

        if (url.equals(originalUrl)) {
            return unknownHostname;
        }

        return url;
    }

    protected String getSite(String url) {
        if (StringUtil.isBlank(url)) {
            return ""; // empty
        }

        int idx = url.indexOf("://");
        if (idx >= 0) {
            url = url.substring(idx + 3);
        }

        idx = url.indexOf("?");
        if (idx >= 0) {
            url = url.substring(0, idx);
        }

        return StringUtils.abbreviate(url, maxSiteLength);
    }

    protected String normalizeContent(String content) {
        return content.replaceAll("\\s+", " ");
    }
}