DROP TABLE IF EXISTS DATA_CONFIG_TO_BROWSER_TYPE_MAPPING;
DROP TABLE IF EXISTS DATA_CONFIG_TO_LABEL_TYPE_MAPPING;
DROP TABLE IF EXISTS DATA_CONFIG_TO_ROLE_TYPE_MAPPING;
DROP TABLE IF EXISTS DATA_CRAWLING_CONFIG;
DROP TABLE IF EXISTS WEB_CONFIG_TO_ROLE_TYPE_MAPPING;
DROP TABLE IF EXISTS FILE_CONFIG_TO_ROLE_TYPE_MAPPING;
DROP TABLE IF EXISTS ROLE_TYPE;
DROP TABLE IF EXISTS WEB_CONFIG_TO_LABEL_TYPE_MAPPING;
DROP TABLE IF EXISTS FILE_CONFIG_TO_LABEL_TYPE_MAPPING;
DROP TABLE IF EXISTS LABEL_TYPE;
DROP TABLE IF EXISTS CRAWLING_SESSION_INFO;
DROP TABLE IF EXISTS WEB_AUTHENTICATION;
DROP TABLE IF EXISTS REQUEST_HEADER;
DROP TABLE IF EXISTS OVERLAPPING_HOST;
DROP TABLE IF EXISTS CRAWLING_SESSION;
DROP TABLE IF EXISTS PATH_MAPPING;
DROP TABLE IF EXISTS FILE_CONFIG_TO_BROWSER_TYPE_MAPPING;
DROP TABLE IF EXISTS WEB_CONFIG_TO_BROWSER_TYPE_MAPPING;
DROP TABLE IF EXISTS FILE_CRAWLING_CONFIG;
DROP TABLE IF EXISTS BROWSER_TYPE;
DROP TABLE IF EXISTS WEB_CRAWLING_CONFIG;

/**********************************/
/* Table Name: Web Crawling Config */
/**********************************/
CREATE TABLE WEB_CRAWLING_CONFIG(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(200) NOT NULL,
  URLS VARCHAR(4000) NOT NULL,
  INCLUDED_URLS VARCHAR(4000),
  EXCLUDED_URLS VARCHAR(4000),
  INCLUDED_DOC_URLS VARCHAR(4000),
  EXCLUDED_DOC_URLS VARCHAR(4000),
  DEPTH INTEGER,
  MAX_ACCESS_COUNT BIGINT,
  USER_AGENT VARCHAR(200) NOT NULL,
  NUM_OF_THREAD INTEGER NOT NULL,
  INTERVAL_TIME INTEGER NOT NULL,
  BOOST FLOAT NOT NULL,
  AVAILABLE VARCHAR(1) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: Browser Type */
/**********************************/
CREATE TABLE BROWSER_TYPE(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(100) NOT NULL,
  VALUE VARCHAR(20) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: File Crawling Config */
/**********************************/
CREATE TABLE FILE_CRAWLING_CONFIG(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(200) NOT NULL,
  PATHS VARCHAR(4000) NOT NULL,
  INCLUDED_PATHS VARCHAR(4000),
  EXCLUDED_PATHS VARCHAR(4000),
  INCLUDED_DOC_PATHS VARCHAR(4000),
  EXCLUDED_DOC_PATHS VARCHAR(4000),
  DEPTH INTEGER,
  MAX_ACCESS_COUNT BIGINT,
  NUM_OF_THREAD INTEGER NOT NULL,
  INTERVAL_TIME INTEGER NOT NULL,
  BOOST FLOAT NOT NULL,
  AVAILABLE VARCHAR(1) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: Web To Browser Mapping */
/**********************************/
CREATE TABLE WEB_CONFIG_TO_BROWSER_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  WEB_CONFIG_ID BIGINT NOT NULL,
  BROWSER_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID),
  FOREIGN KEY (BROWSER_TYPE_ID) REFERENCES BROWSER_TYPE (ID)
);

/**********************************/
/* Table Name: File To Browser Mapping */
/**********************************/
CREATE TABLE FILE_CONFIG_TO_BROWSER_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  FILE_CONFIG_ID BIGINT NOT NULL,
  BROWSER_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID),
  FOREIGN KEY (BROWSER_TYPE_ID) REFERENCES BROWSER_TYPE (ID)
);

/**********************************/
/* Table Name: Path Mapping */
/**********************************/
CREATE TABLE PATH_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  REGEX VARCHAR(1000) NOT NULL,
  REPLACEMENT VARCHAR(1000) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: Crawling Session */
/**********************************/
CREATE TABLE CRAWLING_SESSION(
  ID IDENTITY NOT NULL PRIMARY KEY,
  SESSION_ID VARCHAR(20) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL
);

/**********************************/
/* Table Name: Overlapping Host */
/**********************************/
CREATE TABLE OVERLAPPING_HOST(
  ID IDENTITY NOT NULL PRIMARY KEY,
  REGULAR_NAME VARCHAR(1000) NOT NULL,
  OVERLAPPING_NAME VARCHAR(1000) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: Request Header */
/**********************************/
CREATE TABLE REQUEST_HEADER(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(100) NOT NULL,
  VALUE VARCHAR(1000) NOT NULL,
  WEB_CRAWLING_CONFIG_ID BIGINT NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL,
  FOREIGN KEY (WEB_CRAWLING_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

/**********************************/
/* Table Name: Web Authentication */
/**********************************/
CREATE TABLE WEB_AUTHENTICATION(
  ID IDENTITY NOT NULL PRIMARY KEY,
  HOSTNAME VARCHAR(100),
  PORT INTEGER NOT NULL,
  AUTH_REALM VARCHAR(100),
  PROTOCOL_SCHEME VARCHAR(10),
  USERNAME VARCHAR(100) NOT NULL,
  PASSWORD VARCHAR(100),
  WEB_CRAWLING_CONFIG_ID BIGINT NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL,
  FOREIGN KEY (WEB_CRAWLING_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

/**********************************/
/* Table Name: Crawling Session Info */
/**********************************/
CREATE TABLE CRAWLING_SESSION_INFO(
  ID IDENTITY NOT NULL PRIMARY KEY,
  CRAWLING_SESSION_ID BIGINT NOT NULL,
  KEY VARCHAR(20) NOT NULL,
  VALUE VARCHAR(100) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  FOREIGN KEY (CRAWLING_SESSION_ID) REFERENCES CRAWLING_SESSION (ID)
);

/**********************************/
/* Table Name: Label Type */
/**********************************/
CREATE TABLE LABEL_TYPE(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(100) NOT NULL,
  VALUE VARCHAR(20) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: File To Label Mapping */
/**********************************/
CREATE TABLE FILE_CONFIG_TO_LABEL_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  FILE_CONFIG_ID BIGINT NOT NULL,
  LABEL_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID),
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID)
);

/**********************************/
/* Table Name: Web To Label Mapping */
/**********************************/
CREATE TABLE WEB_CONFIG_TO_LABEL_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  WEB_CONFIG_ID BIGINT NOT NULL,
  LABEL_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID),
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID)
);

/**********************************/
/* Table Name: Role Type */
/**********************************/
CREATE TABLE ROLE_TYPE(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(100) NOT NULL,
  VALUE VARCHAR(20) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: File To Role Mapping */
/**********************************/
CREATE TABLE FILE_CONFIG_TO_ROLE_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  FILE_CONFIG_ID BIGINT NOT NULL,
  ROLE_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (FILE_CONFIG_ID) REFERENCES FILE_CRAWLING_CONFIG (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

/**********************************/
/* Table Name: Web To Role Mapping */
/**********************************/
CREATE TABLE WEB_CONFIG_TO_ROLE_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  WEB_CONFIG_ID BIGINT NOT NULL,
  ROLE_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (WEB_CONFIG_ID) REFERENCES WEB_CRAWLING_CONFIG (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

/**********************************/
/* Table Name: Data Crawling Config */
/**********************************/
CREATE TABLE DATA_CRAWLING_CONFIG(
  ID IDENTITY NOT NULL PRIMARY KEY,
  NAME VARCHAR(200) NOT NULL,
  HANDLER_NAME VARCHAR(200) NOT NULL,
  HANDLER_PARAMETER VARCHAR(4000),
  HANDLER_SCRIPT VARCHAR(4000),
  BOOST FLOAT NOT NULL,
  AVAILABLE VARCHAR(1) NOT NULL,
  SORT_ORDER INTEGER NOT NULL,
  CREATED_BY VARCHAR(255) NOT NULL,
  CREATED_TIME TIMESTAMP NOT NULL,
  UPDATED_BY VARCHAR(255),
  UPDATED_TIME TIMESTAMP,
  DELETED_BY VARCHAR(255),
  DELETED_TIME TIMESTAMP,
  VERSION_NO INTEGER NOT NULL
);

/**********************************/
/* Table Name: Data To Role Mapping */
/**********************************/
CREATE TABLE DATA_CONFIG_TO_ROLE_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  DATA_CONFIG_ID BIGINT NOT NULL,
  ROLE_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (DATA_CONFIG_ID) REFERENCES DATA_CRAWLING_CONFIG (ID),
  FOREIGN KEY (ROLE_TYPE_ID) REFERENCES ROLE_TYPE (ID)
);

/**********************************/
/* Table Name: Data To Label Mapping */
/**********************************/
CREATE TABLE DATA_CONFIG_TO_LABEL_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  DATA_CONFIG_ID BIGINT NOT NULL,
  LABEL_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (DATA_CONFIG_ID) REFERENCES DATA_CRAWLING_CONFIG (ID),
  FOREIGN KEY (LABEL_TYPE_ID) REFERENCES LABEL_TYPE (ID)
);

/**********************************/
/* Table Name: Data To Browser Mapping */
/**********************************/
CREATE TABLE DATA_CONFIG_TO_BROWSER_TYPE_MAPPING(
  ID IDENTITY NOT NULL PRIMARY KEY,
  DATA_CONFIG_ID BIGINT NOT NULL,
  BROWSER_TYPE_ID BIGINT NOT NULL,
  FOREIGN KEY (DATA_CONFIG_ID) REFERENCES DATA_CRAWLING_CONFIG (ID),
  FOREIGN KEY (BROWSER_TYPE_ID) REFERENCES BROWSER_TYPE (ID)
);


CREATE INDEX IDX_WEB_CONFIG_TO_BROWSER_TYPE_MAPPING_FOR_WEB_CONFIG ON WEB_CONFIG_TO_BROWSER_TYPE_MAPPING (WEB_CONFIG_ID);

CREATE INDEX IDX_FILE_CONFIG_TO_BROWSER_TYPE_MAPPING_FOR_FILE_CONFIG ON FILE_CONFIG_TO_BROWSER_TYPE_MAPPING (FILE_CONFIG_ID);

CREATE INDEX IDX_OVERLAPPING_HOST_BY_REGULAR_NAME_AND_SORT_ORDER ON OVERLAPPING_HOST (REGULAR_NAME, SORT_ORDER);

CREATE INDEX IDX_FILE_CONFIG_TO_LABEL_TYPE_MAPPING_FOR_FILE_CONFIG ON FILE_CONFIG_TO_LABEL_TYPE_MAPPING (FILE_CONFIG_ID);

CREATE INDEX IDX_WEB_CONFIG_TO_LABEL_TYPE_MAPPING__FOR_WEB_CONFIG ON WEB_CONFIG_TO_LABEL_TYPE_MAPPING (WEB_CONFIG_ID);

CREATE INDEX IDX_FILE_CONFIG_TO_ROLE_TYPE_MAPPING_FOR_FILE_CONFIG ON FILE_CONFIG_TO_ROLE_TYPE_MAPPING (FILE_CONFIG_ID);

CREATE INDEX IDX_WEB_CONFIG_TO_ROLE_TYPE_MAPPING_FOR_WEB_CONFIG ON WEB_CONFIG_TO_ROLE_TYPE_MAPPING (WEB_CONFIG_ID);

CREATE INDEX IDX_DATA_CONFIG_TO_ROLE_TYPE_MAPPING_FOR_DATA_CONFIG ON DATA_CONFIG_TO_ROLE_TYPE_MAPPING (DATA_CONFIG_ID);

CREATE INDEX IDX_DATA_CONFIG_TO_LABEL_TYPE_MAPPING_FOR_DATA_CONFIG ON DATA_CONFIG_TO_LABEL_TYPE_MAPPING (DATA_CONFIG_ID);

CREATE INDEX IDX_DATA_CONFIG_TO_BROWSER_TYPE_MAPPING_FOR_DATA_CONFIG ON DATA_CONFIG_TO_BROWSER_TYPE_MAPPING (DATA_CONFIG_ID);


INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (1, 'PC', 'pc', 1, 'admin', '2000-01-01 00:00:00', 1);
INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (2, 'DoCoMo', 'docomo', 2, 'admin', '2000-01-01 00:00:00', 1);
INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (3, 'au', 'au', 3, 'admin', '2000-01-01 00:00:00', 1);
INSERT INTO BROWSER_TYPE (ID, NAME, VALUE, SORT_ORDER, CREATED_BY, CREATED_TIME, VERSION_NO) VALUES (4, 'Softbank', 'softbank', 4, 'admin', '2000-01-01 00:00:00', 1);


