/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.OverlappingHostDbm;
import jp.sf.fess.db.cbean.OverlappingHostCB;
import jp.sf.fess.db.exentity.OverlappingHost;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of OVERLAPPING_HOST as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, REGULAR_NAME, OVERLAPPING_NAME, SORT_ORDER, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsOverlappingHostBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "OVERLAPPING_HOST";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return OverlappingHostDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public OverlappingHostDbm getMyDBMeta() {
        return OverlappingHostDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public OverlappingHost newMyEntity() {
        return new OverlappingHost();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public OverlappingHostCB newMyConditionBean() {
        return new OverlappingHostCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * int count = overlappingHostBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The selected count.
     */
    public int selectCount(OverlappingHostCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(OverlappingHostCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * overlappingHostBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;OverlappingHost&gt;() {
     *     public void handle(OverlappingHost entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @param entityRowHandler The handler of entity row of OverlappingHost. (NotNull)
     */
    public void selectCursor(OverlappingHostCB cb,
            EntityRowHandler<OverlappingHost> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> void doSelectCursor(
            OverlappingHostCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<OverlappingHost>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * OverlappingHost overlappingHost = overlappingHostBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (overlappingHost != null) {
     *     ... = overlappingHost.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public OverlappingHost selectEntity(OverlappingHostCB cb) {
        return doSelectEntity(cb, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> ENTITY doSelectEntity(
            final OverlappingHostCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, OverlappingHostCB>() {
                    public List<ENTITY> callbackSelectList(OverlappingHostCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * OverlappingHost overlappingHost = overlappingHostBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = overlappingHost.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public OverlappingHost selectEntityWithDeletedCheck(OverlappingHostCB cb) {
        return doSelectEntityWithDeletedCheck(cb, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> ENTITY doSelectEntityWithDeletedCheck(
            final OverlappingHostCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, OverlappingHostCB>() {
                    public List<ENTITY> callbackSelectList(OverlappingHostCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public OverlappingHost selectByPKValue(Long id) {
        return doSelectByPKValue(id, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public OverlappingHost selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private OverlappingHostCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        OverlappingHostCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;OverlappingHost&gt; overlappingHostList = overlappingHostBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (OverlappingHost overlappingHost : overlappingHostList) {
     *     ... = overlappingHost.get...();
     * }
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<OverlappingHost> selectList(OverlappingHostCB cb) {
        return doSelectList(cb, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> ListResultBean<ENTITY> doSelectList(
            OverlappingHostCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, OverlappingHostCB>() {
                    public List<ENTITY> callbackSelectList(
                            OverlappingHostCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;OverlappingHost&gt; page = overlappingHostBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (OverlappingHost overlappingHost : page) {
     *     ... = overlappingHost.get...();
     * }
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<OverlappingHost> selectPage(OverlappingHostCB cb) {
        return doSelectPage(cb, OverlappingHost.class);
    }

    protected <ENTITY extends OverlappingHost> PagingResultBean<ENTITY> doSelectPage(
            OverlappingHostCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, OverlappingHostCB>() {
                    public int callbackSelectCount(OverlappingHostCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            OverlappingHostCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * overlappingHostBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(OverlappingHostCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<OverlappingHostCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends OverlappingHostCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * overlappingHost.setFoo...(value);
     * overlappingHost.setBar...(value);
     * overlappingHostBhv.<span style="color: #FD4747">insert</span>(overlappingHost);
     * ... = overlappingHost.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param overlappingHost The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(OverlappingHost overlappingHost) {
        assertEntityNotNull(overlappingHost);
        delegateInsert(overlappingHost);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * overlappingHost.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * overlappingHost.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     overlappingHostBhv.<span style="color: #FD4747">update</span>(overlappingHost);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param overlappingHost The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final OverlappingHost overlappingHost) {
        helpUpdateInternally(overlappingHost,
                new InternalUpdateCallback<OverlappingHost>() {
                    public int callbackDelegateUpdate(OverlappingHost entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * overlappingHost.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//overlappingHost.setVersionNo(value);</span>
     * overlappingHostBhv.<span style="color: #FD4747">updateNonstrict</span>(overlappingHost);
     * </pre>
     * @param overlappingHost The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final OverlappingHost overlappingHost) {
        helpUpdateNonstrictInternally(overlappingHost,
                new InternalUpdateNonstrictCallback<OverlappingHost>() {
                    public int callbackDelegateUpdateNonstrict(
                            OverlappingHost entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param overlappingHost The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final OverlappingHost overlappingHost) {
        helpInsertOrUpdateInternally(
                overlappingHost,
                new InternalInsertOrUpdateCallback<OverlappingHost, OverlappingHostCB>() {
                    public void callbackInsert(OverlappingHost entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(OverlappingHost entity) {
                        update(entity);
                    }

                    public OverlappingHostCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(OverlappingHostCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param overlappingHost The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(OverlappingHost overlappingHost) {
        helpInsertOrUpdateInternally(overlappingHost,
                new InternalInsertOrUpdateNonstrictCallback<OverlappingHost>() {
                    public void callbackInsert(OverlappingHost entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(OverlappingHost entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * overlappingHost.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     overlappingHostBhv.<span style="color: #FD4747">delete</span>(overlappingHost);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param overlappingHost The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(OverlappingHost overlappingHost) {
        helpDeleteInternally(overlappingHost,
                new InternalDeleteCallback<OverlappingHost>() {
                    public int callbackDelegateDelete(OverlappingHost entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//overlappingHost.setVersionNo(value);</span>
     * overlappingHostBhv.<span style="color: #FD4747">deleteNonstrict</span>(overlappingHost);
     * </pre>
     * @param overlappingHost Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(OverlappingHost overlappingHost) {
        helpDeleteNonstrictInternally(overlappingHost,
                new InternalDeleteNonstrictCallback<OverlappingHost>() {
                    public int callbackDelegateDeleteNonstrict(
                            OverlappingHost entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//overlappingHost.setVersionNo(value);</span>
     * overlappingHostBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(overlappingHost);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param overlappingHost Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(OverlappingHost overlappingHost) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                overlappingHost,
                new InternalDeleteNonstrictIgnoreDeletedCallback<OverlappingHost>() {
                    public int callbackDelegateDeleteNonstrict(
                            OverlappingHost entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param overlappingHostList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<OverlappingHost> overlappingHostList) {
        assertObjectNotNull("overlappingHostList", overlappingHostList);
        return delegateInsertList(overlappingHostList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param overlappingHostList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<OverlappingHost> overlappingHostList) {
        assertObjectNotNull("overlappingHostList", overlappingHostList);
        return delegateUpdateList(overlappingHostList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param overlappingHostList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<OverlappingHost> overlappingHostList) {
        assertObjectNotNull("overlappingHostList", overlappingHostList);
        return delegateUpdateListNonstrict(overlappingHostList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param overlappingHostList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<OverlappingHost> overlappingHostList) {
        assertObjectNotNull("overlappingHostList", overlappingHostList);
        return delegateDeleteList(overlappingHostList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param overlappingHostList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<OverlappingHost> overlappingHostList) {
        assertObjectNotNull("overlappingHostList", overlappingHostList);
        return delegateDeleteListNonstrict(overlappingHostList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//overlappingHost.setPK...(value);</span>
     * overlappingHost.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//overlappingHost.setVersionNo(value);</span>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * overlappingHostBhv.<span style="color: #FD4747">queryUpdate</span>(overlappingHost, cb);
     * </pre>
     * @param overlappingHost The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(OverlappingHost overlappingHost, OverlappingHostCB cb) {
        return delegateQueryUpdate(overlappingHost, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * overlappingHostBhv.<span style="color: #FD4747">queryDelete</span>(overlappingHost, cb);
     * </pre>
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(OverlappingHostCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * overlappingHost.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * overlappingHost.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;OverlappingHostCB&gt; option = new UpdateOption&lt;OverlappingHostCB&gt;();
     *     option.self(new SpecifyQuery&lt;OverlappingHostCB&gt;() {
     *         public void specify(OverlappingHostCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     overlappingHostBhv.<span style="color: #FD4747">varyingUpdate</span>(overlappingHost, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param overlappingHost The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(OverlappingHost overlappingHost,
            final UpdateOption<OverlappingHostCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(overlappingHost,
                new InternalUpdateCallback<OverlappingHost>() {
                    public int callbackDelegateUpdate(OverlappingHost entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * overlappingHost.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * overlappingHost.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//overlappingHost.setVersionNo(value);</span>
     * UpdateOption&lt;OverlappingHostCB&gt; option = new UpdateOption&lt;OverlappingHostCB&gt;();
     * option.self(new SpecifyQuery&lt;OverlappingHostCB&gt;() {
     *     public void specify(OverlappingHostCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * overlappingHostBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(overlappingHost, option);
     * </pre>
     * @param overlappingHost The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(OverlappingHost overlappingHost,
            final UpdateOption<OverlappingHostCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(overlappingHost,
                new InternalUpdateNonstrictCallback<OverlappingHost>() {
                    public int callbackDelegateUpdateNonstrict(
                            OverlappingHost entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * OverlappingHost overlappingHost = new OverlappingHost();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//overlappingHost.setPK...(value);</span>
     * overlappingHost.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//overlappingHost.setVersionNo(value);</span>
     * OverlappingHostCB cb = new OverlappingHostCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;OverlappingHostCB&gt; option = new UpdateOption&lt;OverlappingHostCB&gt;();
     * option.self(new SpecifyQuery&lt;OverlappingHostCB&gt;() {
     *     public void specify(OverlappingHostCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * overlappingHostBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(overlappingHost, cb, option);
     * </pre>
     * @param overlappingHost The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of OverlappingHost. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(OverlappingHost overlappingHost,
            OverlappingHostCB cb, final UpdateOption<OverlappingHostCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(overlappingHost, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<OverlappingHostCB> option) {
        assertUpdateOptionNotNull(option);
        OverlappingHostCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(OverlappingHostCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends OverlappingHost> void delegateSelectCursor(
            OverlappingHostCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends OverlappingHost> List<ENTITY> delegateSelectList(
            OverlappingHostCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(OverlappingHost e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(OverlappingHost e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(OverlappingHost e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(OverlappingHost e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(OverlappingHost e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<OverlappingHost> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<OverlappingHost> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<OverlappingHost> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<OverlappingHost> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<OverlappingHost> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(OverlappingHost e, OverlappingHostCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(OverlappingHostCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(OverlappingHost e,
            UpdateOption<OverlappingHostCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(OverlappingHost e,
            UpdateOption<OverlappingHostCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(OverlappingHost e,
            OverlappingHostCB cb, UpdateOption<OverlappingHostCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected OverlappingHost downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, OverlappingHost.class);
    }

    protected OverlappingHostCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, OverlappingHostCB.class);
    }
}
