//
// Copyright 2009-2010 Facebook
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#import "Three20Style/TTStyledFrame.h"

// Core
#import "Three20Core/TTCorePreprocessorMacros.h"


///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
@implementation TTStyledFrame

@synthesize element   = _element;
@synthesize nextFrame = _nextFrame;
@synthesize bounds    = _bounds;


///////////////////////////////////////////////////////////////////////////////////////////////////
- (id)initWithElement:(TTStyledElement*)element {
  if (self = [super init]) {
    _element = element;
    _bounds = CGRectZero;
  }

  return self;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (void)dealloc {
  TT_RELEASE_SAFELY(_nextFrame);

  [super dealloc];
}


///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark -
#pragma mark Public


///////////////////////////////////////////////////////////////////////////////////////////////////
- (CGFloat)x {
  return _bounds.origin.x;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (void)setX:(CGFloat)x {
  _bounds.origin.x = x;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (CGFloat)y {
  return _bounds.origin.y;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (void)setY:(CGFloat)y {
  _bounds.origin.y = y;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (CGFloat)width {
  return _bounds.size.width;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (void)setWidth:(CGFloat)width {
  _bounds.size.width = width;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (CGFloat)height {
  return _bounds.size.height;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (void)setHeight:(CGFloat)height {
  _bounds.size.height = height;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (UIFont*)font {
  return nil;
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (void)drawInRect:(CGRect)rect {
}


///////////////////////////////////////////////////////////////////////////////////////////////////
- (TTStyledBoxFrame*)hitTest:(CGPoint)point {
  return [_nextFrame hitTest:point];
}


@end
