/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.bsentity.dbmeta.FileConfigToRoleTypeMappingDbm;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.db.exentity.RoleType;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementConfig;

/**
 * The behavior of FILE_CONFIG_TO_ROLE_TYPE_MAPPING that the type is TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, FILE_CONFIG_ID, ROLE_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     FILE_CRAWLING_CONFIG, ROLE_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     fileCrawlingConfig, roleType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileConfigToRoleTypeMappingBhv extends
        org.seasar.dbflute.bhv.AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_CONFIG_TO_ROLE_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileConfigToRoleTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileConfigToRoleTypeMappingDbm getMyDBMeta() {
        return FileConfigToRoleTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    public Entity newEntity() {
        return newMyEntity();
    }

    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    public FileConfigToRoleTypeMapping newMyEntity() {
        return new FileConfigToRoleTypeMapping();
    }

    public FileConfigToRoleTypeMappingCB newMyConditionBean() {
        return new FileConfigToRoleTypeMappingCB();
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    protected DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                             Default StatementConfig
    //                                                             =======================
    @Override
    protected StatementConfig getDefaultStatementConfig() {
        return DBFluteConfig.getInstance().getDefaultStatementConfig();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean. <br />
     * Attention: It has a mapping cost from result set to entity.
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of FileConfigToRoleTypeMapping. (NotNull)
     */
    public void selectCursor(FileConfigToRoleTypeMappingCB cb,
            EntityRowHandler<FileConfigToRoleTypeMapping> entityRowHandler) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileConfigToRoleTypeMapping>",
                entityRowHandler);
        delegateSelectCursor(cb, entityRowHandler);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (Nullalble)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public FileConfigToRoleTypeMapping selectEntity(
            final FileConfigToRoleTypeMappingCB cb) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<FileConfigToRoleTypeMapping, FileConfigToRoleTypeMappingCB>() {
                    public List<FileConfigToRoleTypeMapping> callbackSelectList(
                            FileConfigToRoleTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public FileConfigToRoleTypeMapping selectEntityWithDeletedCheck(
            final FileConfigToRoleTypeMappingCB cb) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<FileConfigToRoleTypeMapping, FileConfigToRoleTypeMappingCB>() {
                    public List<FileConfigToRoleTypeMapping> callbackSelectList(
                            FileConfigToRoleTypeMappingCB cb) {
                        return selectList(cb);
                    }
                });
    }

    /* (non-javadoc)
     * Select the entity with deleted check. {by primary-key value}
     * @param primaryKey The keys of primary.
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public FileConfigToRoleTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        FileConfigToRoleTypeMapping entity = new FileConfigToRoleTypeMapping();
        entity.setId(id);
        final FileConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.acceptPrimaryKeyMapString(getDBMeta().extractPrimaryKeyMapString(
                entity));
        return selectEntityWithDeletedCheck(cb);
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     */
    public ListResultBean<FileConfigToRoleTypeMapping> selectList(
            FileConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return new ResultBeanBuilder<FileConfigToRoleTypeMapping>(
                getTableDbName()).buildListResultBean(cb,
                delegateSelectList(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean.
     * @param cb The condition-bean of FileConfigToRoleTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     */
    public PagingResultBean<FileConfigToRoleTypeMapping> selectPage(
            final FileConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        final PagingInvoker<FileConfigToRoleTypeMapping> invoker = new PagingInvoker<FileConfigToRoleTypeMapping>(
                getTableDbName());
        final PagingHandler<FileConfigToRoleTypeMapping> handler = new PagingHandler<FileConfigToRoleTypeMapping>() {
            public PagingBean getPagingBean() {
                return cb;
            }

            public int count() {
                return selectCount(cb);
            }

            public List<FileConfigToRoleTypeMapping> paging() {
                return selectList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * Call a function method after this method called like as follows:
     * <pre>
     * fileConfigToRoleTypeMappingBhv.scalarSelect(Date.class).max(new ScalarQuery(FileConfigToRoleTypeMappingCB cb) {
     *     cb.specify().columnXxxDatetime(); // the required specification of target column
     *     cb.query().setXxxName_PrefixSearch("S"); // query as you like it
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<FileConfigToRoleTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        FileConfigToRoleTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<FileConfigToRoleTypeMappingCB, RESULT>(cb,
                resultType);
    }

    // ===================================================================================
    //                                                                       Load Referrer
    //                                                                       =============
    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param fileConfigToRoleTypeMappingList The list of fileConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToRoleTypeMappingList,
                new InternalPulloutCallback<FileConfigToRoleTypeMapping, FileCrawlingConfig>() {
                    public FileCrawlingConfig callbackGetForeignEntity(
                            FileConfigToRoleTypeMapping entity) {
                        return entity.getFileCrawlingConfig();
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'RoleType'.
     * @param fileConfigToRoleTypeMappingList The list of fileConfigToRoleTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<RoleType> pulloutRoleType(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToRoleTypeMappingList,
                new InternalPulloutCallback<FileConfigToRoleTypeMapping, RoleType>() {
                    public RoleType callbackGetForeignEntity(
                            FileConfigToRoleTypeMapping entity) {
                        return entity.getRoleType();
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * @param fileConfigToRoleTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        assertEntityNotNull(fileConfigToRoleTypeMapping);
        delegateInsert(fileConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreate(Entity fileConfigToRoleTypeMapping) {
        insert((FileConfigToRoleTypeMapping) fileConfigToRoleTypeMapping);
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ConcurrencyControl}
     * @param fileConfigToRoleTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        helpUpdateInternally(fileConfigToRoleTypeMapping,
                new InternalUpdateCallback<FileConfigToRoleTypeMapping>() {
                    public int callbackDelegateUpdate(
                            FileConfigToRoleTypeMapping entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update((FileConfigToRoleTypeMapping) entity);
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update((FileConfigToRoleTypeMapping) entity);
    }

    /**
     * Insert or update the entity modified-only. {ConcurrencyControl(when update)}
     * @param fileConfigToRoleTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            final FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        helpInsertOrUpdateInternally(
                fileConfigToRoleTypeMapping,
                new InternalInsertOrUpdateCallback<FileConfigToRoleTypeMapping, FileConfigToRoleTypeMappingCB>() {
                    public void callbackInsert(
                            FileConfigToRoleTypeMapping entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(
                            FileConfigToRoleTypeMapping entity) {
                        update(entity);
                    }

                    public FileConfigToRoleTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            FileConfigToRoleTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity fileConfigToRoleTypeMapping) {
        insertOrUpdate((FileConfigToRoleTypeMapping) fileConfigToRoleTypeMapping);
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate((FileConfigToRoleTypeMapping) entity);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ConcurrencyControl}
     * @param fileConfigToRoleTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping) {
        helpDeleteInternally(fileConfigToRoleTypeMapping,
                new InternalDeleteCallback<FileConfigToRoleTypeMapping>() {
                    public int callbackDelegateDelete(
                            FileConfigToRoleTypeMapping entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity fileConfigToRoleTypeMapping) {
        delete((FileConfigToRoleTypeMapping) fileConfigToRoleTypeMapping);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch insert the list. This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        assertObjectNotNull("fileConfigToRoleTypeMappingList",
                fileConfigToRoleTypeMappingList);
        return delegateInsertList(fileConfigToRoleTypeMappingList);
    }

    /**
     * Batch update the list. All columns are update target. {NOT modified only} <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        assertObjectNotNull("fileConfigToRoleTypeMappingList",
                fileConfigToRoleTypeMappingList);
        return delegateUpdateList(fileConfigToRoleTypeMappingList);
    }

    /**
     * Batch delete the list. <br />
     * This method use 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToRoleTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<FileConfigToRoleTypeMapping> fileConfigToRoleTypeMappingList) {
        assertObjectNotNull("fileConfigToRoleTypeMappingList",
                fileConfigToRoleTypeMappingList);
        return delegateDeleteList(fileConfigToRoleTypeMappingList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query update the several entities. {NoConcurrencyControl}
     * @param fileConfigToRoleTypeMapping Entity. (NotNull) {PrimaryKeyNotRequired}
     * @param cb Condition-bean. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(
            FileConfigToRoleTypeMapping fileConfigToRoleTypeMapping,
            FileConfigToRoleTypeMappingCB cb) {
        assertObjectNotNull("fileConfigToRoleTypeMapping",
                fileConfigToRoleTypeMapping);
        assertCBNotNull(cb);
        setupCommonColumnOfUpdateIfNeeds(fileConfigToRoleTypeMapping);
        filterEntityOfUpdate(fileConfigToRoleTypeMapping);
        assertEntityOfUpdate(fileConfigToRoleTypeMapping);
        return invoke(createQueryUpdateEntityCBCommand(
                fileConfigToRoleTypeMapping, cb));
    }

    /**
     * Query delete the several entities. {NoConcurrencyControl}
     * @param cb Condition-bean. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(FileConfigToRoleTypeMappingCB cb) {
        assertCBNotNull(cb);
        return invoke(createQueryDeleteCBCommand(cb));
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(FileConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected void delegateSelectCursor(FileConfigToRoleTypeMappingCB cb,
            EntityRowHandler<FileConfigToRoleTypeMapping> entityRowHandler) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler,
                FileConfigToRoleTypeMapping.class));
    }

    protected int doCallReadCount(ConditionBean cb) {
        return delegateSelectCount((FileConfigToRoleTypeMappingCB) cb);
    }

    protected List<FileConfigToRoleTypeMapping> delegateSelectList(
            FileConfigToRoleTypeMappingCB cb) {
        return invoke(createSelectListCBCommand(cb,
                FileConfigToRoleTypeMapping.class));
    }

    @SuppressWarnings("unchecked")
    protected List<Entity> doCallReadList(ConditionBean cb) {
        return (List) delegateSelectList((FileConfigToRoleTypeMappingCB) cb);
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileConfigToRoleTypeMapping e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int doCallCreate(Entity entity) {
        return delegateInsert(downcast(entity));
    }

    protected int delegateUpdate(FileConfigToRoleTypeMapping e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int doCallModify(Entity entity) {
        return delegateUpdate(downcast(entity));
    }

    protected int delegateDelete(FileConfigToRoleTypeMapping e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int doCallRemove(Entity entity) {
        return delegateDelete(downcast(entity));
    }

    protected int[] delegateInsertList(List<FileConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<FileConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<FileConfigToRoleTypeMapping> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                              Helper
    //                                                                              ======
    protected FileConfigToRoleTypeMapping downcast(Entity entity) {
        return helpDowncastInternally(entity, FileConfigToRoleTypeMapping.class);
    }
}
