package jp.sf.fess.interceptor;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.struts.interceptor.ActionMessagesThrowsInterceptor;

public class FessActionMessagesThrowsInterceptor extends
        ActionMessagesThrowsInterceptor {

    private static final String SYSTEM_ERROR_JSP = "/error/system.jsp";

    private static final Log log = LogFactory
            .getLog(FessActionMessagesThrowsInterceptor.class);

    private static final long serialVersionUID = 1L;

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return super.invoke(invocation);
        } catch (Throwable t) {
            log.error("System error occured.", t);
            return SYSTEM_ERROR_JSP;
        }
    }

}
