/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.exentity.WebAuthentication;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of WEB_AUTHENTICATION. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class WebAuthenticationDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final WebAuthenticationDbm _instance = new WebAuthenticationDbm();

    private WebAuthenticationDbm() {
    }

    public static WebAuthenticationDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "WEB_AUTHENTICATION";

    protected final String _tablePropertyName = "webAuthentication";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "WEB_AUTHENTICATION");

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, true, "id",
            Long.class, true, true, "BIGINT", 19, 0, false, null, null, null,
            null, null);

    protected final ColumnInfo _columnHostname = cci("HOSTNAME", "HOSTNAME",
            null, false, "hostname", String.class, false, false, "VARCHAR",
            100, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnPort = cci("PORT", "PORT", null, true,
            "port", Integer.class, false, false, "INTEGER", 10, 0, false, null,
            null, null, null, null);

    protected final ColumnInfo _columnAuthRealm = cci("AUTH_REALM",
            "AUTH_REALM", null, false, "authRealm", String.class, false, false,
            "VARCHAR", 100, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnProtocolScheme = cci("PROTOCOL_SCHEME",
            "PROTOCOL_SCHEME", null, false, "protocolScheme", String.class,
            false, false, "VARCHAR", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnUsername = cci("USERNAME", "USERNAME",
            null, true, "username", String.class, false, false, "VARCHAR", 100,
            0, false, null, null, null, null, null);

    protected final ColumnInfo _columnPassword = cci("PASSWORD", "PASSWORD",
            null, false, "password", String.class, false, false, "VARCHAR",
            100, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnParameters = cci("PARAMETERS",
            "PARAMETERS", null, false, "parameters", String.class, false,
            false, "VARCHAR", 1000, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnWebCrawlingConfigId = cci(
            "WEB_CRAWLING_CONFIG_ID", "WEB_CRAWLING_CONFIG_ID", null, true,
            "webCrawlingConfigId", Long.class, false, false, "BIGINT", 19, 0,
            false, null, null, "webCrawlingConfig", null, null);

    protected final ColumnInfo _columnCreatedBy = cci("CREATED_BY",
            "CREATED_BY", null, true, "createdBy", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnCreatedTime = cci("CREATED_TIME",
            "CREATED_TIME", null, true, "createdTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedBy = cci("UPDATED_BY",
            "UPDATED_BY", null, false, "updatedBy", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnUpdatedTime = cci("UPDATED_TIME",
            "UPDATED_TIME", null, false, "updatedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnDeletedBy = cci("DELETED_BY",
            "DELETED_BY", null, false, "deletedBy", String.class, false, false,
            "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnDeletedTime = cci("DELETED_TIME",
            "DELETED_TIME", null, false, "deletedTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnVersionNo = cci("VERSION_NO",
            "VERSION_NO", null, true, "versionNo", Integer.class, false, false,
            "INTEGER", 10, 0, false, OptimisticLockType.VERSION_NO, null, null,
            null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnHostname() {
        return _columnHostname;
    }

    public ColumnInfo columnPort() {
        return _columnPort;
    }

    public ColumnInfo columnAuthRealm() {
        return _columnAuthRealm;
    }

    public ColumnInfo columnProtocolScheme() {
        return _columnProtocolScheme;
    }

    public ColumnInfo columnUsername() {
        return _columnUsername;
    }

    public ColumnInfo columnPassword() {
        return _columnPassword;
    }

    public ColumnInfo columnParameters() {
        return _columnParameters;
    }

    public ColumnInfo columnWebCrawlingConfigId() {
        return _columnWebCrawlingConfigId;
    }

    public ColumnInfo columnCreatedBy() {
        return _columnCreatedBy;
    }

    public ColumnInfo columnCreatedTime() {
        return _columnCreatedTime;
    }

    public ColumnInfo columnUpdatedBy() {
        return _columnUpdatedBy;
    }

    public ColumnInfo columnUpdatedTime() {
        return _columnUpdatedTime;
    }

    public ColumnInfo columnDeletedBy() {
        return _columnDeletedBy;
    }

    public ColumnInfo columnDeletedTime() {
        return _columnDeletedTime;
    }

    public ColumnInfo columnVersionNo() {
        return _columnVersionNo;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnHostname());
        ls.add(columnPort());
        ls.add(columnAuthRealm());
        ls.add(columnProtocolScheme());
        ls.add(columnUsername());
        ls.add(columnPassword());
        ls.add(columnParameters());
        ls.add(columnWebCrawlingConfigId());
        ls.add(columnCreatedBy());
        ls.add(columnCreatedTime());
        ls.add(columnUpdatedBy());
        ls.add(columnUpdatedTime());
        ls.add(columnDeletedBy());
        ls.add(columnDeletedTime());
        ls.add(columnVersionNo());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasTwoOrMorePrimaryKeys() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignWebCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnWebCrawlingConfigId(), WebCrawlingConfigDbm.getInstance()
                        .columnId());
        return cfi("webCrawlingConfig", this,
                WebCrawlingConfigDbm.getInstance(), map, 0, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    public boolean hasVersionNo() {
        return true;
    }

    public ColumnInfo getVersionNoColumnInfo() {
        return _columnVersionNo;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.WebAuthentication";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.WebAuthenticationCB";
    }

    public String getDaoTypeName() {
        return "jp.sf.fess.db.exdao.WebAuthenticationDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.WebAuthenticationBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<WebAuthentication> getEntityType() {
        return WebAuthentication.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public WebAuthentication newMyEntity() {
        return new WebAuthentication();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((WebAuthentication) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<WebAuthentication>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsHostname(), columnHostname());
        setupEps(_epsMap, new EpsPort(), columnPort());
        setupEps(_epsMap, new EpsAuthRealm(), columnAuthRealm());
        setupEps(_epsMap, new EpsProtocolScheme(), columnProtocolScheme());
        setupEps(_epsMap, new EpsUsername(), columnUsername());
        setupEps(_epsMap, new EpsPassword(), columnPassword());
        setupEps(_epsMap, new EpsParameters(), columnParameters());
        setupEps(_epsMap, new EpsWebCrawlingConfigId(),
                columnWebCrawlingConfigId());
        setupEps(_epsMap, new EpsCreatedBy(), columnCreatedBy());
        setupEps(_epsMap, new EpsCreatedTime(), columnCreatedTime());
        setupEps(_epsMap, new EpsUpdatedBy(), columnUpdatedBy());
        setupEps(_epsMap, new EpsUpdatedTime(), columnUpdatedTime());
        setupEps(_epsMap, new EpsDeletedBy(), columnDeletedBy());
        setupEps(_epsMap, new EpsDeletedTime(), columnDeletedTime());
        setupEps(_epsMap, new EpsVersionNo(), columnVersionNo());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup((WebAuthentication) entity, value);
    }

    public class EpsId implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsHostname implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setHostname((String) v);
        }
    }

    public class EpsPort implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setPort(cti(v));
        }
    }

    public static class EpsAuthRealm implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setAuthRealm((String) v);
        }
    }

    public static class EpsProtocolScheme implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setProtocolScheme((String) v);
        }
    }

    public static class EpsUsername implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setUsername((String) v);
        }
    }

    public static class EpsPassword implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setPassword((String) v);
        }
    }

    public static class EpsParameters implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setParameters((String) v);
        }
    }

    public class EpsWebCrawlingConfigId implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setWebCrawlingConfigId(ctl(v));
        }
    }

    public static class EpsCreatedBy implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setCreatedBy((String) v);
        }
    }

    public static class EpsCreatedTime implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setCreatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsUpdatedBy implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setUpdatedBy((String) v);
        }
    }

    public static class EpsUpdatedTime implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setUpdatedTime((java.sql.Timestamp) v);
        }
    }

    public static class EpsDeletedBy implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setDeletedBy((String) v);
        }
    }

    public static class EpsDeletedTime implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setDeletedTime((java.sql.Timestamp) v);
        }
    }

    public class EpsVersionNo implements Eps<WebAuthentication> {
        public void setup(WebAuthentication e, Object v) {
            e.setVersionNo(cti(v));
        }
    }
}
