/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FileConfigToLabelTypeMappingDbm;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.db.exentity.LabelType;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of FILE_CONFIG_TO_LABEL_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, FILE_CONFIG_ID, LABEL_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     FILE_CRAWLING_CONFIG, LABEL_TYPE
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     fileCrawlingConfig, labelType
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileConfigToLabelTypeMappingBhv extends
        AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_CONFIG_TO_LABEL_TYPE_MAPPING";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileConfigToLabelTypeMappingDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileConfigToLabelTypeMappingDbm getMyDBMeta() {
        return FileConfigToLabelTypeMappingDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FileConfigToLabelTypeMapping newMyEntity() {
        return new FileConfigToLabelTypeMapping();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FileConfigToLabelTypeMappingCB newMyConditionBean() {
        return new FileConfigToLabelTypeMappingCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * int count = fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileConfigToLabelTypeMappingCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(FileConfigToLabelTypeMappingCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(FileConfigToLabelTypeMappingCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FileConfigToLabelTypeMapping&gt;() {
     *     public void handle(FileConfigToLabelTypeMapping entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @param entityRowHandler The handler of entity row of FileConfigToLabelTypeMapping. (NotNull)
     */
    public void selectCursor(FileConfigToLabelTypeMappingCB cb,
            EntityRowHandler<FileConfigToLabelTypeMapping> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> void doSelectCursor(
            FileConfigToLabelTypeMappingCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileConfigToLabelTypeMapping>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (fileConfigToLabelTypeMapping != null) {
     *     ... = fileConfigToLabelTypeMapping.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToLabelTypeMapping selectEntity(
            FileConfigToLabelTypeMappingCB cb) {
        return doSelectEntity(cb, FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> ENTITY doSelectEntity(
            final FileConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, FileConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = fileConfigToLabelTypeMapping.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToLabelTypeMapping selectEntityWithDeletedCheck(
            FileConfigToLabelTypeMappingCB cb) {
        return doSelectEntityWithDeletedCheck(cb,
                FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> ENTITY doSelectEntityWithDeletedCheck(
            final FileConfigToLabelTypeMappingCB cb,
            final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FileConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToLabelTypeMappingCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToLabelTypeMapping selectByPKValue(Long id) {
        return doSelectByPKValue(id, FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileConfigToLabelTypeMapping selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id,
                FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FileConfigToLabelTypeMappingCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FileConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FileConfigToLabelTypeMapping&gt; fileConfigToLabelTypeMappingList = fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping : fileConfigToLabelTypeMappingList) {
     *     ... = fileConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FileConfigToLabelTypeMapping> selectList(
            FileConfigToLabelTypeMappingCB cb) {
        return doSelectList(cb, FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> ListResultBean<ENTITY> doSelectList(
            FileConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(
                cb,
                entityType,
                new InternalSelectListCallback<ENTITY, FileConfigToLabelTypeMappingCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FileConfigToLabelTypeMapping&gt; page = fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping : page) {
     *     ... = fileConfigToLabelTypeMapping.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FileConfigToLabelTypeMapping> selectPage(
            FileConfigToLabelTypeMappingCB cb) {
        return doSelectPage(cb, FileConfigToLabelTypeMapping.class);
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> PagingResultBean<ENTITY> doSelectPage(
            FileConfigToLabelTypeMappingCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(
                cb,
                entityType,
                new InternalSelectPageCallback<ENTITY, FileConfigToLabelTypeMappingCB>() {
                    public int callbackSelectCount(
                            FileConfigToLabelTypeMappingCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            FileConfigToLabelTypeMappingCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FileConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<FileConfigToLabelTypeMappingCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FileConfigToLabelTypeMappingCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param fileConfigToLabelTypeMappingList The list of fileConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToLabelTypeMappingList,
                new InternalPulloutCallback<FileConfigToLabelTypeMapping, FileCrawlingConfig>() {
                    public FileCrawlingConfig getFr(
                            FileConfigToLabelTypeMapping e) {
                        return e.getFileCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileConfigToLabelTypeMapping> ls) {
                        e.setFileConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    /**
     * Pull out the list of foreign table 'LabelType'.
     * @param fileConfigToLabelTypeMappingList The list of fileConfigToLabelTypeMapping. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<LabelType> pulloutLabelType(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        return helpPulloutInternally(
                fileConfigToLabelTypeMappingList,
                new InternalPulloutCallback<FileConfigToLabelTypeMapping, LabelType>() {
                    public LabelType getFr(FileConfigToLabelTypeMapping e) {
                        return e.getLabelType();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(LabelType e,
                            List<FileConfigToLabelTypeMapping> ls) {
                        e.setFileConfigToLabelTypeMappingList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileConfigToLabelTypeMapping.setFoo...(value);
     * fileConfigToLabelTypeMapping.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.set...;</span>
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">insert</span>(fileConfigToLabelTypeMapping);
     * ... = fileConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping) {
        doInsert(fileConfigToLabelTypeMapping, null);
    }

    protected void doInsert(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMapping",
                fileConfigToLabelTypeMapping);
        prepareInsertOption(option);
        delegateInsert(fileConfigToLabelTypeMapping, option);
    }

    protected void prepareInsertOption(
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * fileConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">update</span>(fileConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(
            final FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping) {
        doUpdate(fileConfigToLabelTypeMapping, null);
    }

    protected void doUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            final UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMapping",
                fileConfigToLabelTypeMapping);
        prepareUpdateOption(option);
        helpUpdateInternally(fileConfigToLabelTypeMapping,
                new InternalUpdateCallback<FileConfigToLabelTypeMapping>() {
                    public int callbackDelegateUpdate(
                            FileConfigToLabelTypeMapping entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(
            UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected FileConfigToLabelTypeMappingCB createCBForVaryingUpdate() {
        FileConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected FileConfigToLabelTypeMappingCB createCBForSpecifiedUpdate() {
        FileConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    @Override
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        doModify(entity, option);
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param fileConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping) {
        doInesrtOrUpdate(fileConfigToLabelTypeMapping, null, null);
    }

    protected void doInesrtOrUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            final InsertOption<FileConfigToLabelTypeMappingCB> insertOption,
            final UpdateOption<FileConfigToLabelTypeMappingCB> updateOption) {
        helpInsertOrUpdateInternally(
                fileConfigToLabelTypeMapping,
                new InternalInsertOrUpdateCallback<FileConfigToLabelTypeMapping, FileConfigToLabelTypeMappingCB>() {
                    public void callbackInsert(
                            FileConfigToLabelTypeMapping entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(
                            FileConfigToLabelTypeMapping entity) {
                        doUpdate(entity, updateOption);
                    }

                    public FileConfigToLabelTypeMappingCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(
                            FileConfigToLabelTypeMappingCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    @Override
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        doCreateOrModify(entity, insertOption, updateOption);
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * fileConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">delete</span>(fileConfigToLabelTypeMapping);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping) {
        doDelete(fileConfigToLabelTypeMapping, null);
    }

    protected void doDelete(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            final DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMapping",
                fileConfigToLabelTypeMapping);
        prepareDeleteOption(option);
        helpDeleteInternally(fileConfigToLabelTypeMapping,
                new InternalDeleteCallback<FileConfigToLabelTypeMapping>() {
                    public int callbackDelegateDelete(
                            FileConfigToLabelTypeMapping entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(
            DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    @Override
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        doRemove(entity, option);
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        return doBatchInsert(fileConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchInsert(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMappingList",
                fileConfigToLabelTypeMappingList);
        prepareInsertOption(option);
        return delegateBatchInsert(fileConfigToLabelTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        return doBatchUpdate(fileConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchUpdate(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMappingList",
                fileConfigToLabelTypeMappingList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(fileConfigToLabelTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            SpecifyQuery<FileConfigToLabelTypeMappingCB> updateColumnSpec) {
        return doBatchUpdate(fileConfigToLabelTypeMappingList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        return doLumpModify(ls, option);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList) {
        return doBatchDelete(fileConfigToLabelTypeMappingList, null);
    }

    protected int[] doBatchDelete(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMappingList",
                fileConfigToLabelTypeMappingList);
        prepareDeleteOption(option);
        return delegateBatchDelete(fileConfigToLabelTypeMappingList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    @Override
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        return doLumpRemove(ls, option);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;fileConfigToLabelTypeMapping, FileConfigToLabelTypeMappingCB&gt;() {
     *     public ConditionBean setup(fileConfigToLabelTypeMapping entity, FileConfigToLabelTypeMappingCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<FileConfigToLabelTypeMapping, FileConfigToLabelTypeMappingCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<FileConfigToLabelTypeMapping, FileConfigToLabelTypeMappingCB> setupper,
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        FileConfigToLabelTypeMapping entity = new FileConfigToLabelTypeMapping();
        FileConfigToLabelTypeMappingCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected FileConfigToLabelTypeMappingCB createCBForQueryInsert() {
        FileConfigToLabelTypeMappingCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setPK...(value);</span>
     * fileConfigToLabelTypeMapping.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setVersionNo(value);</span>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryUpdate</span>(fileConfigToLabelTypeMapping, cb);
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            FileConfigToLabelTypeMappingCB cb) {
        return doQueryUpdate(fileConfigToLabelTypeMapping, cb, null);
    }

    protected int doQueryUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            FileConfigToLabelTypeMappingCB cb,
            UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        assertObjectNotNull("fileConfigToLabelTypeMapping",
                fileConfigToLabelTypeMapping);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(fileConfigToLabelTypeMapping, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity),
                    (FileConfigToLabelTypeMappingCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (FileConfigToLabelTypeMappingCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">queryDelete</span>(fileConfigToLabelTypeMapping, cb);
     * </pre>
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(FileConfigToLabelTypeMappingCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(FileConfigToLabelTypeMappingCB cb,
            DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((FileConfigToLabelTypeMappingCB) cb);
        } else {
            return varyingQueryDelete((FileConfigToLabelTypeMappingCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileConfigToLabelTypeMapping.setFoo...(value);
     * fileConfigToLabelTypeMapping.setBar...(value);
     * InsertOption<FileConfigToLabelTypeMappingCB> option = new InsertOption<FileConfigToLabelTypeMappingCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingInsert</span>(fileConfigToLabelTypeMapping, option);
     * ... = fileConfigToLabelTypeMapping.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(fileConfigToLabelTypeMapping, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * fileConfigToLabelTypeMapping.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileConfigToLabelTypeMapping.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;FileConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;FileConfigToLabelTypeMappingCB&gt;();
     *     option.self(new SpecifyQuery&lt;FileConfigToLabelTypeMappingCB&gt;() {
     *         public void specify(FileConfigToLabelTypeMappingCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingUpdate</span>(fileConfigToLabelTypeMapping, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(fileConfigToLabelTypeMapping, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param fileConfigToLabelTypeMapping The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            InsertOption<FileConfigToLabelTypeMappingCB> insertOption,
            UpdateOption<FileConfigToLabelTypeMappingCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(fileConfigToLabelTypeMapping, insertOption,
                updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param fileConfigToLabelTypeMapping The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(fileConfigToLabelTypeMapping, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(fileConfigToLabelTypeMappingList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(fileConfigToLabelTypeMappingList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param fileConfigToLabelTypeMappingList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<FileConfigToLabelTypeMapping> fileConfigToLabelTypeMappingList,
            DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(fileConfigToLabelTypeMappingList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<FileConfigToLabelTypeMapping, FileConfigToLabelTypeMappingCB> setupper,
            InsertOption<FileConfigToLabelTypeMappingCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping = new FileConfigToLabelTypeMapping();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setPK...(value);</span>
     * fileConfigToLabelTypeMapping.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileConfigToLabelTypeMapping.setVersionNo(value);</span>
     * FileConfigToLabelTypeMappingCB cb = new FileConfigToLabelTypeMappingCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FileConfigToLabelTypeMappingCB&gt; option = new UpdateOption&lt;FileConfigToLabelTypeMappingCB&gt;();
     * option.self(new SpecifyQuery&lt;FileConfigToLabelTypeMappingCB&gt;() {
     *     public void specify(FileConfigToLabelTypeMappingCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileConfigToLabelTypeMappingBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(fileConfigToLabelTypeMapping, cb, option);
     * </pre>
     * @param fileConfigToLabelTypeMapping The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(
            FileConfigToLabelTypeMapping fileConfigToLabelTypeMapping,
            FileConfigToLabelTypeMappingCB cb,
            UpdateOption<FileConfigToLabelTypeMappingCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(fileConfigToLabelTypeMapping, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of FileConfigToLabelTypeMapping. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(FileConfigToLabelTypeMappingCB cb,
            DeleteOption<FileConfigToLabelTypeMappingCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<FileConfigToLabelTypeMappingBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(FileConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(FileConfigToLabelTypeMappingCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> void delegateSelectCursor(
            FileConfigToLabelTypeMappingCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends FileConfigToLabelTypeMapping> List<ENTITY> delegateSelectList(
            FileConfigToLabelTypeMappingCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileConfigToLabelTypeMapping e,
            InsertOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(FileConfigToLabelTypeMapping e,
            UpdateOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return delegateUpdateNonstrict(e, op);
    }

    protected int delegateUpdateNonstrict(FileConfigToLabelTypeMapping e,
            UpdateOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(FileConfigToLabelTypeMapping e,
            DeleteOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return delegateDeleteNonstrict(e, op);
    }

    protected int delegateDeleteNonstrict(FileConfigToLabelTypeMapping e,
            DeleteOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<FileConfigToLabelTypeMapping> ls,
            InsertOption<FileConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<FileConfigToLabelTypeMapping> ls,
            UpdateOption<FileConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchUpdateNonstrict(ls, op);
    }

    protected int[] delegateBatchUpdateNonstrict(
            List<FileConfigToLabelTypeMapping> ls,
            UpdateOption<FileConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<FileConfigToLabelTypeMapping> ls,
            DeleteOption<FileConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return delegateBatchDeleteNonstrict(ls, op);
    }

    protected int[] delegateBatchDeleteNonstrict(
            List<FileConfigToLabelTypeMapping> ls,
            DeleteOption<FileConfigToLabelTypeMappingCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(FileConfigToLabelTypeMapping e,
            FileConfigToLabelTypeMappingCB inCB, ConditionBean resCB,
            InsertOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(FileConfigToLabelTypeMapping e,
            FileConfigToLabelTypeMappingCB cb,
            UpdateOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(FileConfigToLabelTypeMappingCB cb,
            DeleteOption<FileConfigToLabelTypeMappingCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FileConfigToLabelTypeMapping downcast(Entity entity) {
        return helpEntityDowncastInternally(entity,
                FileConfigToLabelTypeMapping.class);
    }

    protected FileConfigToLabelTypeMappingCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                FileConfigToLabelTypeMappingCB.class);
    }
}
