/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity;

import java.io.Serializable;
import java.util.Set;

import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.exentity.BrowserType;
import jp.sf.fess.db.exentity.DataCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The entity of DATA_CONFIG_TO_BROWSER_TYPE_MAPPING as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, DATA_CONFIG_ID, BROWSER_TYPE_ID
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     BROWSER_TYPE, DATA_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     browserType, dataCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsDataConfigToBrowserTypeMapping implements Entity,
        Serializable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    // -----------------------------------------------------
    //                                                Column
    //                                                ------
    /** ID: {PK, ID, NotNull, BIGINT(19)} */
    protected Long _id;

    /** DATA_CONFIG_ID: {IX, NotNull, BIGINT(19), FK to DATA_CRAWLING_CONFIG} */
    protected Long _dataConfigId;

    /** BROWSER_TYPE_ID: {IX, NotNull, BIGINT(19), FK to BROWSER_TYPE} */
    protected Long _browserTypeId;

    // -----------------------------------------------------
    //                                              Internal
    //                                              --------
    /** The modified properties for this entity. */
    protected final EntityModifiedProperties __modifiedProperties = newModifiedProperties();

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    /**
     * {@inheritDoc}
     */
    public String getTableDbName() {
        return "DATA_CONFIG_TO_BROWSER_TYPE_MAPPING";
    }

    /**
     * {@inheritDoc}
     */
    public String getTablePropertyName() { // according to Java Beans rule
        return "dataConfigToBrowserTypeMapping";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /**
     * {@inheritDoc}
     */
    public DBMeta getDBMeta() {
        return DBMetaInstanceHandler.findDBMeta(getTableDbName());
    }

    // ===================================================================================
    //                                                                         Primary Key
    //                                                                         ===========
    /**
     * {@inheritDoc}
     */
    public boolean hasPrimaryKeyValue() {
        if (getId() == null) {
            return false;
        }
        return true;
    }

    // ===================================================================================
    //                                                                    Foreign Property
    //                                                                    ================
    /** BROWSER_TYPE as 'browserType'. */
    protected BrowserType _browserType;

    /**
     * BROWSER_TYPE as 'browserType'.
     * @return The entity of foreign property 'browserType'. (NullAllowed: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public BrowserType getBrowserType() {
        return _browserType;
    }

    /**
     * BROWSER_TYPE as 'browserType'.
     * @param browserType The entity of foreign property 'browserType'. (NullAllowed)
     */
    public void setBrowserType(BrowserType browserType) {
        _browserType = browserType;
    }

    /** DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'. */
    protected DataCrawlingConfig _dataCrawlingConfig;

    /**
     * DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'.
     * @return The entity of foreign property 'dataCrawlingConfig'. (NullAllowed: If the foreign key does not have 'NotNull' constraint, please check null.)
     */
    public DataCrawlingConfig getDataCrawlingConfig() {
        return _dataCrawlingConfig;
    }

    /**
     * DATA_CRAWLING_CONFIG as 'dataCrawlingConfig'.
     * @param dataCrawlingConfig The entity of foreign property 'dataCrawlingConfig'. (NullAllowed)
     */
    public void setDataCrawlingConfig(DataCrawlingConfig dataCrawlingConfig) {
        _dataCrawlingConfig = dataCrawlingConfig;
    }

    // ===================================================================================
    //                                                                   Referrer Property
    //                                                                   =================
    // ===================================================================================
    //                                                                 Modified Properties
    //                                                                 ===================
    /**
     * {@inheritDoc}
     */
    public Set<String> modifiedProperties() {
        return __modifiedProperties.getPropertyNames();
    }

    /**
     * {@inheritDoc}
     */
    public void clearModifiedInfo() {
        __modifiedProperties.clear();
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasModification() {
        return !__modifiedProperties.isEmpty();
    }

    protected EntityModifiedProperties newModifiedProperties() {
        return new EntityModifiedProperties();
    }

    // ===================================================================================
    //                                                                      Basic Override
    //                                                                      ==============
    /**
     * If primary-keys or columns of the other are same as this one, returns true.
     * @param other The other entity. (NullAllowed)
     * @return Comparing result.
     */
    public boolean equals(Object other) {
        if (other == null
                || !(other instanceof BsDataConfigToBrowserTypeMapping)) {
            return false;
        }
        BsDataConfigToBrowserTypeMapping otherEntity = (BsDataConfigToBrowserTypeMapping) other;
        if (!xSV(getId(), otherEntity.getId())) {
            return false;
        }
        return true;
    }

    protected boolean xSV(Object value1, Object value2) { // isSameValue()
        return InternalUtil.isSameValue(value1, value2);
    }

    /**
     * Calculates the hash-code from primary-keys or columns.
     * @return The hash-code from primary-key or columns.
     */
    public int hashCode() {
        int result = 17;
        result = xCH(result, getTableDbName());
        result = xCH(result, getId());
        return result;
    }

    protected int xCH(int result, Object value) { // calculateHashcode()
        return InternalUtil.calculateHashcode(result, value);
    }

    /**
     * @return The display string of all columns and relation existences. (NotNull)
     */
    public String toString() {
        return buildDisplayString(InternalUtil.toClassTitle(this), true, true);
    }

    /**
     * @return The display string of basic informations with one-nested relation values. (NotNull)
     */
    public String toStringWithRelation() {
        StringBuilder sb = new StringBuilder();
        sb.append(toString());
        String l = "\n  ";
        if (_browserType != null) {
            sb.append(l).append(xbRDS(_browserType, "browserType"));
        }
        if (_dataCrawlingConfig != null) {
            sb.append(l).append(
                    xbRDS(_dataCrawlingConfig, "dataCrawlingConfig"));
        }
        return sb.toString();
    }

    protected String xbRDS(Entity e, String name) { // buildRelationDisplayString()
        return e.buildDisplayString(name, true, true);
    }

    /**
     * @param name The name for display. (NullAllowed: If it's null, it does not have a name)
     * @param column Does it contains column values or not?
     * @param relation Does it contains relation existences or not?
     * @return The display string for this entity. (NotNull)
     */
    public String buildDisplayString(String name, boolean column,
            boolean relation) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name).append(column || relation ? ":" : "");
        }
        if (column) {
            sb.append(buildColumnString());
        }
        if (relation) {
            sb.append(buildRelationString());
        }
        sb.append("@").append(Integer.toHexString(hashCode()));
        return sb.toString();
    }

    protected String buildColumnString() {
        String c = ", ";
        StringBuilder sb = new StringBuilder();
        sb.append(c).append(getId());
        sb.append(c).append(getDataConfigId());
        sb.append(c).append(getBrowserTypeId());
        if (sb.length() > 0) {
            sb.delete(0, c.length());
        }
        sb.insert(0, "{").append("}");
        return sb.toString();
    }

    protected String buildRelationString() {
        StringBuilder sb = new StringBuilder();
        String c = ",";
        if (_browserType != null) {
            sb.append(c).append("browserType");
        }
        if (_dataCrawlingConfig != null) {
            sb.append(c).append("dataCrawlingConfig");
        }
        if (sb.length() > 0) {
            sb.delete(0, c.length()).insert(0, "(").append(")");
        }
        return sb.toString();
    }

    // ===================================================================================
    //                                                                            Accessor
    //                                                                            ========
    /**
     * [get] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @return The value of the column 'ID'. (NullAllowed)
     */
    public Long getId() {
        return _id;
    }

    /**
     * [set] ID: {PK, ID, NotNull, BIGINT(19)} <br />
     * @param id The value of the column 'ID'. (NullAllowed)
     */
    public void setId(Long id) {
        __modifiedProperties.addPropertyName("id");
        this._id = id;
    }

    /**
     * [get] DATA_CONFIG_ID: {IX, NotNull, BIGINT(19), FK to DATA_CRAWLING_CONFIG} <br />
     * @return The value of the column 'DATA_CONFIG_ID'. (NullAllowed)
     */
    public Long getDataConfigId() {
        return _dataConfigId;
    }

    /**
     * [set] DATA_CONFIG_ID: {IX, NotNull, BIGINT(19), FK to DATA_CRAWLING_CONFIG} <br />
     * @param dataConfigId The value of the column 'DATA_CONFIG_ID'. (NullAllowed)
     */
    public void setDataConfigId(Long dataConfigId) {
        __modifiedProperties.addPropertyName("dataConfigId");
        this._dataConfigId = dataConfigId;
    }

    /**
     * [get] BROWSER_TYPE_ID: {IX, NotNull, BIGINT(19), FK to BROWSER_TYPE} <br />
     * @return The value of the column 'BROWSER_TYPE_ID'. (NullAllowed)
     */
    public Long getBrowserTypeId() {
        return _browserTypeId;
    }

    /**
     * [set] BROWSER_TYPE_ID: {IX, NotNull, BIGINT(19), FK to BROWSER_TYPE} <br />
     * @param browserTypeId The value of the column 'BROWSER_TYPE_ID'. (NullAllowed)
     */
    public void setBrowserTypeId(Long browserTypeId) {
        __modifiedProperties.addPropertyName("browserTypeId");
        this._browserTypeId = browserTypeId;
    }
}
