<%@page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="content-style-type" content="text/css" />
<meta http-equiv="content-script-type" content="text/javascript" />
<title><bean:message key="labels.search_title" /></title>
<link href="${f:url('/css/style-base.css')}" rel="stylesheet"
	type="text/css" />
<link href="${f:url('/css/style.css')}" rel="stylesheet" type="text/css" />
<link rel="stylesheet"
	href="${f:url('/css/smoothness/jquery-ui-1.8.20.css')}" type="text/css"
	media="all" />
<link rel="stylesheet" href="${f:url('/css/jquery.multiselect.css')}"
	type="text/css" media="all" />
<script type="text/javascript" src="${f:url('/js/jquery-1.7.2.min.js')}"></script>
<script type="text/javascript"
	src="${f:url('/js/jquery-ui-1.8.20.min.js')}"></script>
<script type="text/javascript"
	src="${f:url('/js/jquery.multiselect.js')}"></script>
</head>
<body>
	<jsp:include page="header.jsp" />
	<div class="container">
		<div class="content">
			<div class="page-header">
				<h1>
					<bean:message key="labels.index_title" />
					<small><bean:message key="labels.index_subtitle" /></small>
				</h1>
			</div>
			<div class="row">
				<div class="span6 row">
					<div class="span6">
						<h2>
							<bean:message key="labels.index_search_title" />
						</h2>
						<s:form styleClass="form-stacked" action="search" method="get">
							<fieldset>
								<div class="clearfix">
									<label for="contentQuery"><bean:message
											key="labels.index_form_query_label" /></label>
									<div class="input">
										<html:text styleClass="query" property="query" size="50"
											maxlength="1000" styleId="contentQuery" />
									</div>
								</div>
								<c:if test="${displayLabelTypeItems}">
									<div class="clearfix">
										<label for="contentLabelType"><bean:message
												key="labels.index_form_label_label" /></label>
										<div class="input">
											<html:select property="fields.label"
												styleId="contentLabelType" multiple="true">
												<c:forEach var="item" items="${labelTypeItems}">
													<html:option value="${f:u(item.value)}">
															${f:h(item.label)}
														</html:option>
												</c:forEach>
											</html:select>
											<span id="contentLabelTypeNoneSelectedText" class="hide"><bean:message key="labels.search_result_noneselect_label"/></span>
											<span id="contentLabelTypeSelectedText" class="hide"><bean:message key="labels.search_result_select_label"/></span>
										</div>
									</div>
								</c:if>
								<div class="clearfix">
									<button type="submit" name="search" id="contentSearchButton"
										class="btn primary">
										<bean:message key="labels.index_form_search_btn" />
									</button>
									<button type="reset" name="reset" id="contentResetButton"
										class="btn">
										<bean:message key="labels.index_form_reset_btn" />
									</button>
								</div>
							</fieldset>
						</s:form>
					</div>
					<c:if test="${fe:hswsize(null) != 0}">
						<div class="span6">
							<h2>
								<bean:message key="labels.index_hotkeywords_title" />
							</h2>
							<p class="hotSearchWordBody">
								<c:forEach var="item" items="${fe:hsw(null, 5)}">
									<html:link href="search?query=${f:u(item)}">
											${f:h(item)}
										</html:link>
								</c:forEach>
							</p>
						</div>
					</c:if>
				</div>
				<div class="span10">
					<jsp:include page="${helpPage}" />
				</div>
			</div>
		</div>
		<jsp:include page="footer.jsp" />
	</div>
	<script type="text/javascript" src="${f:url('/js/index.js')}"></script>
</body>
</html>
