/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.cbean.bs;

import java.util.Map;

import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.allcommon.DBMetaInstanceHandler;
import jp.sf.fess.db.allcommon.ImplementedSqlClauseCreator;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.cbean.CrawlingSessionInfoCB;
import jp.sf.fess.db.cbean.cq.CrawlingSessionCQ;
import jp.sf.fess.db.cbean.cq.CrawlingSessionInfoCQ;
import jp.sf.fess.db.cbean.nss.CrawlingSessionNss;

import org.seasar.dbflute.cbean.AbstractConditionBean;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionQuery;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.UnionQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMetaProvider;

/**
 * The base condition-bean of CRAWLING_SESSION_INFO.
 * @author DBFlute(AutoGenerator)
 */
public class BsCrawlingSessionInfoCB extends AbstractConditionBean {

    // ===================================================================================
    //                                                                           Attribute
    //                                                                           =========
    private final DBMetaProvider _dbmetaProvider = new DBMetaInstanceHandler();

    protected CrawlingSessionInfoCQ _conditionQuery;

    // ===================================================================================
    //                                                                           SqlClause
    //                                                                           =========
    @Override
    protected SqlClause createSqlClause() {
        return new ImplementedSqlClauseCreator().createSqlClause(this);
    }

    // ===================================================================================
    //                                                                     DBMeta Provider
    //                                                                     ===============
    @Override
    protected DBMetaProvider getDBMetaProvider() {
        return _dbmetaProvider;
    }

    // ===================================================================================
    //                                                                          Table Name
    //                                                                          ==========
    public String getTableDbName() {
        return "CRAWLING_SESSION_INFO";
    }

    public String getTableSqlName() {
        return "CRAWLING_SESSION_INFO";
    }

    // ===================================================================================
    //                                                                      PrimaryKey Map
    //                                                                      ==============
    public void acceptPrimaryKeyMap(Map<String, ? extends Object> primaryKeyMap) {
        assertPrimaryKeyMap(primaryKeyMap);
        {
            Object obj = primaryKeyMap.get("ID");
            if (obj instanceof Long) {
                query().setId_Equal((Long) obj);
            } else {
                query().setId_Equal(new Long((String) obj));
            }
        }

    }

    // ===================================================================================
    //                                                                     OrderBy Setting
    //                                                                     ===============
    public ConditionBean addOrderBy_PK_Asc() {
        query().addOrderBy_Id_Asc();
        return this;
    }

    public ConditionBean addOrderBy_PK_Desc() {
        query().addOrderBy_Id_Desc();
        return this;
    }

    // ===================================================================================
    //                                                                               Query
    //                                                                               =====
    public CrawlingSessionInfoCQ query() {
        return getConditionQuery();
    }

    public CrawlingSessionInfoCQ getConditionQuery() {
        if (_conditionQuery == null) {
            _conditionQuery = new CrawlingSessionInfoCQ(null, getSqlClause(),
                    getSqlClause().getLocalTableAliasName(), 0);
        }
        return _conditionQuery;
    }

    /**
     * {@inheritDoc}
     */
    public ConditionQuery localCQ() {
        return getConditionQuery();
    }

    // ===================================================================================
    //                                                                               Union
    //                                                                               =====
    /**
     * Set up 'union'.
     * <pre>
     * cb.query().union(new UnionQuery&lt;CrawlingSessionInfoCB&gt;() {
     *     public void query(CrawlingSessionInfoCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void union(UnionQuery<CrawlingSessionInfoCB> unionQuery) {
        final CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final CrawlingSessionInfoCQ cq = cb.query();
        query().xsetUnionQuery(cq);
    }

    /**
     * Set up 'union all'.
     * <pre>
     * cb.query().unionAll(new UnionQuery&lt;CrawlingSessionInfoCB&gt;() {
     *     public void query(CrawlingSessionInfoCB unionCB) {
     *         unionCB.query().setXxx...
     *     }
     * });
     * </pre>
     * @param unionQuery The query of 'union'. (NotNull)
     */
    public void unionAll(UnionQuery<CrawlingSessionInfoCB> unionQuery) {
        final CrawlingSessionInfoCB cb = new CrawlingSessionInfoCB();
        cb.xsetupForUnion();
        unionQuery.query(cb);
        final CrawlingSessionInfoCQ cq = cb.query();
        query().xsetUnionAllQuery(cq);
    }

    public boolean hasUnionQueryOrUnionAllQuery() {
        return query().hasUnionQueryOrUnionAllQuery();
    }

    // ===================================================================================
    //                                                                        Setup Select
    //                                                                        ============
    protected CrawlingSessionNss _nssCrawlingSession;

    public CrawlingSessionNss getNssCrawlingSession() {
        if (_nssCrawlingSession == null) {
            _nssCrawlingSession = new CrawlingSessionNss(null);
        }
        return _nssCrawlingSession;
    }

    public CrawlingSessionNss setupSelect_CrawlingSession() {
        doSetupSelect(new SsCall() {
            public ConditionQuery qf() {
                return query().queryCrawlingSession();
            }
        });
        if (_nssCrawlingSession == null
                || !_nssCrawlingSession.hasConditionQuery()) {
            _nssCrawlingSession = new CrawlingSessionNss(query()
                    .queryCrawlingSession());
        }
        return _nssCrawlingSession;
    }

    // [DBFlute-0.7.4]
    // ===================================================================================
    //                                                                             Specify
    //                                                                             =======
    protected Specification _specification;

    public Specification specify() {
        if (_specification == null) {
            _specification = new Specification(this,
                    new SpQyCall<CrawlingSessionInfoCQ>() {
                        public boolean has() {
                            return true;
                        }

                        public CrawlingSessionInfoCQ qy() {
                            return query();
                        }
                    }, _forDerivedReferrer, _forScalarSelect,
                    _forScalarSubQuery, getDBMetaProvider());
        }
        return _specification;
    }

    public static class Specification extends
            AbstractSpecification<CrawlingSessionInfoCQ> {
        protected SpQyCall<CrawlingSessionInfoCQ> _myQyCall;

        protected CrawlingSessionCB.Specification _crawlingSession;

        public Specification(ConditionBean baseCB,
                SpQyCall<CrawlingSessionInfoCQ> qyCall,
                boolean forDeriveReferrer, boolean forScalarSelect,
                boolean forScalarSubQuery, DBMetaProvider dbmetaProvider) {
            super(baseCB, qyCall, forDeriveReferrer, forScalarSelect,
                    forScalarSubQuery, dbmetaProvider);
            _myQyCall = qyCall;
        }

        public void columnId() {
            doColumn("ID");
        }

        public void columnCrawlingSessionId() {
            doColumn("CRAWLING_SESSION_ID");
        }

        public void columnKey() {
            doColumn("KEY");
        }

        public void columnValue() {
            doColumn("VALUE");
        }

        public void columnCreatedTime() {
            doColumn("CREATED_TIME");
        }

        protected void doSpecifyRequiredColumn() {
            columnId(); // PK
            if (_myQyCall.qy().hasConditionQueryCrawlingSession()) {
                columnCrawlingSessionId(); // FK
            }
        }

        protected String getTableDbName() {
            return "CRAWLING_SESSION_INFO";
        }

        public CrawlingSessionCB.Specification specifyCrawlingSession() {
            assertForeign("crawlingSession");
            if (_crawlingSession == null) {
                _crawlingSession = new CrawlingSessionCB.Specification(
                        _baseCB,
                        new SpQyCall<CrawlingSessionCQ>() {
                            public boolean has() {
                                return _myQyCall.has()
                                        && _myQyCall
                                                .qy()
                                                .hasConditionQueryCrawlingSession();
                            }

                            public CrawlingSessionCQ qy() {
                                return _myQyCall.qy().queryCrawlingSession();
                            }
                        }, _forDerivedReferrer, _forScalarSelect,
                        _forScalarSubQuery, _dbmetaProvider);
            }
            return _crawlingSession;
        }
    }

    // ===================================================================================
    //                                                                         Display SQL
    //                                                                         ===========
    @Override
    protected String getLogDateFormat() {
        return DBFluteConfig.getInstance().getLogDateFormat();
    }

    @Override
    protected String getLogTimestampFormat() {
        return DBFluteConfig.getInstance().getLogTimestampFormat();
    }

    // ===================================================================================
    //                                                                            Internal
    //                                                                            ========
    // Very Internal (for Suppressing Warn about 'Not Use Import')
    protected String getConditionBeanClassNameInternally() {
        return CrawlingSessionInfoCB.class.getName();
    }

    protected String getConditionQueryClassNameInternally() {
        return CrawlingSessionInfoCQ.class.getName();
    }

    protected String getSubQueryClassNameInternally() {
        return SubQuery.class.getName();
    }
}
