/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.fess.crud.service.BsOverlappingHostService;
import jp.sf.fess.db.cbean.OverlappingHostCB;
import jp.sf.fess.db.exentity.OverlappingHost;
import jp.sf.fess.pager.OverlappingHostPager;

public class OverlappingHostService extends BsOverlappingHostService implements
        Serializable {

    private static final long serialVersionUID = 1L;

    public List<OverlappingHost> getOverlappingHostList() {

        OverlappingHostCB cb = new OverlappingHostCB();

        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();
        cb.query().addOrderBy_RegularName_Asc();
        cb.query().addOrderBy_OverlappingName_Asc();

        return overlappingHostBhv.selectList(cb);
    }

    protected void setupListCondition(OverlappingHostCB cb,
            OverlappingHostPager overlappingHostPager) {
        super.setupListCondition(cb, overlappingHostPager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();

        // search

    }

    protected void setupEntityCondition(OverlappingHostCB cb,
            Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(OverlappingHost overlappingHost) {
        super.setupStoreCondition(overlappingHost);

        // setup condition

    }

    protected void setupDeleteCondition(OverlappingHost overlappingHost) {
        super.setupDeleteCondition(overlappingHost);

        // setup condition

    }

}
