/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of LABEL_TYPE_TO_ROLE_TYPE_MAPPING. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class LabelTypeToRoleTypeMappingDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final LabelTypeToRoleTypeMappingDbm _instance = new LabelTypeToRoleTypeMappingDbm();

    private LabelTypeToRoleTypeMappingDbm() {
    }

    public static LabelTypeToRoleTypeMappingDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "LABEL_TYPE_TO_ROLE_TYPE_MAPPING";

    protected final String _tablePropertyName = "labelTypeToRoleTypeMapping";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "LABEL_TYPE_TO_ROLE_TYPE_MAPPING", _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, null, true,
            "id", Long.class, true, true, "BIGINT", 19, 0, false, null, null,
            null, null, null);

    protected final ColumnInfo _columnLabelTypeId = cci("LABEL_TYPE_ID",
            "LABEL_TYPE_ID", null, null, true, "labelTypeId", Long.class,
            false, false, "BIGINT", 19, 0, false, null, null, "labelType",
            null, null);

    protected final ColumnInfo _columnRoleTypeId = cci("ROLE_TYPE_ID",
            "ROLE_TYPE_ID", null, null, true, "roleTypeId", Long.class, false,
            false, "BIGINT", 19, 0, false, null, null, "roleType", null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnLabelTypeId() {
        return _columnLabelTypeId;
    }

    public ColumnInfo columnRoleTypeId() {
        return _columnRoleTypeId;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnLabelTypeId());
        ls.add(columnRoleTypeId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignLabelType() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnLabelTypeId(),
                LabelTypeDbm.getInstance().columnId());
        return cfi("labelType", this, LabelTypeDbm.getInstance(), map, 0,
                false, false);
    }

    public ForeignInfo foreignRoleType() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnRoleTypeId(),
                RoleTypeDbm.getInstance().columnId());
        return cfi("roleType", this, RoleTypeDbm.getInstance(), map, 1, false,
                false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.LabelTypeToRoleTypeMapping";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.LabelTypeToRoleTypeMappingCB";
    }

    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.LabelTypeToRoleTypeMappingDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.LabelTypeToRoleTypeMappingBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<LabelTypeToRoleTypeMapping> getEntityType() {
        return LabelTypeToRoleTypeMapping.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public LabelTypeToRoleTypeMapping newMyEntity() {
        return new LabelTypeToRoleTypeMapping();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((LabelTypeToRoleTypeMapping) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<LabelTypeToRoleTypeMapping>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsLabelTypeId(), columnLabelTypeId());
        setupEps(_epsMap, new EpsRoleTypeId(), columnRoleTypeId());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup(
                (LabelTypeToRoleTypeMapping) entity, value);
    }

    public class EpsId implements Eps<LabelTypeToRoleTypeMapping> {
        public void setup(LabelTypeToRoleTypeMapping e, Object v) {
            e.setId(ctl(v));
        }
    }

    public class EpsLabelTypeId implements Eps<LabelTypeToRoleTypeMapping> {
        public void setup(LabelTypeToRoleTypeMapping e, Object v) {
            e.setLabelTypeId(ctl(v));
        }
    }

    public class EpsRoleTypeId implements Eps<LabelTypeToRoleTypeMapping> {
        public void setup(LabelTypeToRoleTypeMapping e, Object v) {
            e.setRoleTypeId(ctl(v));
        }
    }
}
