/*
 * Copyright 2009-2013 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess;

public class InvalidQueryException extends FessSystemException {

    private static final long serialVersionUID = 1L;

    private final String messageCode;

    public InvalidQueryException(final String messageCode,
            final String message, final Throwable cause) {
        super(message, cause);
        this.messageCode = messageCode;
    }

    public InvalidQueryException(final String messageCode, final String message) {
        super(message);
        this.messageCode = messageCode;
    }

    /**
     * @return the messageCode
     */
    public String getMessageCode() {
        return messageCode;
    }

}
