package org.seasar.chronos.core.trigger;

import java.util.List;

import org.seasar.chronos.core.TaskTrigger;
import org.seasar.framework.util.tiger.CollectionsUtil;

/**
 * 複数のトリガーを扱えるトリガーチェインクラスです．
 * 
 * @author j5ik2o
 * 
 */
public class TriggerChain implements TaskTrigger {

    private static final long serialVersionUID = -1L;

    private Long triggerId;

    private String name;

    private Object task;

    private String description;

    private final List<TaskTrigger> triggerList = CollectionsUtil
            .newArrayList();

    public void addTrigger(final TaskTrigger trigger) {
        triggerList.add(trigger);
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public Object getTask() {
        return task;
    }

    public Long getTriggerId() {
        return triggerId;
    }

    public boolean isEndTask() {
        for (final TaskTrigger trigger : triggerList) {
            if (trigger.isEndTask()) {
                return true;
            }
        }
        return false;
    }

    public boolean isExecute() {
        for (final TaskTrigger trigger : triggerList) {
            if (trigger.isExecute()) {
                return true;
            }
        }
        return false;
    }

    public boolean isReScheduleTask() {
        for (final TaskTrigger trigger : triggerList) {
            if (trigger.isReScheduleTask()) {
                return true;
            }
        }
        return false;
    }

    public boolean isShutdownTask() {
        for (final TaskTrigger trigger : triggerList) {
            if (trigger.isShutdownTask()) {
                return true;
            }
        }
        return false;
    }

    public boolean isStartTask() {
        for (final TaskTrigger trigger : triggerList) {
            if (trigger.isStartTask()) {
                return true;
            }
        }
        return false;
    }

    public void removeTrigger(final TaskTrigger trigger) {
        triggerList.remove(trigger);
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public void setEndTask(final boolean endTask) {
        for (final TaskTrigger trigger : triggerList) {
            trigger.setEndTask(endTask);
        }
    }

    public void setExecute(final boolean execute) {
        for (final TaskTrigger trigger : triggerList) {
            trigger.setExecute(execute);
        }
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setReScheduleTask(final boolean reScheduleTask) {
        for (final TaskTrigger trigger : triggerList) {
            trigger.setReScheduleTask(reScheduleTask);
        }
    }

    public void setShutdownTask(final boolean shutdownTask) {
        for (final TaskTrigger trigger : triggerList) {
            trigger.setShutdownTask(shutdownTask);
        }
    }

    public void setStartTask(final boolean startTask) {
        for (final TaskTrigger trigger : triggerList) {
            trigger.setEndTask(startTask);
        }
    }

    public void setTask(final Object task) {
        this.task = task;
    }

    public void setTriggerId(final Long triggerId) {
        this.triggerId = triggerId;
    }
}
