﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class ArchiveProcess
        Implements IAppBase

        Public Property AppBase As AppBase Implements IAppBase.AppBase

        Protected IsStopRequestedDelegate As Logic.Threading.SignalHandler

        Public Sub New()
            IsStopRequestedDelegate = Nothing
        End Sub

        Public Function IsStopRequested() As Boolean
            If IsStopRequestedDelegate Is Nothing Then Return False
            Return IsStopRequestedDelegate()
        End Function

        Public Overridable Function CrcCheck(ByVal Path As Logic.FileSystem.Path) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public Overridable Function Extract(ByVal DestDir As Logic.FileSystem.Path, ByVal SrcArcPath As Logic.FileSystem.Path) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public Overridable Function Extract(ByRef DestBuf As IO.MemoryStream, ByVal SrcEntryPath As String, ByVal SrcArcPath As Logic.FileSystem.Path) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public Overridable Function CompressDir(ByVal DestArcPath As Logic.FileSystem.Path, ByVal SrcDir As Logic.FileSystem.Path) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public Overridable Function GetEntryList(ByRef Dest() As String, ByVal SrcArcPath As Logic.FileSystem.Path) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public Overridable Function GetEntryList(ByRef Dest() As Archive.EntryInfo, ByVal SrcArcPath As Logic.FileSystem.Path) As RESULT
            Return RESULT.INVALID_FILE_EXT
        End Function

        Public Class Impl(Of TConfig As ArchiveOptionConfig)
            Inherits ArchiveProcess

            Protected BaseConfig As TConfig

            Public Sub New(ByVal src As TConfig, ByVal AppBase As AppBase, Optional ByVal IsStopReq As Logic.Threading.SignalHandler = Nothing)
                MyBase.New()
                BaseConfig = Nothing
                If Not src Is Nothing Then BaseConfig = src.Clone
                Me.AppBase = AppBase
                If Not IsStopReq Is Nothing Then IsStopRequestedDelegate = IsStopReq
            End Sub

            Protected Class CompressPathInfo

                Public WorkingDir As Logic.FileSystem.Path
                Public DestArcPath As Logic.FileSystem.Path
                Public SrcDir As Logic.FileSystem.Path

                Public Sub New(ByVal DestDirOrArcPath As Logic.FileSystem.Path, ByVal SourceDir As Logic.FileSystem.Path, ByVal Ext As Logic.FileSystem.Extention)

                    Dim SrcDirPath As Logic.FileSystem.Path
                    SrcDirPath = SourceDir
                    SrcDir = SrcDirPath.ToString

                    Dim DestPath As Logic.FileSystem.Path
                    DestPath = DestDirOrArcPath

                    Try
                        If DestPath.HasExtention Then
                            WorkingDir = DestPath.Parent.ToString
                            DestArcPath = DestPath.ToString
                        Else
                            ' if DestDirOrArcPath has no extention, DestDirOrArcPath is read as workind directory path
                            ' DestArcPath = DestDirOrArcPath/[Name Of SrcDir].[Extention]
                            WorkingDir = DestPath.ToString
                            DestPath.Name = SrcDirPath
                            DestPath.Extention = Ext
                            DestArcPath = DestPath.ToString
                        End If
                    Catch ex As Exception
                        WorkingDir = String.Empty
                        DestArcPath = String.Empty
                    End Try

                End Sub

                Public Function Exists() As Boolean
                    Return WorkingDir.DirectoryExists AndAlso SrcDir.DirectoryExists AndAlso DestArcPath.Name.IsNullOrWhiteSpace = False
                End Function

            End Class ' ArchiveProcess.Impl.CompressPathInfo

        End Class ' ArchiveProcess.Impl

    End Class ' ArchiveProcess

End Class ' AppBase


