﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class Locations ' Filepath managing utilities

        Public Class WorkingDirectory

            Protected Overrides Sub Finalize()
                Close()
                MyBase.Finalize()
            End Sub

            ' public property ////////////////////////////////////////////////////////////////////////////////////////////////////////

            Public Property Path As Logic.FileSystem.Path
                Get
                    Return m_path
                End Get
                Set(ByVal value As Logic.FileSystem.Path)

                    If m_path IsNot Nothing AndAlso m_path.Equals(value) Then Return

                    Close()

                    If value Is Nothing OrElse value.IsNullOrWhiteSpace OrElse value.DirectoryExists = False Then
                        m_path = String.Empty
                        Return
                    End If
                    m_path = value

                    Do
                        m_temp = Logic.FileSystem.JoinPathElements(m_path.ToString, Replace(IO.Path.GetRandomFileName, ".", "_"))
                    Loop While m_temp.DirectoryExists

                    Try
                        Dim IDir As IO.DirectoryInfo = IO.Directory.CreateDirectory(m_temp.ToString)
                        IDir.Attributes = IDir.Attributes Or IO.FileAttributes.Hidden
                        m_hLockFile = System.IO.File.Create(Logic.FileSystem.JoinPathElements(m_temp.ToString, IO.Path.GetRandomFileName))
                    Catch ex As Exception
#If DEBUG Then
                        Throw
#End If
                        m_hLockFile = Nothing
                    End Try

                End Set
            End Property

            Public ReadOnly Property TemporaryDir As Logic.FileSystem.Path
                Get
                    Return m_temp
                End Get
            End Property

            Public ReadOnly Property IsReady As Boolean
                Get
                    Return m_path IsNot Nothing AndAlso m_path.DirectoryExists AndAlso m_temp IsNot Nothing AndAlso m_temp.DirectoryExists
                End Get
            End Property

            ' public methods ////////////////////////////////////////////////////////////////////////////////////////////////////

            Public Sub Close()
                If m_hLockFile IsNot Nothing Then
                    m_hLockFile.Close()
                    m_hLockFile = Nothing
                End If
                Logic.FileSystem.DirectoryDelete(m_temp)
                m_path = Nothing
                m_temp = Nothing
            End Sub

            Public Function Exists() As Boolean
                Return m_path IsNot Nothing AndAlso m_path.DirectoryExists
            End Function

            ' private implements ////////////////////////////////////////////////////////////////////////////////////////////////////////

            Private m_path As Logic.FileSystem.Path
            Private m_temp As Logic.FileSystem.Path
            Private m_hLockFile As System.IO.Stream

        End Class

        Public Class OptionConfiguration
            Public Sub New()
                WorkFolder = Nothing
            End Sub
            Public LastLogPath As String
            Private m_WorkFolder As WorkingDirectory
            Public Property WorkFolder As WorkingDirectory
                Get
                    Return m_WorkFolder
                End Get
                Set(ByVal value As WorkingDirectory)
                    If value Is Nothing Then value = New WorkingDirectory
                    m_WorkFolder = value
                End Set
            End Property
        End Class

        Public Shared ReadOnly ConfigurationPath As Logic.FileSystem.Path = Logic.FileSystem.JoinPathElements(ExecutingLocation.UserAppDataPath.ToString, "config.xml")

    End Class

End Class

