﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class AppBase

    Public Class ShellIcon
        Implements Collections.IEnumerable

        Private Shared ReadOnly instance As New ShellIcon
        Public Shared Function GetSingletonInstance() As ShellIcon
            Return instance
        End Function

        Private ary As Collections.Generic.SortedDictionary(Of HANDLE, Drawing.Bitmap)

        Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
            Return ary.GetEnumerator()
        End Function

        Default Public ReadOnly Property Item(ByVal id As HANDLE) As Drawing.Bitmap
            Get
                If ary.ContainsKey(id) Then Return ary(id)
                Return Nothing
            End Get
        End Property

        Public Enum HANDLE As Integer

            OPENAS_FILE
            OPENAS_IMG
            OPENAS_SND

            CANCEL
            START_EXEC
            START_SCAN

            FS_FOLDER
            FS_DRIVE
            FS_CDROM
            FS_NETWORK
            FS_RAM
            FS_REMOVABLE

            STATE_BATCMD
            STATE_HASDELETE
            STATE_ISCHECKED
            STATE_ISDELETE
            STATE_ISFILTER

            CANCEL_BATCMD
            CANCEL_BATCMD_SELECTED
            CANCEL_HASDELETE
            CANCEL_HASDELETE_SELECTED
            CANCEL_ISDELETE
            CANCEL_ISDELETE_SELECTED

        End Enum

        Protected Sub New()

            Dim CancelTransArray As New Collections.Generic.SortedDictionary(Of HANDLE, HANDLE) From {
                {HANDLE.STATE_BATCMD, HANDLE.CANCEL_BATCMD},
                {HANDLE.STATE_HASDELETE, HANDLE.CANCEL_HASDELETE},
                {HANDLE.STATE_ISDELETE, HANDLE.CANCEL_ISDELETE}
            }
            Dim CancelStampArray As New Collections.Generic.SortedDictionary(Of HANDLE, HANDLE) From {
                {HANDLE.STATE_BATCMD, HANDLE.CANCEL_BATCMD_SELECTED},
                {HANDLE.STATE_HASDELETE, HANDLE.CANCEL_HASDELETE_SELECTED},
                {HANDLE.STATE_ISDELETE, HANDLE.CANCEL_ISDELETE_SELECTED}
            }

            ary = New Collections.Generic.SortedDictionary(Of HANDLE, Drawing.Bitmap) From {
                {HANDLE.OPENAS_FILE, Shell.GetIconImageFromDLL(Nothing, 126, True).ToBitmap},
                {HANDLE.OPENAS_IMG, Shell.GetIconImageFromDLL(Nothing, 127, True).ToBitmap},
                {HANDLE.OPENAS_SND, Shell.GetIconImageFromDLL(Nothing, 128, True).ToBitmap},
                {HANDLE.CANCEL, Shell.GetIconImageFromDLL(Nothing, 109, True).ToBitmap},
                {HANDLE.START_EXEC, Shell.GetIconImageFromDLL(Nothing, 24, True).ToBitmap},
                {HANDLE.START_SCAN, Shell.GetIconImageFromDLL(Nothing, 176, True).ToBitmap},
                {HANDLE.FS_FOLDER, Shell.GetIconImageFromDLL(Nothing, 4, True).ToBitmap},
                {HANDLE.FS_DRIVE, Shell.GetIconImageFromDLL(Nothing, 8, True).ToBitmap},
                {HANDLE.FS_CDROM, Shell.GetIconImageFromDLL(Nothing, 11, True).ToBitmap},
                {HANDLE.FS_NETWORK, Shell.GetIconImageFromDLL(Nothing, 9, True).ToBitmap},
                {HANDLE.FS_RAM, Shell.GetIconImageFromDLL(Nothing, 12, True).ToBitmap},
                {HANDLE.FS_REMOVABLE, Shell.GetIconImageFromDLL(Nothing, 7, True).ToBitmap},
                {HANDLE.STATE_BATCMD, Shell.GetIconImageFromDLL(Nothing, 169, True).ToBitmap},
                {HANDLE.STATE_HASDELETE, Shell.GetIconImageFromDLL(Nothing, 32, True).ToBitmap},
                {HANDLE.STATE_ISCHECKED, New Bitmap(Shell.GetIconImageFromDLL(Nothing, 137, True).ToBitmap, 12, 12)},
                {HANDLE.STATE_ISDELETE, Shell.GetIconImageFromDLL(Nothing, 131, True).ToBitmap},
                {HANDLE.STATE_ISFILTER, New Bitmap(Shell.GetIconImageFromDLL(Nothing, 146, True).ToBitmap, 12, 12)}
            }

            Dim cm As New System.Drawing.Imaging.ColorMatrix
            Dim ia As New System.Drawing.Imaging.ImageAttributes
            cm.Matrix00 = 1
            cm.Matrix11 = 1
            cm.Matrix22 = 1
            cm.Matrix33 = 0.5F
            cm.Matrix44 = 1
            ia.SetColorMatrix(cm)

            For Each e As HANDLE In CancelTransArray.Keys

                Dim CanvasSize As Drawing.Size
                CanvasSize.Width = Math.Max(ary(e).Width, ary(HANDLE.CANCEL).Width)
                CanvasSize.Height = Math.Max(ary(e).Height, ary(HANDLE.CANCEL).Height)

                Dim Canvas As New Drawing.Bitmap(CanvasSize.Width, CanvasSize.Height)
                Dim g As System.Drawing.Graphics = System.Drawing.Graphics.FromImage(Canvas)
                g.FillRectangle(New Drawing.SolidBrush(Drawing.Color.FromArgb(&HFFFFFF)), 0, 0, Canvas.Width, Canvas.Height)

                Dim rcBase As New Rectangle(Fix((Canvas.Width - ary(e).Width) / 2),
                                            Fix((Canvas.Height - ary(e).Height) / 2),
                                            ary(e).Width, ary(e).Height)
                g.DrawImage(ary(e), rcBase, 0, 0, ary(e).Width, ary(e).Height, Drawing.GraphicsUnit.Pixel, ia)
                g.Dispose()
                g = Nothing
                ary.Add(CancelTransArray(e), Canvas)

                Dim StampCamvas As New Drawing.Bitmap(Canvas)
                g = System.Drawing.Graphics.FromImage(StampCamvas)
                g.FillRectangle(New Drawing.SolidBrush(Drawing.Color.FromArgb(&HFFFFFF)), 0, 0, StampCamvas.Width, StampCamvas.Height)
                Dim rcStmp As New Rectangle(Fix((StampCamvas.Width - ary(HANDLE.CANCEL).Width) / 2),
                                            Fix((StampCamvas.Height - ary(HANDLE.CANCEL).Height) / 2),
                                            ary(HANDLE.CANCEL).Width, ary(HANDLE.CANCEL).Height)
                g.DrawImage(ary(HANDLE.CANCEL), rcStmp, 0, 0, rcStmp.Width, rcStmp.Height, Drawing.GraphicsUnit.Pixel)
                g.Dispose()
                g = Nothing
                ary.Add(CancelStampArray(e), StampCamvas)

            Next

        End Sub

    End Class

End Class


