﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class FileSystem

        Public Class Path
            Inherits PathBase(Of PathStringValidater)

            Public Class Collection
                Inherits PathBase(Of PathStringValidater).CollectionBase(Of Path)
                Public Sub New()
                    MyBase.New()
                End Sub
                Public Sub New(ByVal s As String)
                    MyBase.New(s)
                End Sub
                Public Sub New(ByVal s As System.Collections.Generic.IEnumerable(Of String))
                    MyBase.New(s)
                End Sub
                Public Shared Widening Operator CType(ByVal s As String) As Collection
                    Return New Collection(s)
                End Operator
            End Class

            Public Sub New()
                MyBase.New()
            End Sub

            Public Sub New(ByVal s As String)
                MyBase.New(s)
            End Sub

            Public Shared Widening Operator CType(ByVal s As String) As Path
                Return New Path(s)
            End Operator

            Public Function DeleteDirectory() As Boolean
                Return DirectoryDelete(Payload)
            End Function

            Public Sub DeleteFile()
                FileDelete(Payload)
            End Sub

            Public Function DirectoryExists() As Boolean
                Return FileSystem.DirectoryExists(Payload)
            End Function

            Public Function Exists() As Boolean
                Return FileSystem.Exists(Payload)
            End Function

            Public Property Extention As Extention
                Get
                    Try
                        Extention = New Extention(GetPathExtention(Payload))
                    Catch ex As Exception
                        Extention = New Extention(String.Empty)
                    End Try
                End Get
                Set(ByVal value As Extention)
                    Dim NewExtention As String = String.Empty
                    If value IsNot Nothing Then
                        NewExtention = value.ToString.TrimStart({"."c})
                        If Not String.IsNullOrWhiteSpace(NewExtention) Then NewExtention = "."c & NewExtention
                    End If
                    Name = New Path(GetPathNameWithoutExtention(Payload) & NewExtention)
                End Set
            End Property

            Public Function FileExists() As Boolean
                Return FileSystem.FileExists(Payload)
            End Function

            Public Shared Function GetExceptCollection(ByVal items As System.Collections.Generic.IEnumerable(Of String), ByVal e As Extention.Collection) As System.Collections.Generic.List(Of String)
                If items Is Nothing OrElse e Is Nothing Then Return Nothing
                GetExceptCollection = New System.Collections.Generic.List(Of String)
                For Each item As String In items
                    If Not String.IsNullOrWhiteSpace(item) Then
                        If New Path(item).HasExtention(e) = False Then GetExceptCollection.Add(item)
                    End If
                Next
            End Function

            Public Shared Function GetExtention(ByVal s As String) As Extention
                Return New Extention(IO.Path.GetExtension(s))
            End Function

            Public Shared Function GetIntersectCollection(ByVal items As System.Collections.Generic.IEnumerable(Of String), ByVal e As Extention.Collection) As System.Collections.Generic.List(Of String)
                If items Is Nothing OrElse e Is Nothing Then Return Nothing
                GetIntersectCollection = New System.Collections.Generic.List(Of String)
                For Each item As String In items
                    If Not String.IsNullOrWhiteSpace(item) Then
                        If New Path(item).HasExtention(e) Then GetIntersectCollection.Add(item)
                    End If
                Next
            End Function

            Public Function HasExtention() As Boolean
                Return Not Extention.IsNullOrWhiteSpace
            End Function

            Public Function HasExtention(ByVal e As Extention) As Boolean
                Return Extention.Equals(e)
            End Function

            Public Function HasExtention(ByVal e As Extention.Collection) As Boolean
                If e Is Nothing Then Return False
                Return e.Contains(Extention)
            End Function

            Public Function HasName() As Boolean
                Return Not Name.IsNullOrWhiteSpace
            End Function

            Public Function HasParent() As Boolean
                Return Not Parent.IsNullOrWhiteSpace
            End Function

            Public Function HasRoot() As Boolean
                Return Not Root.IsNullOrWhiteSpace
            End Function

            Public Function IsRootOnly() As Boolean
                Dim WithoutRoot As String = String.Empty
                SplitPathRoot(WithoutRoot, Payload)
                Return String.IsNullOrEmpty(WithoutRoot)
            End Function

            Public Function IsUncPath(Path As String) As Boolean
                Dim FilenamePath As Uri = New Uri(Path)
                Return FilenamePath.IsUnc
            End Function

            Public Property Name As Path
                Get
                    Try
                        Name = New Path(GetPathName(Payload))
                    Catch ex As Exception
                        Name = New Path(String.Empty)
                    End Try
                End Get
                Set(ByVal value As Path)
                    Dim NewName As String = Nothing
                    If value IsNot Nothing Then NewName = value.Name.Payload
                    Payload = JoinPathElements(GetPathParent(Payload), NewName)
                End Set
            End Property

            Public Property NameWithoutExtention As Path
                Get
                    Try
                        NameWithoutExtention = New Path(GetPathNameWithoutExtention(Payload))
                    Catch ex As Exception
                        NameWithoutExtention = New Path(String.Empty)
                    End Try
                End Get
                Set(ByVal value As Path)
                    Dim OldExtention As Extention = Extention
                    If value IsNot Nothing Then
                        Name = value.NameWithoutExtention
                        If Name.IsNullOrWhiteSpace = False Then Extention = OldExtention
                    End If
                End Set
            End Property

            Public Property Parent As Path
                Get
                    Try
                        Parent = New Path(GetPathParent(Payload))
                    Catch ex As Exception
                        Parent = New Path(String.Empty)
                    End Try
                End Get
                Set(ByVal value As Path)
                    Dim NewParent As String = Nothing
                    If value IsNot Nothing Then NewParent = value.Payload
                    Payload = JoinPathElements(NewParent, GetPathName(Payload))
                End Set
            End Property

            Public Property Root As Path
                Get
                    Try
                        Root = New Path(GetPathRoot(Payload))
                    Catch ex As Exception
                        Root = New Path(String.Empty)
                    End Try
                End Get
                Set(ByVal value As Path)
                    Dim NewRoot As String = Nothing
                    If value IsNot Nothing Then NewRoot = value.Root.Payload
                    Payload = JoinPathElements(NewRoot, GetPathWithoutRoot(Payload))
                End Set
            End Property

        End Class

    End Class
End Class