﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class FileSystem

        Public Class PathStringValidater

            ' construct
            Public Sub New()
                Dim codes As New System.Collections.Generic.List(Of Char)
                For Each code As Char In IO.Path.GetInvalidFileNameChars
                    Select Case code
                        Case IO.Path.AltDirectorySeparatorChar, IO.Path.DirectorySeparatorChar, IO.Path.VolumeSeparatorChar, "."c
                            ' do nothing
                        Case Else
                            If codes.Contains(code) = False Then codes.Add(code)
                    End Select
                Next
                m_InvalidChars = codes.ToArray
            End Sub

            ' public properties
            Private ReadOnly m_InvalidChars As Char()
            Public Overridable ReadOnly Property InvalidChars As Char()
                Get
                    Return m_InvalidChars
                End Get
            End Property

            ' public methods
            Default Public ReadOnly Property Validate(ByVal path As String) As String
                Get
                    If String.IsNullOrWhiteSpace(path) Then Return String.Empty
                    path = New String(path)
                    For Each code As Char In InvalidChars
                        path = path.Replace(code, String.Empty)
                    Next
                    Return path
                End Get
            End Property

        End Class

    End Class
End Class




