﻿' *
' * The project site is at: http://sourceforge.jp/projects/fishbornas/
' *
' * First author tiritomato 2012.
' *
' * Distributed under the FishbornArchiveShelf License (See
' *  file "Licenses/License.txt" contained in a project, or the following link.
' *  http://sourceforge.jp/projects/fishbornas/scm/svn/blobs/head/trunk/Licenses/License.txt)
' *
' * 2012.06.07 Initial Revision (tiritomato)
' *

Partial Public Class Logic
    Partial Public Class SerializableCollections

        <Serializable()> _
        Public Class ProtectedSerializable(Of T)
            Implements Xml.Serialization.IXmlSerializable
            Protected Payload As T

            Public Class SerializeException
                Inherits ApplicationException
                Public Sub New(ByVal ex As Exception)
                    MyBase.New("serialize exception", ex)
                End Sub
            End Class

            Protected Sub ExportToXml(ByVal Path As Logic.FileSystem.Path)

                If Path Is Nothing OrElse Path.IsNullOrWhiteSpace Then Throw New ArgumentNullException()

                Dim fs As System.IO.FileStream = Nothing
                Try
                    fs = New System.IO.FileStream(Path.ToString, System.IO.FileMode.OpenOrCreate, System.IO.FileAccess.Write)
                    fs.SetLength(0)
                    Try
                        Dim sz As New System.Xml.Serialization.XmlSerializer(GetType(T))
                        sz.Serialize(fs, Payload)
                    Catch ex As Exception
                        Throw New SerializeException(ex)
                    End Try
                Catch
                    Throw
                Finally
                    If Not fs Is Nothing Then fs.Close()
                End Try

            End Sub

            Public Function GetSchema() As System.Xml.Schema.XmlSchema Implements System.Xml.Serialization.IXmlSerializable.GetSchema
                Return Nothing
            End Function

            Protected Sub ImportFromXml(ByVal Path As Logic.FileSystem.Path)

                If Path Is Nothing Then Throw New ArgumentNullException
                If Path.FileExists = False Then Throw New IO.FileNotFoundException
                Try
                    Dim doc As New Xml.XmlDocument
                    doc.PreserveWhitespace = True
                    doc.Load(Path.ToString)
                    Dim reader As New Xml.XmlNodeReader(doc.DocumentElement)
                    Dim NewPayload As T = New System.Xml.Serialization.XmlSerializer(GetType(T)).Deserialize(reader)
                    Payload = NewPayload
                Catch ex As Exception
                    Throw New SerializeException(ex)
                End Try

            End Sub

            Public Overridable Sub ReadXml(ByVal reader As System.Xml.XmlReader) Implements System.Xml.Serialization.IXmlSerializable.ReadXml

                If reader.IsEmptyElement Then
                    reader.Read() ' skip to next node
                    Exit Sub
                End If

                Dim strElementName As String = reader.Name
                reader.Read() ' enter node
                While True
                    reader.MoveToContent() ' skip white space
                    Select Case reader.NodeType
                        Case Xml.XmlNodeType.EndElement
                            If reader.Name <> strElementName Then
                                MsgBox("SerializableDictionary XML ReadError:Invalid EndElement <" & reader.Name & "/>")
                            End If
                            reader.Read() ' skip to next node
                            Exit While
                        Case Xml.XmlNodeType.Element
                            Dim NewPayload As T = XmlSerializer.Deserialize(reader)
                            Payload = NewPayload
                        Case Xml.XmlNodeType.CDATA
                            reader.Read() ' skip
                    End Select
                End While

            End Sub

            Public Overridable Sub WriteXml(ByVal writer As System.Xml.XmlWriter) Implements System.Xml.Serialization.IXmlSerializable.WriteXml
                XmlSerializer.Serialize(writer, Payload)
            End Sub

            Private Function XmlSerializer() As Xml.Serialization.XmlSerializer
                Return New Xml.Serialization.XmlSerializer(GetType(T))
            End Function

        End Class

    End Class
End Class