/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.Link;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.AbstractConfiguration;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class Configuration
extends AbstractConfiguration {
    private Integer _key;

    public void bindEnvEntry(WebAppContext context, String name, Object value) throws Exception {
        InitialContext ic = null;
        boolean bound = false;
        ic = new InitialContext();
        try {
            NamingEntry ne = (NamingEntry)ic.lookup("java:comp/env/" + NamingEntryUtil.makeNamingEntryName(ic.getNameParser(""), name));
            if (ne != null && ne instanceof EnvEntry) {
                EnvEntry ee = (EnvEntry)ne;
                bound = ee.isOverrideWebXml();
            }
        }
        catch (NameNotFoundException e) {
            bound = false;
        }
        if (!bound) {
            Context envCtx = (Context)ic.lookup("java:comp/env");
            NamingUtil.bind((Context)envCtx, (String)name, (Object)value);
        }
    }

    public void bindResourceRef(WebAppContext context, String name, Class typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindResourceEnvRef(WebAppContext context, String name, Class typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindMessageDestinationRef(WebAppContext context, String name, Class typeClass) throws Exception {
        this.bindEntry(context, name, typeClass);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            Log.info((String)"No Transaction manager found - if your webapp requires one, please configure one.");
        }
    }

    public void preConfigure(WebAppContext context) throws Exception {
        super.preConfigure(context);
    }

    public void configure(WebAppContext context) throws Exception {
        super.configure(context);
    }

    public void postConfigure(WebAppContext context) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        this.lockCompEnv(context);
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        this.unlockCompEnv(context);
        this._key = null;
        Thread.currentThread().setContextClassLoader(oldLoader);
        super.deconfigure(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Random random = new Random();
            this._key = new Integer(random.nextInt());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.eclipse.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.eclipse.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old_loader);
            }
        }
    }

    private void bindEntry(WebAppContext context, String name, Class typeClass) throws Exception {
        String nameInEnvironment = name;
        boolean bound = false;
        WebAppContext scope = context;
        NamingEntry ne = NamingEntryUtil.lookupNamingEntry(scope, name);
        if (ne != null && ne instanceof Link) {
            nameInEnvironment = (String)((Link)ne).getObjectToBind();
            Link l = (Link)ne;
        }
        if (bound = NamingEntryUtil.bindToENC(scope = context, name, nameInEnvironment)) {
            return;
        }
        scope = context.getServer();
        bound = NamingEntryUtil.bindToENC(scope, name, nameInEnvironment);
        if (bound) {
            return;
        }
        bound = NamingEntryUtil.bindToENC(null, name, nameInEnvironment);
        if (bound) {
            return;
        }
        nameInEnvironment = typeClass.getName() + "/default";
        NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(context.getServer(), nameInEnvironment);
        if (defaultNE == null) {
            defaultNE = NamingEntryUtil.lookupNamingEntry(null, nameInEnvironment);
        }
        if (defaultNE == null) {
            throw new IllegalStateException("Nothing to bind for name " + nameInEnvironment);
        }
        defaultNE.bindToENC(name);
    }
}

