package jp.hasc.hasctool.core.blockdiagram.model;

import org.apache.commons.beanutils.PropertyUtils;

import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.util.CoreUtil;


/**
 * ブロックの super class
 * @author iwasaki
 */
public abstract class AbstractBlock extends AbstractModel {
	private static final long serialVersionUID = 1L;
	
	private Point viewPosition=null;
	private String name;
	private Boolean enabled=null;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this. name = name;
	}

	public Point getViewPosition() {
		return viewPosition;
	}

	public void setViewPosition(Point viewPosition) {
		this.viewPosition = viewPosition;
	}
	
	public abstract Object newRuntimeInstance(BlockDiagramExecutor e);
	
	public abstract PortReference getPortByName(String name);
	
	/**
	 * get port instance
	 */
	public Object getRuntimePortByName(Object instance, String portName) {
		try {
			return PropertyUtils.getProperty(instance, portName);
		} catch (Exception ex) {
			CoreUtil.throwAsRuntimeException(ex);
			return null;
		}
	}

	public boolean isEnabled() {
		return enabled!=Boolean.FALSE;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled?null:Boolean.FALSE;
	}
}
