package jp.hasc.hasctool.core.blockdiagram.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/**
 * ポート間の接続
 * @author iwasaki
 */
public class Connection extends AbstractModel {
	private static final long serialVersionUID = 1L;
	
	private String name;
	
	@XStreamAlias("output")
	private PortReference outputPortReference;
	
	@XStreamAlias("input")
	private PortReference inputPortReference;
	
	//private ArrayList<Point> viewIntermediatePoints=null;
	
	public Connection() {
		super();
	}
	
	public Connection(PortReference outputPortPath, PortReference inputPortPath) {
		this();
		this.outputPortReference = outputPortPath;
		this.inputPortReference = inputPortPath;
	}

	/*
	public ArrayList<Point> getViewIntermediatePoints() {
		if (viewIntermediatePoints==null) viewIntermediatePoints=new ArrayList<Point>();
		return viewIntermediatePoints;
	}
	*/
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public PortReference getOutputPortReference() {
		return outputPortReference;
	}

	public void setOutputPortReference(PortReference outputPortRef) {
		this.outputPortReference = outputPortRef;
	}

	public PortReference getInputPortReference() {
		return inputPortReference;
	}

	public void setInputPortReference(PortReference inputPortRef) {
		this.inputPortReference = inputPortRef;
	}

	// IPropertySource関係は、jp.hasc.hasctool.ui.views.grapheditor.ConnectionObject へ移動した
}
